//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicyinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Attestation.
func (a Attestation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Attestation.
func (a *Attestation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttestationEvidence.
func (a AttestationEvidence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "sourceUri", a.SourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttestationEvidence.
func (a *AttestationEvidence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "sourceUri":
			err = unpopulate(val, "SourceURI", &a.SourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttestationListResult.
func (a AttestationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttestationListResult.
func (a *AttestationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttestationProperties.
func (a AttestationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "assessmentDate", a.AssessmentDate)
	populate(objectMap, "comments", a.Comments)
	populate(objectMap, "complianceState", a.ComplianceState)
	populate(objectMap, "evidence", a.Evidence)
	populateDateTimeRFC3339(objectMap, "expiresOn", a.ExpiresOn)
	populateDateTimeRFC3339(objectMap, "lastComplianceStateChangeAt", a.LastComplianceStateChangeAt)
	populateAny(objectMap, "metadata", a.Metadata)
	populate(objectMap, "owner", a.Owner)
	populate(objectMap, "policyAssignmentId", a.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionReferenceId", a.PolicyDefinitionReferenceID)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttestationProperties.
func (a *AttestationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentDate":
			err = unpopulateDateTimeRFC3339(val, "AssessmentDate", &a.AssessmentDate)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &a.Comments)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &a.ComplianceState)
			delete(rawMsg, key)
		case "evidence":
			err = unpopulate(val, "Evidence", &a.Evidence)
			delete(rawMsg, key)
		case "expiresOn":
			err = unpopulateDateTimeRFC3339(val, "ExpiresOn", &a.ExpiresOn)
			delete(rawMsg, key)
		case "lastComplianceStateChangeAt":
			err = unpopulateDateTimeRFC3339(val, "LastComplianceStateChangeAt", &a.LastComplianceStateChangeAt)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &a.Owner)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &a.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &a.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckManagementGroupRestrictionsRequest.
func (c CheckManagementGroupRestrictionsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pendingFields", c.PendingFields)
	populate(objectMap, "resourceDetails", c.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckManagementGroupRestrictionsRequest.
func (c *CheckManagementGroupRestrictionsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pendingFields":
			err = unpopulate(val, "PendingFields", &c.PendingFields)
			delete(rawMsg, key)
		case "resourceDetails":
			err = unpopulate(val, "ResourceDetails", &c.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckRestrictionsRequest.
func (c CheckRestrictionsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pendingFields", c.PendingFields)
	populate(objectMap, "resourceDetails", c.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckRestrictionsRequest.
func (c *CheckRestrictionsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pendingFields":
			err = unpopulate(val, "PendingFields", &c.PendingFields)
			delete(rawMsg, key)
		case "resourceDetails":
			err = unpopulate(val, "ResourceDetails", &c.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckRestrictionsResourceDetails.
func (c CheckRestrictionsResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", c.APIVersion)
	populateAny(objectMap, "resourceContent", c.ResourceContent)
	populate(objectMap, "scope", c.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckRestrictionsResourceDetails.
func (c *CheckRestrictionsResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &c.APIVersion)
			delete(rawMsg, key)
		case "resourceContent":
			err = unpopulate(val, "ResourceContent", &c.ResourceContent)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &c.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckRestrictionsResult.
func (c CheckRestrictionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentEvaluationResult", c.ContentEvaluationResult)
	populate(objectMap, "fieldRestrictions", c.FieldRestrictions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckRestrictionsResult.
func (c *CheckRestrictionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentEvaluationResult":
			err = unpopulate(val, "ContentEvaluationResult", &c.ContentEvaluationResult)
			delete(rawMsg, key)
		case "fieldRestrictions":
			err = unpopulate(val, "FieldRestrictions", &c.FieldRestrictions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckRestrictionsResultContentEvaluationResult.
func (c CheckRestrictionsResultContentEvaluationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyEvaluations", c.PolicyEvaluations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckRestrictionsResultContentEvaluationResult.
func (c *CheckRestrictionsResultContentEvaluationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyEvaluations":
			err = unpopulate(val, "PolicyEvaluations", &c.PolicyEvaluations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceDetail.
func (c ComplianceDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceState", c.ComplianceState)
	populate(objectMap, "count", c.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceDetail.
func (c *ComplianceDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &c.ComplianceState)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentEventDetails.
func (c ComponentEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "policyDefinitionAction", c.PolicyDefinitionAction)
	populate(objectMap, "principalOid", c.PrincipalOid)
	populate(objectMap, "tenantId", c.TenantID)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	populate(objectMap, "type", c.Type)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentEventDetails.
func (c *ComponentEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "policyDefinitionAction":
			err = unpopulate(val, "PolicyDefinitionAction", &c.PolicyDefinitionAction)
			delete(rawMsg, key)
		case "principalOid":
			err = unpopulate(val, "PrincipalOid", &c.PrincipalOid)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentStateDetails.
func (c ComponentStateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceState", c.ComplianceState)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	populate(objectMap, "type", c.Type)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentStateDetails.
func (c *ComponentStateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &c.ComplianceState)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinitionAutoGenerated.
func (e ErrorDefinitionAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinitionAutoGenerated.
func (e *ErrorDefinitionAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinitionAutoGenerated2.
func (e ErrorDefinitionAutoGenerated2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinitionAutoGenerated2.
func (e *ErrorDefinitionAutoGenerated2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseAutoGenerated.
func (e ErrorResponseAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseAutoGenerated.
func (e *ErrorResponseAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseAutoGenerated2.
func (e ErrorResponseAutoGenerated2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseAutoGenerated2.
func (e *ErrorResponseAutoGenerated2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressionEvaluationDetails.
func (e ExpressionEvaluationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expression", e.Expression)
	populate(objectMap, "expressionKind", e.ExpressionKind)
	populateAny(objectMap, "expressionValue", e.ExpressionValue)
	populate(objectMap, "operator", e.Operator)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "result", e.Result)
	populateAny(objectMap, "targetValue", e.TargetValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressionEvaluationDetails.
func (e *ExpressionEvaluationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expression":
			err = unpopulate(val, "Expression", &e.Expression)
			delete(rawMsg, key)
		case "expressionKind":
			err = unpopulate(val, "ExpressionKind", &e.ExpressionKind)
			delete(rawMsg, key)
		case "expressionValue":
			err = unpopulate(val, "ExpressionValue", &e.ExpressionValue)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &e.Operator)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &e.Result)
			delete(rawMsg, key)
		case "targetValue":
			err = unpopulate(val, "TargetValue", &e.TargetValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FieldRestriction.
func (f FieldRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultValue", f.DefaultValue)
	populate(objectMap, "policy", f.Policy)
	populate(objectMap, "result", f.Result)
	populate(objectMap, "values", f.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FieldRestriction.
func (f *FieldRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &f.DefaultValue)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &f.Policy)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &f.Result)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FieldRestrictions.
func (f FieldRestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "field", f.Field)
	populate(objectMap, "restrictions", f.Restrictions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FieldRestrictions.
func (f *FieldRestrictions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "field":
			err = unpopulate(val, "Field", &f.Field)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &f.Restrictions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IfNotExistsEvaluationDetails.
func (i IfNotExistsEvaluationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceId", i.ResourceID)
	populate(objectMap, "totalResources", i.TotalResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IfNotExistsEvaluationDetails.
func (i *IfNotExistsEvaluationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &i.ResourceID)
			delete(rawMsg, key)
		case "totalResources":
			err = unpopulate(val, "TotalResources", &i.TotalResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsListResults.
func (o OperationsListResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "@odata.count", o.ODataCount)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsListResults.
func (o *OperationsListResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &o.ODataCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PendingField.
func (p PendingField) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "field", p.Field)
	populate(objectMap, "values", p.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PendingField.
func (p *PendingField) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "field":
			err = unpopulate(val, "Field", &p.Field)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &p.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentSummary.
func (p PolicyAssignmentSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyDefinitions", p.PolicyDefinitions)
	populate(objectMap, "policyGroups", p.PolicyGroups)
	populate(objectMap, "policySetDefinitionId", p.PolicySetDefinitionID)
	populate(objectMap, "results", p.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentSummary.
func (p *PolicyAssignmentSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitions":
			err = unpopulate(val, "PolicyDefinitions", &p.PolicyDefinitions)
			delete(rawMsg, key)
		case "policyGroups":
			err = unpopulate(val, "PolicyGroups", &p.PolicyGroups)
			delete(rawMsg, key)
		case "policySetDefinitionId":
			err = unpopulate(val, "PolicySetDefinitionID", &p.PolicySetDefinitionID)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &p.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyDefinitionSummary.
func (p PolicyDefinitionSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "effect", p.Effect)
	populate(objectMap, "policyDefinitionGroupNames", p.PolicyDefinitionGroupNames)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "results", p.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyDefinitionSummary.
func (p *PolicyDefinitionSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "effect":
			err = unpopulate(val, "Effect", &p.Effect)
			delete(rawMsg, key)
		case "policyDefinitionGroupNames":
			err = unpopulate(val, "PolicyDefinitionGroupNames", &p.PolicyDefinitionGroupNames)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &p.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyDetails.
func (p PolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyAssignmentDisplayName", p.PolicyAssignmentDisplayName)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyAssignmentScope", p.PolicyAssignmentScope)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "policySetDefinitionId", p.PolicySetDefinitionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyDetails.
func (p *PolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyAssignmentDisplayName":
			err = unpopulate(val, "PolicyAssignmentDisplayName", &p.PolicyAssignmentDisplayName)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyAssignmentScope":
			err = unpopulate(val, "PolicyAssignmentScope", &p.PolicyAssignmentScope)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "policySetDefinitionId":
			err = unpopulate(val, "PolicySetDefinitionID", &p.PolicySetDefinitionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyEvaluationDetails.
func (p PolicyEvaluationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "evaluatedExpressions", p.EvaluatedExpressions)
	populate(objectMap, "ifNotExistsDetails", p.IfNotExistsDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyEvaluationDetails.
func (p *PolicyEvaluationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "evaluatedExpressions":
			err = unpopulate(val, "EvaluatedExpressions", &p.EvaluatedExpressions)
			delete(rawMsg, key)
		case "ifNotExistsDetails":
			err = unpopulate(val, "IfNotExistsDetails", &p.IfNotExistsDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyEvaluationResult.
func (p PolicyEvaluationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "evaluationDetails", p.EvaluationDetails)
	populate(objectMap, "evaluationResult", p.EvaluationResult)
	populate(objectMap, "policyInfo", p.PolicyInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyEvaluationResult.
func (p *PolicyEvaluationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "evaluationDetails":
			err = unpopulate(val, "EvaluationDetails", &p.EvaluationDetails)
			delete(rawMsg, key)
		case "evaluationResult":
			err = unpopulate(val, "EvaluationResult", &p.EvaluationResult)
			delete(rawMsg, key)
		case "policyInfo":
			err = unpopulate(val, "PolicyInfo", &p.PolicyInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyEvent.
func (p PolicyEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceState", p.ComplianceState)
	populate(objectMap, "components", p.Components)
	populate(objectMap, "effectiveParameters", p.EffectiveParameters)
	populate(objectMap, "isCompliant", p.IsCompliant)
	populate(objectMap, "managementGroupIds", p.ManagementGroupIDs)
	populate(objectMap, "@odata.context", p.ODataContext)
	populate(objectMap, "@odata.id", p.ODataID)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyAssignmentName", p.PolicyAssignmentName)
	populate(objectMap, "policyAssignmentOwner", p.PolicyAssignmentOwner)
	populate(objectMap, "policyAssignmentParameters", p.PolicyAssignmentParameters)
	populate(objectMap, "policyAssignmentScope", p.PolicyAssignmentScope)
	populate(objectMap, "policyDefinitionAction", p.PolicyDefinitionAction)
	populate(objectMap, "policyDefinitionCategory", p.PolicyDefinitionCategory)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionName", p.PolicyDefinitionName)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "policySetDefinitionCategory", p.PolicySetDefinitionCategory)
	populate(objectMap, "policySetDefinitionId", p.PolicySetDefinitionID)
	populate(objectMap, "policySetDefinitionName", p.PolicySetDefinitionName)
	populate(objectMap, "policySetDefinitionOwner", p.PolicySetDefinitionOwner)
	populate(objectMap, "policySetDefinitionParameters", p.PolicySetDefinitionParameters)
	populate(objectMap, "principalOid", p.PrincipalOid)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populate(objectMap, "resourceId", p.ResourceID)
	populate(objectMap, "resourceLocation", p.ResourceLocation)
	populate(objectMap, "resourceTags", p.ResourceTags)
	populate(objectMap, "resourceType", p.ResourceType)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populate(objectMap, "tenantId", p.TenantID)
	populateDateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	if p.AdditionalProperties != nil {
		for key, val := range p.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyEvent.
func (p *PolicyEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &p.ComplianceState)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &p.Components)
			delete(rawMsg, key)
		case "effectiveParameters":
			err = unpopulate(val, "EffectiveParameters", &p.EffectiveParameters)
			delete(rawMsg, key)
		case "isCompliant":
			err = unpopulate(val, "IsCompliant", &p.IsCompliant)
			delete(rawMsg, key)
		case "managementGroupIds":
			err = unpopulate(val, "ManagementGroupIDs", &p.ManagementGroupIDs)
			delete(rawMsg, key)
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &p.ODataContext)
			delete(rawMsg, key)
		case "@odata.id":
			err = unpopulate(val, "ODataID", &p.ODataID)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyAssignmentName":
			err = unpopulate(val, "PolicyAssignmentName", &p.PolicyAssignmentName)
			delete(rawMsg, key)
		case "policyAssignmentOwner":
			err = unpopulate(val, "PolicyAssignmentOwner", &p.PolicyAssignmentOwner)
			delete(rawMsg, key)
		case "policyAssignmentParameters":
			err = unpopulate(val, "PolicyAssignmentParameters", &p.PolicyAssignmentParameters)
			delete(rawMsg, key)
		case "policyAssignmentScope":
			err = unpopulate(val, "PolicyAssignmentScope", &p.PolicyAssignmentScope)
			delete(rawMsg, key)
		case "policyDefinitionAction":
			err = unpopulate(val, "PolicyDefinitionAction", &p.PolicyDefinitionAction)
			delete(rawMsg, key)
		case "policyDefinitionCategory":
			err = unpopulate(val, "PolicyDefinitionCategory", &p.PolicyDefinitionCategory)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionName":
			err = unpopulate(val, "PolicyDefinitionName", &p.PolicyDefinitionName)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "policySetDefinitionCategory":
			err = unpopulate(val, "PolicySetDefinitionCategory", &p.PolicySetDefinitionCategory)
			delete(rawMsg, key)
		case "policySetDefinitionId":
			err = unpopulate(val, "PolicySetDefinitionID", &p.PolicySetDefinitionID)
			delete(rawMsg, key)
		case "policySetDefinitionName":
			err = unpopulate(val, "PolicySetDefinitionName", &p.PolicySetDefinitionName)
			delete(rawMsg, key)
		case "policySetDefinitionOwner":
			err = unpopulate(val, "PolicySetDefinitionOwner", &p.PolicySetDefinitionOwner)
			delete(rawMsg, key)
		case "policySetDefinitionParameters":
			err = unpopulate(val, "PolicySetDefinitionParameters", &p.PolicySetDefinitionParameters)
			delete(rawMsg, key)
		case "principalOid":
			err = unpopulate(val, "PrincipalOid", &p.PrincipalOid)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &p.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &p.ResourceLocation)
			delete(rawMsg, key)
		case "resourceTags":
			err = unpopulate(val, "ResourceTags", &p.ResourceTags)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &p.ResourceType)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		default:
			if p.AdditionalProperties == nil {
				p.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				p.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyEventsQueryResults.
func (p PolicyEventsQueryResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "@odata.context", p.ODataContext)
	populate(objectMap, "@odata.count", p.ODataCount)
	populate(objectMap, "@odata.nextLink", p.ODataNextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyEventsQueryResults.
func (p *PolicyEventsQueryResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &p.ODataContext)
			delete(rawMsg, key)
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &p.ODataCount)
			delete(rawMsg, key)
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &p.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyGroupSummary.
func (p PolicyGroupSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyGroupName", p.PolicyGroupName)
	populate(objectMap, "results", p.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyGroupSummary.
func (p *PolicyGroupSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyGroupName":
			err = unpopulate(val, "PolicyGroupName", &p.PolicyGroupName)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &p.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyMetadata.
func (p PolicyMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyMetadata.
func (p *PolicyMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyMetadataCollection.
func (p PolicyMetadataCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyMetadataCollection.
func (p *PolicyMetadataCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyMetadataProperties.
func (p PolicyMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalContentUrl", p.AdditionalContentURL)
	populate(objectMap, "category", p.Category)
	populate(objectMap, "description", p.Description)
	populateAny(objectMap, "metadata", p.Metadata)
	populate(objectMap, "metadataId", p.MetadataID)
	populate(objectMap, "owner", p.Owner)
	populate(objectMap, "requirements", p.Requirements)
	populate(objectMap, "title", p.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyMetadataProperties.
func (p *PolicyMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalContentUrl":
			err = unpopulate(val, "AdditionalContentURL", &p.AdditionalContentURL)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &p.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		case "metadataId":
			err = unpopulate(val, "MetadataID", &p.MetadataID)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &p.Owner)
			delete(rawMsg, key)
		case "requirements":
			err = unpopulate(val, "Requirements", &p.Requirements)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &p.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyMetadataSlimProperties.
func (p PolicyMetadataSlimProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalContentUrl", p.AdditionalContentURL)
	populate(objectMap, "category", p.Category)
	populateAny(objectMap, "metadata", p.Metadata)
	populate(objectMap, "metadataId", p.MetadataID)
	populate(objectMap, "owner", p.Owner)
	populate(objectMap, "title", p.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyMetadataSlimProperties.
func (p *PolicyMetadataSlimProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalContentUrl":
			err = unpopulate(val, "AdditionalContentURL", &p.AdditionalContentURL)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &p.Category)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		case "metadataId":
			err = unpopulate(val, "MetadataID", &p.MetadataID)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &p.Owner)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &p.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyReference.
func (p PolicyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "policySetDefinitionId", p.PolicySetDefinitionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyReference.
func (p *PolicyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "policySetDefinitionId":
			err = unpopulate(val, "PolicySetDefinitionID", &p.PolicySetDefinitionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyState.
func (p PolicyState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceState", p.ComplianceState)
	populate(objectMap, "components", p.Components)
	populate(objectMap, "effectiveParameters", p.EffectiveParameters)
	populate(objectMap, "isCompliant", p.IsCompliant)
	populate(objectMap, "managementGroupIds", p.ManagementGroupIDs)
	populate(objectMap, "@odata.context", p.ODataContext)
	populate(objectMap, "@odata.id", p.ODataID)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyAssignmentName", p.PolicyAssignmentName)
	populate(objectMap, "policyAssignmentOwner", p.PolicyAssignmentOwner)
	populate(objectMap, "policyAssignmentParameters", p.PolicyAssignmentParameters)
	populate(objectMap, "policyAssignmentScope", p.PolicyAssignmentScope)
	populate(objectMap, "policyAssignmentVersion", p.PolicyAssignmentVersion)
	populate(objectMap, "policyDefinitionAction", p.PolicyDefinitionAction)
	populate(objectMap, "policyDefinitionCategory", p.PolicyDefinitionCategory)
	populate(objectMap, "policyDefinitionGroupNames", p.PolicyDefinitionGroupNames)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionName", p.PolicyDefinitionName)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "policyDefinitionVersion", p.PolicyDefinitionVersion)
	populate(objectMap, "policyEvaluationDetails", p.PolicyEvaluationDetails)
	populate(objectMap, "policySetDefinitionCategory", p.PolicySetDefinitionCategory)
	populate(objectMap, "policySetDefinitionId", p.PolicySetDefinitionID)
	populate(objectMap, "policySetDefinitionName", p.PolicySetDefinitionName)
	populate(objectMap, "policySetDefinitionOwner", p.PolicySetDefinitionOwner)
	populate(objectMap, "policySetDefinitionParameters", p.PolicySetDefinitionParameters)
	populate(objectMap, "policySetDefinitionVersion", p.PolicySetDefinitionVersion)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populate(objectMap, "resourceId", p.ResourceID)
	populate(objectMap, "resourceLocation", p.ResourceLocation)
	populate(objectMap, "resourceTags", p.ResourceTags)
	populate(objectMap, "resourceType", p.ResourceType)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	if p.AdditionalProperties != nil {
		for key, val := range p.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyState.
func (p *PolicyState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &p.ComplianceState)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &p.Components)
			delete(rawMsg, key)
		case "effectiveParameters":
			err = unpopulate(val, "EffectiveParameters", &p.EffectiveParameters)
			delete(rawMsg, key)
		case "isCompliant":
			err = unpopulate(val, "IsCompliant", &p.IsCompliant)
			delete(rawMsg, key)
		case "managementGroupIds":
			err = unpopulate(val, "ManagementGroupIDs", &p.ManagementGroupIDs)
			delete(rawMsg, key)
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &p.ODataContext)
			delete(rawMsg, key)
		case "@odata.id":
			err = unpopulate(val, "ODataID", &p.ODataID)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyAssignmentName":
			err = unpopulate(val, "PolicyAssignmentName", &p.PolicyAssignmentName)
			delete(rawMsg, key)
		case "policyAssignmentOwner":
			err = unpopulate(val, "PolicyAssignmentOwner", &p.PolicyAssignmentOwner)
			delete(rawMsg, key)
		case "policyAssignmentParameters":
			err = unpopulate(val, "PolicyAssignmentParameters", &p.PolicyAssignmentParameters)
			delete(rawMsg, key)
		case "policyAssignmentScope":
			err = unpopulate(val, "PolicyAssignmentScope", &p.PolicyAssignmentScope)
			delete(rawMsg, key)
		case "policyAssignmentVersion":
			err = unpopulate(val, "PolicyAssignmentVersion", &p.PolicyAssignmentVersion)
			delete(rawMsg, key)
		case "policyDefinitionAction":
			err = unpopulate(val, "PolicyDefinitionAction", &p.PolicyDefinitionAction)
			delete(rawMsg, key)
		case "policyDefinitionCategory":
			err = unpopulate(val, "PolicyDefinitionCategory", &p.PolicyDefinitionCategory)
			delete(rawMsg, key)
		case "policyDefinitionGroupNames":
			err = unpopulate(val, "PolicyDefinitionGroupNames", &p.PolicyDefinitionGroupNames)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionName":
			err = unpopulate(val, "PolicyDefinitionName", &p.PolicyDefinitionName)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "policyDefinitionVersion":
			err = unpopulate(val, "PolicyDefinitionVersion", &p.PolicyDefinitionVersion)
			delete(rawMsg, key)
		case "policyEvaluationDetails":
			err = unpopulate(val, "PolicyEvaluationDetails", &p.PolicyEvaluationDetails)
			delete(rawMsg, key)
		case "policySetDefinitionCategory":
			err = unpopulate(val, "PolicySetDefinitionCategory", &p.PolicySetDefinitionCategory)
			delete(rawMsg, key)
		case "policySetDefinitionId":
			err = unpopulate(val, "PolicySetDefinitionID", &p.PolicySetDefinitionID)
			delete(rawMsg, key)
		case "policySetDefinitionName":
			err = unpopulate(val, "PolicySetDefinitionName", &p.PolicySetDefinitionName)
			delete(rawMsg, key)
		case "policySetDefinitionOwner":
			err = unpopulate(val, "PolicySetDefinitionOwner", &p.PolicySetDefinitionOwner)
			delete(rawMsg, key)
		case "policySetDefinitionParameters":
			err = unpopulate(val, "PolicySetDefinitionParameters", &p.PolicySetDefinitionParameters)
			delete(rawMsg, key)
		case "policySetDefinitionVersion":
			err = unpopulate(val, "PolicySetDefinitionVersion", &p.PolicySetDefinitionVersion)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &p.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &p.ResourceLocation)
			delete(rawMsg, key)
		case "resourceTags":
			err = unpopulate(val, "ResourceTags", &p.ResourceTags)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &p.ResourceType)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		default:
			if p.AdditionalProperties == nil {
				p.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				p.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyStatesQueryResults.
func (p PolicyStatesQueryResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "@odata.context", p.ODataContext)
	populate(objectMap, "@odata.count", p.ODataCount)
	populate(objectMap, "@odata.nextLink", p.ODataNextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyStatesQueryResults.
func (p *PolicyStatesQueryResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &p.ODataContext)
			delete(rawMsg, key)
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &p.ODataCount)
			delete(rawMsg, key)
		case "@odata.nextLink":
			err = unpopulate(val, "ODataNextLink", &p.ODataNextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyTrackedResource.
func (p PolicyTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdBy", p.CreatedBy)
	populate(objectMap, "lastModifiedBy", p.LastModifiedBy)
	populateDateTimeRFC3339(objectMap, "lastUpdateUtc", p.LastUpdateUTC)
	populate(objectMap, "policyDetails", p.PolicyDetails)
	populate(objectMap, "trackedResourceId", p.TrackedResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyTrackedResource.
func (p *PolicyTrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &p.CreatedBy)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &p.LastModifiedBy)
			delete(rawMsg, key)
		case "lastUpdateUtc":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateUTC", &p.LastUpdateUTC)
			delete(rawMsg, key)
		case "policyDetails":
			err = unpopulate(val, "PolicyDetails", &p.PolicyDetails)
			delete(rawMsg, key)
		case "trackedResourceId":
			err = unpopulate(val, "TrackedResourceID", &p.TrackedResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyTrackedResourcesQueryResults.
func (p PolicyTrackedResourcesQueryResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyTrackedResourcesQueryResults.
func (p *PolicyTrackedResourcesQueryResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryFailure.
func (q QueryFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", q.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryFailure.
func (q *QueryFailure) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &q.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryFailureError.
func (q QueryFailureError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", q.Code)
	populate(objectMap, "message", q.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryFailureError.
func (q *QueryFailureError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &q.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &q.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Remediation.
func (r Remediation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Remediation.
func (r *Remediation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationDeployment.
func (r RemediationDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "deploymentId", r.DeploymentID)
	populate(objectMap, "error", r.Error)
	populateDateTimeRFC3339(objectMap, "lastUpdatedOn", r.LastUpdatedOn)
	populate(objectMap, "remediatedResourceId", r.RemediatedResourceID)
	populate(objectMap, "resourceLocation", r.ResourceLocation)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationDeployment.
func (r *RemediationDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &r.DeploymentID)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "lastUpdatedOn":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedOn", &r.LastUpdatedOn)
			delete(rawMsg, key)
		case "remediatedResourceId":
			err = unpopulate(val, "RemediatedResourceID", &r.RemediatedResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &r.ResourceLocation)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationDeploymentSummary.
func (r RemediationDeploymentSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failedDeployments", r.FailedDeployments)
	populate(objectMap, "successfulDeployments", r.SuccessfulDeployments)
	populate(objectMap, "totalDeployments", r.TotalDeployments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationDeploymentSummary.
func (r *RemediationDeploymentSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedDeployments":
			err = unpopulate(val, "FailedDeployments", &r.FailedDeployments)
			delete(rawMsg, key)
		case "successfulDeployments":
			err = unpopulate(val, "SuccessfulDeployments", &r.SuccessfulDeployments)
			delete(rawMsg, key)
		case "totalDeployments":
			err = unpopulate(val, "TotalDeployments", &r.TotalDeployments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationDeploymentsListResult.
func (r RemediationDeploymentsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationDeploymentsListResult.
func (r *RemediationDeploymentsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationFilters.
func (r RemediationFilters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", r.Locations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationFilters.
func (r *RemediationFilters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationListResult.
func (r RemediationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationListResult.
func (r *RemediationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationProperties.
func (r RemediationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationId", r.CorrelationID)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "failureThreshold", r.FailureThreshold)
	populate(objectMap, "filters", r.Filters)
	populateDateTimeRFC3339(objectMap, "lastUpdatedOn", r.LastUpdatedOn)
	populate(objectMap, "parallelDeployments", r.ParallelDeployments)
	populate(objectMap, "policyAssignmentId", r.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionReferenceId", r.PolicyDefinitionReferenceID)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceCount", r.ResourceCount)
	populate(objectMap, "resourceDiscoveryMode", r.ResourceDiscoveryMode)
	populate(objectMap, "statusMessage", r.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationProperties.
func (r *RemediationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &r.DeploymentStatus)
			delete(rawMsg, key)
		case "failureThreshold":
			err = unpopulate(val, "FailureThreshold", &r.FailureThreshold)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &r.Filters)
			delete(rawMsg, key)
		case "lastUpdatedOn":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedOn", &r.LastUpdatedOn)
			delete(rawMsg, key)
		case "parallelDeployments":
			err = unpopulate(val, "ParallelDeployments", &r.ParallelDeployments)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &r.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &r.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceCount":
			err = unpopulate(val, "ResourceCount", &r.ResourceCount)
			delete(rawMsg, key)
		case "resourceDiscoveryMode":
			err = unpopulate(val, "ResourceDiscoveryMode", &r.ResourceDiscoveryMode)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &r.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemediationPropertiesFailureThreshold.
func (r RemediationPropertiesFailureThreshold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "percentage", r.Percentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemediationPropertiesFailureThreshold.
func (r *RemediationPropertiesFailureThreshold) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "percentage":
			err = unpopulate(val, "Percentage", &r.Percentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlimPolicyMetadata.
func (s SlimPolicyMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlimPolicyMetadata.
func (s *SlimPolicyMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummarizeResults.
func (s SummarizeResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "@odata.context", s.ODataContext)
	populate(objectMap, "@odata.count", s.ODataCount)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummarizeResults.
func (s *SummarizeResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &s.ODataContext)
			delete(rawMsg, key)
		case "@odata.count":
			err = unpopulate(val, "ODataCount", &s.ODataCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Summary.
func (s Summary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "@odata.context", s.ODataContext)
	populate(objectMap, "@odata.id", s.ODataID)
	populate(objectMap, "policyAssignments", s.PolicyAssignments)
	populate(objectMap, "results", s.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Summary.
func (s *Summary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.context":
			err = unpopulate(val, "ODataContext", &s.ODataContext)
			delete(rawMsg, key)
		case "@odata.id":
			err = unpopulate(val, "ODataID", &s.ODataID)
			delete(rawMsg, key)
		case "policyAssignments":
			err = unpopulate(val, "PolicyAssignments", &s.PolicyAssignments)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &s.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummaryResults.
func (s SummaryResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nonCompliantPolicies", s.NonCompliantPolicies)
	populate(objectMap, "nonCompliantResources", s.NonCompliantResources)
	populate(objectMap, "policyDetails", s.PolicyDetails)
	populate(objectMap, "policyGroupDetails", s.PolicyGroupDetails)
	populate(objectMap, "queryResultsUri", s.QueryResultsURI)
	populate(objectMap, "resourceDetails", s.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummaryResults.
func (s *SummaryResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nonCompliantPolicies":
			err = unpopulate(val, "NonCompliantPolicies", &s.NonCompliantPolicies)
			delete(rawMsg, key)
		case "nonCompliantResources":
			err = unpopulate(val, "NonCompliantResources", &s.NonCompliantResources)
			delete(rawMsg, key)
		case "policyDetails":
			err = unpopulate(val, "PolicyDetails", &s.PolicyDetails)
			delete(rawMsg, key)
		case "policyGroupDetails":
			err = unpopulate(val, "PolicyGroupDetails", &s.PolicyGroupDetails)
			delete(rawMsg, key)
		case "queryResultsUri":
			err = unpopulate(val, "QueryResultsURI", &s.QueryResultsURI)
			delete(rawMsg, key)
		case "resourceDetails":
			err = unpopulate(val, "ResourceDetails", &s.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResourceModificationDetails.
func (t TrackedResourceModificationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentId", t.DeploymentID)
	populateDateTimeRFC3339(objectMap, "deploymentTime", t.DeploymentTime)
	populate(objectMap, "policyDetails", t.PolicyDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResourceModificationDetails.
func (t *TrackedResourceModificationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &t.DeploymentID)
			delete(rawMsg, key)
		case "deploymentTime":
			err = unpopulateDateTimeRFC3339(val, "DeploymentTime", &t.DeploymentTime)
			delete(rawMsg, key)
		case "policyDetails":
			err = unpopulate(val, "PolicyDetails", &t.PolicyDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TypedErrorInfo.
func (t TypedErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", t.Info)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TypedErrorInfo.
func (t *TypedErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &t.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
