//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/solutions/armmanagedapplications/v2"
	"net/http"
	"net/url"
	"regexp"
)

// JitRequestsServer is a fake server for instances of the armmanagedapplications.JitRequestsClient type.
type JitRequestsServer struct {
	// BeginCreateOrUpdate is the fake for method JitRequestsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, jitRequestName string, parameters armmanagedapplications.JitRequestDefinition, options *armmanagedapplications.JitRequestsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmanagedapplications.JitRequestsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method JitRequestsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, jitRequestName string, options *armmanagedapplications.JitRequestsClientDeleteOptions) (resp azfake.Responder[armmanagedapplications.JitRequestsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JitRequestsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	Get func(ctx context.Context, resourceGroupName string, jitRequestName string, options *armmanagedapplications.JitRequestsClientGetOptions) (resp azfake.Responder[armmanagedapplications.JitRequestsClientGetResponse], errResp azfake.ErrorResponder)

	// ListByResourceGroup is the fake for method JitRequestsClient.ListByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	ListByResourceGroup func(ctx context.Context, resourceGroupName string, options *armmanagedapplications.JitRequestsClientListByResourceGroupOptions) (resp azfake.Responder[armmanagedapplications.JitRequestsClientListByResourceGroupResponse], errResp azfake.ErrorResponder)

	// ListBySubscription is the fake for method JitRequestsClient.ListBySubscription
	// HTTP status codes to indicate success: http.StatusOK
	ListBySubscription func(ctx context.Context, options *armmanagedapplications.JitRequestsClientListBySubscriptionOptions) (resp azfake.Responder[armmanagedapplications.JitRequestsClientListBySubscriptionResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method JitRequestsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, jitRequestName string, parameters armmanagedapplications.JitRequestPatchable, options *armmanagedapplications.JitRequestsClientUpdateOptions) (resp azfake.Responder[armmanagedapplications.JitRequestsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewJitRequestsServerTransport creates a new instance of JitRequestsServerTransport with the provided implementation.
// The returned JitRequestsServerTransport instance is connected to an instance of armmanagedapplications.JitRequestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJitRequestsServerTransport(srv *JitRequestsServer) *JitRequestsServerTransport {
	return &JitRequestsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armmanagedapplications.JitRequestsClientCreateOrUpdateResponse]](),
	}
}

// JitRequestsServerTransport connects instances of armmanagedapplications.JitRequestsClient to instances of JitRequestsServer.
// Don't use this type directly, use NewJitRequestsServerTransport instead.
type JitRequestsServerTransport struct {
	srv                 *JitRequestsServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armmanagedapplications.JitRequestsClientCreateOrUpdateResponse]]
}

// Do implements the policy.Transporter interface for JitRequestsServerTransport.
func (j *JitRequestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JitRequestsClient.BeginCreateOrUpdate":
		resp, err = j.dispatchBeginCreateOrUpdate(req)
	case "JitRequestsClient.Delete":
		resp, err = j.dispatchDelete(req)
	case "JitRequestsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JitRequestsClient.ListByResourceGroup":
		resp, err = j.dispatchListByResourceGroup(req)
	case "JitRequestsClient.ListBySubscription":
		resp, err = j.dispatchListBySubscription(req)
	case "JitRequestsClient.Update":
		resp, err = j.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := j.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests/(?P<jitRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.JitRequestDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jitRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitRequestName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, jitRequestNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		j.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		j.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		j.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if j.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests/(?P<jitRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jitRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Delete(req.Context(), resourceGroupNameParam, jitRequestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests/(?P<jitRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jitRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), resourceGroupNameParam, jitRequestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitRequestDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchListByResourceGroup(req *http.Request) (*http.Response, error) {
	if j.srv.ListByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.ListByResourceGroup(req.Context(), resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitRequestDefinitionListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchListBySubscription(req *http.Request) (*http.Response, error) {
	if j.srv.ListBySubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListBySubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := j.srv.ListBySubscription(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitRequestDefinitionListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitRequestsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/jitRequests/(?P<jitRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.JitRequestPatchable](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jitRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Update(req.Context(), resourceGroupNameParam, jitRequestNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitRequestDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
