//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/workloads/armworkloads"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SAPCentralInstancesServer is a fake server for instances of the armworkloads.SAPCentralInstancesClient type.
type SAPCentralInstancesServer struct {
	// BeginCreate is the fake for method SAPCentralInstancesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, body armworkloads.SAPCentralServerInstance, options *armworkloads.SAPCentralInstancesClientBeginCreateOptions) (resp azfake.PollerResponder[armworkloads.SAPCentralInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SAPCentralInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, options *armworkloads.SAPCentralInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armworkloads.SAPCentralInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SAPCentralInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, options *armworkloads.SAPCentralInstancesClientGetOptions) (resp azfake.Responder[armworkloads.SAPCentralInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SAPCentralInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, sapVirtualInstanceName string, options *armworkloads.SAPCentralInstancesClientListOptions) (resp azfake.PagerResponder[armworkloads.SAPCentralInstancesClientListResponse])

	// BeginStartInstance is the fake for method SAPCentralInstancesClient.BeginStartInstance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartInstance func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, options *armworkloads.SAPCentralInstancesClientBeginStartInstanceOptions) (resp azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStartInstanceResponse], errResp azfake.ErrorResponder)

	// BeginStopInstance is the fake for method SAPCentralInstancesClient.BeginStopInstance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStopInstance func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, options *armworkloads.SAPCentralInstancesClientBeginStopInstanceOptions) (resp azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStopInstanceResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method SAPCentralInstancesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, centralInstanceName string, body armworkloads.UpdateSAPCentralInstanceRequest, options *armworkloads.SAPCentralInstancesClientBeginUpdateOptions) (resp azfake.PollerResponder[armworkloads.SAPCentralInstancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSAPCentralInstancesServerTransport creates a new instance of SAPCentralInstancesServerTransport with the provided implementation.
// The returned SAPCentralInstancesServerTransport instance is connected to an instance of armworkloads.SAPCentralInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSAPCentralInstancesServerTransport(srv *SAPCentralInstancesServer) *SAPCentralInstancesServerTransport {
	return &SAPCentralInstancesServerTransport{
		srv:                srv,
		beginCreate:        newTracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientCreateResponse]](),
		beginDelete:        newTracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientDeleteResponse]](),
		newListPager:       newTracker[azfake.PagerResponder[armworkloads.SAPCentralInstancesClientListResponse]](),
		beginStartInstance: newTracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStartInstanceResponse]](),
		beginStopInstance:  newTracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStopInstanceResponse]](),
		beginUpdate:        newTracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientUpdateResponse]](),
	}
}

// SAPCentralInstancesServerTransport connects instances of armworkloads.SAPCentralInstancesClient to instances of SAPCentralInstancesServer.
// Don't use this type directly, use NewSAPCentralInstancesServerTransport instead.
type SAPCentralInstancesServerTransport struct {
	srv                *SAPCentralInstancesServer
	beginCreate        *tracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientCreateResponse]]
	beginDelete        *tracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientDeleteResponse]]
	newListPager       *tracker[azfake.PagerResponder[armworkloads.SAPCentralInstancesClientListResponse]]
	beginStartInstance *tracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStartInstanceResponse]]
	beginStopInstance  *tracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientStopInstanceResponse]]
	beginUpdate        *tracker[azfake.PollerResponder[armworkloads.SAPCentralInstancesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SAPCentralInstancesServerTransport.
func (s *SAPCentralInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SAPCentralInstancesClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SAPCentralInstancesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SAPCentralInstancesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SAPCentralInstancesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SAPCentralInstancesClient.BeginStartInstance":
		resp, err = s.dispatchBeginStartInstance(req)
	case "SAPCentralInstancesClient.BeginStopInstance":
		resp, err = s.dispatchBeginStopInstance(req)
	case "SAPCentralInstancesClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloads.SAPCentralServerInstance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
	if err != nil {
		return nil, err
	}
	centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SAPCentralServerInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, sapVirtualInstanceNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armworkloads.SAPCentralInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchBeginStartInstance(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStartInstance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartInstance not implemented")}
	}
	beginStartInstance := s.beginStartInstance.get(req)
	if beginStartInstance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginStartInstance(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartInstance = &respr
		s.beginStartInstance.add(req, beginStartInstance)
	}

	resp, err := server.PollerResponderNext(beginStartInstance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStartInstance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartInstance) {
		s.beginStartInstance.remove(req)
	}

	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchBeginStopInstance(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStopInstance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStopInstance not implemented")}
	}
	beginStopInstance := s.beginStopInstance.get(req)
	if beginStopInstance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloads.StopRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
		if err != nil {
			return nil, err
		}
		var options *armworkloads.SAPCentralInstancesClientBeginStopInstanceOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armworkloads.SAPCentralInstancesClientBeginStopInstanceOptions{
				Body: &body,
			}
		}
		respr, errRespr := s.srv.BeginStopInstance(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStopInstance = &respr
		s.beginStopInstance.add(req, beginStopInstance)
	}

	resp, err := server.PollerResponderNext(beginStopInstance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStopInstance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStopInstance) {
		s.beginStopInstance.remove(req)
	}

	return resp, nil
}

func (s *SAPCentralInstancesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/centralInstances/(?P<centralInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloads.UpdateSAPCentralInstanceRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		centralInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("centralInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, centralInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
