// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/customer_manager_link_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerManagerLinkService.GetCustomerManagerLink][google.ads.googleads.v2.services.CustomerManagerLinkService.GetCustomerManagerLink].
type GetCustomerManagerLinkRequest struct {
	// Required. The resource name of the CustomerManagerLink to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerManagerLinkRequest) Reset()         { *m = GetCustomerManagerLinkRequest{} }
func (m *GetCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerManagerLinkRequest) ProtoMessage()    {}
func (*GetCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8cdb3ffa9e04120c, []int{0}
}

func (m *GetCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *GetCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerManagerLinkRequest.Merge(m, src)
}
func (m *GetCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Size(m)
}
func (m *GetCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *GetCustomerManagerLinkRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerManagerLinkService.MutateCustomerManagerLink][google.ads.googleads.v2.services.CustomerManagerLinkService.MutateCustomerManagerLink].
type MutateCustomerManagerLinkRequest struct {
	// Required. The ID of the customer whose customer manager links are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual customer manager links.
	Operations           []*CustomerManagerLinkOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateCustomerManagerLinkRequest) Reset()         { *m = MutateCustomerManagerLinkRequest{} }
func (m *MutateCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkRequest) ProtoMessage()    {}
func (*MutateCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8cdb3ffa9e04120c, []int{1}
}

func (m *MutateCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.Merge(m, src)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Size(m)
}
func (m *MutateCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerManagerLinkRequest) GetOperations() []*CustomerManagerLinkOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Updates the status of a CustomerManagerLink.
// The following actions are possible:
// 1. Update operation with status ACTIVE accepts a pending invitation.
// 2. Update operation with status REFUSED declines a pending invitation.
// 3. Update operation with status INACTIVE terminates link to manager.
type CustomerManagerLinkOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerManagerLinkOperation_Update
	Operation            isCustomerManagerLinkOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *CustomerManagerLinkOperation) Reset()         { *m = CustomerManagerLinkOperation{} }
func (m *CustomerManagerLinkOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerManagerLinkOperation) ProtoMessage()    {}
func (*CustomerManagerLinkOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8cdb3ffa9e04120c, []int{2}
}

func (m *CustomerManagerLinkOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerManagerLinkOperation.Unmarshal(m, b)
}
func (m *CustomerManagerLinkOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerManagerLinkOperation.Marshal(b, m, deterministic)
}
func (m *CustomerManagerLinkOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerManagerLinkOperation.Merge(m, src)
}
func (m *CustomerManagerLinkOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerManagerLinkOperation.Size(m)
}
func (m *CustomerManagerLinkOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerManagerLinkOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerManagerLinkOperation proto.InternalMessageInfo

func (m *CustomerManagerLinkOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerManagerLinkOperation_Operation interface {
	isCustomerManagerLinkOperation_Operation()
}

type CustomerManagerLinkOperation_Update struct {
	Update *resources.CustomerManagerLink `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomerManagerLinkOperation_Update) isCustomerManagerLinkOperation_Operation() {}

func (m *CustomerManagerLinkOperation) GetOperation() isCustomerManagerLinkOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerManagerLinkOperation) GetUpdate() *resources.CustomerManagerLink {
	if x, ok := m.GetOperation().(*CustomerManagerLinkOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerManagerLinkOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerManagerLinkOperation_Update)(nil),
	}
}

// Response message for a CustomerManagerLink mutate.
type MutateCustomerManagerLinkResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Results              []*MutateCustomerManagerLinkResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateCustomerManagerLinkResponse) Reset()         { *m = MutateCustomerManagerLinkResponse{} }
func (m *MutateCustomerManagerLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResponse) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8cdb3ffa9e04120c, []int{3}
}

func (m *MutateCustomerManagerLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Size(m)
}
func (m *MutateCustomerManagerLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResponse proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResponse) GetResults() []*MutateCustomerManagerLinkResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer manager link mutate.
type MutateCustomerManagerLinkResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerManagerLinkResult) Reset()         { *m = MutateCustomerManagerLinkResult{} }
func (m *MutateCustomerManagerLinkResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResult) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_8cdb3ffa9e04120c, []int{4}
}

func (m *MutateCustomerManagerLinkResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResult.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Size(m)
}
func (m *MutateCustomerManagerLinkResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResult proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerManagerLinkRequest)(nil), "google.ads.googleads.v2.services.GetCustomerManagerLinkRequest")
	proto.RegisterType((*MutateCustomerManagerLinkRequest)(nil), "google.ads.googleads.v2.services.MutateCustomerManagerLinkRequest")
	proto.RegisterType((*CustomerManagerLinkOperation)(nil), "google.ads.googleads.v2.services.CustomerManagerLinkOperation")
	proto.RegisterType((*MutateCustomerManagerLinkResponse)(nil), "google.ads.googleads.v2.services.MutateCustomerManagerLinkResponse")
	proto.RegisterType((*MutateCustomerManagerLinkResult)(nil), "google.ads.googleads.v2.services.MutateCustomerManagerLinkResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/customer_manager_link_service.proto", fileDescriptor_8cdb3ffa9e04120c)
}

var fileDescriptor_8cdb3ffa9e04120c = []byte{
	// 679 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4f, 0x6b, 0xd4, 0x4e,
	0x18, 0xfe, 0x25, 0x2d, 0xfd, 0xd1, 0x59, 0xbd, 0xe4, 0x50, 0xb7, 0x6b, 0xa5, 0x6b, 0xec, 0xa1,
	0x2c, 0x65, 0x02, 0x51, 0x8a, 0xa6, 0xb4, 0x32, 0x5b, 0x69, 0x2b, 0xd8, 0x5a, 0x56, 0x28, 0xa8,
	0x2b, 0xcb, 0x74, 0x33, 0x8d, 0xa1, 0x49, 0x66, 0xcd, 0x4c, 0xf6, 0x60, 0x29, 0x88, 0x82, 0x5f,
	0xc0, 0x6f, 0xa0, 0x37, 0xc1, 0x2f, 0xe0, 0x47, 0xe8, 0xd5, 0x5b, 0x4f, 0x15, 0x3c, 0xf9, 0x11,
	0x3c, 0x49, 0x32, 0x33, 0xd9, 0x14, 0x92, 0x5d, 0xb0, 0xb7, 0x77, 0xf3, 0x3e, 0xf3, 0x3c, 0xcf,
	0xfb, 0x67, 0x66, 0xc1, 0x23, 0x8f, 0x52, 0x2f, 0x20, 0x16, 0x76, 0x99, 0x25, 0xc2, 0x34, 0x1a,
	0xda, 0x16, 0x23, 0xf1, 0xd0, 0xef, 0x13, 0x66, 0xf5, 0x13, 0xc6, 0x69, 0x48, 0xe2, 0x5e, 0x88,
	0x23, 0xec, 0x91, 0xb8, 0x17, 0xf8, 0xd1, 0x71, 0x4f, 0xa6, 0xe1, 0x20, 0xa6, 0x9c, 0x1a, 0x4d,
	0x71, 0x14, 0x62, 0x97, 0xc1, 0x9c, 0x05, 0x0e, 0x6d, 0xa8, 0x58, 0x1a, 0xeb, 0x55, 0x3a, 0x31,
	0x61, 0x34, 0x89, 0x2b, 0x85, 0x84, 0x40, 0x63, 0x41, 0x1d, 0x1f, 0xf8, 0x16, 0x8e, 0x22, 0xca,
	0x31, 0xf7, 0x69, 0xc4, 0x64, 0xf6, 0x46, 0x21, 0xdb, 0x0f, 0x7c, 0x12, 0x71, 0x99, 0x58, 0x2c,
	0x24, 0x8e, 0x7c, 0x12, 0xb8, 0xbd, 0x43, 0xf2, 0x1a, 0x0f, 0x7d, 0x1a, 0x4b, 0xc0, 0x7c, 0x01,
	0xa0, 0x9c, 0xc8, 0x94, 0xac, 0xc9, 0xca, 0x7e, 0x1d, 0x26, 0x47, 0x92, 0x20, 0xc4, 0x4c, 0x9a,
	0x32, 0xdf, 0x82, 0x5b, 0xdb, 0x84, 0x6f, 0x4a, 0xdb, 0xbb, 0xc2, 0xf5, 0x13, 0x3f, 0x3a, 0xee,
	0x90, 0x37, 0x09, 0x61, 0xdc, 0x78, 0x0e, 0xae, 0x2b, 0xd2, 0x5e, 0x84, 0x43, 0x52, 0xd7, 0x9a,
	0xda, 0xf2, 0x6c, 0xfb, 0xde, 0x05, 0xd2, 0xff, 0x20, 0x08, 0x56, 0x46, 0xad, 0x92, 0xd1, 0xc0,
	0x67, 0xb0, 0x4f, 0x43, 0xab, 0x8c, 0xf3, 0x9a, 0xa2, 0xda, 0xc3, 0x21, 0x31, 0xbf, 0x69, 0xa0,
	0xb9, 0x9b, 0x70, 0xcc, 0xc9, 0x18, 0xfd, 0x25, 0x50, 0xcb, 0x9b, 0xea, 0xbb, 0x52, 0x7d, 0xea,
	0x02, 0xe9, 0x1d, 0xa0, 0xbe, 0x3f, 0x76, 0x8d, 0x3e, 0x00, 0x74, 0x40, 0x62, 0xd1, 0xd1, 0xba,
	0xde, 0x9c, 0x5a, 0xae, 0xd9, 0x1b, 0x70, 0xd2, 0x44, 0x61, 0x89, 0xee, 0x53, 0x45, 0x23, 0x45,
	0x46, 0xb4, 0xe6, 0x77, 0x0d, 0x2c, 0x8c, 0x3b, 0x61, 0xac, 0x81, 0x5a, 0x32, 0x70, 0x31, 0x27,
	0x59, 0x87, 0xeb, 0xd3, 0x4d, 0x6d, 0xb9, 0x66, 0x37, 0x94, 0x0d, 0x35, 0x04, 0xb8, 0x95, 0x0e,
	0x61, 0x17, 0xb3, 0xe3, 0x0e, 0x10, 0xf0, 0x34, 0x36, 0xf6, 0xc1, 0x8c, 0xf8, 0x55, 0xd7, 0xb3,
	0x73, 0xab, 0x95, 0xf6, 0xf3, 0x75, 0x2b, 0xf3, 0xbf, 0xf3, 0x5f, 0x47, 0xf2, 0xb4, 0x6b, 0x60,
	0x36, 0x77, 0x6f, 0xbe, 0xd3, 0xc0, 0xed, 0x31, 0xcd, 0x66, 0x03, 0x1a, 0x31, 0x62, 0xbc, 0x04,
	0xff, 0xc7, 0x84, 0x25, 0x01, 0x67, 0x75, 0x2d, 0x6b, 0x22, 0x9a, 0xdc, 0xc4, 0x71, 0xac, 0x49,
	0xc0, 0x3b, 0x8a, 0xd1, 0xdc, 0x02, 0x8b, 0x13, 0xb0, 0xc6, 0x9d, 0xd2, 0x6d, 0xbb, 0xbc, 0x37,
	0xf6, 0x97, 0x69, 0xd0, 0x28, 0xa1, 0x78, 0x26, 0x0c, 0x19, 0x3f, 0x35, 0x30, 0x57, 0xbe, 0xd3,
	0xc6, 0xc3, 0xc9, 0xd5, 0x8c, 0xbd, 0x0d, 0x8d, 0x7f, 0x1c, 0x8a, 0xb9, 0x77, 0x8e, 0x2e, 0x17,
	0xf6, 0xfe, 0xc7, 0xaf, 0x4f, 0xfa, 0x7d, 0x63, 0x35, 0x7d, 0x3e, 0x4e, 0x2e, 0x65, 0xd6, 0xd5,
	0x5a, 0x33, 0xab, 0x95, 0xbf, 0x27, 0x05, 0x2e, 0x66, 0xb5, 0x4e, 0x8d, 0x0f, 0x3a, 0x98, 0xaf,
	0xec, 0xa5, 0xd1, 0xbe, 0xd2, 0xd0, 0x44, 0xa5, 0x9b, 0x57, 0x1b, 0x7c, 0xb6, 0x4e, 0xe6, 0xab,
	0x73, 0x34, 0x57, 0xb8, 0xbd, 0x2b, 0xa3, 0xcb, 0x94, 0xd5, 0xbf, 0x61, 0x3e, 0x48, 0xeb, 0x1f,
	0x15, 0x7c, 0x52, 0x00, 0xaf, 0xb7, 0x4e, 0x4b, 0xcb, 0x77, 0xc2, 0x4c, 0xd6, 0xd1, 0x5a, 0x8d,
	0x9b, 0x67, 0xa8, 0x5e, 0xf5, 0xfe, 0xb4, 0x3f, 0xea, 0x60, 0xa9, 0x4f, 0xc3, 0x89, 0x65, 0xb4,
	0x17, 0xab, 0x77, 0x69, 0x3f, 0xbd, 0xb2, 0xfb, 0xda, 0x8b, 0x1d, 0x49, 0xe2, 0xd1, 0x00, 0x47,
	0x1e, 0xa4, 0xb1, 0x67, 0x79, 0x24, 0xca, 0x2e, 0xb4, 0x35, 0x92, 0xad, 0xfe, 0x03, 0x5a, 0x53,
	0xc1, 0x67, 0x7d, 0x6a, 0x1b, 0xa1, 0xaf, 0x7a, 0x73, 0x5b, 0x10, 0x22, 0x97, 0x41, 0x11, 0xa6,
	0xd1, 0x81, 0x0d, 0xa5, 0x30, 0x3b, 0x53, 0x90, 0x2e, 0x72, 0x59, 0x37, 0x87, 0x74, 0x0f, 0xec,
	0xae, 0x82, 0xfc, 0xd6, 0x97, 0xc4, 0x77, 0xc7, 0x41, 0x2e, 0x73, 0x9c, 0x1c, 0xe4, 0x38, 0x07,
	0xb6, 0xe3, 0x28, 0xd8, 0xe1, 0x4c, 0xe6, 0xf3, 0xee, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2c,
	0x3b, 0x7d, 0x2c, 0x27, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerManagerLinkServiceClient is the client API for CustomerManagerLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerManagerLinkServiceClient interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error)
}

type customerManagerLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerManagerLinkServiceClient(cc grpc.ClientConnInterface) CustomerManagerLinkServiceClient {
	return &customerManagerLinkServiceClient{cc}
}

func (c *customerManagerLinkServiceClient) GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error) {
	out := new(resources.CustomerManagerLink)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomerManagerLinkService/GetCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerManagerLinkServiceClient) MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error) {
	out := new(MutateCustomerManagerLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomerManagerLinkService/MutateCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerManagerLinkServiceServer is the server API for CustomerManagerLinkService service.
type CustomerManagerLinkServiceServer interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(context.Context, *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(context.Context, *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error)
}

// UnimplementedCustomerManagerLinkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerManagerLinkServiceServer struct {
}

func (*UnimplementedCustomerManagerLinkServiceServer) GetCustomerManagerLink(ctx context.Context, req *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerManagerLink not implemented")
}
func (*UnimplementedCustomerManagerLinkServiceServer) MutateCustomerManagerLink(ctx context.Context, req *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomerManagerLink not implemented")
}

func RegisterCustomerManagerLinkServiceServer(s *grpc.Server, srv CustomerManagerLinkServiceServer) {
	s.RegisterService(&_CustomerManagerLinkService_serviceDesc, srv)
}

func _CustomerManagerLinkService_GetCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomerManagerLinkService/GetCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, req.(*GetCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerManagerLinkService_MutateCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomerManagerLinkService/MutateCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, req.(*MutateCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerManagerLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.CustomerManagerLinkService",
	HandlerType: (*CustomerManagerLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_GetCustomerManagerLink_Handler,
		},
		{
			MethodName: "MutateCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_MutateCustomerManagerLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/customer_manager_link_service.proto",
}
