; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -loop-reduce -S | FileCheck %s

; This test tests several things. The load and store should use the
; same address instead of having it computed twice, and SCEVExpander should
; be able to reconstruct the full getelementptr, despite it having a few
; obstacles set in its way.
; We only check that the inner loop (bb1-bb2) is "reduced" because LSR
; currently only operates on inner loops.

target datalayout = "e-p:64:64:64-p1:16:16:16-n16:32:64"

define void @foo(i64 %n, i64 %m, i64 %o, i64 %q, ptr addrspace(1) nocapture %p) nounwind {
; CHECK-LABEL: define void @foo
; CHECK-SAME: (i64 [[N:%.*]], i64 [[M:%.*]], i64 [[O:%.*]], i64 [[Q:%.*]], ptr addrspace(1) nocapture [[P:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = icmp sgt i64 [[N]], 0
; CHECK-NEXT:    br i1 [[TMP]], label [[BB_NPH3:%.*]], label [[RETURN:%.*]]
; CHECK:       bb.nph:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LSR_IV2:%.*]] = phi ptr addrspace(1) [ [[SCEVGEP3:%.*]], [[BB2:%.*]] ], [ [[LSR_IV:%.*]], [[BB_NPH:%.*]] ]
; CHECK-NEXT:    [[J_01:%.*]] = phi i64 [ [[TMP9:%.*]], [[BB2]] ], [ 0, [[BB_NPH]] ]
; CHECK-NEXT:    [[TMP6:%.*]] = load double, ptr addrspace(1) [[LSR_IV2]], align 8
; CHECK-NEXT:    [[TMP7:%.*]] = fdiv double [[TMP6]], 2.100000e+00
; CHECK-NEXT:    store double [[TMP7]], ptr addrspace(1) [[LSR_IV2]], align 8
; CHECK-NEXT:    [[TMP9]] = add i64 [[J_01]], 1
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[SCEVGEP3]] = getelementptr i8, ptr addrspace(1) [[LSR_IV2]], i16 8
; CHECK-NEXT:    [[TMP10:%.*]] = icmp slt i64 [[TMP9]], [[M]]
; CHECK-NEXT:    br i1 [[TMP10]], label [[BB1]], label [[BB2_BB3_CRIT_EDGE:%.*]]
; CHECK:       bb2.bb3_crit_edge:
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[I_02:%.*]], 1
; CHECK-NEXT:    br label [[BB4:%.*]]
; CHECK:       bb4:
; CHECK-NEXT:    [[SCEVGEP1:%.*]] = getelementptr i8, ptr addrspace(1) [[LSR_IV]], i16 [[TMP4:%.*]]
; CHECK-NEXT:    [[TMP12:%.*]] = icmp slt i64 [[TMP11]], [[N]]
; CHECK-NEXT:    br i1 [[TMP12]], label [[BB2_PREHEADER:%.*]], label [[BB4_RETURN_CRIT_EDGE:%.*]]
; CHECK:       bb4.return_crit_edge:
; CHECK-NEXT:    br label [[BB4_RETURN_CRIT_EDGE_SPLIT:%.*]]
; CHECK:       bb4.return_crit_edge.split:
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       bb.nph3:
; CHECK-NEXT:    [[TMP13:%.*]] = icmp sgt i64 [[M]], 0
; CHECK-NEXT:    br i1 [[TMP13]], label [[BB_NPH3_SPLIT:%.*]], label [[BB4_RETURN_CRIT_EDGE_SPLIT]]
; CHECK:       bb.nph3.split:
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr addrspace(1) [[P]], i16 -23912
; CHECK-NEXT:    [[TMP0:%.*]] = mul i64 [[Q]], [[O]]
; CHECK-NEXT:    [[TMP1:%.*]] = mul i64 [[TMP0]], [[N]]
; CHECK-NEXT:    [[TMP2:%.*]] = mul i64 [[TMP1]], 37
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[TMP2]] to i16
; CHECK-NEXT:    [[TMP4]] = shl i16 [[TMP3]], 3
; CHECK-NEXT:    br label [[BB2_PREHEADER]]
; CHECK:       bb2.preheader:
; CHECK-NEXT:    [[LSR_IV]] = phi ptr addrspace(1) [ [[SCEVGEP]], [[BB_NPH3_SPLIT]] ], [ [[SCEVGEP1]], [[BB4]] ]
; CHECK-NEXT:    [[I_02]] = phi i64 [ [[TMP11]], [[BB4]] ], [ 0, [[BB_NPH3_SPLIT]] ]
; CHECK-NEXT:    br i1 true, label [[BB_NPH]], label [[BB3]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %tmp = icmp sgt i64 %n, 0		; <i1> [#uses=1]
  br i1 %tmp, label %bb.nph3, label %return

bb.nph:		; preds = %bb2.preheader
  %tmp1 = mul i64 %tmp16, %i.02		; <i64> [#uses=1]
  %tmp2 = mul i64 %tmp19, %i.02		; <i64> [#uses=1]
  br label %bb1

bb1:		; preds = %bb2, %bb.nph
  %j.01 = phi i64 [ %tmp9, %bb2 ], [ 0, %bb.nph ]		; <i64> [#uses=3]
  %tmp3 = add i64 %j.01, %tmp1		; <i64> [#uses=1]
  %tmp4 = add i64 %j.01, %tmp2		; <i64> [#uses=1]
  %z0 = add i64 %tmp3, 5203
  %tmp5 = getelementptr double, ptr addrspace(1) %p, i64 %z0		; <ptr addrspace(1)> [#uses=1]
  %tmp6 = load double, ptr addrspace(1) %tmp5, align 8		; <double> [#uses=1]
  %tmp7 = fdiv double %tmp6, 2.100000e+00		; <double> [#uses=1]
  %z1 = add i64 %tmp4, 5203
  %tmp8 = getelementptr double, ptr addrspace(1) %p, i64 %z1		; <ptr addrspace(1)> [#uses=1]
  store double %tmp7, ptr addrspace(1) %tmp8, align 8
  %tmp9 = add i64 %j.01, 1		; <i64> [#uses=2]
  br label %bb2

bb2:		; preds = %bb1
  %tmp10 = icmp slt i64 %tmp9, %m		; <i1> [#uses=1]
  br i1 %tmp10, label %bb1, label %bb2.bb3_crit_edge

bb2.bb3_crit_edge:		; preds = %bb2
  br label %bb3

bb3:		; preds = %bb2.preheader, %bb2.bb3_crit_edge
  %tmp11 = add i64 %i.02, 1		; <i64> [#uses=2]
  br label %bb4

bb4:		; preds = %bb3
  %tmp12 = icmp slt i64 %tmp11, %n		; <i1> [#uses=1]
  br i1 %tmp12, label %bb2.preheader, label %bb4.return_crit_edge

bb4.return_crit_edge:		; preds = %bb4
  br label %bb4.return_crit_edge.split

bb4.return_crit_edge.split:		; preds = %bb.nph3, %bb4.return_crit_edge
  br label %return

bb.nph3:		; preds = %entry
  %tmp13 = icmp sgt i64 %m, 0		; <i1> [#uses=1]
  %tmp14 = mul i64 %n, 37		; <i64> [#uses=1]
  %tmp15 = mul i64 %tmp14, %o		; <i64> [#uses=1]
  %tmp16 = mul i64 %tmp15, %q		; <i64> [#uses=1]
  %tmp17 = mul i64 %n, 37		; <i64> [#uses=1]
  %tmp18 = mul i64 %tmp17, %o		; <i64> [#uses=1]
  %tmp19 = mul i64 %tmp18, %q		; <i64> [#uses=1]
  br i1 %tmp13, label %bb.nph3.split, label %bb4.return_crit_edge.split

bb.nph3.split:		; preds = %bb.nph3
  br label %bb2.preheader

bb2.preheader:		; preds = %bb.nph3.split, %bb4
  %i.02 = phi i64 [ %tmp11, %bb4 ], [ 0, %bb.nph3.split ]		; <i64> [#uses=3]
  br i1 true, label %bb.nph, label %bb3

return:		; preds = %bb4.return_crit_edge.split, %entry
  ret void
}
