// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +zfh \
// RUN:   -target-feature +zvfh -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_f64m1x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv8i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_f64m1x4(double *base, vfloat64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_f64m1x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_f64m2x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv16i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_f64m2x4(double *base, vfloat64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_f64m2x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_i64m1x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv8i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_i64m1x4(int64_t *base, vint64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_i64m1x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_i64m2x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv16i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_i64m2x4(int64_t *base, vint64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_i64m2x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_u64m1x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv8i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_u64m1x4(uint64_t *base, vuint64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_u64m1x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_u64m2x4
// CHECK-RV64-SAME: (ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.triscv.vector.tuple_nxv16i8_4t.p0.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_u64m2x4(uint64_t *base, vuint64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_u64m2x4(base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_f64m1x4_m
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv8i8_4t.p0.nxv1i1.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_f64m1x4_m(vbool64_t mask, double *base, vfloat64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_f64m1x4_m(mask, base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_f64m2x4_m
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv16i8_4t.p0.nxv2i1.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_f64m2x4_m(vbool32_t mask, double *base, vfloat64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_f64m2x4_m(mask, base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_i64m1x4_m
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv8i8_4t.p0.nxv1i1.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_i64m1x4_m(vbool64_t mask, int64_t *base, vint64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_i64m1x4_m(mask, base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_i64m2x4_m
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv16i8_4t.p0.nxv2i1.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_i64m2x4_m(vbool32_t mask, int64_t *base, vint64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_i64m2x4_m(mask, base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_u64m1x4_m
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv8i8_4t.p0.nxv1i1.i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_u64m1x4_m(vbool64_t mask, uint64_t *base, vuint64m1x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_u64m1x4_m(mask, base, v_tuple, vl);
}

// CHECK-RV64-LABEL: define dso_local void @test_vsseg4e64_v_u64m2x4_m
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], ptr noundef [[BASE:%.*]], target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.vsseg4.mask.triscv.vector.tuple_nxv16i8_4t.p0.nxv2i1.i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) [[V_TUPLE]], ptr [[BASE]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 6)
// CHECK-RV64-NEXT:    ret void
//
void test_vsseg4e64_v_u64m2x4_m(vbool32_t mask, uint64_t *base, vuint64m2x4_t v_tuple, size_t vl) {
  return __riscv_vsseg4e64_v_u64m2x4_m(mask, base, v_tuple, vl);
}

