/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include <QGraphicsView>
#include <QGraphicsScene>

class MvQOdbMetaData;

class MvQOdbTableView : public QGraphicsView
{
    Q_OBJECT

public:
    MvQOdbTableView(QWidget* parent = 0);
    void init(MvQOdbMetaData*, QString);
    void renderTableGraph();
    void centreTableGraph();
    void setSelectedTable(QString);

signals:
    void tableSelection(QString);

public slots:
    void mousePressedInTableGraph(int, int);

protected:
    void getTablePos(int, int, int&, int&);
    bool setSelectedTable(int, int);
    void resizeEvent(QResizeEvent*);
    void adjustPixmapSizeToView(int, int, int&, int&);

    MvQOdbMetaData* odb_;

    int tableOffsetX_;
    int tableOffsetY_;
    int tableWidth_;
    int tableHeight_;
    int tableGapX_;
    int tableGapY_;
    int graphWidth_;
    int graphHeight_;

    QString selectedTable_;

    QPixmap* tablePixmap_;
};


class OdbTableScene : public QGraphicsScene
{
    Q_OBJECT

public:
    OdbTableScene(QGraphicsScene* parent = 0);

signals:
    void mousePressed(int, int);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent*);
};
