#version 450 core
#define PRECISION $precision
#define FORMAT    $format

layout(std430) buffer;

/* Qualifiers: layout - storage - precision - memory */

layout(set = 0, binding = 0, rgba8ui) uniform PRECISION restrict writeonly uimage3D   uOutput;
layout(set = 0, binding = 1)          uniform PRECISION                    isampler3D  uInput;
layout(set = 0, binding = 2)          uniform PRECISION restrict           Block {
  ivec4 size;
  ivec2 isize;
  vec2 scale;
} uBlock;

layout(local_size_x_id = 0, local_size_y_id = 1, local_size_z_id = 2) in;

void main() {
  const ivec3 pos = ivec3(gl_GlobalInvocationID);

  if (all(lessThan(pos, uBlock.size.xyz))) {
    const ivec2 ipos = clamp(
        ivec2(pos.xy * uBlock.scale),
        ivec2(0),
        uBlock.isize);

    vec4 texel = texelFetch(uInput, ivec3(ipos, pos.z), 0);
    uvec4 ret = uvec4(int(texel.r), int(texel.g), int(texel.b), int(texel.a));

    imageStore(
        uOutput,
        pos,
        ret);
  }
}
