% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{FeatureIntercepts}
\alias{FeatureIntercepts}
\alias{FeatureIntercepts<-}
\alias{FeatureIntercepts,MOFAmodel-method}
\alias{FeatureIntercepts<-,MOFAmodel,list-method}
\title{FeatureIntercepts: set and retrieve feature intercepts}
\usage{
FeatureIntercepts(object)

FeatureIntercepts(object) <- value

\S4method{FeatureIntercepts}{MOFAmodel}(object)

\S4method{FeatureIntercepts}{MOFAmodel,list}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{value}{list of feature intercepts (per view)}
}
\value{
list of feature intercepts (per view)
}
\description{
Function to set and retrieve feature intercepts
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
str(FeatureIntercepts(MOFAobject))
}
