% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_reddim.R
\name{Reduced dimension plots}
\alias{Reduced dimension plots}
\alias{plotPCASCE}
\alias{plotTSNE}
\alias{plotUMAP}
\alias{plotDiffusionMap}
\alias{plotMDS}
\alias{plotNMF}
\alias{plotPCA,SingleCellExperiment-method}
\alias{plotPCA}
\title{Plot specific reduced dimensions}
\usage{
plotPCASCE(object, ..., ncomponents = 2)

plotTSNE(object, ..., ncomponents = 2)

plotUMAP(object, ..., ncomponents = 2)

plotDiffusionMap(object, ..., ncomponents = 2)

plotMDS(object, ..., ncomponents = 2)

plotNMF(object, ..., ncomponents = 2)

\S4method{plotPCA}{SingleCellExperiment}(object, ..., ncomponents = 2)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{...}{Additional arguments to pass to \code{\link{plotReducedDim}}.}

\item{ncomponents}{Numeric scalar indicating the number of dimensions components to (calculate and) plot.
This can also be a numeric vector, see \code{?\link{plotReducedDim}} for details.}
}
\value{
A \link{ggplot} object.
}
\description{
Wrapper functions to create plots for specific types of reduced dimension results in a SingleCellExperiment object.
}
\details{
Each function is a convenient wrapper around \code{\link{plotReducedDim}} that searches the \code{\link{reducedDims}} slot for an appropriately named dimensionality reduction result:
\itemize{
\item \code{"PCA"} for \code{plotPCA}
\item \code{"TSNE"} for \code{plotTSNE}
\item \code{"DiffusionMap"} for \code{plotDiffusionMap}
\item \code{"MDS"} for \code{"plotMDS"}
\item \code{"NMF"} for \code{"plotNMF"}
\item \code{"UMAP"} for \code{"plotUMAP"}
}
Its only purpose is to streamline workflows to avoid the need to specify the \code{dimred} argument.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
example_sce <- runPCA(example_sce)

## Examples plotting PC1 and PC2
plotPCA(example_sce)
plotPCA(example_sce, colour_by = "Cell_Cycle")
plotPCA(example_sce, colour_by = "Cell_Cycle", shape_by = "Treatment")

## Examples plotting more than 2 PCs
plotPCA(example_sce, ncomponents = 4, colour_by = "Treatment",
    shape_by = "Mutation_Status")

## Same for TSNE:
example_sce <- runTSNE(example_sce)
plotTSNE(example_sce, colour_by="Mutation_Status")

\dontrun{
## Same for DiffusionMaps:
example_sce <- runDiffusionMap(example_sce)
plotDiffusionMap(example_sce)
}

## Same for MDS plots:
example_sce <- runMDS(example_sce)
plotMDS(example_sce)

}
\seealso{
\code{\link{runPCA}},
\code{\link{runDiffusionMap}}, 
\code{\link{runTSNE}}, 
\code{\link{runMDS}},
\code{\link{runNMF}},
and \code{\link{runUMAP}},
for the functions that actually perform the calculations.

\code{\link{plotReducedDim}}, for the underlying plotting function.
}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
