% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colCummaxs,dgCMatrix-method}
\alias{colCummaxs,dgCMatrix-method}
\alias{rowCummaxs,dgCMatrix-method}
\title{Calculates the cumulative maxima for each row (column) of a matrix-like
object}
\usage{
\S4method{colCummaxs}{dgCMatrix}(x, rows = NULL, cols = NULL, useNames = TRUE)

\S4method{rowCummaxs}{dgCMatrix}(x, rows = NULL, cols = NULL, useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}}with the same
dimensions as \code{x}.
}
\description{
Calculates the cumulative maxima for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowCummaxs}} /
\code{matrixStats::\link[matrixStats]{colCummaxs}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowCummaxs(mat)
colCummaxs(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowCumsums]{rowCummaxs}()} and
\code{matrixStats::\link[matrixStats:rowCumsums]{colCummaxs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For single maximum estimates, see \code{\link[MatrixGenerics]{rowMaxs}()}.
\item \code{base::\link{cummax}()}.
}
}
