% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeClusterFutureSlurm2.R
\name{makeClusterFunctionsSlurm2}
\alias{makeClusterFunctionsSlurm2}
\title{ClusterFunctions for Slurm Systems (patched)}
\usage{
makeClusterFunctionsSlurm2(
  template = "slurm",
  array.jobs = TRUE,
  nodename = "localhost",
  scheduler.latency = 1,
  fs.latency = 65
)
}
\arguments{
\item{template}{[\code{character(1)}]\cr
Either a path to a \pkg{brew} template file (with extension \dQuote{tmpl}), or a short descriptive name enabling the following heuristic for the file lookup:
\enumerate{
  \item \dQuote{batchtools.[template].tmpl} in the path specified by the environment variable \dQuote{R_BATCHTOOLS_SEARCH_PATH}.
  \item \dQuote{batchtools.[template].tmpl} in the current working directory.
  \item \dQuote{[template].tmpl} in the user config directory (see \code{\link[rappdirs]{user_config_dir}}); on linux this is usually \dQuote{~/.config/batchtools/[template].tmpl}.
  \item \dQuote{.batchtools.[template].tmpl} in the home directory.
  \item \dQuote{[template].tmpl} in the package installation directory in the subfolder \dQuote{templates}.
}}

\item{array.jobs}{[\code{logical(1)}]\cr
If array jobs are disabled on the computing site, set to \code{FALSE}.}

\item{nodename}{[\code{character(1)}]\cr
Nodename of the master host. All commands are send via SSH to this host. Only works iff
\enumerate{
  \item{Passwordless authentication (e.g., via SSH public key authentication) is set up.}
  \item{The file directory is shared across machines, e.g. mounted via SSHFS.}
  \item{Either the absolute path to the \code{file.dir} is identical on the machines, or paths are provided relative to the home directory. Symbolic links should work.}
}}

\item{scheduler.latency}{[\code{numeric(1)}]\cr
Time to sleep after important interactions with the scheduler to ensure a sane state.
Currently only triggered after calling \code{\link[batchtools]{submitJobs}}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}
}
\value{
A \link[batchtools:makeClusterFunctions]{batchtools::ClusterFunctions} object.
}
\description{
This functions enhances \code{\link[batchtools:makeClusterFunctionsSlurm]{batchtools::makeClusterFunctionsSlurm()}} with
a few patches.
Firstly, it patches the \code{listJobsQueued()} cluster function such that it
falls back to querying Slurm's account database (\code{sacct}), if the future
was \emph{not} found in the Slurm job queue (\code{squeue}), which might be the case
when Slurm provisions a job that was just submitted to the scheduler.
Secondly, it patched the \code{submitJob()} cluster function such that the
system call to \code{sbatch} does to capture stderr together with stdout, but
rather separately such that any extra INFO messages from \code{sbatch} do
not corrupt the output intended to come from stdout only.
}
