/*---------------------------------------------------------------------------*\
**$Author: saulius $
**$Date: 2017-11-19 12:24:19 +0200 (Sun, 19 Nov 2017) $ 
**$Revision: 77 $
**$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/smiles-scripts/tags/v0.2.0/src/net/crystallography/vector/space/ChangeOfBasis.java $
\*---------------------------------------------------------------------------*/

// Produce change-of-base matrix and provide a helper function to
// change basis of a vector.

package net.crystallography.vector.space;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class ChangeOfBasis {

    // Produce a change-of-base matrix given the components of *old*
    // basis vectors in the *new* basis:
    
    public static Matrix3d changeOfBaseMatrix( Vector3d va, Vector3d vb,
                                               Vector3d vc ) {
        Matrix3d m = new Matrix3d();
        m.setColumn(0, va);
        m.setColumn(1, vb);
        m.setColumn(2, vc);
        return m;
    }

    // Multiply a matrix with a vector (given as a Pion3d) from the
    // right. If the 'm' matrix was prodcued by the
    // 'changeOfBaseMatrix()' from this class, and the point 'p'
    // components are in the same *old* basis, then the result wil be
    // the point coordinates in the *new* basis:
    
    public static Point3d mpMultiply( Matrix3d m, Point3d p ) {
        Point3d xyz = new Point3d();
        xyz.setX( m.m00 * p.x + m.m01 * p.y + m.m02 * p.z );
        xyz.setY( m.m10 * p.x + m.m11 * p.y + m.m12 * p.z );
        xyz.setZ( m.m20 * p.x + m.m21 * p.y + m.m22 * p.z );
        return xyz;
    }
    
}
