{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetWeight: Single;
    procedure SetWeight(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCoordIndex: TMFInt32;
    { Internal wrapper for property @code(CoordIndex). This wrapper API may change, we advise to access simpler @code(CoordIndex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCoordIndex: TMFInt32 read FFdCoordIndex;
    {  }
    procedure SetCoordIndex(const Value: array of Int32); overload;
    {  }
    procedure SetCoordIndex(const Value: TInt32List); overload;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdDisplacements: TMFVec3f;
    { Internal wrapper for property @code(Displacements). This wrapper API may change, we advise to access simpler @code(Displacements) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacements: TMFVec3f read FFdDisplacements;
    {  }
    procedure SetDisplacements(const Value: array of TVector3); overload;
    {  }
    procedure SetDisplacements(const Value: TVector3List); overload;

    strict private FFdName: TSFString;
    { Internal wrapper for property @code(NameField). This wrapper API may change, we advise to access simpler @code(NameField) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdWeight: TSFFloat;
    { Internal wrapper for property @code(Weight). This wrapper API may change, we advise to access simpler @code(Weight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWeight: TSFFloat read FFdWeight;
    {  }
    property Weight: Single read GetWeight write SetWeight;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimDisplacerNode ----------------------------------------------- }

procedure THAnimDisplacerNode.SetCoordIndex(const Value: array of Int32);
begin
  FdCoordIndex.Send(Value);
end;

procedure THAnimDisplacerNode.SetCoordIndex(const Value: TInt32List);
begin
  FdCoordIndex.Send(Value);
end;

function THAnimDisplacerNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure THAnimDisplacerNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

procedure THAnimDisplacerNode.SetDisplacements(const Value: array of TVector3);
begin
  FdDisplacements.Send(Value);
end;

procedure THAnimDisplacerNode.SetDisplacements(const Value: TVector3List);
begin
  FdDisplacements.Send(Value);
end;

function THAnimDisplacerNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimDisplacerNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimDisplacerNode.GetWeight: Single;
begin
  Result := FdWeight.Value;
end;

procedure THAnimDisplacerNode.SetWeight(const Value: Single);
begin
  FdWeight.Send(Value);
end;

class function THAnimDisplacerNode.ClassX3DType: String;
begin
  Result := 'HAnimDisplacer';
end;

procedure THAnimDisplacerNode.CreateNode;
begin
  inherited;

  FFdCoordIndex := TMFInt32.Create(Self, True, 'coordIndex', []);
   FdCoordIndex.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCoordIndex);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FFdDisplacements := TMFVec3f.Create(Self, True, 'displacements', []);
   FdDisplacements.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacements);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdWeight := TSFFloat.Create(Self, True, 'weight', 0.0);
   FdWeight.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWeight);

  DefaultContainerField := 'displacers';
end;

{$endif read_implementation}
