{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetInternal: Boolean;
    procedure SetInternal(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_coordIndex: TMFInt32Event;
    {  }
    public property EventSet_coordIndex: TMFInt32Event read FEventSet_coordIndex;

    strict private FFdCoord: TSFNode;
    { Internal wrapper for property @code(Coord). This wrapper API may change, we advise to access simpler @code(Coord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCoord: TSFNode read FFdCoord;
    {  }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @code(Direction). This wrapper API may change, we advise to access simpler @code(Direction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdCoordIndex: TMFInt32;
    { Internal wrapper for property @code(CoordIndex). This wrapper API may change, we advise to access simpler @code(CoordIndex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCoordIndex: TMFInt32 read FFdCoordIndex;
    {  }
    procedure SetCoordIndex(const Value: array of Int32); overload;
    {  }
    procedure SetCoordIndex(const Value: TInt32List); overload;

    strict private FFdInternal: TSFBool;
    { Internal wrapper for property @code(Internal). This wrapper API may change, we advise to access simpler @code(Internal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInternal: TSFBool read FFdInternal;
    {  }
    property Internal: Boolean read GetInternal write SetInternal;

{$endif read_interface}

{$ifdef read_implementation}

{ TVolumeEmitterNode ----------------------------------------------- }

function TVolumeEmitterNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TVolumeEmitterNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

function TVolumeEmitterNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TVolumeEmitterNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: array of Int32);
begin
  FdCoordIndex.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: TInt32List);
begin
  FdCoordIndex.Send(Value);
end;

function TVolumeEmitterNode.GetInternal: Boolean;
begin
  Result := FdInternal.Value;
end;

procedure TVolumeEmitterNode.SetInternal(const Value: Boolean);
begin
  FdInternal.Send(Value);
end;

class function TVolumeEmitterNode.ClassX3DType: String;
begin
  Result := 'VolumeEmitter';
end;

procedure TVolumeEmitterNode.CreateNode;
begin
  inherited;

  FEventSet_coordIndex := TMFInt32Event.Create(Self, 'set_coordIndex', true);
  AddEvent(FEventSet_coordIndex);

  FFdCoord := TSFNode.Create(Self, True, 'coord', [TAbstractCoordinateNode]);
   FdCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCoord);

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 1, 0));
   FdDirection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirection);

  FFdCoordIndex := TMFInt32.Create(Self, False, 'coordIndex', [-1]);
   FdCoordIndex.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCoordIndex);

  FFdInternal := TSFBool.Create(Self, False, 'internal', true);
   FdInternal.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInternal);
end;

{$endif read_implementation}
