#
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import numpy as np


### Generic ###

DT_2M5 = 0
DT_5M  = 1
DT_7M5 = 2
DT_10M = 3
NUM_DT = 4

DT_MS = np.array([ 2.5, 5, 7.5, 10 ])


SRATE_8K     = 0
SRATE_8K     = 0
SRATE_16K    = 1
SRATE_24K    = 2
SRATE_32K    = 3
SRATE_48K    = 4
SRATE_48K_HR = 5
SRATE_96K_HR = 6
NUM_SR    = 6

SRATE_KHZ = np.array([ 8, 16, 24, 32, 48, 48, 96 ])


NS = np.array([(SRATE_KHZ * DT_MS[dt]).astype(int) for dt in range(NUM_DT) ])

ND = NS // 2 + np.array([ 5 * SRATE_KHZ, 5 * SRATE_KHZ, \
                          8 * SRATE_KHZ, 5 * SRATE_KHZ ]) // 4


I_2M5_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,
])

I_2M5_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  32,  34,  36,  38,  40,
])

I_2M5_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  28,  30,  32,
     34,  36,  38,  40,  42,  44,  47,  50,  53,  56,
     60,
])

I_2M5_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  26,  28,  30,  32,  34,
     36,  38,  40,  43,  46,  49,  52,  55,  59,  63,
     67,  71,  75,  80,
])

I_2M5_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  23,  25,  27,  29,  31,  33,  35,  37,
     40,  43,  46,  49,  52,  56,  60,  64,  68,  72,
     77,  82,  87,  93, 100,
])

I_2M5_48K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     21,  23,  25,  27,  29,  31,  33,  35,  37,  40,
     43,  46,  49,  53,  57,  61,  65,  69,  74,  79,
     85,  91,  97, 104, 112, 120
])

I_2M5_96K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  18,  20,  22,
     24,  26,  28,  30,  32,  35,  38,  41,  45,  49,
     53,  57,  62,  67,  73,  79,  85,  92, 100, 108,
    117, 127, 137, 149, 161, 174, 189, 204, 221, 240
])

I_5M_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  40,
])

I_5M_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  32,  34,  36,  38,  40,  42,  44,  46,  48,
     50,  52,  54,  57,  60,  63,  66,  69,  72,  76,
     80,
])

I_5M_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  26,  28,  30,  32,  34,
     36,  38,  40,  42,  44,  47,  50,  53,  56,  59,
     62,  65,  69,  73,  77,  81,  86,  91,  96, 101,
    107, 113, 120,
])

I_5M_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  24,  26,  28,  30,  32,  34,  36,
     38,  40,  42,  45,  48,  51,  54,  57,  61,  65,
     69,  73,  78,  83,  88,  93,  99, 105, 112, 119,
    126, 134, 142, 151, 160,
])

I_5M_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  23,  25,  27,  29,  31,  33,  35,  37,
     40,  43,  46,  49,  52,  55,  59,  63,  67,  72,
     77,  82,  87,  93,  99, 105, 112, 120, 128, 136,
    145, 155, 165, 176, 187, 200,
])

I_5M_48K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     21,  23,  25,  27,  29,  31,  33,  35,  38,  41,
     44,  47,  50,  54,  58,  62,  66,  71,  76,  81,
     87,  93, 100, 107, 114, 122, 131, 140, 149, 160,
    171, 183, 196, 209, 224, 240,
])

I_5M_96K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  19,  21,
     23,  25,  27,  29,  31,  34,  37,  40,  44,  48,
     52,  56,  61,  66,  71,  77,  83,  90,  98, 106,
    115, 124, 135, 146, 158, 171, 185, 200, 217, 235,
    254, 275, 298, 323, 349, 378, 409, 443, 480
])

I_7M5_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
     60
])

I_7M5_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  36,  38,  40,  42,  44,
     46,  48,  50,  52,  54,  56,  58,  60,  62,  65,
     68,  71,  74,  77,  80,  83,  86,  90,  94,  98,
    102, 106, 110, 115, 120
])

I_7M5_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  29,  31,
     33,  35,  37,  39,  41,  43,  45,  47,  49,  52,
     55,  58,  61,  64,  67,  70,  74,  78,  82,  86,
     90,  95, 100, 105, 110, 115, 121, 127, 134, 141,
    148, 155, 163, 171, 180
])

I_7M5_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  26,  28,  30,  32,  34,
     36,  38,  40,  42,  45,  48,  51,  54,  57,  60,
     63,  67,  71,  75,  79,  84,  89,  94,  99, 105,
    111, 117, 124, 131, 138, 146, 154, 163, 172, 182,
    192, 203, 215, 227, 240
])

I_7M5_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  24,  26,  28,  30,  32,  34,  36,
     38,  40,  43,  46,  49,  52,  55,  59,  63,  67,
     71,  75,  80,  85,  90,  96, 102, 108, 115, 122,
    129, 137, 146, 155, 165, 175, 186, 197, 209, 222,
    236, 251, 266, 283, 300
])

I_10M_8K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
     51,  53,  55,  57,  59,  61,  63,  65,  67,  69,
     71,  73,  75,  77,  80
])

I_10M_16K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  24,  25,  26,  27,  28,  30,
     32,  34,  36,  38,  40,  42,  44,  46,  48,  50,
     52,  55,  58,  61,  64,  67,  70,  73,  76,  80,
     84,  88,  92,  96, 101, 106, 111, 116, 121, 127,
    133, 139, 146, 153, 160
])

I_10M_24K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  21,  22,  23,  25,  27,  29,  31,  33,  35,
     37,  39,  41,  43,  46,  49,  52,  55,  58,  61,
     64,  68,  72,  76,  80,  85,  90,  95, 100, 106,
    112, 118, 125, 132, 139, 147, 155, 164, 173, 183,
    193, 204, 215, 227, 240
])

I_10M_32K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
     20,  22,  24,  26,  28,  30,  32,  34,  36,  38,
     41,  44,  47,  50,  53,  56,  60,  64,  68,  72,
     76,  81,  86,  91,  97, 103, 109, 116, 123, 131,
    139, 148, 157, 166, 176, 187, 199, 211, 224, 238,
    252, 268, 284, 302, 320
])

I_10M_48K = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  18,  20,
     22,  24,  26,  28,  30,  32,  34,  36,  39,  42,
     45,  48,  51,  55,  59,  63,  67,  71,  76,  81,
     86,  92,  98, 105, 112, 119, 127, 135, 144, 154,
    164, 175, 186, 198, 211, 225, 240, 256, 273, 291,
    310, 330, 352, 375, 400
])

I_10M_48K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  13,  14,  15,  16,  17,  19,  21,
     23,  25,  27,  29,  31,  33,  36,  39,  42,  45,
     48,  51,  55,  59,  63,  67,  72,  77,  83,  89,
     95, 101, 108, 116, 124, 133, 142, 152, 163, 174,
    187, 200, 214, 229, 244, 262, 280, 299, 320, 343,
    367, 392, 419, 449, 480
])

I_10M_96K_HR = np.array([
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
     10,  11,  12,  14,  16,  18,  20,  22,  24,  26,
     28,  30,  33,  36,  39,  42,  46,  50,  54,  59,
     64,  69,  75,  82,  89,  96, 104, 113, 122, 132,
    143, 155, 168, 181, 196, 213, 230, 249, 270, 292,
    316, 342, 371, 401, 434, 470, 509, 551, 596, 646,
    699, 757, 819, 887, 960
])

I = [ [ I_2M5_8K, I_2M5_16K, I_2M5_24K, I_2M5_32K, I_2M5_48K,
        I_2M5_48K_HR, I_2M5_96K_HR                           ],

      [ I_5M_8K , I_5M_16K , I_5M_24K , I_5M_32K , I_5M_48K ,
        I_5M_48K_HR, I_5M_96K_HR                             ],

      [ I_7M5_8K, I_7M5_16K, I_7M5_24K, I_7M5_32K, I_7M5_48K ],

      [ I_10M_8K, I_10M_16K, I_10M_24K, I_10M_32K, I_10M_48K,
        I_10M_48K_HR, I_10M_96K_HR                           ] ]


### LC3 PLUS - 5.9.2 ###

W_2M5_8K = np.array([
     6.73791440e-03,  2.73228958e-02,  6.16356097e-02,  1.11912504e-01,
     1.78705350e-01,  2.60752499e-01,  3.54977638e-01,  4.56769675e-01,
     5.60523927e-01,  6.60366535e-01,  7.50943422e-01,  8.28138232e-01,
     8.89585018e-01,  9.34874773e-01,  9.65405703e-01,  9.83902633e-01,
     9.93718088e-01,  9.98098731e-01,  9.99626637e-01,  9.99977291e-01,
     9.99977291e-01,  9.99626637e-01,  9.98098731e-01,  9.93718088e-01,
     9.83902633e-01,  9.65405703e-01,  9.34874773e-01,  8.89585018e-01,
     8.28138232e-01,  7.50943422e-01,  6.60366535e-01,  5.60523927e-01,
     4.56769675e-01,  3.54977638e-01,  2.60752499e-01,  1.78705350e-01,
     1.11912504e-01,  6.16356097e-02,  2.73228958e-02,  6.73791440e-03,
])

W_2M5_16K = np.array([
     4.76441615e-03,  1.20463628e-02,  2.22639654e-02,  3.58022311e-02,
     5.29905465e-02,  7.40851840e-02,  9.92538592e-02,  1.28563118e-01,
     1.61969244e-01,  1.99313241e-01,  2.40320282e-01,  2.84603818e-01,
     3.31674323e-01,  3.80952458e-01,  4.31786202e-01,  4.83471316e-01,
     5.35274327e-01,  5.86457098e-01,  6.36301916e-01,  6.84136019e-01,
     7.29354445e-01,  7.71440129e-01,  8.09980291e-01,  8.44678279e-01,
     8.75360204e-01,  9.01975984e-01,  9.24594627e-01,  9.43393949e-01,
     9.58645225e-01,  9.70693650e-01,  9.79935831e-01,  9.86795807e-01,
     9.91701328e-01,  9.95062145e-01,  9.97251917e-01,  9.98595014e-01,
     9.99358895e-01,  9.99752127e-01,  9.99927440e-01,  9.99988650e-01,
     9.99988650e-01,  9.99927440e-01,  9.99752127e-01,  9.99358895e-01,
     9.98595014e-01,  9.97251917e-01,  9.95062145e-01,  9.91701328e-01,
     9.86795807e-01,  9.79935831e-01,  9.70693650e-01,  9.58645225e-01,
     9.43393949e-01,  9.24594627e-01,  9.01975984e-01,  8.75360204e-01,
     8.44678279e-01,  8.09980291e-01,  7.71440129e-01,  7.29354445e-01,
     6.84136019e-01,  6.36301916e-01,  5.86457098e-01,  5.35274327e-01,
     4.83471316e-01,  4.31786202e-01,  3.80952458e-01,  3.31674323e-01,
     2.84603818e-01,  2.40320282e-01,  1.99313241e-01,  1.61969244e-01,
     1.28563118e-01,  9.92538592e-02,  7.40851840e-02,  5.29905465e-02,
     3.58022311e-02,  2.22639654e-02,  1.20463628e-02,  4.76441615e-03,
])

W_2M5_24K = np.array([
     3.89013421e-03,  8.20259508e-03,  1.37023556e-02,  2.05296853e-02,
     2.88030773e-02,  3.86278514e-02,  5.00956972e-02,  6.32829654e-02,
     7.82488109e-02,  9.50334651e-02,  1.13656749e-01,  1.34116888e-01,
     1.56389671e-01,  1.80427981e-01,  2.06161727e-01,  2.33498181e-01,
     2.62322720e-01,  2.92499991e-01,  3.23875450e-01,  3.56277288e-01,
     3.89518694e-01,  4.23400416e-01,  4.57713594e-01,  4.92242792e-01,
     5.26769190e-01,  5.61073868e-01,  5.94941120e-01,  6.28161737e-01,
     6.60536189e-01,  6.91877646e-01,  7.22014766e-01,  7.50794208e-01,
     7.78082793e-01,  8.03769285e-01,  8.27765737e-01,  8.50008365e-01,
     8.70457945e-01,  8.89099694e-01,  9.05942652e-01,  9.21018560e-01,
     9.34380273e-01,  9.46099727e-01,  9.56265526e-01,  9.64980202e-01,
     9.72357239e-01,  9.78517931e-01,  9.83588198e-01,  9.87695434e-01,
     9.90965519e-01,  9.93520077e-01,  9.95474078e-01,  9.96933861e-01,
     9.97995624e-01,  9.98744422e-01,  9.99253666e-01,  9.99585105e-01,
     9.99789244e-01,  9.99906118e-01,  9.99966358e-01,  9.99992433e-01,
     9.99992433e-01,  9.99966358e-01,  9.99906118e-01,  9.99789244e-01,
     9.99585105e-01,  9.99253666e-01,  9.98744422e-01,  9.97995624e-01,
     9.96933861e-01,  9.95474078e-01,  9.93520077e-01,  9.90965519e-01,
     9.87695434e-01,  9.83588198e-01,  9.78517931e-01,  9.72357239e-01,
     9.64980202e-01,  9.56265526e-01,  9.46099727e-01,  9.34380273e-01,
     9.21018560e-01,  9.05942652e-01,  8.89099694e-01,  8.70457945e-01,
     8.50008365e-01,  8.27765737e-01,  8.03769285e-01,  7.78082793e-01,
     7.50794208e-01,  7.22014766e-01,  6.91877646e-01,  6.60536189e-01,
     6.28161737e-01,  5.94941120e-01,  5.61073868e-01,  5.26769190e-01,
     4.92242792e-01,  4.57713594e-01,  4.23400416e-01,  3.89518694e-01,
     3.56277288e-01,  3.23875450e-01,  2.92499991e-01,  2.62322720e-01,
     2.33498181e-01,  2.06161727e-01,  1.80427981e-01,  1.56389671e-01,
     1.34116888e-01,  1.13656749e-01,  9.50334651e-02,  7.82488109e-02,
     6.32829654e-02,  5.00956972e-02,  3.86278514e-02,  2.88030773e-02,
     2.05296853e-02,  1.37023556e-02,  8.20259508e-03,  3.89013421e-03,
])

W_2M5_32K = np.array([
     3.36895835e-03,  6.45555741e-03,  1.01430808e-02,  1.45212685e-02,
     1.96507673e-02,  2.55835280e-02,  3.23662853e-02,  4.00411787e-02,
     4.86456418e-02,  5.82120708e-02,  6.87674290e-02,  8.03328498e-02,
     9.29232660e-02,  1.06547081e-01,  1.21205893e-01,  1.36894275e-01,
     1.53599623e-01,  1.71302066e-01,  1.89974455e-01,  2.09582413e-01,
     2.30084468e-01,  2.51432255e-01,  2.73570790e-01,  2.96438816e-01,
     3.19969212e-01,  3.44089476e-01,  3.68722258e-01,  3.93785956e-01,
     4.19195353e-01,  4.44862309e-01,  4.70696475e-01,  4.96606050e-01,
     5.22498546e-01,  5.48281575e-01,  5.73863636e-01,  5.99154896e-01,
     6.24067964e-01,  6.48518633e-01,  6.72426605e-01,  6.95716161e-01,
     7.18316799e-01,  7.40163807e-01,  7.61198780e-01,  7.81370064e-01,
     8.00633131e-01,  8.18950870e-01,  8.36293796e-01,  8.52640176e-01,
     8.67976054e-01,  8.82295205e-01,  8.95598976e-01,  9.07896060e-01,
     9.19202165e-01,  9.29539615e-01,  9.38936863e-01,  9.47427941e-01,
     9.55051846e-01,  9.61851871e-01,  9.67874900e-01,  9.73170662e-01,
     9.77790986e-01,  9.81789034e-01,  9.85218555e-01,  9.88133167e-01,
     9.90585664e-01,  9.92627388e-01,  9.94307658e-01,  9.95673273e-01,
     9.96768094e-01,  9.97632718e-01,  9.98304240e-01,  9.98816100e-01,
     9.99198030e-01,  9.99476075e-01,  9.99672688e-01,  9.99806905e-01,
     9.99894561e-01,  9.99948558e-01,  9.99979163e-01,  9.99994325e-01,
     9.99994325e-01,  9.99979163e-01,  9.99948558e-01,  9.99894561e-01,
     9.99806905e-01,  9.99672688e-01,  9.99476075e-01,  9.99198030e-01,
     9.98816100e-01,  9.98304240e-01,  9.97632718e-01,  9.96768094e-01,
     9.95673273e-01,  9.94307658e-01,  9.92627388e-01,  9.90585664e-01,
     9.88133167e-01,  9.85218555e-01,  9.81789034e-01,  9.77790986e-01,
     9.73170662e-01,  9.67874900e-01,  9.61851871e-01,  9.55051846e-01,
     9.47427941e-01,  9.38936863e-01,  9.29539615e-01,  9.19202165e-01,
     9.07896060e-01,  8.95598976e-01,  8.82295205e-01,  8.67976054e-01,
     8.52640176e-01,  8.36293796e-01,  8.18950870e-01,  8.00633131e-01,
     7.81370064e-01,  7.61198780e-01,  7.40163807e-01,  7.18316799e-01,
     6.95716161e-01,  6.72426605e-01,  6.48518633e-01,  6.24067964e-01,
     5.99154896e-01,  5.73863636e-01,  5.48281575e-01,  5.22498546e-01,
     4.96606050e-01,  4.70696475e-01,  4.44862309e-01,  4.19195353e-01,
     3.93785956e-01,  3.68722258e-01,  3.44089476e-01,  3.19969212e-01,
     2.96438816e-01,  2.73570790e-01,  2.51432255e-01,  2.30084468e-01,
     2.09582413e-01,  1.89974455e-01,  1.71302066e-01,  1.53599623e-01,
     1.36894275e-01,  1.21205893e-01,  1.06547081e-01,  9.29232660e-02,
     8.03328498e-02,  6.87674290e-02,  5.82120708e-02,  4.86456418e-02,
     4.00411787e-02,  3.23662853e-02,  2.55835280e-02,  1.96507673e-02,
     1.45212685e-02,  1.01430808e-02,  6.45555741e-03,  3.36895835e-03,
])

W_2M5_48K = np.array([
     2.75074638e-03,  4.77524515e-03,  6.99126548e-03,  9.47011816e-03,
     1.22441576e-02,  1.53355947e-02,  1.87626677e-02,  2.25415434e-02,
     2.66870142e-02,  3.12127707e-02,  3.61315008e-02,  4.14549100e-02,
     4.71937052e-02,  5.33575588e-02,  5.99550649e-02,  6.69936920e-02,
     7.44797342e-02,  8.24182658e-02,  9.08130967e-02,  9.96667332e-02,
     1.08980342e-01,  1.18753719e-01,  1.28985265e-01,  1.39671964e-01,
     1.50809372e-01,  1.62391604e-01,  1.74411338e-01,  1.86859813e-01,
     1.99726844e-01,  2.13000841e-01,  2.26668825e-01,  2.40716465e-01,
     2.55128110e-01,  2.69886836e-01,  2.84974488e-01,  3.00371741e-01,
     3.16058154e-01,  3.32012241e-01,  3.48211540e-01,  3.64632687e-01,
     3.81251499e-01,  3.98043054e-01,  4.14981787e-01,  4.32041576e-01,
     4.49195839e-01,  4.66417630e-01,  4.83679744e-01,  5.00954812e-01,
     5.18215407e-01,  5.35434150e-01,  5.52583807e-01,  5.69637402e-01,
     5.86568309e-01,  6.03350364e-01,  6.19957957e-01,  6.36366131e-01,
     6.52550680e-01,  6.68488237e-01,  6.84156362e-01,  6.99533624e-01,
     7.14599684e-01,  7.29335364e-01,  7.43722715e-01,  7.57745082e-01,
     7.71387158e-01,  7.84635031e-01,  7.97476230e-01,  8.09899758e-01,
     8.21896119e-01,  8.33457339e-01,  8.44576978e-01,  8.55250134e-01,
     8.65473441e-01,  8.75245054e-01,  8.84564635e-01,  8.93433321e-01,
     9.01853689e-01,  9.09829718e-01,  9.17366735e-01,  9.24471360e-01,
     9.31151439e-01,  9.37415982e-01,  9.43275077e-01,  9.48739819e-01,
     9.53822215e-01,  9.58535102e-01,  9.62892048e-01,  9.66907259e-01,
     9.70595479e-01,  9.73971891e-01,  9.77052016e-01,  9.79851615e-01,
     9.82386589e-01,  9.84672882e-01,  9.86726389e-01,  9.88562863e-01,
     9.90197830e-01,  9.91646510e-01,  9.92923740e-01,  9.94043905e-01,
     9.95020875e-01,  9.95867954e-01,  9.96597827e-01,  9.97222527e-01,
     9.97753399e-01,  9.98201077e-01,  9.98575471e-01,  9.98885756e-01,
     9.99140376e-01,  9.99347044e-01,  9.99512763e-01,  9.99643838e-01,
     9.99745907e-01,  9.99823966e-01,  9.99882403e-01,  9.99925037e-01,
     9.99955157e-01,  9.99975561e-01,  9.99988598e-01,  9.99996217e-01,
     9.99996217e-01,  9.99988598e-01,  9.99975561e-01,  9.99955157e-01,
     9.99925037e-01,  9.99882403e-01,  9.99823966e-01,  9.99745907e-01,
     9.99643838e-01,  9.99512763e-01,  9.99347044e-01,  9.99140376e-01,
     9.98885756e-01,  9.98575471e-01,  9.98201077e-01,  9.97753399e-01,
     9.97222527e-01,  9.96597827e-01,  9.95867954e-01,  9.95020875e-01,
     9.94043905e-01,  9.92923740e-01,  9.91646510e-01,  9.90197830e-01,
     9.88562863e-01,  9.86726389e-01,  9.84672882e-01,  9.82386589e-01,
     9.79851615e-01,  9.77052016e-01,  9.73971891e-01,  9.70595479e-01,
     9.66907259e-01,  9.62892048e-01,  9.58535102e-01,  9.53822215e-01,
     9.48739819e-01,  9.43275077e-01,  9.37415982e-01,  9.31151439e-01,
     9.24471360e-01,  9.17366735e-01,  9.09829718e-01,  9.01853689e-01,
     8.93433321e-01,  8.84564635e-01,  8.75245054e-01,  8.65473441e-01,
     8.55250134e-01,  8.44576978e-01,  8.33457339e-01,  8.21896119e-01,
     8.09899758e-01,  7.97476230e-01,  7.84635031e-01,  7.71387158e-01,
     7.57745082e-01,  7.43722715e-01,  7.29335364e-01,  7.14599684e-01,
     6.99533624e-01,  6.84156362e-01,  6.68488237e-01,  6.52550680e-01,
     6.36366131e-01,  6.19957957e-01,  6.03350364e-01,  5.86568309e-01,
     5.69637402e-01,  5.52583807e-01,  5.35434150e-01,  5.18215407e-01,
     5.00954812e-01,  4.83679744e-01,  4.66417630e-01,  4.49195839e-01,
     4.32041576e-01,  4.14981787e-01,  3.98043054e-01,  3.81251499e-01,
     3.64632687e-01,  3.48211540e-01,  3.32012241e-01,  3.16058154e-01,
     3.00371741e-01,  2.84974488e-01,  2.69886836e-01,  2.55128110e-01,
     2.40716465e-01,  2.26668825e-01,  2.13000841e-01,  1.99726844e-01,
     1.86859813e-01,  1.74411338e-01,  1.62391604e-01,  1.50809372e-01,
     1.39671964e-01,  1.28985265e-01,  1.18753719e-01,  1.08980342e-01,
     9.96667332e-02,  9.08130967e-02,  8.24182658e-02,  7.44797342e-02,
     6.69936920e-02,  5.99550649e-02,  5.33575588e-02,  4.71937052e-02,
     4.14549100e-02,  3.61315008e-02,  3.12127707e-02,  2.66870142e-02,
     2.25415434e-02,  1.87626677e-02,  1.53355947e-02,  1.22441576e-02,
     9.47011816e-03,  6.99126548e-03,  4.77524515e-03,  2.75074638e-03,
])

W_2M5_48K_HR = np.array([
     1.92887526e-07,  1.26862312e-06,  3.73694297e-06,  8.64938647e-06,
     1.75249988e-05,  3.25100409e-05,  5.65499504e-05,  9.35865319e-05,
     1.48780979e-04,  2.28761899e-04,  3.41896375e-04,  4.98580979e-04,
     7.11548259e-04,  9.96182440e-04,  1.37083745e-03,  1.85714674e-03,
     2.48031598e-03,  3.26938415e-03,  4.25744150e-03,  5.48178842e-03,
     6.98402245e-03,  8.81003775e-03,  1.10099232e-02,  1.36377569e-02,
     1.67512707e-02,  2.04114113e-02,  2.46817525e-02,  2.96278261e-02,
     3.53163108e-02,  4.18141559e-02,  4.91876006e-02,  5.75011559e-02,
     6.68165460e-02,  7.71916136e-02,  8.86792317e-02,  1.01326235e-01,
     1.15172401e-01,  1.30249396e-01,  1.46579877e-01,  1.64176553e-01,
     1.83041364e-01,  2.03164726e-01,  2.24524856e-01,  2.47087196e-01,
     2.70803988e-01,  2.95613915e-01,  3.21442008e-01,  3.48199695e-01,
     3.75785023e-01,  4.04083431e-01,  4.32968378e-01,  4.62302625e-01,
     4.91939783e-01,  5.21726012e-01,  5.51502347e-01,  5.81106782e-01,
     6.10377192e-01,  6.39154077e-01,  6.67283058e-01,  6.94617987e-01,
     7.21023440e-01,  7.46377110e-01,  7.70571768e-01,  7.93517113e-01,
     8.15140784e-01,  8.35389018e-01,  8.54227006e-01,  8.71638596e-01,
     8.87625158e-01,  9.02204990e-01,  9.15411413e-01,  9.27291155e-01,
     9.37902570e-01,  9.47313428e-01,  9.55598950e-01,  9.62839723e-01,
     9.69119847e-01,  9.74524975e-01,  9.79140759e-01,  9.83051181e-01,
     9.86337543e-01,  9.89076972e-01,  9.91342008e-01,  9.93199587e-01,
     9.94710743e-01,  9.95930433e-01,  9.96907234e-01,  9.97683644e-01,
     9.98296261e-01,  9.98776138e-01,  9.99149203e-01,  9.99436796e-01,
     9.99656200e-01,  9.99821365e-01,  9.99943137e-01,  1.00003016e+00,
     1.00008917e+00,  1.00012529e+00,  1.00014281e+00,  1.00014508e+00,
     1.00013494e+00,  1.00011492e+00,  1.00008726e+00,  1.00005412e+00,
     1.00001764e+00,  9.99979734e-01,  9.99942362e-01,  9.99907196e-01,
     9.99876022e-01,  9.99850094e-01,  9.99830663e-01,  9.99818563e-01,
     9.99814391e-01,  9.99818325e-01,  9.99830186e-01,  9.99849498e-01,
     9.99875486e-01,  9.99906898e-01,  9.99942422e-01,  9.99980509e-01,
     1.00001943e+00,  1.00005758e+00,  1.00009310e+00,  1.00012457e+00,
     1.00015044e+00,  1.00016987e+00,  1.00018167e+00,  1.00018561e+00,
     1.00018144e+00,  1.00016928e+00,  1.00014985e+00,  1.00012374e+00,
     1.00009227e+00,  1.00005662e+00,  1.00001836e+00,  9.99978960e-01,
     9.99939740e-01,  9.99902129e-01,  9.99867082e-01,  9.99835134e-01,
     9.99806285e-01,  9.99779761e-01,  9.99753773e-01,  9.99725282e-01,
     9.99689877e-01,  9.99641180e-01,  9.99570787e-01,  9.99467850e-01,
     9.99318600e-01,  9.99105930e-01,  9.98809040e-01,  9.98403072e-01,
     9.97858584e-01,  9.97141182e-01,  9.96211350e-01,  9.95023966e-01,
     9.93528485e-01,  9.91668522e-01,  9.89382327e-01,  9.86602664e-01,
     9.83257711e-01,  9.79271173e-01,  9.74563420e-01,  9.69052374e-01,
     9.62654769e-01,  9.55287457e-01,  9.46869195e-01,  9.37322080e-01,
     9.26573634e-01,  9.14558887e-01,  9.01221931e-01,  8.86518419e-01,
     8.70416999e-01,  8.52901220e-01,  8.33971083e-01,  8.13643873e-01,
     7.91955233e-01,  7.68959403e-01,  7.44728804e-01,  7.19353676e-01,
     6.92940772e-01,  6.65611804e-01,  6.37501359e-01,  6.08754635e-01,
     5.79524696e-01,  5.49970031e-01,  5.20251453e-01,  4.90529478e-01,
     4.60961968e-01,  4.31701392e-01,  4.02893007e-01,  3.74672860e-01,
     3.47166419e-01,  3.20487350e-01,  2.94736743e-01,  2.70002425e-01,
     2.46358722e-01,  2.23866433e-01,  2.02572897e-01,  1.82512373e-01,
     1.63706377e-01,  1.46164373e-01,  1.29884347e-01,  1.14853561e-01,
     1.01049446e-01,  8.84404257e-02,  7.69868940e-02,  6.66421950e-02,
     5.73536530e-02,  4.90636751e-02,  4.17107828e-02,  3.52307148e-02,
     2.95574907e-02,  2.46244166e-02,  2.03650557e-02,  1.67141166e-02,
     1.36082442e-02,  1.09867034e-02,  8.79194960e-03,  6.97008055e-03,
     5.47116203e-03,  4.24943818e-03,  3.26343346e-03,  2.47595203e-03,
     1.85399409e-03,  1.36859657e-03,  9.94618051e-04,  7.10477470e-04,
     4.97864152e-04,  3.41428356e-04,  2.28464938e-04,  1.48598730e-04,
     9.34789787e-05,  5.64894217e-05,  3.24779357e-05,  1.75092246e-05,
     8.64240701e-06,  3.73430225e-06,  1.26786131e-06,  1.92776696e-07,
])

W_2M5_96K_HR = np.array([
     1.36335345e-07,  4.57767612e-07,  9.97567554e-07,  1.84077624e-06,
     3.09224833e-06,  4.88094383e-06,  7.36381799e-06,  1.07300075e-05,
     1.52053863e-05,  2.10575054e-05,  2.86009363e-05,  3.82030121e-05,
     5.02899893e-05,  6.53535899e-05,  8.39579952e-05,  1.06747175e-04,
     1.34452668e-04,  1.67901671e-04,  2.08025551e-04,  2.55868625e-04,
     3.12597229e-04,  3.79509147e-04,  4.58043127e-04,  5.49788703e-04,
     6.56496093e-04,  7.80086033e-04,  9.22659819e-04,  1.08650920e-03,
     1.27412600e-03,  1.48821168e-03,  1.73168664e-03,  2.00769864e-03,
     2.31963093e-03,  2.67111068e-03,  3.06601473e-03,  3.50847607e-03,
     4.00288915e-03,  4.55391267e-03,  5.16647473e-03,  5.84577024e-03,
     6.59726607e-03,  7.42669497e-03,  8.34005512e-03,  9.34360363e-03,
     1.04438523e-02,  1.16475578e-02,  1.29617099e-02,  1.43935224e-02,
     1.59504171e-02,  1.76400058e-02,  1.94700807e-02,  2.14485861e-02,
     2.35835947e-02,  2.58832965e-02,  2.83559617e-02,  3.10099237e-02,
     3.38535421e-02,  3.68951820e-02,  4.01431806e-02,  4.36058082e-02,
     4.72912528e-02,  5.12075722e-02,  5.53626679e-02,  5.97642474e-02,
     6.44197986e-02,  6.93365484e-02,  7.45214298e-02,  7.99810365e-02,
     8.57216269e-02,  9.17490497e-02,  9.80687290e-02,  1.04685634e-01,
     1.11604236e-01,  1.18828513e-01,  1.26361862e-01,  1.34207115e-01,
     1.42366499e-01,  1.50841609e-01,  1.59633383e-01,  1.68742076e-01,
     1.78167209e-01,  1.87907621e-01,  1.97961360e-01,  2.08325714e-01,
     2.18997195e-01,  2.29971498e-01,  2.41243511e-01,  2.52807260e-01,
     2.64655977e-01,  2.76782036e-01,  2.89176911e-01,  3.01831275e-01,
     3.14734906e-01,  3.27876776e-01,  3.41245025e-01,  3.54826927e-01,
     3.68608981e-01,  3.82576853e-01,  3.96715522e-01,  4.11009163e-01,
     4.25441355e-01,  4.39994961e-01,  4.54652220e-01,  4.69394863e-01,
     4.84204173e-01,  4.99060899e-01,  5.13945460e-01,  5.28838038e-01,
     5.43718576e-01,  5.58566749e-01,  5.73362410e-01,  5.88085234e-01,
     6.02715075e-01,  6.17232025e-01,  6.31616414e-01,  6.45848989e-01,
     6.59910858e-01,  6.73783839e-01,  6.87450290e-01,  7.00893283e-01,
     7.14096606e-01,  7.27045000e-01,  7.39724100e-01,  7.52120554e-01,
     7.64221907e-01,  7.76016891e-01,  7.87495315e-01,  7.98648119e-01,
     8.09467375e-01,  8.19946468e-01,  8.30079675e-01,  8.39862764e-01,
     8.49292517e-01,  8.58366787e-01,  8.67084682e-01,  8.75446379e-01,
     8.83453131e-01,  8.91107082e-01,  8.98411512e-01,  9.05370474e-01,
     9.11989033e-01,  9.18272913e-01,  9.24228728e-01,  9.29863691e-01,
     9.35185611e-01,  9.40202892e-01,  9.44924474e-01,  9.49359715e-01,
     9.53518271e-01,  9.57410157e-01,  9.61045623e-01,  9.64435160e-01,
     9.67589259e-01,  9.70518589e-01,  9.73233819e-01,  9.75745618e-01,
     9.78064537e-01,  9.80201006e-01,  9.82165277e-01,  9.83967602e-01,
     9.85617757e-01,  9.87125397e-01,  9.88499880e-01,  9.89750206e-01,
     9.90885139e-01,  9.91913080e-01,  9.92841959e-01,  9.93679583e-01,
     9.94433045e-01,  9.95109439e-01,  9.95715141e-01,  9.96256351e-01,
     9.96738791e-01,  9.97167945e-01,  9.97548699e-01,  9.97885823e-01,
     9.98183608e-01,  9.98446047e-01,  9.98676717e-01,  9.98879075e-01,
     9.99056041e-01,  9.99210536e-01,  9.99344945e-01,  9.99461591e-01,
     9.99562562e-01,  9.99649644e-01,  9.99724448e-01,  9.99788404e-01,
     9.99842882e-01,  9.99888957e-01,  9.99927700e-01,  9.99959946e-01,
     9.99986470e-01,  1.00000799e+00,  1.00002515e+00,  1.00003839e+00,
     1.00004816e+00,  1.00005496e+00,  1.00005913e+00,  1.00006092e+00,
     1.00006080e+00,  1.00005877e+00,  1.00005519e+00,  1.00005031e+00,
     1.00004435e+00,  1.00003731e+00,  1.00002968e+00,  1.00002134e+00,
     1.00001252e+00,  1.00000334e+00,  9.99994040e-01,  9.99984682e-01,
     9.99975443e-01,  9.99966383e-01,  9.99957621e-01,  9.99949336e-01,
     9.99941528e-01,  9.99934316e-01,  9.99927878e-01,  9.99922156e-01,
     9.99917269e-01,  9.99913335e-01,  9.99910295e-01,  9.99908268e-01,
     9.99907196e-01,  9.99907196e-01,  9.99908149e-01,  9.99910176e-01,
     9.99913156e-01,  9.99917090e-01,  9.99921918e-01,  9.99927640e-01,
     9.99934137e-01,  9.99941349e-01,  9.99949217e-01,  9.99957681e-01,
     9.99966562e-01,  9.99975860e-01,  9.99985397e-01,  9.99995112e-01,
     1.00000489e+00,  1.00001454e+00,  1.00002408e+00,  1.00003338e+00,
     1.00004232e+00,  1.00005078e+00,  1.00005865e+00,  1.00006592e+00,
     1.00007236e+00,  1.00007808e+00,  1.00008297e+00,  1.00008690e+00,
     1.00008988e+00,  1.00009179e+00,  1.00009286e+00,  1.00009274e+00,
     1.00009179e+00,  1.00008965e+00,  1.00008667e+00,  1.00008261e+00,
     1.00007772e+00,  1.00007200e+00,  1.00006545e+00,  1.00005817e+00,
     1.00005031e+00,  1.00004172e+00,  1.00003278e+00,  1.00002337e+00,
     1.00001371e+00,  1.00000370e+00,  9.99993682e-01,  9.99983490e-01,
     9.99973357e-01,  9.99963224e-01,  9.99953210e-01,  9.99943376e-01,
     9.99933660e-01,  9.99924064e-01,  9.99914587e-01,  9.99905109e-01,
     9.99895573e-01,  9.99885738e-01,  9.99875546e-01,  9.99864578e-01,
     9.99852657e-01,  9.99839306e-01,  9.99824166e-01,  9.99806523e-01,
     9.99785900e-01,  9.99761462e-01,  9.99732316e-01,  9.99697566e-01,
     9.99655962e-01,  9.99606311e-01,  9.99547124e-01,  9.99476731e-01,
     9.99393344e-01,  9.99294996e-01,  9.99179363e-01,  9.99043941e-01,
     9.98886049e-01,  9.98702645e-01,  9.98490512e-01,  9.98246014e-01,
     9.97965276e-01,  9.97644246e-01,  9.97278214e-01,  9.96862471e-01,
     9.96391773e-01,  9.95860577e-01,  9.95262980e-01,  9.94592726e-01,
     9.93843138e-01,  9.93007302e-01,  9.92077827e-01,  9.91046965e-01,
     9.89906728e-01,  9.88648713e-01,  9.87264156e-01,  9.85744119e-01,
     9.84079301e-01,  9.82260108e-01,  9.80276704e-01,  9.78119195e-01,
     9.75777209e-01,  9.73240614e-01,  9.70498860e-01,  9.67541456e-01,
     9.64357972e-01,  9.60937798e-01,  9.57270682e-01,  9.53346252e-01,
     9.49154437e-01,  9.44685459e-01,  9.39929724e-01,  9.34878111e-01,
     9.29521918e-01,  9.23852861e-01,  9.17863250e-01,  9.11546052e-01,
     9.04894829e-01,  8.97903919e-01,  8.90568554e-01,  8.82884681e-01,
     8.74849200e-01,  8.66460025e-01,  8.57716084e-01,  8.48617196e-01,
     8.39164436e-01,  8.29359889e-01,  8.19206893e-01,  8.08709860e-01,
     7.97874272e-01,  7.86707044e-01,  7.75215983e-01,  7.63410211e-01,
     7.51299858e-01,  7.38896310e-01,  7.26211846e-01,  7.13259816e-01,
     7.00054646e-01,  6.86611593e-01,  6.72946632e-01,  6.59076810e-01,
     6.45019531e-01,  6.30793154e-01,  6.16416335e-01,  6.01908267e-01,
     5.87288618e-01,  5.72577178e-01,  5.57793975e-01,  5.42959273e-01,
     5.28093219e-01,  5.13215959e-01,  4.98347521e-01,  4.83507633e-01,
     4.68715757e-01,  4.53991085e-01,  4.39352304e-01,  4.24817562e-01,
     4.10404533e-01,  3.96130294e-01,  3.82011205e-01,  3.68063033e-01,
     3.54300767e-01,  3.40738595e-01,  3.27390045e-01,  3.14267725e-01,
     3.01383466e-01,  2.88748264e-01,  2.76372313e-01,  2.64264882e-01,
     2.52434462e-01,  2.40888610e-01,  2.29634136e-01,  2.18676925e-01,
     2.08022103e-01,  1.97673932e-01,  1.87635899e-01,  1.77910715e-01,
     1.68500274e-01,  1.59405768e-01,  1.50627658e-01,  1.42165691e-01,
     1.34018898e-01,  1.26185730e-01,  1.18663922e-01,  1.11450672e-01,
     1.04542568e-01,  9.79356542e-02,  9.16254595e-02,  8.56070295e-02,
     7.98749477e-02,  7.44233727e-02,  6.92460760e-02,  6.43364564e-02,
     5.96875995e-02,  5.52923009e-02,  5.11430874e-02,  4.72322591e-02,
     4.35519405e-02,  4.00940813e-02,  3.68505120e-02,  3.38129811e-02,
     3.09731625e-02,  2.83227116e-02,  2.58532818e-02,  2.35565584e-02,
     2.14242823e-02,  1.94482822e-02,  1.76204946e-02,  1.59329921e-02,
     1.43779973e-02,  1.29479105e-02,  1.16353221e-02,  1.04330294e-02,
     9.33405478e-03,  8.33165180e-03,  7.41932075e-03,  6.59081247e-03,
     5.84013900e-03,  5.16157458e-03,  4.54966258e-03,  3.99921415e-03,
     3.50530911e-03,  3.06329457e-03,  2.66878284e-03,  2.31764605e-03,
     2.00601248e-03,  1.73026032e-03,  1.48701016e-03,  1.27311819e-03,
     1.08566787e-03,  9.21960978e-04,  7.79508497e-04,  6.56021410e-04,
     5.49400807e-04,  4.57728049e-04,  3.79254925e-04,  3.12393560e-04,
     2.55706662e-04,  2.07897814e-04,  1.67801816e-04,  1.34375354e-04,
     1.06687941e-04,  8.39131390e-05,  6.53200550e-05,  5.02652765e-05,
     3.81850987e-05,  2.85881870e-05,  2.10486251e-05,  1.51993554e-05,
     1.07260339e-05,  7.36129550e-06,  4.87941543e-06,  3.09137795e-06,
     1.84032115e-06,  9.97358256e-07,  4.57689993e-07,  1.36315705e-07,
])

W_5M_8K = np.array([
     9.95908659e-04,  3.81905679e-03,  9.54083261e-03,  1.92165980e-02,
     3.38271908e-02,  5.42483167e-02,  8.12077767e-02,  1.15217189e-01,
     1.56494233e-01,  2.04936342e-01,  2.60116658e-01,  3.21281416e-01,
     3.87347300e-01,  4.56949708e-01,  5.28519296e-01,  6.00352249e-01,
     6.70689638e-01,  7.37804446e-01,  8.00092531e-01,  8.56140918e-01,
     9.04827229e-01,  9.45368503e-01,  9.77350743e-01,  1.00080087e+00,
     1.01617159e+00,  1.02431525e+00,  1.02641543e+00,  1.02385837e+00,
     1.01813571e+00,  1.01079482e+00,  1.00340651e+00,  9.96783127e-01,
     9.92099552e-01,  9.89220694e-01,  9.87965832e-01,  9.88127353e-01,
     9.89480554e-01,  9.91784992e-01,  9.94784758e-01,  9.98211967e-01,
     1.00179124e+00,  1.00524258e+00,  1.00828305e+00,  1.01063128e+00,
     1.01201530e+00,  1.01218075e+00,  1.01089677e+00,  1.00796336e+00,
     1.00322726e+00,  9.96605055e-01,  9.86828423e-01,  9.73125029e-01,
     9.54063648e-01,  9.28386428e-01,  8.95091686e-01,  8.53476936e-01,
     8.03209093e-01,  7.44473520e-01,  6.78078703e-01,  6.05397045e-01,
     5.28207751e-01,  4.48655296e-01,  3.69187599e-01,  2.92456641e-01,
     2.21071854e-01,  1.57314858e-01,  1.03052576e-01,  5.98273224e-02,
     2.87183192e-02,  9.68388493e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_16K = np.array([
     6.14338818e-04,  1.48958283e-03,  2.88410496e-03,  4.93429883e-03,
     7.77913046e-03,  1.15491061e-02,  1.63715562e-02,  2.23711616e-02,
     2.96615969e-02,  3.83566333e-02,  4.85561099e-02,  6.03505574e-02,
     7.38228820e-02,  8.90356369e-02,  1.06035623e-01,  1.24853486e-01,
     1.45493189e-01,  1.67943556e-01,  1.92172862e-01,  2.18123826e-01,
     2.45725974e-01,  2.74883943e-01,  3.05482471e-01,  3.37387380e-01,
     3.70441593e-01,  4.04474963e-01,  4.39300436e-01,  4.74722545e-01,
     5.10534149e-01,  5.46520192e-01,  5.82465810e-01,  6.18145266e-01,
     6.53341146e-01,  6.87836730e-01,  7.21417603e-01,  7.53888797e-01,
     7.85054657e-01,  8.14739745e-01,  8.42781936e-01,  8.69037674e-01,
     8.93393548e-01,  9.15748356e-01,  9.36027020e-01,  9.54173114e-01,
     9.70163547e-01,  9.84003644e-01,  9.95719942e-01,  1.00537427e+00,
     1.01304666e+00,  1.01884338e+00,  1.02289695e+00,  1.02535529e+00,
     1.02638288e+00,  1.02615553e+00,  1.02485397e+00,  1.02266460e+00,
     1.01977940e+00,  1.01639169e+00,  1.01269703e+00,  1.00888519e+00,
     1.00537874e+00,  1.00156378e+00,  9.98253156e-01,  9.95434664e-01,
     9.93095027e-01,  9.91217091e-01,  9.89780519e-01,  9.88762494e-01,
     9.88138324e-01,  9.87881941e-01,  9.87966213e-01,  9.88363051e-01,
     9.89043407e-01,  9.89977232e-01,  9.91133456e-01,  9.92480044e-01,
     9.93984121e-01,  9.95612147e-01,  9.97330059e-01,  9.99103363e-01,
     1.00089744e+00,  1.00267709e+00,  1.00440719e+00,  1.00605229e+00,
     1.00757693e+00,  1.00894586e+00,  1.01012424e+00,  1.01107797e+00,
     1.01177396e+00,  1.01218036e+00,  1.01226671e+00,  1.01200406e+00,
     1.01136522e+00,  1.01032500e+00,  1.00886073e+00,  1.00695298e+00,
     1.00458627e+00,  1.00174990e+00,  9.98438663e-01,  9.94650033e-01,
     9.89575685e-01,  9.83830313e-01,  9.76999916e-01,  9.68914116e-01,
     9.59403812e-01,  9.48308632e-01,  9.35486022e-01,  9.20810131e-01,
     9.04173226e-01,  8.85488225e-01,  8.64686495e-01,  8.41723747e-01,
     8.16587571e-01,  7.89298635e-01,  7.59917189e-01,  7.28547452e-01,
     6.95328294e-01,  6.60433402e-01,  6.24066143e-01,  5.86446142e-01,
     5.47816066e-01,  5.08449976e-01,  4.68636143e-01,  4.28678989e-01,
     3.88903272e-01,  3.49643142e-01,  3.11236082e-01,  2.74012847e-01,
     2.38284723e-01,  2.04337983e-01,  1.72430586e-01,  1.42793979e-01,
     1.15638588e-01,  9.11582177e-02,  6.95274904e-02,  5.08897541e-02,
     3.53343019e-02,  2.28668041e-02,  1.33800502e-02,  6.64050653e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_24K = np.array([
     5.08722763e-04,  9.95908659e-04,  1.68220801e-03,  2.60969726e-03,
     3.81905679e-03,  5.34931959e-03,  7.24390638e-03,  9.54083261e-03,
     1.22763764e-02,  1.54895024e-02,  1.92165980e-02,  2.34936962e-02,
     2.83519958e-02,  3.38271908e-02,  3.99493954e-02,  4.67477524e-02,
     5.42483167e-02,  6.24777078e-02,  7.14583592e-02,  8.12077767e-02,
     9.17440041e-02,  1.03076496e-01,  1.15217189e-01,  1.28166571e-01,
     1.41926438e-01,  1.56494233e-01,  1.71859319e-01,  1.88013425e-01,
     2.04936342e-01,  2.22612306e-01,  2.41015124e-01,  2.60116658e-01,
     2.79887101e-01,  3.00288014e-01,  3.21281416e-01,  3.42820846e-01,
     3.64859656e-01,  3.87347300e-01,  4.10229495e-01,  4.33449453e-01,
     4.56949708e-01,  4.80669640e-01,  5.04547382e-01,  5.28519296e-01,
     5.52519610e-01,  5.76487245e-01,  6.00352249e-01,  6.24050987e-01,
     6.47518259e-01,  6.70689638e-01,  6.93502907e-01,  7.15892752e-01,
     7.37804446e-01,  7.59178724e-01,  7.79958661e-01,  8.00092531e-01,
     8.19531865e-01,  8.38228896e-01,  8.56140918e-01,  8.73231695e-01,
     8.89470202e-01,  9.04827229e-01,  9.19273638e-01,  9.32794041e-01,
     9.45368503e-01,  9.56988393e-01,  9.67648642e-01,  9.77350743e-01,
     9.86102783e-01,  9.93912241e-01,  1.00080087e+00,  1.00678781e+00,
     1.01190127e+00,  1.01617159e+00,  1.01963641e+00,  1.02233661e+00,
     1.02431525e+00,  1.02562130e+00,  1.02630344e+00,  1.02641543e+00,
     1.02600793e+00,  1.02513744e+00,  1.02385837e+00,  1.02222694e+00,
     1.02030055e+00,  1.01813571e+00,  1.01579215e+00,  1.01332597e+00,
     1.01079482e+00,  1.00826513e+00,  1.00604687e+00,  1.00340651e+00,
     1.00097740e+00,  9.98770454e-01,  9.96783127e-01,  9.95011891e-01,
     9.93452397e-01,  9.92099552e-01,  9.90947600e-01,  9.89990243e-01,
     9.89220694e-01,  9.88631804e-01,  9.88216090e-01,  9.87965832e-01,
     9.87873077e-01,  9.87929693e-01,  9.88127353e-01,  9.88457554e-01,
     9.88911587e-01,  9.89480554e-01,  9.90155346e-01,  9.90926656e-01,
     9.91784992e-01,  9.92720684e-01,  9.93723921e-01,  9.94784758e-01,
     9.95893149e-01,  9.97038957e-01,  9.98211967e-01,  9.99402034e-01,
     1.00059832e+00,  1.00179124e+00,  1.00296984e+00,  1.00412379e+00,
     1.00524258e+00,  1.00631572e+00,  1.00733269e+00,  1.00828305e+00,
     1.00915642e+00,  1.00994254e+00,  1.01063128e+00,  1.01121274e+00,
     1.01167723e+00,  1.01201530e+00,  1.01221778e+00,  1.01227579e+00,
     1.01218075e+00,  1.01192443e+00,  1.01149892e+00,  1.01089677e+00,
     1.01011097e+00,  1.00913509e+00,  1.00796336e+00,  1.00659076e+00,
     1.00501312e+00,  1.00322726e+00,  1.00123106e+00,  9.99023556e-01,
     9.96605055e-01,  9.93989471e-01,  9.90453920e-01,  9.86828423e-01,
     9.82771674e-01,  9.78220667e-01,  9.73125029e-01,  9.67432353e-01,
     9.61094704e-01,  9.54063648e-01,  9.46295299e-01,  9.37748911e-01,
     9.28386428e-01,  9.18176261e-01,  9.07086156e-01,  8.95091686e-01,
     8.82169624e-01,  8.68302529e-01,  8.53476936e-01,  8.37685201e-01,
     8.20927526e-01,  8.03209093e-01,  7.84545048e-01,  7.64955485e-01,
     7.44473520e-01,  7.23134807e-01,  7.00986056e-01,  6.78078703e-01,
     6.54468651e-01,  6.30221215e-01,  6.05397045e-01,  5.80071577e-01,
     5.54312928e-01,  5.28207751e-01,  5.01836972e-01,  4.75290296e-01,
     4.48655296e-01,  4.22028112e-01,  3.95505797e-01,  3.69187599e-01,
     3.43173285e-01,  3.17563302e-01,  2.92456641e-01,  2.67946378e-01,
     2.44123133e-01,  2.21071854e-01,  1.98871915e-01,  1.77596763e-01,
     1.57314858e-01,  1.38090336e-01,  1.19983750e-01,  1.03052576e-01,
     8.73508501e-02,  7.29281158e-02,  5.98273224e-02,  4.80817884e-02,
     3.77113530e-02,  2.87183192e-02,  2.10835203e-02,  1.47628941e-02,
     9.68388493e-03,  5.64216879e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_32K = np.array([
     4.59588635e-04,  7.91932361e-04,  1.22792717e-03,  1.78365327e-03,
     2.47954941e-03,  3.32979945e-03,  4.35353548e-03,  5.56496516e-03,
     6.98610836e-03,  8.62988232e-03,  1.05134341e-02,  1.26508264e-02,
     1.50609045e-02,  1.77559123e-02,  2.07547598e-02,  2.40681372e-02,
     2.77120786e-02,  3.16993325e-02,  3.60460964e-02,  4.07612864e-02,
     4.58603812e-02,  5.13513668e-02,  5.72478022e-02,  6.35585474e-02,
     7.02945073e-02,  7.74598720e-02,  8.50663537e-02,  9.31164162e-02,
     1.01616296e-01,  1.10569081e-01,  1.19978929e-01,  1.29841729e-01,
     1.40162380e-01,  1.50937156e-01,  1.62163230e-01,  1.73835412e-01,
     1.85952036e-01,  1.98500883e-01,  2.11477855e-01,  2.24873256e-01,
     2.38676395e-01,  2.52872945e-01,  2.67454701e-01,  2.82403147e-01,
     2.97705015e-01,  3.13341912e-01,  3.29297670e-01,  3.45549016e-01,
     3.62079505e-01,  3.78864867e-01,  3.95885158e-01,  4.13114379e-01,
     4.30530830e-01,  4.48107672e-01,  4.65822779e-01,  4.83646639e-01,
     5.01556485e-01,  5.19522807e-01,  5.37519704e-01,  5.55518384e-01,
     5.73495781e-01,  5.91418665e-01,  6.09262289e-01,  6.26998116e-01,
     6.44600201e-01,  6.62038458e-01,  6.79290655e-01,  6.96325643e-01,
     7.13119439e-01,  7.29646991e-01,  7.45886459e-01,  7.61809472e-01,
     7.77395845e-01,  7.92620875e-01,  8.07466639e-01,  8.21910156e-01,
     8.35934316e-01,  8.49518047e-01,  8.62648584e-01,  8.75308323e-01,
     8.87488472e-01,  8.99173772e-01,  9.10352743e-01,  9.21014413e-01,
     9.31155619e-01,  9.40764474e-01,  9.49838224e-01,  9.58373260e-01,
     9.66369041e-01,  9.73823562e-01,  9.80744251e-01,  9.87129797e-01,
     9.92987227e-01,  9.98324140e-01,  1.00315076e+00,  1.00747371e+00,
     1.01130915e+00,  1.01466668e+00,  1.01756334e+00,  1.02001468e+00,
     1.02203987e+00,  1.02365426e+00,  1.02488162e+00,  1.02573929e+00,
     1.02625071e+00,  1.02643667e+00,  1.02632086e+00,  1.02592292e+00,
     1.02526998e+00,  1.02438219e+00,  1.02328494e+00,  1.02200083e+00,
     1.02055597e+00,  1.01897139e+00,  1.01727518e+00,  1.01548913e+00,
     1.01363936e+00,  1.01174775e+00,  1.00984084e+00,  1.00793976e+00,
     1.00640740e+00,  1.00437483e+00,  1.00246981e+00,  1.00068907e+00,
     9.99034600e-01,  9.97502490e-01,  9.96094155e-01,  9.94805124e-01,
     9.93636273e-01,  9.92582654e-01,  9.91644701e-01,  9.90817076e-01,
     9.90099845e-01,  9.89487369e-01,  9.88979432e-01,  9.88570179e-01,
     9.88259191e-01,  9.88040442e-01,  9.87913369e-01,  9.87871810e-01,
     9.87915076e-01,  9.88036894e-01,  9.88236456e-01,  9.88507369e-01,
     9.88848709e-01,  9.89253949e-01,  9.89722041e-01,  9.90246329e-01,
     9.90825634e-01,  9.91453181e-01,  9.92127681e-01,  9.92842250e-01,
     9.93595510e-01,  9.94380481e-01,  9.95195724e-01,  9.96034188e-01,
     9.96894383e-01,  9.97769201e-01,  9.98657113e-01,  9.99550974e-01,
     1.00044923e+00,  1.00134469e+00,  1.00223579e+00,  1.00311529e+00,
     1.00398160e+00,  1.00482747e+00,  1.00565128e+00,  1.00644577e+00,
     1.00720935e+00,  1.00793478e+00,  1.00862050e+00,  1.00925931e+00,
     1.00984974e+00,  1.01038469e+00,  1.01086278e+00,  1.01127704e+00,
     1.01162625e+00,  1.01190357e+00,  1.01210795e+00,  1.01223276e+00,
     1.01227709e+00,  1.01223451e+00,  1.01210432e+00,  1.01188029e+00,
     1.01156197e+00,  1.01114337e+00,  1.01062432e+00,  1.00999915e+00,
     1.00926803e+00,  1.00842570e+00,  1.00747277e+00,  1.00640448e+00,
     1.00522200e+00,  1.00392116e+00,  1.00250376e+00,  1.00096633e+00,
     9.99311401e-01,  9.97536270e-01,  9.95644231e-01,  9.93633392e-01,
     9.90867748e-01,  9.88232633e-01,  9.85362057e-01,  9.82230509e-01,
     9.78818585e-01,  9.75102633e-01,  9.71063185e-01,  9.66675967e-01,
     9.61924219e-01,  9.56784199e-01,  9.51239430e-01,  9.45270024e-01,
     9.38861570e-01,  9.31994644e-01,  9.24659203e-01,  9.16838340e-01,
     9.08521803e-01,  8.99696701e-01,  8.90356205e-01,  8.80487793e-01,
     8.70088421e-01,  8.59149213e-01,  8.47668639e-01,  8.35642897e-01,
     8.23075389e-01,  8.09964930e-01,  7.96320451e-01,  7.82146054e-01,
     7.67454182e-01,  7.52256346e-01,  7.36570205e-01,  7.20409055e-01,
     7.03797511e-01,  6.86754281e-01,  6.69304189e-01,  6.51471096e-01,
     6.33285483e-01,  6.14768539e-01,  5.95955378e-01,  5.76873796e-01,
     5.57553429e-01,  5.38032014e-01,  5.18345403e-01,  4.98525942e-01,
     4.78615607e-01,  4.58647304e-01,  4.38664366e-01,  4.18704689e-01,
     3.98812306e-01,  3.79026292e-01,  3.59391483e-01,  3.39947413e-01,
     3.20739242e-01,  3.01806111e-01,  2.83190595e-01,  2.64928837e-01,
     2.47060855e-01,  2.29620112e-01,  2.12643372e-01,  1.96160182e-01,
     1.80203520e-01,  1.64799688e-01,  1.49978755e-01,  1.35764352e-01,
     1.22184253e-01,  1.09260199e-01,  9.70178845e-02,  8.54768028e-02,
     7.46597638e-02,  6.45825432e-02,  5.52628119e-02,  4.67097698e-02,
     3.89324443e-02,  3.19297601e-02,  2.56981064e-02,  2.02225927e-02,
     1.54831778e-02,  1.14492491e-02,  8.07648266e-03,  5.30004408e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_48K = np.array([
     4.09010650e-04,  6.14338818e-04,  8.57175988e-04,  1.14701506e-03,
     1.48958283e-03,  1.88977038e-03,  2.35300080e-03,  2.88410496e-03,
     3.48821379e-03,  4.17004043e-03,  4.93429883e-03,  5.78707651e-03,
     6.73381174e-03,  7.77913046e-03,  8.92704496e-03,  1.01820289e-02,
     1.15491061e-02,  1.30334922e-02,  1.46395129e-02,  1.63715562e-02,
     1.82345538e-02,  2.02330949e-02,  2.23711616e-02,  2.46523735e-02,
     2.70810194e-02,  2.96615969e-02,  3.23988485e-02,  3.52960177e-02,
     3.83566333e-02,  4.15844793e-02,  4.49832242e-02,  4.85561099e-02,
     5.23059648e-02,  5.62362458e-02,  6.03505574e-02,  6.46518632e-02,
     6.91419575e-02,  7.38228820e-02,  7.86970933e-02,  8.37676164e-02,
     8.90356369e-02,  9.45019924e-02,  1.00168019e-01,  1.06035623e-01,
     1.12106022e-01,  1.18378855e-01,  1.24853486e-01,  1.31530285e-01,
     1.38410308e-01,  1.45493189e-01,  1.52777295e-01,  1.60260884e-01,
     1.67943556e-01,  1.75824562e-01,  1.83902012e-01,  1.92172862e-01,
     2.00634430e-01,  2.09285388e-01,  2.18123826e-01,  2.27146226e-01,
     2.36347921e-01,  2.45725974e-01,  2.55277155e-01,  2.64998109e-01,
     2.74883943e-01,  2.84929644e-01,  2.95130651e-01,  3.05482471e-01,
     3.15979964e-01,  3.26616979e-01,  3.37387380e-01,  3.48285592e-01,
     3.59305769e-01,  3.70441593e-01,  3.81686239e-01,  3.93032978e-01,
     4.04474963e-01,  4.16005110e-01,  4.27615960e-01,  4.39300436e-01,
     4.51051633e-01,  4.62861605e-01,  4.74722545e-01,  4.86626671e-01,
     4.98566451e-01,  5.10534149e-01,  5.22521279e-01,  5.34519051e-01,
     5.46520192e-01,  5.58517277e-01,  5.70502154e-01,  5.82465810e-01,
     5.94399172e-01,  6.06294818e-01,  6.18145266e-01,  6.29942202e-01,
     6.41676874e-01,  6.53341146e-01,  6.64927754e-01,  6.76429270e-01,
     6.87836730e-01,  6.99142147e-01,  7.10337961e-01,  7.21417603e-01,
     7.32374610e-01,  7.43200803e-01,  7.53888797e-01,  7.64431550e-01,
     7.74822315e-01,  7.85054657e-01,  7.95122352e-01,  8.05019386e-01,
     8.14739745e-01,  8.24277441e-01,  8.33626711e-01,  8.42781936e-01,
     8.51738619e-01,  8.60492087e-01,  8.69037674e-01,  8.77372045e-01,
     8.85492794e-01,  8.93393548e-01,  9.01072709e-01,  9.08524940e-01,
     9.15748356e-01,  9.22741384e-01,  9.29501747e-01,  9.36027020e-01,
     9.42314305e-01,  9.48362979e-01,  9.54173114e-01,  9.59743838e-01,
     9.65073839e-01,  9.70163547e-01,  9.75014336e-01,  9.79627719e-01,
     9.84003644e-01,  9.88142677e-01,  9.92047045e-01,  9.95719942e-01,
     9.99164081e-01,  1.00238131e+00,  1.00537427e+00,  1.00814672e+00,
     1.01070312e+00,  1.01304666e+00,  1.01518127e+00,  1.01711164e+00,
     1.01884338e+00,  1.02038171e+00,  1.02173110e+00,  1.02289695e+00,
     1.02388546e+00,  1.02470297e+00,  1.02535529e+00,  1.02584824e+00,
     1.02618837e+00,  1.02638288e+00,  1.02643810e+00,  1.02636013e+00,
     1.02615553e+00,  1.02583146e+00,  1.02539543e+00,  1.02485397e+00,
     1.02421348e+00,  1.02348118e+00,  1.02266460e+00,  1.02177090e+00,
     1.02080692e+00,  1.01977940e+00,  1.01869600e+00,  1.01756442e+00,
     1.01639169e+00,  1.01518492e+00,  1.01395084e+00,  1.01269703e+00,
     1.01143075e+00,  1.01015835e+00,  1.00888519e+00,  1.00759272e+00,
     1.00680560e+00,  1.00537874e+00,  1.00404905e+00,  1.00277836e+00,
     1.00156378e+00,  1.00040492e+00,  9.99301484e-01,  9.98253156e-01,
     9.97259546e-01,  9.96320213e-01,  9.95434664e-01,  9.94602354e-01,
     9.93822688e-01,  9.93095027e-01,  9.92418692e-01,  9.91792966e-01,
     9.91217091e-01,  9.90690276e-01,  9.90211700e-01,  9.89780519e-01,
     9.89395860e-01,  9.89056824e-01,  9.88762494e-01,  9.88511936e-01,
     9.88304203e-01,  9.88138324e-01,  9.88013316e-01,  9.87928190e-01,
     9.87881941e-01,  9.87873551e-01,  9.87901987e-01,  9.87966213e-01,
     9.88065178e-01,  9.88197816e-01,  9.88363051e-01,  9.88559796e-01,
     9.88786953e-01,  9.89043407e-01,  9.89328032e-01,  9.89639690e-01,
     9.89977232e-01,  9.90339493e-01,  9.90725297e-01,  9.91133456e-01,
     9.91562775e-01,  9.92012044e-01,  9.92480044e-01,  9.92965548e-01,
     9.93467321e-01,  9.93984121e-01,  9.94514697e-01,  9.95057793e-01,
     9.95612147e-01,  9.96176492e-01,  9.96749554e-01,  9.97330059e-01,
     9.97916725e-01,  9.98508264e-01,  9.99103363e-01,  9.99700348e-01,
     1.00029974e+00,  1.00089744e+00,  1.00149396e+00,  1.00208762e+00,
     1.00267709e+00,  1.00326105e+00,  1.00383818e+00,  1.00440719e+00,
     1.00496675e+00,  1.00551556e+00,  1.00605229e+00,  1.00657564e+00,
     1.00708429e+00,  1.00757693e+00,  1.00805228e+00,  1.00850902e+00,
     1.00894586e+00,  1.00936153e+00,  1.00975474e+00,  1.01012424e+00,
     1.01046877e+00,  1.01078709e+00,  1.01107797e+00,  1.01134021e+00,
     1.01157260e+00,  1.01177396e+00,  1.01194314e+00,  1.01207898e+00,
     1.01218036e+00,  1.01224617e+00,  1.01227531e+00,  1.01226671e+00,
     1.01221932e+00,  1.01213211e+00,  1.01200406e+00,  1.01183421e+00,
     1.01162157e+00,  1.01136522e+00,  1.01106425e+00,  1.01071779e+00,
     1.01032500e+00,  1.00988506e+00,  1.00939721e+00,  1.00886073e+00,
     1.00827495e+00,  1.00763922e+00,  1.00695298e+00,  1.00621571e+00,
     1.00542694e+00,  1.00458627e+00,  1.00369338e+00,  1.00274798e+00,
     1.00174990e+00,  1.00069900e+00,  9.99595249e-01,  9.98438663e-01,
     9.97229342e-01,  9.95967277e-01,  9.94650033e-01,  9.93240400e-01,
     9.91251152e-01,  9.89575685e-01,  9.87771321e-01,  9.85857748e-01,
     9.83830313e-01,  9.81682263e-01,  9.79407449e-01,  9.76999916e-01,
     9.74452836e-01,  9.71759750e-01,  9.68914116e-01,  9.65910162e-01,
     9.62742183e-01,  9.59403812e-01,  9.55888998e-01,  9.52192243e-01,
     9.48308632e-01,  9.44233254e-01,  9.39960724e-01,  9.35486022e-01,
     9.30805297e-01,  9.25914697e-01,  9.20810131e-01,  9.15487360e-01,
     9.09942607e-01,  9.04173226e-01,  8.98176373e-01,  8.91949024e-01,
     8.85488225e-01,  8.78791944e-01,  8.71858584e-01,  8.64686495e-01,
     8.57273814e-01,  8.49619586e-01,  8.41723747e-01,  8.33586272e-01,
     8.25207443e-01,  8.16587571e-01,  8.07728037e-01,  7.98631159e-01,
     7.89298635e-01,  7.79733095e-01,  7.69937953e-01,  7.59917189e-01,
     7.49675842e-01,  7.39217684e-01,  7.28547452e-01,  7.17671448e-01,
     7.06596231e-01,  6.95328294e-01,  6.83873906e-01,  6.72239531e-01,
     6.60433402e-01,  6.48464360e-01,  6.36339500e-01,  6.24066143e-01,
     6.11653033e-01,  5.99109864e-01,  5.86446142e-01,  5.73669485e-01,
     5.60788103e-01,  5.47816066e-01,  5.34761979e-01,  5.21636515e-01,
     5.08449976e-01,  4.95213509e-01,  4.81938756e-01,  4.68636143e-01,
     4.55317077e-01,  4.41993995e-01,  4.28678989e-01,  4.15383779e-01,
     4.02121106e-01,  3.88903272e-01,  3.75742544e-01,  3.62651518e-01,
     3.49643142e-01,  3.36729082e-01,  3.23922808e-01,  3.11236082e-01,
     2.98680794e-01,  2.86269467e-01,  2.74012847e-01,  2.61922833e-01,
     2.50009844e-01,  2.38284723e-01,  2.26757849e-01,  2.15439100e-01,
     2.04337983e-01,  1.93463677e-01,  1.82825032e-01,  1.72430586e-01,
     1.62288635e-01,  1.52407188e-01,  1.42793979e-01,  1.33456585e-01,
     1.24402392e-01,  1.15638588e-01,  1.07172155e-01,  9.90098587e-02,
     9.11582177e-02,  8.36234486e-02,  7.64114037e-02,  6.95274904e-02,
     6.29765645e-02,  5.67628424e-02,  5.08897541e-02,  4.53598330e-02,
     4.01745731e-02,  3.53343019e-02,  3.08380606e-02,  2.66835542e-02,
     2.28668041e-02,  1.93823634e-02,  1.62231272e-02,  1.33800502e-02,
     1.08421860e-02,  8.59675398e-03,  6.64050653e-03,  5.17270311e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_48K_HR = np.array([
     9.75247545e-08,  6.41356849e-07,  1.88872264e-06,  4.37003746e-06,
     8.85053487e-06,  1.64097619e-05,  2.85265469e-05,  4.71757776e-05,
     7.49369574e-05,  1.15113864e-04,  1.71864056e-04,  2.50336452e-04,
     3.56814737e-04,  4.98863636e-04,  6.85475010e-04,  9.27209505e-04,
     1.23633002e-03,  1.62692170e-03,  2.11499492e-03,  2.71856366e-03,
     3.45769688e-03,  4.35453700e-03,  5.43327769e-03,  6.72010100e-03,
     8.24306626e-03,  1.00319488e-02,  1.21180220e-02,  1.45337880e-02,
     1.73126478e-02,  2.04885192e-02,  2.40953956e-02,  2.81668510e-02,
     3.27355117e-02,  3.78324650e-02,  4.34866548e-02,  4.97242436e-02,
     5.65679595e-02,  6.40364513e-02,  7.21436515e-02,  8.08981732e-02,
     9.03027356e-02,  1.00353681e-01,  1.11040540e-01,  1.22345708e-01,
     1.34244218e-01,  1.46703660e-01,  1.59684196e-01,  1.73138753e-01,
     1.87013358e-01,  2.01247633e-01,  2.15775400e-01,  2.30525494e-01,
     2.45422661e-01,  2.60388613e-01,  2.75343060e-01,  2.90205121e-01,
     3.04894298e-01,  3.19332004e-01,  3.33442599e-01,  3.47154707e-01,
     3.60402405e-01,  3.73126328e-01,  3.85274231e-01,  3.96802038e-01,
     4.07674283e-01,  4.17864561e-01,  4.27355647e-01,  4.36139554e-01,
     4.44217294e-01,  4.51598674e-01,  4.58301634e-01,  4.64351624e-01,
     4.69781011e-01,  4.74628091e-01,  4.78936344e-01,  4.82753456e-01,
     4.86130476e-01,  4.89120960e-01,  4.91780102e-01,  4.94164050e-01,
     4.96329218e-01,  4.98331696e-01,  5.00226736e-01,  5.02068341e-01,
     5.03908992e-01,  5.05799294e-01,  5.07787943e-01,  5.09921193e-01,
     5.12243330e-01,  5.14795899e-01,  5.17618179e-01,  5.20746589e-01,
     5.24214983e-01,  5.28054178e-01,  5.32292068e-01,  5.36953092e-01,
     5.42058468e-01,  5.47625661e-01,  5.53668439e-01,  5.60196400e-01,
     5.67215025e-01,  5.74725628e-01,  5.82724869e-01,  5.91205239e-01,
     6.00154579e-01,  6.09556615e-01,  6.19390607e-01,  6.29631937e-01,
     6.40252173e-01,  6.51219368e-01,  6.62498534e-01,  6.74051821e-01,
     6.85839176e-01,  6.97818637e-01,  7.09946930e-01,  7.22179890e-01,
     7.34472811e-01,  7.46781170e-01,  7.59061038e-01,  7.71269321e-01,
     7.83364296e-01,  7.95306087e-01,  8.07056785e-01,  8.18580806e-01,
     8.29845190e-01,  8.40819776e-01,  8.51477146e-01,  8.61792982e-01,
     8.71745944e-01,  8.81317794e-01,  8.90493214e-01,  8.99259806e-01,
     9.07608211e-01,  9.15531754e-01,  9.23026323e-01,  9.30090547e-01,
     9.36725318e-01,  9.42933977e-01,  9.48721945e-01,  9.54096615e-01,
     9.59067523e-01,  9.63645637e-01,  9.67843831e-01,  9.71676290e-01,
     9.75158513e-01,  9.78307128e-01,  9.81139660e-01,  9.83674467e-01,
     9.85930443e-01,  9.87926722e-01,  9.89682734e-01,  9.91217852e-01,
     9.92551088e-01,  9.93701279e-01,  9.94686544e-01,  9.95524466e-01,
     9.96231675e-01,  9.96824026e-01,  9.97316301e-01,  9.97722328e-01,
     9.98054802e-01,  9.98325348e-01,  9.98544455e-01,  9.98721540e-01,
     9.98864949e-01,  9.98981953e-01,  9.99078929e-01,  9.99161184e-01,
     9.99233246e-01,  9.99298692e-01,  9.99360621e-01,  9.99421120e-01,
     9.99481916e-01,  9.99544203e-01,  9.99608576e-01,  9.99675393e-01,
     9.99744534e-01,  9.99815881e-01,  9.99888837e-01,  9.99962866e-01,
     1.00003707e+00,  1.00011098e+00,  1.00018346e+00,  1.00025380e+00,
     1.00032115e+00,  1.00038469e+00,  1.00044382e+00,  1.00049770e+00,
     1.00054598e+00,  1.00058782e+00,  1.00062299e+00,  1.00065112e+00,
     1.00067186e+00,  1.00068521e+00,  1.00069082e+00,  1.00068903e+00,
     1.00067961e+00,  1.00066280e+00,  1.00063896e+00,  1.00060833e+00,
     1.00057113e+00,  1.00052810e+00,  1.00047958e+00,  1.00042605e+00,
     1.00036812e+00,  1.00030637e+00,  1.00024164e+00,  1.00017428e+00,
     1.00010526e+00,  1.00003517e+00,  9.99964774e-01,  9.99894679e-01,
     9.99825716e-01,  9.99758482e-01,  9.99693692e-01,  9.99632061e-01,
     9.99574184e-01,  9.99520719e-01,  9.99472201e-01,  9.99429166e-01,
     9.99392092e-01,  9.99361455e-01,  9.99337614e-01,  9.99320924e-01,
     9.99311507e-01,  9.99309599e-01,  9.99315262e-01,  9.99328554e-01,
     9.99349296e-01,  9.99377370e-01,  9.99412537e-01,  9.99454379e-01,
     9.99502480e-01,  9.99556363e-01,  9.99615431e-01,  9.99678969e-01,
     9.99746263e-01,  9.99816597e-01,  9.99889076e-01,  9.99962866e-01,
     1.00003707e+00,  1.00011098e+00,  1.00018346e+00,  1.00025380e+00,
     1.00032115e+00,  1.00038469e+00,  1.00044382e+00,  1.00049770e+00,
     1.00054598e+00,  1.00058782e+00,  1.00062299e+00,  1.00065112e+00,
     1.00067186e+00,  1.00068521e+00,  1.00069082e+00,  1.00068903e+00,
     1.00067961e+00,  1.00066280e+00,  1.00063896e+00,  1.00060833e+00,
     1.00057113e+00,  1.00052810e+00,  1.00047958e+00,  1.00042605e+00,
     1.00036812e+00,  1.00030637e+00,  1.00024164e+00,  1.00017428e+00,
     1.00010526e+00,  1.00003517e+00,  9.99964774e-01,  9.99894679e-01,
     9.99825716e-01,  9.99758482e-01,  9.99693692e-01,  9.99632061e-01,
     9.99574184e-01,  9.99520719e-01,  9.99472201e-01,  9.99429166e-01,
     9.99392092e-01,  9.99361455e-01,  9.99337614e-01,  9.99320924e-01,
     9.99311507e-01,  9.99309599e-01,  9.99315262e-01,  9.99328554e-01,
     9.99349296e-01,  9.99377370e-01,  9.99412537e-01,  9.99454379e-01,
     9.99502480e-01,  9.99556363e-01,  9.99615431e-01,  9.99678969e-01,
     9.99746263e-01,  9.99816597e-01,  9.99889076e-01,  9.99962866e-01,
     1.00003707e+00,  1.00011075e+00,  1.00018275e+00,  1.00025201e+00,
     1.00031757e+00,  1.00037789e+00,  1.00043166e+00,  1.00047719e+00,
     1.00051260e+00,  1.00053585e+00,  1.00054419e+00,  1.00053477e+00,
     1.00050414e+00,  1.00044823e+00,  1.00036228e+00,  1.00024092e+00,
     1.00007784e+00,  9.99865890e-01,  9.99597013e-01,  9.99261975e-01,
     9.98850465e-01,  9.98351038e-01,  9.97750819e-01,  9.97035682e-01,
     9.96189833e-01,  9.95196044e-01,  9.94035423e-01,  9.92687285e-01,
     9.91129041e-01,  9.89336133e-01,  9.87281919e-01,  9.84937787e-01,
     9.82272744e-01,  9.79253709e-01,  9.75845337e-01,  9.72010076e-01,
     9.67708528e-01,  9.62899387e-01,  9.57539737e-01,  9.51585472e-01,
     9.44991708e-01,  9.37713265e-01,  9.29705381e-01,  9.20924187e-01,
     9.11327481e-01,  9.00875807e-01,  8.89532745e-01,  8.77266228e-01,
     8.64049077e-01,  8.49859893e-01,  8.34683776e-01,  8.18513036e-01,
     8.01347792e-01,  7.83196509e-01,  7.64076352e-01,  7.44013488e-01,
     7.23043203e-01,  7.01209962e-01,  6.78567350e-01,  6.55177712e-01,
     6.31111801e-01,  6.06448233e-01,  5.81272960e-01,  5.55678487e-01,
     5.29762745e-01,  5.03628492e-01,  4.77382004e-01,  4.51132149e-01,
     4.24988985e-01,  3.99062574e-01,  3.73461813e-01,  3.48293066e-01,
     3.23658854e-01,  2.99656719e-01,  2.76377857e-01,  2.53906131e-01,
     2.32316986e-01,  2.11676583e-01,  1.92040950e-01,  1.73455566e-01,
     1.55954808e-01,  1.39561892e-01,  1.24288827e-01,  1.10136725e-01,
     9.70961973e-02,  8.51479918e-02,  7.42638558e-02,  6.44074306e-02,
     5.55353425e-02,  4.75983508e-02,  4.05424982e-02,  3.43103148e-02,
     2.88419761e-02,  2.40764078e-02,  1.99523065e-02,  1.64090749e-02,
     1.33876354e-02,  1.08311241e-02,  8.68547149e-03,  6.89984858e-03,
     5.42699778e-03,  4.22345474e-03,  3.24966502e-03,  2.47000973e-03,
     1.85274973e-03,  1.36990519e-03,  9.97077208e-04,  7.13227608e-04,
     5.00426511e-04,  3.43578606e-04,  2.30138365e-04,  1.49821601e-04,
     9.43217892e-05,  5.70367956e-05,  3.28110509e-05,  1.76969679e-05,
     8.73827867e-06,  3.77677043e-06,  1.28252009e-06,  1.95021386e-07,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_5M_96K_HR = np.array([
     6.89548827e-08,  2.31516253e-07,  5.04477669e-07,  9.30795125e-07,
     1.56340695e-06,  2.46738750e-06,  3.72189174e-06,  5.42224188e-06,
     7.68219343e-06,  1.06363877e-05,  1.44429905e-05,  1.92865264e-05,
     2.53808976e-05,  3.29725954e-05,  4.23441015e-05,  5.38174427e-05,
     6.77579446e-05,  8.45781324e-05,  1.04741775e-04,  1.28768093e-04,
     1.57236034e-04,  1.90788676e-04,  2.30137754e-04,  2.76068167e-04,
     3.29442613e-04,  3.91206064e-04,  4.62390453e-04,  5.44119219e-04,
     6.37611491e-04,  7.44186866e-04,  8.65269103e-04,  1.00239040e-03,
     1.15719519e-03,  1.33144355e-03,  1.52701419e-03,  1.74590782e-03,
     1.99024938e-03,  2.26228987e-03,  2.56440835e-03,  2.89911311e-03,
     3.26904119e-03,  3.67696048e-03,  4.12576646e-03,  4.61848313e-03,
     5.15825953e-03,  5.74836833e-03,  6.39220094e-03,  7.09326472e-03,
     7.85517693e-03,  8.68165866e-03,  9.57652833e-03,  1.05436966e-02,
     1.15871523e-02,  1.27109587e-02,  1.39192408e-02,  1.52161736e-02,
     1.66059695e-02,  1.80928707e-02,  1.96811259e-02,  2.13749874e-02,
     2.31786855e-02,  2.50964165e-02,  2.71323286e-02,  2.92905010e-02,
     3.15749235e-02,  3.39894816e-02,  3.65379415e-02,  3.92239206e-02,
     4.20508720e-02,  4.50220704e-02,  4.81405817e-02,  5.14092445e-02,
     5.48306555e-02,  5.84071539e-02,  6.21407814e-02,  6.60332814e-02,
     7.00860694e-02,  7.43002295e-02,  7.86764771e-02,  8.32151473e-02,
     8.79162028e-02,  9.27791744e-02,  9.78031904e-02,  1.02986939e-01,
     1.08328678e-01,  1.13826200e-01,  1.19476855e-01,  1.25277504e-01,
     1.31224588e-01,  1.37314022e-01,  1.43541321e-01,  1.49901465e-01,
     1.56389058e-01,  1.62998185e-01,  1.69722542e-01,  1.76555380e-01,
     1.83489516e-01,  1.90517426e-01,  1.97631180e-01,  2.04822496e-01,
     2.12082773e-01,  2.19403118e-01,  2.26774365e-01,  2.34187096e-01,
     2.41631702e-01,  2.49098375e-01,  2.56577194e-01,  2.64058143e-01,
     2.71531105e-01,  2.78985947e-01,  2.86412567e-01,  2.93800950e-01,
     3.01141053e-01,  3.08423132e-01,  3.15637439e-01,  3.22774589e-01,
     3.29825372e-01,  3.36780816e-01,  3.43632400e-01,  3.50371778e-01,
     3.56991231e-01,  3.63483250e-01,  3.69840890e-01,  3.76057625e-01,
     3.82127434e-01,  3.88044775e-01,  3.93804729e-01,  3.99402857e-01,
     4.04835284e-01,  4.10098761e-01,  4.15190488e-01,  4.20108408e-01,
     4.24850911e-01,  4.29417044e-01,  4.33806360e-01,  4.38019037e-01,
     4.42055762e-01,  4.45917755e-01,  4.49606776e-01,  4.53125089e-01,
     4.56475437e-01,  4.59661037e-01,  4.62685496e-01,  4.65552896e-01,
     4.68267679e-01,  4.70834643e-01,  4.73258942e-01,  4.75546002e-01,
     4.77701575e-01,  4.79731590e-01,  4.81642276e-01,  4.83440012e-01,
     4.85131353e-01,  4.86723036e-01,  4.88221824e-01,  4.89634633e-01,
     4.90968436e-01,  4.92230296e-01,  4.93427187e-01,  4.94566232e-01,
     4.95654404e-01,  4.96698737e-01,  4.97706175e-01,  4.98683631e-01,
     4.99637932e-01,  5.00575840e-01,  5.01503944e-01,  5.02428830e-01,
     5.03356874e-01,  5.04294455e-01,  5.05247772e-01,  5.06222844e-01,
     5.07225573e-01,  5.08261740e-01,  5.09337008e-01,  5.10456860e-01,
     5.11626601e-01,  5.12851536e-01,  5.14136553e-01,  5.15486538e-01,
     5.16906321e-01,  5.18400311e-01,  5.19972920e-01,  5.21628320e-01,
     5.23370624e-01,  5.25203526e-01,  5.27130723e-01,  5.29155731e-01,
     5.31281710e-01,  5.33511758e-01,  5.35848677e-01,  5.38295090e-01,
     5.40853441e-01,  5.43525815e-01,  5.46314240e-01,  5.49220264e-01,
     5.52245498e-01,  5.55391014e-01,  5.58657765e-01,  5.62046468e-01,
     5.65557480e-01,  5.69190919e-01,  5.72946727e-01,  5.76824427e-01,
     5.80823362e-01,  5.84942579e-01,  5.89180827e-01,  5.93536615e-01,
     5.98008096e-01,  6.02593303e-01,  6.07289851e-01,  6.12095237e-01,
     6.17006540e-01,  6.22020781e-01,  6.27134562e-01,  6.32344365e-01,
     6.37646437e-01,  6.43036783e-01,  6.48511291e-01,  6.54065490e-01,
     6.59694970e-01,  6.65394902e-01,  6.71160460e-01,  6.76986754e-01,
     6.82868540e-01,  6.88800693e-01,  6.94777906e-01,  7.00794756e-01,
     7.06845820e-01,  7.12925553e-01,  7.19028473e-01,  7.25149035e-01,
     7.31281698e-01,  7.37420917e-01,  7.43561149e-01,  7.49696970e-01,
     7.55823016e-01,  7.61933863e-01,  7.68024206e-01,  7.74088979e-01,
     7.80123055e-01,  7.86121488e-01,  7.92079389e-01,  7.97992110e-01,
     8.03855121e-01,  8.09663892e-01,  8.15414310e-01,  8.21102202e-01,
     8.26723635e-01,  8.32274854e-01,  8.37752342e-01,  8.43152702e-01,
     8.48472714e-01,  8.53709280e-01,  8.58859718e-01,  8.63921225e-01,
     8.68891478e-01,  8.73768151e-01,  8.78549099e-01,  8.83232594e-01,
     8.87816727e-01,  8.92300129e-01,  8.96681368e-01,  9.00959313e-01,
     9.05132890e-01,  9.09201384e-01,  9.13164079e-01,  9.17020440e-01,
     9.20770228e-01,  9.24413145e-01,  9.27949250e-01,  9.31378603e-01,
     9.34701502e-01,  9.37918305e-01,  9.41029668e-01,  9.44036126e-01,
     9.46938515e-01,  9.49737847e-01,  9.52435017e-01,  9.55031335e-01,
     9.57527936e-01,  9.59926248e-01,  9.62227762e-01,  9.64434028e-01,
     9.66546714e-01,  9.68567610e-01,  9.70498502e-01,  9.72341299e-01,
     9.74098027e-01,  9.75770652e-01,  9.77361381e-01,  9.78872299e-01,
     9.80305672e-01,  9.81663704e-01,  9.82948720e-01,  9.84162986e-01,
     9.85308945e-01,  9.86388862e-01,  9.87405181e-01,  9.88360226e-01,
     9.89256442e-01,  9.90096152e-01,  9.90881741e-01,  9.91615593e-01,
     9.92299914e-01,  9.92937148e-01,  9.93529499e-01,  9.94079232e-01,
     9.94588435e-01,  9.95059371e-01,  9.95494127e-01,  9.95894730e-01,
     9.96263146e-01,  9.96601343e-01,  9.96911168e-01,  9.97194529e-01,
     9.97453094e-01,  9.97688591e-01,  9.97902572e-01,  9.98096704e-01,
     9.98272479e-01,  9.98431206e-01,  9.98574317e-01,  9.98703122e-01,
     9.98818815e-01,  9.98922586e-01,  9.99015450e-01,  9.99098480e-01,
     9.99172688e-01,  9.99238908e-01,  9.99298036e-01,  9.99350786e-01,
     9.99397993e-01,  9.99440193e-01,  9.99478102e-01,  9.99512255e-01,
     9.99543130e-01,  9.99571264e-01,  9.99597073e-01,  9.99620855e-01,
     9.99643087e-01,  9.99663949e-01,  9.99683797e-01,  9.99702871e-01,
     9.99721289e-01,  9.99739230e-01,  9.99756932e-01,  9.99774456e-01,
     9.99791920e-01,  9.99809384e-01,  9.99826908e-01,  9.99844551e-01,
     9.99862373e-01,  9.99880314e-01,  9.99898374e-01,  9.99916673e-01,
     9.99935031e-01,  9.99953508e-01,  9.99972105e-01,  9.99990702e-01,
     1.00000930e+00,  1.00002778e+00,  1.00004625e+00,  1.00006461e+00,
     1.00008273e+00,  1.00010061e+00,  1.00011826e+00,  1.00013554e+00,
     1.00015235e+00,  1.00016880e+00,  1.00018466e+00,  1.00020003e+00,
     1.00021482e+00,  1.00022900e+00,  1.00024247e+00,  1.00025523e+00,
     1.00026727e+00,  1.00027859e+00,  1.00028908e+00,  1.00029874e+00,
     1.00030744e+00,  1.00031543e+00,  1.00032246e+00,  1.00032854e+00,
     1.00033379e+00,  1.00033808e+00,  1.00034130e+00,  1.00034368e+00,
     1.00034511e+00,  1.00034559e+00,  1.00034511e+00,  1.00034368e+00,
     1.00034142e+00,  1.00033808e+00,  1.00033391e+00,  1.00032878e+00,
     1.00032282e+00,  1.00031602e+00,  1.00030828e+00,  1.00029981e+00,
     1.00029051e+00,  1.00028050e+00,  1.00026977e+00,  1.00025833e+00,
     1.00024617e+00,  1.00023329e+00,  1.00021994e+00,  1.00020599e+00,
     1.00019157e+00,  1.00017655e+00,  1.00016105e+00,  1.00014532e+00,
     1.00012910e+00,  1.00011253e+00,  1.00009573e+00,  1.00007868e+00,
     1.00006139e+00,  1.00004399e+00,  1.00002646e+00,  1.00000882e+00,
     9.99991179e-01,  9.99973595e-01,  9.99956071e-01,  9.99938667e-01,
     9.99921381e-01,  9.99904335e-01,  9.99887526e-01,  9.99870956e-01,
     9.99854743e-01,  9.99838948e-01,  9.99823511e-01,  9.99808550e-01,
     9.99794066e-01,  9.99780118e-01,  9.99766707e-01,  9.99753952e-01,
     9.99741793e-01,  9.99730289e-01,  9.99719560e-01,  9.99709487e-01,
     9.99700248e-01,  9.99691784e-01,  9.99684095e-01,  9.99677300e-01,
     9.99671280e-01,  9.99666214e-01,  9.99662042e-01,  9.99658763e-01,
     9.99656379e-01,  9.99655008e-01,  9.99654531e-01,  9.99654949e-01,
     9.99656379e-01,  9.99658763e-01,  9.99662101e-01,  9.99666333e-01,
     9.99671519e-01,  9.99677658e-01,  9.99684691e-01,  9.99692619e-01,
     9.99701381e-01,  9.99711037e-01,  9.99721527e-01,  9.99732792e-01,
     9.99744833e-01,  9.99757588e-01,  9.99771118e-01,  9.99785244e-01,
     9.99800026e-01,  9.99815404e-01,  9.99831259e-01,  9.99847651e-01,
     9.99864519e-01,  9.99881744e-01,  9.99899328e-01,  9.99917269e-01,
     9.99935389e-01,  9.99953687e-01,  9.99972165e-01,  9.99990702e-01,
     1.00000930e+00,  1.00002778e+00,  1.00004625e+00,  1.00006461e+00,
     1.00008273e+00,  1.00010061e+00,  1.00011826e+00,  1.00013554e+00,
     1.00015235e+00,  1.00016880e+00,  1.00018466e+00,  1.00020003e+00,
     1.00021482e+00,  1.00022900e+00,  1.00024247e+00,  1.00025523e+00,
     1.00026727e+00,  1.00027859e+00,  1.00028908e+00,  1.00029874e+00,
     1.00030744e+00,  1.00031543e+00,  1.00032246e+00,  1.00032854e+00,
     1.00033379e+00,  1.00033808e+00,  1.00034130e+00,  1.00034368e+00,
     1.00034511e+00,  1.00034559e+00,  1.00034511e+00,  1.00034368e+00,
     1.00034142e+00,  1.00033808e+00,  1.00033391e+00,  1.00032878e+00,
     1.00032282e+00,  1.00031602e+00,  1.00030828e+00,  1.00029981e+00,
     1.00029051e+00,  1.00028050e+00,  1.00026977e+00,  1.00025833e+00,
     1.00024617e+00,  1.00023329e+00,  1.00021994e+00,  1.00020599e+00,
     1.00019157e+00,  1.00017655e+00,  1.00016105e+00,  1.00014532e+00,
     1.00012910e+00,  1.00011253e+00,  1.00009573e+00,  1.00007868e+00,
     1.00006139e+00,  1.00004399e+00,  1.00002646e+00,  1.00000882e+00,
     9.99991179e-01,  9.99973595e-01,  9.99956071e-01,  9.99938667e-01,
     9.99921381e-01,  9.99904335e-01,  9.99887526e-01,  9.99870956e-01,
     9.99854743e-01,  9.99838948e-01,  9.99823511e-01,  9.99808550e-01,
     9.99794066e-01,  9.99780118e-01,  9.99766707e-01,  9.99753952e-01,
     9.99741793e-01,  9.99730289e-01,  9.99719560e-01,  9.99709487e-01,
     9.99700248e-01,  9.99691784e-01,  9.99684095e-01,  9.99677300e-01,
     9.99671280e-01,  9.99666214e-01,  9.99662042e-01,  9.99658763e-01,
     9.99656379e-01,  9.99655008e-01,  9.99654531e-01,  9.99654949e-01,
     9.99656379e-01,  9.99658763e-01,  9.99662101e-01,  9.99666333e-01,
     9.99671519e-01,  9.99677658e-01,  9.99684691e-01,  9.99692619e-01,
     9.99701381e-01,  9.99711037e-01,  9.99721527e-01,  9.99732792e-01,
     9.99744833e-01,  9.99757588e-01,  9.99771118e-01,  9.99785244e-01,
     9.99800026e-01,  9.99815404e-01,  9.99831259e-01,  9.99847651e-01,
     9.99864519e-01,  9.99881744e-01,  9.99899328e-01,  9.99917269e-01,
     9.99935389e-01,  9.99953687e-01,  9.99972165e-01,  9.99990702e-01,
     1.00000930e+00,  1.00002778e+00,  1.00004613e+00,  1.00006425e+00,
     1.00008214e+00,  1.00009966e+00,  1.00011683e+00,  1.00013340e+00,
     1.00014925e+00,  1.00016439e+00,  1.00017869e+00,  1.00019193e+00,
     1.00020397e+00,  1.00021482e+00,  1.00022411e+00,  1.00023162e+00,
     1.00023735e+00,  1.00024080e+00,  1.00024199e+00,  1.00024033e+00,
     1.00023568e+00,  1.00022769e+00,  1.00021589e+00,  1.00020003e+00,
     1.00017941e+00,  1.00015378e+00,  1.00012243e+00,  1.00008476e+00,
     1.00004041e+00,  9.99988317e-01,  9.99928057e-01,  9.99858677e-01,
     9.99779403e-01,  9.99689281e-01,  9.99587417e-01,  9.99472737e-01,
     9.99344110e-01,  9.99200404e-01,  9.99040425e-01,  9.98862803e-01,
     9.98666167e-01,  9.98449087e-01,  9.98209953e-01,  9.97947097e-01,
     9.97658968e-01,  9.97343540e-01,  9.96999085e-01,  9.96623516e-01,
     9.96214747e-01,  9.95770633e-01,  9.95288789e-01,  9.94766831e-01,
     9.94202256e-01,  9.93592501e-01,  9.92934704e-01,  9.92226064e-01,
     9.91463542e-01,  9.90644097e-01,  9.89764392e-01,  9.88821149e-01,
     9.87810850e-01,  9.86729801e-01,  9.85574305e-01,  9.84340370e-01,
     9.83024001e-01,  9.81621027e-01,  9.80127096e-01,  9.78537738e-01,
     9.76848423e-01,  9.75054383e-01,  9.73150730e-01,  9.71132576e-01,
     9.68994796e-01,  9.66732204e-01,  9.64339435e-01,  9.61811244e-01,
     9.59142029e-01,  9.56326306e-01,  9.53358531e-01,  9.50233042e-01,
     9.46944118e-01,  9.43486214e-01,  9.39853668e-01,  9.36040819e-01,
     9.32042122e-01,  9.27852154e-01,  9.23465431e-01,  9.18876767e-01,
     9.14081097e-01,  9.09073353e-01,  9.03848886e-01,  8.98403168e-01,
     8.92731845e-01,  8.86831045e-01,  8.80696952e-01,  8.74326289e-01,
     8.67715955e-01,  8.60863328e-01,  8.53766203e-01,  8.46422672e-01,
     8.38831365e-01,  8.30991328e-01,  8.22902203e-01,  8.14563930e-01,
     8.05977046e-01,  7.97142744e-01,  7.88062632e-01,  7.78738797e-01,
     7.69173980e-01,  7.59371519e-01,  7.49335289e-01,  7.39069760e-01,
     7.28579819e-01,  7.17871130e-01,  7.06949770e-01,  6.95822597e-01,
     6.84496701e-01,  6.72980070e-01,  6.61280870e-01,  6.49408042e-01,
     6.37370944e-01,  6.25179410e-01,  6.12843752e-01,  6.00374699e-01,
     5.87783396e-01,  5.75081468e-01,  5.62280834e-01,  5.49393654e-01,
     5.36432624e-01,  5.23410499e-01,  5.10340393e-01,  4.97235566e-01,
     4.84109521e-01,  4.70975846e-01,  4.57848251e-01,  4.44740474e-01,
     4.31666315e-01,  4.18639511e-01,  4.05673832e-01,  3.92782807e-01,
     3.79979968e-01,  3.67278606e-01,  3.54691803e-01,  3.42232376e-01,
     3.29912812e-01,  3.17745358e-01,  3.05741847e-01,  2.93913603e-01,
     2.82271683e-01,  2.70826548e-01,  2.59588152e-01,  2.48565957e-01,
     2.37768814e-01,  2.27205008e-01,  2.16882199e-01,  2.06807390e-01,
     1.96986943e-01,  1.87426537e-01,  1.78131178e-01,  1.69105172e-01,
     1.60352126e-01,  1.51874945e-01,  1.43675804e-01,  1.35756254e-01,
     1.28117070e-01,  1.20758407e-01,  1.13679729e-01,  1.06879868e-01,
     1.00357018e-01,  9.41087753e-02,  8.81321430e-02,  8.24235976e-02,
     7.69790635e-02,  7.17940032e-02,  6.68634027e-02,  6.21818379e-02,
     5.77434972e-02,  5.35422154e-02,  4.95715141e-02,  4.58246432e-02,
     4.22946103e-02,  3.89742292e-02,  3.58561426e-02,  3.29328589e-02,
     3.01968064e-02,  2.76403390e-02,  2.52557844e-02,  2.30354760e-02,
     2.09717732e-02,  1.90570969e-02,  1.72839500e-02,  1.56449396e-02,
     1.41328052e-02,  1.27404351e-02,  1.14608845e-02,  1.02873892e-02,
     9.21338331e-03,  8.23251065e-03,  7.33863330e-03,  6.52584061e-03,
     5.78845851e-03,  5.12105133e-03,  4.51842742e-03,  3.97564145e-03,
     3.48799396e-03,  3.05103138e-03,  2.66054412e-03,  2.31256452e-03,
     2.00336217e-03,  1.72943878e-03,  1.48752402e-03,  1.27456791e-03,
     1.08773448e-03,  9.24394117e-04,  7.82115792e-04,  6.58658682e-04,
     5.51963516e-04,  4.60143900e-04,  3.81477352e-04,  3.14396282e-04,
     2.57478940e-04,  2.09440448e-04,  1.69123945e-04,  1.35491777e-04,
     1.07617016e-04,  8.46750627e-05,  6.59356156e-05,  5.07548866e-05,
     3.85681342e-05,  2.88825358e-05,  2.12704090e-05,  1.53627971e-05,
     1.08434460e-05,  7.44312956e-06,  4.93438165e-06,  3.12659085e-06,
     1.86147406e-06,  1.00890213e-06,  4.63012810e-07,  1.37904777e-07,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

### LC3 - 3.7.3 ###

W_7M5_8K = np.array([
     2.95060859e-03,  7.17541132e-03,  1.37695374e-02,  2.30953556e-02,
     3.54036230e-02,  5.08289304e-02,  6.94696293e-02,  9.13884278e-02,
     1.16604575e-01,  1.45073546e-01,  1.76711174e-01,  2.11342953e-01,
     2.48768614e-01,  2.88701102e-01,  3.30823871e-01,  3.74814544e-01,
     4.20308013e-01,  4.66904918e-01,  5.14185341e-01,  5.61710041e-01,
     6.09026346e-01,  6.55671016e-01,  7.01218384e-01,  7.45240679e-01,
     7.87369206e-01,  8.27223833e-01,  8.64513675e-01,  8.98977415e-01,
     9.30407518e-01,  9.58599937e-01,  9.83447719e-01,  1.00488283e+00,
     1.02285381e+00,  1.03740495e+00,  1.04859791e+00,  1.05656184e+00,
     1.06149371e+00,  1.06362578e+00,  1.06325973e+00,  1.06074505e+00,
     1.05643590e+00,  1.05069500e+00,  1.04392435e+00,  1.03647725e+00,
     1.02872867e+00,  1.02106486e+00,  1.01400658e+00,  1.00727455e+00,
     1.00172250e+00,  9.97309592e-01,  9.93985158e-01,  9.91683335e-01,
     9.90325325e-01,  9.89822613e-01,  9.90074734e-01,  9.90975314e-01,
     9.92412851e-01,  9.94273149e-01,  9.96439157e-01,  9.98791616e-01,
     1.00120985e+00,  1.00357357e+00,  1.00575984e+00,  1.00764515e+00,
     1.00910687e+00,  1.01002476e+00,  1.01028203e+00,  1.00976919e+00,
     1.00838641e+00,  1.00605124e+00,  1.00269767e+00,  9.98280464e-01,
     9.92777987e-01,  9.86186892e-01,  9.77634164e-01,  9.67447270e-01,
     9.55129725e-01,  9.40389877e-01,  9.22959280e-01,  9.02607350e-01,
     8.79202689e-01,  8.52641750e-01,  8.22881272e-01,  7.89971715e-01,
     7.54030328e-01,  7.15255742e-01,  6.73936911e-01,  6.30414716e-01,
     5.85078858e-01,  5.38398518e-01,  4.90833753e-01,  4.42885823e-01,
     3.95091024e-01,  3.48004343e-01,  3.02196710e-01,  2.58227431e-01,
     2.16641416e-01,  1.77922122e-01,  1.42480547e-01,  1.10652194e-01,
     8.26995967e-02,  5.88334516e-02,  3.92030848e-02,  2.38629107e-02,
     1.26976223e-02,  5.35665361e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_16K = np.array([
     2.20824874e-03,  3.81014420e-03,  5.91552473e-03,  8.58361457e-03,
     1.18759723e-02,  1.58335301e-02,  2.04918652e-02,  2.58883593e-02,
     3.20415894e-02,  3.89616721e-02,  4.66742169e-02,  5.51849337e-02,
     6.45038384e-02,  7.46411071e-02,  8.56000162e-02,  9.73846703e-02,
     1.09993603e-01,  1.23419277e-01,  1.37655457e-01,  1.52690437e-01,
     1.68513363e-01,  1.85093105e-01,  2.02410419e-01,  2.20450365e-01,
     2.39167941e-01,  2.58526168e-01,  2.78498539e-01,  2.99038432e-01,
     3.20104862e-01,  3.41658622e-01,  3.63660034e-01,  3.86062695e-01,
     4.08815272e-01,  4.31871046e-01,  4.55176988e-01,  4.78676593e-01,
     5.02324813e-01,  5.26060916e-01,  5.49831283e-01,  5.73576883e-01,
     5.97241338e-01,  6.20770242e-01,  6.44099662e-01,  6.67176382e-01,
     6.89958854e-01,  7.12379980e-01,  7.34396372e-01,  7.55966688e-01,
     7.77036981e-01,  7.97558114e-01,  8.17490856e-01,  8.36796950e-01,
     8.55447310e-01,  8.73400798e-01,  8.90635719e-01,  9.07128770e-01,
     9.22848784e-01,  9.37763323e-01,  9.51860206e-01,  9.65130600e-01,
     9.77556541e-01,  9.89126209e-01,  9.99846919e-01,  1.00970073e+00,
     1.01868229e+00,  1.02681455e+00,  1.03408981e+00,  1.04051196e+00,
     1.04610837e+00,  1.05088565e+00,  1.05486289e+00,  1.05807221e+00,
     1.06053414e+00,  1.06227662e+00,  1.06333815e+00,  1.06375557e+00,
     1.06356632e+00,  1.06282156e+00,  1.06155996e+00,  1.05981709e+00,
     1.05765876e+00,  1.05512006e+00,  1.05223985e+00,  1.04908779e+00,
     1.04569860e+00,  1.04210831e+00,  1.03838099e+00,  1.03455276e+00,
     1.03067200e+00,  1.02679167e+00,  1.02295558e+00,  1.01920733e+00,
     1.01587289e+00,  1.01221017e+00,  1.00884559e+00,  1.00577851e+00,
     1.00300262e+00,  1.00051460e+00,  9.98309229e-01,  9.96378601e-01,
     9.94718132e-01,  9.93316216e-01,  9.92166957e-01,  9.91258603e-01,
     9.90581104e-01,  9.90123118e-01,  9.89873712e-01,  9.89818707e-01,
     9.89946800e-01,  9.90243175e-01,  9.90695564e-01,  9.91288540e-01,
     9.92009469e-01,  9.92842693e-01,  9.93775067e-01,  9.94790398e-01,
     9.95875534e-01,  9.97014367e-01,  9.98192871e-01,  9.99394506e-01,
     1.00060586e+00,  1.00181040e+00,  1.00299457e+00,  1.00414155e+00,
     1.00523688e+00,  1.00626393e+00,  1.00720890e+00,  1.00805489e+00,
     1.00878802e+00,  1.00939182e+00,  1.00985296e+00,  1.01015529e+00,
     1.01028602e+00,  1.01022988e+00,  1.00997541e+00,  1.00950846e+00,
     1.00881848e+00,  1.00789488e+00,  1.00672876e+00,  1.00530991e+00,
     1.00363456e+00,  1.00169363e+00,  9.99485663e-01,  9.97006370e-01,
     9.94254687e-01,  9.91231967e-01,  9.87937115e-01,  9.84375125e-01,
     9.79890963e-01,  9.75269879e-01,  9.70180498e-01,  9.64580027e-01,
     9.58425534e-01,  9.51684014e-01,  9.44320232e-01,  9.36290624e-01,
     9.27580507e-01,  9.18153414e-01,  9.07976524e-01,  8.97050058e-01,
     8.85351360e-01,  8.72857927e-01,  8.59579819e-01,  8.45502615e-01,
     8.30619943e-01,  8.14946648e-01,  7.98489378e-01,  7.81262450e-01,
     7.63291769e-01,  7.44590843e-01,  7.25199287e-01,  7.05153668e-01,
     6.84490545e-01,  6.63245210e-01,  6.41477162e-01,  6.19235334e-01,
     5.96559133e-01,  5.73519989e-01,  5.50173851e-01,  5.26568538e-01,
     5.02781159e-01,  4.78860889e-01,  4.54877894e-01,  4.30898123e-01,
     4.06993964e-01,  3.83234031e-01,  3.59680098e-01,  3.36408100e-01,
     3.13496418e-01,  2.91010565e-01,  2.69019585e-01,  2.47584348e-01,
     2.26788433e-01,  2.06677771e-01,  1.87310343e-01,  1.68739644e-01,
     1.51012382e-01,  1.34171842e-01,  1.18254662e-01,  1.03290734e-01,
     8.93117360e-02,  7.63429787e-02,  6.44077291e-02,  5.35243715e-02,
     4.37084453e-02,  3.49667099e-02,  2.72984629e-02,  2.06895808e-02,
     1.51125125e-02,  1.05228754e-02,  6.85547314e-03,  4.02351119e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_24K = np.array([
     1.97084908e-03,  2.95060859e-03,  4.12447721e-03,  5.52688664e-03,
     7.17541132e-03,  9.08757730e-03,  1.12819105e-02,  1.37695374e-02,
     1.65600266e-02,  1.96650895e-02,  2.30953556e-02,  2.68612894e-02,
     3.09632560e-02,  3.54036230e-02,  4.01915610e-02,  4.53331403e-02,
     5.08289304e-02,  5.66815448e-02,  6.28935304e-02,  6.94696293e-02,
     7.64106314e-02,  8.37160016e-02,  9.13884278e-02,  9.94294008e-02,
     1.07834725e-01,  1.16604575e-01,  1.25736503e-01,  1.35226811e-01,
     1.45073546e-01,  1.55273819e-01,  1.65822194e-01,  1.76711174e-01,
     1.87928776e-01,  1.99473180e-01,  2.11342953e-01,  2.23524554e-01,
     2.36003100e-01,  2.48768614e-01,  2.61813811e-01,  2.75129161e-01,
     2.88701102e-01,  3.02514034e-01,  3.16558805e-01,  3.30823871e-01,
     3.45295567e-01,  3.59963992e-01,  3.74814544e-01,  3.89831817e-01,
     4.05001010e-01,  4.20308013e-01,  4.35739515e-01,  4.51277817e-01,
     4.66904918e-01,  4.82609041e-01,  4.98375466e-01,  5.14185341e-01,
     5.30021478e-01,  5.45869352e-01,  5.61710041e-01,  5.77528151e-01,
     5.93304696e-01,  6.09026346e-01,  6.24674189e-01,  6.40227555e-01,
     6.55671016e-01,  6.70995935e-01,  6.86184559e-01,  7.01218384e-01,
     7.16078449e-01,  7.30756084e-01,  7.45240679e-01,  7.59515122e-01,
     7.73561955e-01,  7.87369206e-01,  8.00923138e-01,  8.14211386e-01,
     8.27223833e-01,  8.39952374e-01,  8.52386102e-01,  8.64513675e-01,
     8.76324079e-01,  8.87814288e-01,  8.98977415e-01,  9.09803319e-01,
     9.20284312e-01,  9.30407518e-01,  9.40169652e-01,  9.49567795e-01,
     9.58599937e-01,  9.67260260e-01,  9.75545166e-01,  9.83447719e-01,
     9.90971957e-01,  9.98119269e-01,  1.00488283e+00,  1.01125773e+00,
     1.01724436e+00,  1.02285381e+00,  1.02808734e+00,  1.03293706e+00,
     1.03740495e+00,  1.04150164e+00,  1.04523236e+00,  1.04859791e+00,
     1.05160340e+00,  1.05425505e+00,  1.05656184e+00,  1.05853400e+00,
     1.06017414e+00,  1.06149371e+00,  1.06249943e+00,  1.06320577e+00,
     1.06362578e+00,  1.06376487e+00,  1.06363778e+00,  1.06325973e+00,
     1.06264695e+00,  1.06180496e+00,  1.06074505e+00,  1.05948492e+00,
     1.05804533e+00,  1.05643590e+00,  1.05466218e+00,  1.05274047e+00,
     1.05069500e+00,  1.04853894e+00,  1.04627898e+00,  1.04392435e+00,
     1.04149540e+00,  1.03901003e+00,  1.03647725e+00,  1.03390793e+00,
     1.03131989e+00,  1.02872867e+00,  1.02614832e+00,  1.02358988e+00,
     1.02106486e+00,  1.01856262e+00,  1.01655770e+00,  1.01400658e+00,
     1.01162953e+00,  1.00938590e+00,  1.00727455e+00,  1.00529616e+00,
     1.00344526e+00,  1.00172250e+00,  1.00012792e+00,  9.98657533e-01,
     9.97309592e-01,  9.96083571e-01,  9.94976569e-01,  9.93985158e-01,
     9.93107530e-01,  9.92341305e-01,  9.91683335e-01,  9.91130070e-01,
     9.90678325e-01,  9.90325325e-01,  9.90067562e-01,  9.89901282e-01,
     9.89822613e-01,  9.89827845e-01,  9.89913241e-01,  9.90074734e-01,
     9.90308256e-01,  9.90609852e-01,  9.90975314e-01,  9.91400330e-01,
     9.91880966e-01,  9.92412851e-01,  9.92991779e-01,  9.93613381e-01,
     9.94273149e-01,  9.94966958e-01,  9.95690370e-01,  9.96439157e-01,
     9.97208572e-01,  9.97994275e-01,  9.98791616e-01,  9.99596062e-01,
     1.00040410e+00,  1.00120985e+00,  1.00200976e+00,  1.00279924e+00,
     1.00357357e+00,  1.00432828e+00,  1.00505850e+00,  1.00575984e+00,
     1.00642767e+00,  1.00705768e+00,  1.00764515e+00,  1.00818549e+00,
     1.00867427e+00,  1.00910687e+00,  1.00947916e+00,  1.00978659e+00,
     1.01002476e+00,  1.01018954e+00,  1.01027669e+00,  1.01028203e+00,
     1.01020174e+00,  1.01003208e+00,  1.00976919e+00,  1.00940939e+00,
     1.00894931e+00,  1.00838641e+00,  1.00771780e+00,  1.00694031e+00,
     1.00605124e+00,  1.00504879e+00,  1.00393183e+00,  1.00269767e+00,
     1.00134427e+00,  9.99872092e-01,  9.98280464e-01,  9.96566569e-01,
     9.94731737e-01,  9.92777987e-01,  9.90701374e-01,  9.88504165e-01,
     9.86186892e-01,  9.83711989e-01,  9.80584643e-01,  9.77634164e-01,
     9.74455033e-01,  9.71062916e-01,  9.67447270e-01,  9.63593926e-01,
     9.59491398e-01,  9.55129725e-01,  9.50501326e-01,  9.45592810e-01,
     9.40389877e-01,  9.34886760e-01,  9.29080559e-01,  9.22959280e-01,
     9.16509579e-01,  9.09724456e-01,  9.02607350e-01,  8.95155084e-01,
     8.87356154e-01,  8.79202689e-01,  8.70699698e-01,  8.61847424e-01,
     8.52641750e-01,  8.43077833e-01,  8.33154905e-01,  8.22881272e-01,
     8.12257597e-01,  8.01285439e-01,  7.89971715e-01,  7.78318177e-01,
     7.66337710e-01,  7.54030328e-01,  7.41407991e-01,  7.28477501e-01,
     7.15255742e-01,  7.01751739e-01,  6.87975632e-01,  6.73936911e-01,
     6.59652573e-01,  6.45139489e-01,  6.30414716e-01,  6.15483622e-01,
     6.00365852e-01,  5.85078858e-01,  5.69649536e-01,  5.54084810e-01,
     5.38398518e-01,  5.22614738e-01,  5.06756805e-01,  4.90833753e-01,
     4.74866033e-01,  4.58876566e-01,  4.42885823e-01,  4.26906539e-01,
     4.10970973e-01,  3.95091024e-01,  3.79291327e-01,  3.63587417e-01,
     3.48004343e-01,  3.32563201e-01,  3.17287485e-01,  3.02196710e-01,
     2.87309403e-01,  2.72643992e-01,  2.58227431e-01,  2.44072856e-01,
     2.30208977e-01,  2.16641416e-01,  2.03398481e-01,  1.90486162e-01,
     1.77922122e-01,  1.65726674e-01,  1.53906397e-01,  1.42480547e-01,
     1.31453980e-01,  1.20841778e-01,  1.10652194e-01,  1.00891734e-01,
     9.15718851e-02,  8.26995967e-02,  7.42815529e-02,  6.63242382e-02,
     5.88334516e-02,  5.18140676e-02,  4.52698346e-02,  3.92030848e-02,
     3.36144159e-02,  2.85023308e-02,  2.38629107e-02,  1.96894227e-02,
     1.59720527e-02,  1.26976223e-02,  9.84937739e-03,  7.40724463e-03,
     5.35665361e-03,  3.83226552e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_32K = np.array([
     1.84833037e-03,  2.56481839e-03,  3.36762118e-03,  4.28736617e-03,
     5.33830143e-03,  6.52679223e-03,  7.86112587e-03,  9.34628179e-03,
     1.09916868e-02,  1.28011172e-02,  1.47805911e-02,  1.69307043e-02,
     1.92592307e-02,  2.17696937e-02,  2.44685983e-02,  2.73556543e-02,
     3.04319230e-02,  3.36980464e-02,  3.71583577e-02,  4.08148180e-02,
     4.46708068e-02,  4.87262995e-02,  5.29820633e-02,  5.74382470e-02,
     6.20968580e-02,  6.69609767e-02,  7.20298364e-02,  7.73039146e-02,
     8.27825574e-02,  8.84682102e-02,  9.43607566e-02,  1.00460272e-01,
     1.06763824e-01,  1.13273679e-01,  1.19986420e-01,  1.26903521e-01,
     1.34020853e-01,  1.41339557e-01,  1.48857211e-01,  1.56573685e-01,
     1.64484622e-01,  1.72589077e-01,  1.80879090e-01,  1.89354320e-01,
     1.98012244e-01,  2.06854141e-01,  2.15875319e-01,  2.25068672e-01,
     2.34427407e-01,  2.43948314e-01,  2.53627993e-01,  2.63464061e-01,
     2.73450494e-01,  2.83582189e-01,  2.93853469e-01,  3.04257373e-01,
     3.14790914e-01,  3.25449123e-01,  3.36227410e-01,  3.47118760e-01,
     3.58120177e-01,  3.69224663e-01,  3.80427793e-01,  3.91720023e-01,
     4.03097022e-01,  4.14551955e-01,  4.26081719e-01,  4.37676318e-01,
     4.49330196e-01,  4.61034855e-01,  4.72786043e-01,  4.84576777e-01,
     4.96401707e-01,  5.08252458e-01,  5.20122078e-01,  5.32002077e-01,
     5.43888090e-01,  5.55771601e-01,  5.67645739e-01,  5.79502786e-01,
     5.91335035e-01,  6.03138367e-01,  6.14904172e-01,  6.26623941e-01,
     6.38288834e-01,  6.49893375e-01,  6.61432360e-01,  6.72902514e-01,
     6.84293750e-01,  6.95600460e-01,  7.06811784e-01,  7.17923425e-01,
     7.28931386e-01,  7.39832773e-01,  7.50618982e-01,  7.61284053e-01,
     7.71818919e-01,  7.82220992e-01,  7.92481330e-01,  8.02599448e-01,
     8.12565230e-01,  8.22377129e-01,  8.32030518e-01,  8.41523208e-01,
     8.50848313e-01,  8.60002412e-01,  8.68979881e-01,  8.77778347e-01,
     8.86395904e-01,  8.94829421e-01,  9.03077626e-01,  9.11132652e-01,
     9.18993585e-01,  9.26652937e-01,  9.34111420e-01,  9.41364344e-01,
     9.48412967e-01,  9.55255630e-01,  9.61892013e-01,  9.68316363e-01,
     9.74530156e-01,  9.80528338e-01,  9.86313928e-01,  9.91886049e-01,
     9.97246345e-01,  1.00239190e+00,  1.00731946e+00,  1.01202707e+00,
     1.01651654e+00,  1.02079430e+00,  1.02486082e+00,  1.02871471e+00,
     1.03235170e+00,  1.03577375e+00,  1.03898432e+00,  1.04198786e+00,
     1.04478564e+00,  1.04737818e+00,  1.04976743e+00,  1.05195405e+00,
     1.05394290e+00,  1.05573463e+00,  1.05734177e+00,  1.05875726e+00,
     1.05998674e+00,  1.06103672e+00,  1.06190651e+00,  1.06260369e+00,
     1.06313289e+00,  1.06350237e+00,  1.06370981e+00,  1.06376322e+00,
     1.06366765e+00,  1.06343012e+00,  1.06305656e+00,  1.06255421e+00,
     1.06192235e+00,  1.06116702e+00,  1.06029469e+00,  1.05931469e+00,
     1.05823465e+00,  1.05705891e+00,  1.05578948e+00,  1.05442979e+00,
     1.05298793e+00,  1.05147505e+00,  1.04989930e+00,  1.04826213e+00,
     1.04656691e+00,  1.04481699e+00,  1.04302125e+00,  1.04118768e+00,
     1.03932339e+00,  1.03743168e+00,  1.03551757e+00,  1.03358511e+00,
     1.03164371e+00,  1.02969955e+00,  1.02775944e+00,  1.02582719e+00,
     1.02390791e+00,  1.02200805e+00,  1.02013910e+00,  1.01826310e+00,
     1.01687901e+00,  1.01492195e+00,  1.01309662e+00,  1.01134205e+00,
     1.00965912e+00,  1.00805036e+00,  1.00651754e+00,  1.00505799e+00,
     1.00366956e+00,  1.00235327e+00,  1.00110981e+00,  9.99937523e-01,
     9.98834524e-01,  9.97800606e-01,  9.96835756e-01,  9.95938881e-01,
     9.95108459e-01,  9.94343411e-01,  9.93642921e-01,  9.93005832e-01,
     9.92430984e-01,  9.91917493e-01,  9.91463898e-01,  9.91068214e-01,
     9.90729218e-01,  9.90446225e-01,  9.90217819e-01,  9.90041963e-01,
     9.89917085e-01,  9.89841975e-01,  9.89815048e-01,  9.89834329e-01,
     9.89898211e-01,  9.90005403e-01,  9.90154189e-01,  9.90342427e-01,
     9.90568459e-01,  9.90830953e-01,  9.91128038e-01,  9.91457566e-01,
     9.91817881e-01,  9.92207559e-01,  9.92624757e-01,  9.93067358e-01,
     9.93533398e-01,  9.94021410e-01,  9.94529685e-01,  9.95055964e-01,
     9.95598351e-01,  9.96155580e-01,  9.96725627e-01,  9.97306092e-01,
     9.97895214e-01,  9.98491441e-01,  9.99092890e-01,  9.99697063e-01,
     1.00030303e+00,  1.00090793e+00,  1.00151084e+00,  1.00210923e+00,
     1.00270118e+00,  1.00328513e+00,  1.00385926e+00,  1.00442111e+00,
     1.00496860e+00,  1.00550040e+00,  1.00601455e+00,  1.00650869e+00,
     1.00698104e+00,  1.00743004e+00,  1.00785364e+00,  1.00824962e+00,
     1.00861604e+00,  1.00895138e+00,  1.00925390e+00,  1.00952134e+00,
     1.00975175e+00,  1.00994371e+00,  1.01009550e+00,  1.01020488e+00,
     1.01027007e+00,  1.01028975e+00,  1.01026227e+00,  1.01018562e+00,
     1.01005820e+00,  1.00987882e+00,  1.00964593e+00,  1.00935753e+00,
     1.00901228e+00,  1.00860959e+00,  1.00814837e+00,  1.00762674e+00,
     1.00704343e+00,  1.00639775e+00,  1.00568877e+00,  1.00491559e+00,
     1.00407768e+00,  1.00317429e+00,  1.00220424e+00,  1.00116684e+00,
     1.00006248e+00,  9.98891422e-01,  9.97652252e-01,  9.96343856e-01,
     9.94967462e-01,  9.93524663e-01,  9.92013927e-01,  9.90433283e-01,
     9.88785147e-01,  9.87072681e-01,  9.85297443e-01,  9.83401161e-01,
     9.80949418e-01,  9.78782729e-01,  9.76468238e-01,  9.74042850e-01,
     9.71498848e-01,  9.68829968e-01,  9.66030974e-01,  9.63095104e-01,
     9.60018198e-01,  9.56795738e-01,  9.53426267e-01,  9.49903482e-01,
     9.46222115e-01,  9.42375820e-01,  9.38361702e-01,  9.34177798e-01,
     9.29823124e-01,  9.25292320e-01,  9.20580120e-01,  9.15679793e-01,
     9.10590604e-01,  9.05315030e-01,  8.99852756e-01,  8.94199497e-01,
     8.88350152e-01,  8.82301631e-01,  8.76054874e-01,  8.69612385e-01,
     8.62972799e-01,  8.56135198e-01,  8.49098179e-01,  8.41857024e-01,
     8.34414055e-01,  8.26774617e-01,  8.18939244e-01,  8.10904891e-01,
     8.02675318e-01,  7.94253751e-01,  7.85641662e-01,  7.76838609e-01,
     7.67853193e-01,  7.58685181e-01,  7.49330658e-01,  7.39809171e-01,
     7.30109944e-01,  7.20247781e-01,  7.10224161e-01,  7.00044326e-01,
     6.89711890e-01,  6.79231154e-01,  6.68608179e-01,  6.57850997e-01,
     6.46965718e-01,  6.35959617e-01,  6.24840336e-01,  6.13603503e-01,
     6.02265091e-01,  5.90829083e-01,  5.79309408e-01,  5.67711124e-01,
     5.56037416e-01,  5.44293664e-01,  5.32489768e-01,  5.20636084e-01,
     5.08743273e-01,  4.96811166e-01,  4.84849881e-01,  4.72868107e-01,
     4.60875918e-01,  4.48881081e-01,  4.36891039e-01,  4.24912022e-01,
     4.12960603e-01,  4.01035896e-01,  3.89157867e-01,  3.77322199e-01,
     3.65543767e-01,  3.53832356e-01,  3.42196115e-01,  3.30644820e-01,
     3.19187559e-01,  3.07833309e-01,  2.96588182e-01,  2.85463717e-01,
     2.74462409e-01,  2.63609584e-01,  2.52883101e-01,  2.42323489e-01,
     2.31925746e-01,  2.21690837e-01,  2.11638058e-01,  2.01766920e-01,
     1.92082236e-01,  1.82589160e-01,  1.73305997e-01,  1.64229200e-01,
     1.55362654e-01,  1.46717079e-01,  1.38299391e-01,  1.30105078e-01,
     1.22145310e-01,  1.14423458e-01,  1.06941076e-01,  9.97025893e-02,
     9.27124283e-02,  8.59737427e-02,  7.94893311e-02,  7.32616579e-02,
     6.72934102e-02,  6.15874081e-02,  5.61458003e-02,  5.09700747e-02,
     4.60617047e-02,  4.14220117e-02,  3.70514189e-02,  3.29494666e-02,
     2.91153327e-02,  2.55476401e-02,  2.22437711e-02,  1.92000659e-02,
     1.64122205e-02,  1.38747611e-02,  1.15806353e-02,  9.52213664e-03,
     7.69137380e-03,  6.07207833e-03,  4.62581217e-03,  3.60685164e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_7M5_48K = np.array([
     1.72152668e-03,  2.20824874e-03,  2.68901752e-03,  3.22613342e-03,
     3.81014420e-03,  4.45371932e-03,  5.15369240e-03,  5.91552473e-03,
     6.73869158e-03,  7.62861841e-03,  8.58361457e-03,  9.60938437e-03,
     1.07060753e-02,  1.18759723e-02,  1.31190130e-02,  1.44390108e-02,
     1.58335301e-02,  1.73063081e-02,  1.88584711e-02,  2.04918652e-02,
     2.22061476e-02,  2.40057166e-02,  2.58883593e-02,  2.78552326e-02,
     2.99059145e-02,  3.20415894e-02,  3.42610013e-02,  3.65680973e-02,
     3.89616721e-02,  4.14435824e-02,  4.40140796e-02,  4.66742169e-02,
     4.94214625e-02,  5.22588489e-02,  5.51849337e-02,  5.82005143e-02,
     6.13059845e-02,  6.45038384e-02,  6.77913923e-02,  7.11707833e-02,
     7.46411071e-02,  7.82028053e-02,  8.18549521e-02,  8.56000162e-02,
     8.94357617e-02,  9.33642589e-02,  9.73846703e-02,  1.01496718e-01,
     1.05698760e-01,  1.09993603e-01,  1.14378287e-01,  1.18853508e-01,
     1.23419277e-01,  1.28075997e-01,  1.32820581e-01,  1.37655457e-01,
     1.42578648e-01,  1.47590522e-01,  1.52690437e-01,  1.57878853e-01,
     1.63152529e-01,  1.68513363e-01,  1.73957969e-01,  1.79484737e-01,
     1.85093105e-01,  1.90784835e-01,  1.96556497e-01,  2.02410419e-01,
     2.08345433e-01,  2.14359825e-01,  2.20450365e-01,  2.26617296e-01,
     2.32856279e-01,  2.39167941e-01,  2.45550642e-01,  2.52003951e-01,
     2.58526168e-01,  2.65118408e-01,  2.71775911e-01,  2.78498539e-01,
     2.85284606e-01,  2.92132459e-01,  2.99038432e-01,  3.06004256e-01,
     3.13026529e-01,  3.20104862e-01,  3.27237324e-01,  3.34423210e-01,
     3.41658622e-01,  3.48944976e-01,  3.56279252e-01,  3.63660034e-01,
     3.71085146e-01,  3.78554327e-01,  3.86062695e-01,  3.93610554e-01,
     4.01195225e-01,  4.08815272e-01,  4.16468460e-01,  4.24155411e-01,
     4.31871046e-01,  4.39614744e-01,  4.47384019e-01,  4.55176988e-01,
     4.62990138e-01,  4.70824619e-01,  4.78676593e-01,  4.86545433e-01,
     4.94428714e-01,  5.02324813e-01,  5.10229471e-01,  5.18142927e-01,
     5.26060916e-01,  5.33982818e-01,  5.41906817e-01,  5.49831283e-01,
     5.57751234e-01,  5.65667636e-01,  5.73576883e-01,  5.81476666e-01,
     5.89364661e-01,  5.97241338e-01,  6.05102013e-01,  6.12946170e-01,
     6.20770242e-01,  6.28572094e-01,  6.36348526e-01,  6.44099662e-01,
     6.51820973e-01,  6.59513822e-01,  6.67176382e-01,  6.74806795e-01,
     6.82400711e-01,  6.89958854e-01,  6.97475722e-01,  7.04950145e-01,
     7.12379980e-01,  7.19765434e-01,  7.27103833e-01,  7.34396372e-01,
     7.41638561e-01,  7.48829639e-01,  7.55966688e-01,  7.63049259e-01,
     7.70072273e-01,  7.77036981e-01,  7.83941108e-01,  7.90781257e-01,
     7.97558114e-01,  8.04271381e-01,  8.10914901e-01,  8.17490856e-01,
     8.23997094e-01,  8.30432785e-01,  8.36796950e-01,  8.43089298e-01,
     8.49305847e-01,  8.55447310e-01,  8.61511037e-01,  8.67496281e-01,
     8.73400798e-01,  8.79227518e-01,  8.84972438e-01,  8.90635719e-01,
     8.96217173e-01,  9.01716414e-01,  9.07128770e-01,  9.12456578e-01,
     9.17697261e-01,  9.22848784e-01,  9.27909917e-01,  9.32882596e-01,
     9.37763323e-01,  9.42553356e-01,  9.47252428e-01,  9.51860206e-01,
     9.56376060e-01,  9.60800602e-01,  9.65130600e-01,  9.69366689e-01,
     9.73508812e-01,  9.77556541e-01,  9.81507226e-01,  9.85364580e-01,
     9.89126209e-01,  9.92794201e-01,  9.96367545e-01,  9.99846919e-01,
     1.00322812e+00,  1.00651341e+00,  1.00970073e+00,  1.01279029e+00,
     1.01578293e+00,  1.01868229e+00,  1.02148657e+00,  1.02419772e+00,
     1.02681455e+00,  1.02933598e+00,  1.03176043e+00,  1.03408981e+00,
     1.03632326e+00,  1.03846361e+00,  1.04051196e+00,  1.04246831e+00,
     1.04433331e+00,  1.04610837e+00,  1.04779018e+00,  1.04938334e+00,
     1.05088565e+00,  1.05229923e+00,  1.05362522e+00,  1.05486289e+00,
     1.05601521e+00,  1.05708746e+00,  1.05807221e+00,  1.05897524e+00,
     1.05979447e+00,  1.06053414e+00,  1.06119412e+00,  1.06177366e+00,
     1.06227662e+00,  1.06270324e+00,  1.06305569e+00,  1.06333815e+00,
     1.06354800e+00,  1.06368607e+00,  1.06375557e+00,  1.06375743e+00,
     1.06369358e+00,  1.06356632e+00,  1.06337707e+00,  1.06312782e+00,
     1.06282156e+00,  1.06245782e+00,  1.06203634e+00,  1.06155996e+00,
     1.06102951e+00,  1.06044797e+00,  1.05981709e+00,  1.05914163e+00,
     1.05842136e+00,  1.05765876e+00,  1.05685377e+00,  1.05600761e+00,
     1.05512006e+00,  1.05419505e+00,  1.05323346e+00,  1.05223985e+00,
     1.05121668e+00,  1.05016637e+00,  1.04908779e+00,  1.04798366e+00,
     1.04685334e+00,  1.04569860e+00,  1.04452056e+00,  1.04332348e+00,
     1.04210831e+00,  1.04087907e+00,  1.03963603e+00,  1.03838099e+00,
     1.03711403e+00,  1.03583813e+00,  1.03455276e+00,  1.03326200e+00,
     1.03196750e+00,  1.03067200e+00,  1.02937564e+00,  1.02808244e+00,
     1.02679167e+00,  1.02550635e+00,  1.02422655e+00,  1.02295558e+00,
     1.02169299e+00,  1.02044475e+00,  1.01920733e+00,  1.01799992e+00,
     1.01716022e+00,  1.01587289e+00,  1.01461783e+00,  1.01339738e+00,
     1.01221017e+00,  1.01105652e+00,  1.00993444e+00,  1.00884559e+00,
     1.00778956e+00,  1.00676790e+00,  1.00577851e+00,  1.00482173e+00,
     1.00389592e+00,  1.00300262e+00,  1.00214091e+00,  1.00131213e+00,
     1.00051460e+00,  9.99748988e-01,  9.99013486e-01,  9.98309229e-01,
     9.97634934e-01,  9.96991885e-01,  9.96378601e-01,  9.95795982e-01,
     9.95242217e-01,  9.94718132e-01,  9.94222122e-01,  9.93755313e-01,
     9.93316216e-01,  9.92905809e-01,  9.92522422e-01,  9.92166957e-01,
     9.91837704e-01,  9.91535508e-01,  9.91258603e-01,  9.91007878e-01,
     9.90781723e-01,  9.90581104e-01,  9.90404336e-01,  9.90252267e-01,
     9.90123118e-01,  9.90017726e-01,  9.89934325e-01,  9.89873712e-01,
     9.89834110e-01,  9.89816359e-01,  9.89818707e-01,  9.89841998e-01,
     9.89884438e-01,  9.89946800e-01,  9.90027287e-01,  9.90126680e-01,
     9.90243175e-01,  9.90377594e-01,  9.90528134e-01,  9.90695564e-01,
     9.90878043e-01,  9.91076302e-01,  9.91288540e-01,  9.91515602e-01,
     9.91755666e-01,  9.92009469e-01,  9.92275155e-01,  9.92553486e-01,
     9.92842693e-01,  9.93143533e-01,  9.93454080e-01,  9.93775067e-01,
     9.94104689e-01,  9.94443742e-01,  9.94790398e-01,  9.95145361e-01,
     9.95506800e-01,  9.95875534e-01,  9.96249681e-01,  9.96629919e-01,
     9.97014367e-01,  9.97403799e-01,  9.97796404e-01,  9.98192871e-01,
     9.98591286e-01,  9.98992436e-01,  9.99394506e-01,  9.99798247e-01,
     1.00020179e+00,  1.00060586e+00,  1.00100858e+00,  1.00141070e+00,
     1.00181040e+00,  1.00220846e+00,  1.00260296e+00,  1.00299457e+00,
     1.00338148e+00,  1.00376444e+00,  1.00414155e+00,  1.00451348e+00,
     1.00487832e+00,  1.00523688e+00,  1.00558730e+00,  1.00593027e+00,
     1.00626393e+00,  1.00658905e+00,  1.00690380e+00,  1.00720890e+00,
     1.00750238e+00,  1.00778498e+00,  1.00805489e+00,  1.00831287e+00,
     1.00855700e+00,  1.00878802e+00,  1.00900405e+00,  1.00920593e+00,
     1.00939182e+00,  1.00956244e+00,  1.00971590e+00,  1.00985296e+00,
     1.00997177e+00,  1.01007317e+00,  1.01015529e+00,  1.01021893e+00,
     1.01026225e+00,  1.01028602e+00,  1.01028842e+00,  1.01027030e+00,
     1.01022988e+00,  1.01016802e+00,  1.01008292e+00,  1.00997541e+00,
     1.00984369e+00,  1.00968863e+00,  1.00950846e+00,  1.00930404e+00,
     1.00907371e+00,  1.00881848e+00,  1.00853675e+00,  1.00822947e+00,
     1.00789488e+00,  1.00753391e+00,  1.00714488e+00,  1.00672876e+00,
     1.00628393e+00,  1.00581146e+00,  1.00530991e+00,  1.00478053e+00,
     1.00422177e+00,  1.00363456e+00,  1.00301719e+00,  1.00237067e+00,
     1.00169363e+00,  1.00098749e+00,  1.00025108e+00,  9.99485663e-01,
     9.98689592e-01,  9.97863666e-01,  9.97006370e-01,  9.96119199e-01,
     9.95201404e-01,  9.94254687e-01,  9.93277595e-01,  9.92270651e-01,
     9.91231967e-01,  9.90163286e-01,  9.89064394e-01,  9.87937115e-01,
     9.86779736e-01,  9.85592773e-01,  9.84375125e-01,  9.83129288e-01,
     9.81348463e-01,  9.79890963e-01,  9.78400459e-01,  9.76860435e-01,
     9.75269879e-01,  9.73627353e-01,  9.71931341e-01,  9.70180498e-01,
     9.68372652e-01,  9.66506952e-01,  9.64580027e-01,  9.62592318e-01,
     9.60540986e-01,  9.58425534e-01,  9.56244393e-01,  9.53998416e-01,
     9.51684014e-01,  9.49301185e-01,  9.46846884e-01,  9.44320232e-01,
     9.41718404e-01,  9.39042580e-01,  9.36290624e-01,  9.33464050e-01,
     9.30560854e-01,  9.27580507e-01,  9.24519592e-01,  9.21378471e-01,
     9.18153414e-01,  9.14844696e-01,  9.11451652e-01,  9.07976524e-01,
     9.04417545e-01,  9.00776308e-01,  8.97050058e-01,  8.93238398e-01,
     8.89338681e-01,  8.85351360e-01,  8.81274023e-01,  8.77109638e-01,
     8.72857927e-01,  8.68519505e-01,  8.64092796e-01,  8.59579819e-01,
     8.54976007e-01,  8.50285220e-01,  8.45502615e-01,  8.40630470e-01,
     8.35667925e-01,  8.30619943e-01,  8.25482007e-01,  8.20258909e-01,
     8.14946648e-01,  8.09546696e-01,  8.04059978e-01,  7.98489378e-01,
     7.92831417e-01,  7.87090668e-01,  7.81262450e-01,  7.75353947e-01,
     7.69363613e-01,  7.63291769e-01,  7.57139016e-01,  7.50901711e-01,
     7.44590843e-01,  7.38205136e-01,  7.31738075e-01,  7.25199287e-01,
     7.18588225e-01,  7.11905687e-01,  7.05153668e-01,  6.98332634e-01,
     6.91444101e-01,  6.84490545e-01,  6.77470119e-01,  6.70388375e-01,
     6.63245210e-01,  6.56045780e-01,  6.48788627e-01,  6.41477162e-01,
     6.34114323e-01,  6.26702000e-01,  6.19235334e-01,  6.11720596e-01,
     6.04161612e-01,  5.96559133e-01,  5.88914401e-01,  5.81234783e-01,
     5.73519989e-01,  5.65770616e-01,  5.57988067e-01,  5.50173851e-01,
     5.42330194e-01,  5.34460798e-01,  5.26568538e-01,  5.18656324e-01,
     5.10728813e-01,  5.02781159e-01,  4.94819491e-01,  4.86845139e-01,
     4.78860889e-01,  4.70869928e-01,  4.62875144e-01,  4.54877894e-01,
     4.46882512e-01,  4.38889325e-01,  4.30898123e-01,  4.22918322e-01,
     4.14950878e-01,  4.06993964e-01,  3.99052648e-01,  3.91134614e-01,
     3.83234031e-01,  3.75354653e-01,  3.67502060e-01,  3.59680098e-01,
     3.51887312e-01,  3.44130166e-01,  3.36408100e-01,  3.28728966e-01,
     3.21090505e-01,  3.13496418e-01,  3.05951565e-01,  2.98454319e-01,
     2.91010565e-01,  2.83621109e-01,  2.76285415e-01,  2.69019585e-01,
     2.61812445e-01,  2.54659232e-01,  2.47584348e-01,  2.40578694e-01,
     2.33647009e-01,  2.26788433e-01,  2.20001992e-01,  2.13301325e-01,
     2.06677771e-01,  2.00140409e-01,  1.93683630e-01,  1.87310343e-01,
     1.81027384e-01,  1.74839476e-01,  1.68739644e-01,  1.62737273e-01,
     1.56825277e-01,  1.51012382e-01,  1.45298230e-01,  1.39687469e-01,
     1.34171842e-01,  1.28762544e-01,  1.23455562e-01,  1.18254662e-01,
     1.13159677e-01,  1.08171439e-01,  1.03290734e-01,  9.85202978e-02,
     9.38600023e-02,  8.93117360e-02,  8.48752103e-02,  8.05523737e-02,
     7.63429787e-02,  7.22489246e-02,  6.82699120e-02,  6.44077291e-02,
     6.06620003e-02,  5.70343711e-02,  5.35243715e-02,  5.01334690e-02,
     4.68610790e-02,  4.37084453e-02,  4.06748365e-02,  3.77612269e-02,
     3.49667099e-02,  3.22919275e-02,  2.97357669e-02,  2.72984629e-02,
     2.49787186e-02,  2.27762542e-02,  2.06895808e-02,  1.87178169e-02,
     1.68593418e-02,  1.51125125e-02,  1.34757094e-02,  1.19462709e-02,
     1.05228754e-02,  9.20130941e-03,  7.98124316e-03,  6.85547314e-03,
     5.82657334e-03,  4.87838525e-03,  4.02351119e-03,  3.15418663e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_8K = np.array([
    -7.07854671e-04, -2.09819773e-03, -4.52519808e-03, -8.23397633e-03,
    -1.33771310e-02, -1.99972156e-02, -2.80090946e-02, -3.72150208e-02,
    -4.73176826e-02, -5.79465483e-02, -6.86760675e-02, -7.90464744e-02,
    -8.85970547e-02, -9.68830362e-02, -1.03496124e-01, -1.08076646e-01,
    -1.10324226e-01, -1.09980985e-01, -1.06817214e-01, -1.00619042e-01,
    -9.11645251e-02, -7.82061748e-02, -6.14668812e-02, -4.06336286e-02,
    -1.53632952e-02,  1.47015507e-02,  4.98973651e-02,  9.05036926e-02,
     1.36691102e-01,  1.88468639e-01,  2.45645680e-01,  3.07778908e-01,
     3.74164237e-01,  4.43811480e-01,  5.15473546e-01,  5.87666172e-01,
     6.58761977e-01,  7.27057670e-01,  7.90875299e-01,  8.48664336e-01,
     8.99132024e-01,  9.41334815e-01,  9.74763483e-01,  9.99411473e-01,
     1.01576037e+00,  1.02473616e+00,  1.02763429e+00,  1.02599149e+00,
     1.02142721e+00,  1.01543986e+00,  1.00936693e+00,  1.00350816e+00,
     9.98889821e-01,  9.95313390e-01,  9.92594392e-01,  9.90577196e-01,
     9.89137162e-01,  9.88179075e-01,  9.87624927e-01,  9.87405628e-01,
     9.87452485e-01,  9.87695113e-01,  9.88064062e-01,  9.88492687e-01,
     9.88923003e-01,  9.89307497e-01,  9.89614633e-01,  9.89831927e-01,
     9.89969310e-01,  9.90060335e-01,  9.90157502e-01,  9.90325529e-01,
     9.90630379e-01,  9.91129889e-01,  9.91866549e-01,  9.92861973e-01,
     9.94115607e-01,  9.95603378e-01,  9.97279311e-01,  9.99078484e-01,
     1.00092237e+00,  1.00272811e+00,  1.00441604e+00,  1.00591922e+00,
     1.00718935e+00,  1.00820015e+00,  1.00894949e+00,  1.00945824e+00,
     1.00976898e+00,  1.00994034e+00,  1.01003945e+00,  1.01013232e+00,
     1.01027252e+00,  1.01049435e+00,  1.01080807e+00,  1.01120107e+00,
     1.01164127e+00,  1.01208013e+00,  1.01245818e+00,  1.01270696e+00,
     1.01275501e+00,  1.01253013e+00,  1.01196233e+00,  1.01098214e+00,
     1.00951244e+00,  1.00746086e+00,  1.00470868e+00,  1.00111141e+00,
     9.96504102e-01,  9.90720000e-01,  9.82376587e-01,  9.70882175e-01,
     9.54673298e-01,  9.32155386e-01,  9.01800368e-01,  8.62398408e-01,
     8.13281737e-01,  7.54455197e-01,  6.86658072e-01,  6.11348804e-01,
     5.30618165e-01,  4.47130985e-01,  3.63911468e-01,  2.84164703e-01,
     2.11020945e-01,  1.47228797e-01,  9.48266535e-02,  5.48243661e-02,
     2.70146141e-02,  9.99674359e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_16K = np.array([
    -4.61989875e-04, -9.74716672e-04, -1.66447310e-03, -2.59710692e-03,
    -3.80628516e-03, -5.32460872e-03, -7.17588528e-03, -9.38248086e-03,
    -1.19527030e-02, -1.48952816e-02, -1.82066640e-02, -2.18757093e-02,
    -2.58847194e-02, -3.02086274e-02, -3.48159779e-02, -3.96706799e-02,
    -4.47269805e-02, -4.99422586e-02, -5.52633479e-02, -6.06371724e-02,
    -6.60096152e-02, -7.13196627e-02, -7.65117823e-02, -8.15296401e-02,
    -8.63113754e-02, -9.08041129e-02, -9.49537776e-02, -9.87073651e-02,
    -1.02020268e-01, -1.04843883e-01, -1.07138231e-01, -1.08869014e-01,
    -1.09996966e-01, -1.10489847e-01, -1.10322584e-01, -1.09462175e-01,
    -1.07883429e-01, -1.05561251e-01, -1.02465016e-01, -9.85701457e-02,
    -9.38468492e-02, -8.82630999e-02, -8.17879272e-02, -7.43878560e-02,
    -6.60218980e-02, -5.66565564e-02, -4.62445689e-02, -3.47458578e-02,
    -2.21158161e-02, -8.31042570e-03,  6.71769764e-03,  2.30064206e-02,
     4.06010646e-02,  5.95323909e-02,  7.98335419e-02,  1.01523314e-01,
     1.24617139e-01,  1.49115252e-01,  1.75006740e-01,  2.02269985e-01,
     2.30865538e-01,  2.60736512e-01,  2.91814469e-01,  3.24009570e-01,
     3.57217518e-01,  3.91314689e-01,  4.26157164e-01,  4.61592545e-01,
     4.97447159e-01,  5.33532682e-01,  5.69654673e-01,  6.05608382e-01,
     6.41183084e-01,  6.76165350e-01,  7.10340055e-01,  7.43494372e-01,
     7.75428189e-01,  8.05943723e-01,  8.34858937e-01,  8.62010834e-01,
     8.87259971e-01,  9.10486312e-01,  9.31596250e-01,  9.50522086e-01,
     9.67236671e-01,  9.81739750e-01,  9.94055718e-01,  1.00424751e+00,
     1.01240743e+00,  1.01865099e+00,  1.02311884e+00,  1.02597245e+00,
     1.02739752e+00,  1.02758583e+00,  1.02673867e+00,  1.02506178e+00,
     1.02275651e+00,  1.02000914e+00,  1.01699650e+00,  1.01391595e+00,
     1.01104487e+00,  1.00777386e+00,  1.00484875e+00,  1.00224501e+00,
     9.99939317e-01,  9.97905542e-01,  9.96120338e-01,  9.94559753e-01,
     9.93203161e-01,  9.92029727e-01,  9.91023065e-01,  9.90166895e-01,
     9.89448837e-01,  9.88855636e-01,  9.88377852e-01,  9.88005163e-01,
     9.87729546e-01,  9.87541274e-01,  9.87432981e-01,  9.87394992e-01,
     9.87419705e-01,  9.87497321e-01,  9.87620124e-01,  9.87778192e-01,
     9.87963798e-01,  9.88167801e-01,  9.88383520e-01,  9.88602222e-01,
     9.88818277e-01,  9.89024798e-01,  9.89217866e-01,  9.89392368e-01,
     9.89546334e-01,  9.89677201e-01,  9.89785920e-01,  9.89872536e-01,
     9.89941079e-01,  9.89994556e-01,  9.90039402e-01,  9.90081472e-01,
     9.90129379e-01,  9.90190227e-01,  9.90273445e-01,  9.90386228e-01,
     9.90537983e-01,  9.90734883e-01,  9.90984259e-01,  9.91290512e-01,
     9.91658694e-01,  9.92090615e-01,  9.92588721e-01,  9.93151653e-01,
     9.93779087e-01,  9.94466818e-01,  9.95211663e-01,  9.96006862e-01,
     9.96846133e-01,  9.97720337e-01,  9.98621352e-01,  9.99538258e-01,
     1.00046196e+00,  1.00138055e+00,  1.00228487e+00,  1.00316385e+00,
     1.00400915e+00,  1.00481138e+00,  1.00556397e+00,  1.00625986e+00,
     1.00689557e+00,  1.00746662e+00,  1.00797244e+00,  1.00841147e+00,
     1.00878601e+00,  1.00909776e+00,  1.00935176e+00,  1.00955240e+00,
     1.00970709e+00,  1.00982209e+00,  1.00990696e+00,  1.00996902e+00,
     1.01001789e+00,  1.01006081e+00,  1.01010656e+00,  1.01016113e+00,
     1.01023108e+00,  1.01031948e+00,  1.01043047e+00,  1.01056410e+00,
     1.01072136e+00,  1.01089966e+00,  1.01109699e+00,  1.01130817e+00,
     1.01152919e+00,  1.01175301e+00,  1.01197388e+00,  1.01218284e+00,
     1.01237303e+00,  1.01253506e+00,  1.01266098e+00,  1.01274058e+00,
     1.01276592e+00,  1.01272696e+00,  1.01261590e+00,  1.01242289e+00,
     1.01214046e+00,  1.01175881e+00,  1.01126996e+00,  1.01066368e+00,
     1.00993075e+00,  1.00905825e+00,  1.00803431e+00,  1.00684335e+00,
     1.00547001e+00,  1.00389477e+00,  1.00209885e+00,  1.00006069e+00,
     9.97760020e-01,  9.95174643e-01,  9.92286108e-01,  9.89075787e-01,
     9.84736245e-01,  9.79861353e-01,  9.74137862e-01,  9.67333198e-01,
     9.59253976e-01,  9.49698408e-01,  9.38463416e-01,  9.25356797e-01,
     9.10198679e-01,  8.92833832e-01,  8.73143784e-01,  8.51042044e-01,
     8.26483991e-01,  7.99468149e-01,  7.70043128e-01,  7.38302860e-01,
     7.04381434e-01,  6.68461648e-01,  6.30775533e-01,  5.91579959e-01,
     5.51170316e-01,  5.09891542e-01,  4.68101711e-01,  4.26177297e-01,
     3.84517234e-01,  3.43522867e-01,  3.03600465e-01,  2.65143468e-01,
     2.28528397e-01,  1.94102191e-01,  1.62173542e-01,  1.33001524e-01,
     1.06784043e-01,  8.36505724e-02,  6.36518811e-02,  4.67653841e-02,
     3.28807275e-02,  2.18305756e-02,  1.33638143e-02,  6.75812489e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_24K = np.array([
    -3.61349642e-04, -7.07854671e-04, -1.07444364e-03, -1.53347854e-03,
    -2.09819773e-03, -2.77842087e-03, -3.58412992e-03, -4.52519808e-03,
    -5.60932724e-03, -6.84323454e-03, -8.23397633e-03, -9.78531476e-03,
    -1.14988030e-02, -1.33771310e-02, -1.54218168e-02, -1.76297991e-02,
    -1.99972156e-02, -2.25208056e-02, -2.51940630e-02, -2.80090946e-02,
    -3.09576509e-02, -3.40299627e-02, -3.72150208e-02, -4.05005325e-02,
    -4.38721922e-02, -4.73176826e-02, -5.08232534e-02, -5.43716664e-02,
    -5.79465483e-02, -6.15342620e-02, -6.51170816e-02, -6.86760675e-02,
    -7.21944781e-02, -7.56569598e-02, -7.90464744e-02, -8.23444256e-02,
    -8.55332458e-02, -8.85970547e-02, -9.15209110e-02, -9.42884745e-02,
    -9.68830362e-02, -9.92912326e-02, -1.01500847e-01, -1.03496124e-01,
    -1.05263700e-01, -1.06793998e-01, -1.08076646e-01, -1.09099730e-01,
    -1.09852449e-01, -1.10324226e-01, -1.10508462e-01, -1.10397741e-01,
    -1.09980985e-01, -1.09249277e-01, -1.08197423e-01, -1.06817214e-01,
    -1.05099580e-01, -1.03036011e-01, -1.00619042e-01, -9.78412002e-02,
    -9.46930422e-02, -9.11645251e-02, -8.72464453e-02, -8.29304391e-02,
    -7.82061748e-02, -7.30614243e-02, -6.74846818e-02, -6.14668812e-02,
    -5.49949726e-02, -4.80544442e-02, -4.06336286e-02, -3.27204559e-02,
    -2.43012258e-02, -1.53632952e-02, -5.89143427e-03,  4.12659586e-03,
     1.47015507e-02,  2.58473819e-02,  3.75765277e-02,  4.98973651e-02,
     6.28203403e-02,  7.63539773e-02,  9.05036926e-02,  1.05274712e-01,
     1.20670347e-01,  1.36691102e-01,  1.53334389e-01,  1.70595471e-01,
     1.88468639e-01,  2.06944996e-01,  2.26009300e-01,  2.45645680e-01,
     2.65834602e-01,  2.86554381e-01,  3.07778908e-01,  3.29476944e-01,
     3.51617148e-01,  3.74164237e-01,  3.97073959e-01,  4.20304305e-01,
     4.43811480e-01,  4.67544229e-01,  4.91449863e-01,  5.15473546e-01,
     5.39555764e-01,  5.63639982e-01,  5.87666172e-01,  6.11569531e-01,
     6.35289059e-01,  6.58761977e-01,  6.81923097e-01,  7.04709282e-01,
     7.27057670e-01,  7.48906896e-01,  7.70199019e-01,  7.90875299e-01,
     8.10878869e-01,  8.30157914e-01,  8.48664336e-01,  8.66354816e-01,
     8.83189685e-01,  8.99132024e-01,  9.14154056e-01,  9.28228255e-01,
     9.41334815e-01,  9.53461939e-01,  9.64604825e-01,  9.74763483e-01,
     9.83943539e-01,  9.92152910e-01,  9.99411473e-01,  1.00574608e+00,
     1.01118397e+00,  1.01576037e+00,  1.01951507e+00,  1.02249094e+00,
     1.02473616e+00,  1.02630410e+00,  1.02725098e+00,  1.02763429e+00,
     1.02751106e+00,  1.02694280e+00,  1.02599149e+00,  1.02471615e+00,
     1.02317598e+00,  1.02142721e+00,  1.01952157e+00,  1.01751012e+00,
     1.01543986e+00,  1.01346092e+00,  1.01165490e+00,  1.00936693e+00,
     1.00726318e+00,  1.00531319e+00,  1.00350816e+00,  1.00184079e+00,
     1.00030393e+00,  9.98889821e-01,  9.97591528e-01,  9.96401528e-01,
     9.95313390e-01,  9.94320108e-01,  9.93415896e-01,  9.92594392e-01,
     9.91851028e-01,  9.91179799e-01,  9.90577196e-01,  9.90038105e-01,
     9.89559439e-01,  9.89137162e-01,  9.88768437e-01,  9.88449792e-01,
     9.88179075e-01,  9.87952836e-01,  9.87769137e-01,  9.87624927e-01,
     9.87517995e-01,  9.87445813e-01,  9.87405628e-01,  9.87395112e-01,
     9.87411537e-01,  9.87452485e-01,  9.87514989e-01,  9.87596889e-01,
     9.87695113e-01,  9.87807582e-01,  9.87931200e-01,  9.88064062e-01,
     9.88203257e-01,  9.88347108e-01,  9.88492687e-01,  9.88638659e-01,
     9.88782558e-01,  9.88923003e-01,  9.89058172e-01,  9.89186767e-01,
     9.89307497e-01,  9.89419640e-01,  9.89522076e-01,  9.89614633e-01,
     9.89697035e-01,  9.89769260e-01,  9.89831927e-01,  9.89885257e-01,
     9.89930764e-01,  9.89969310e-01,  9.90002569e-01,  9.90032156e-01,
     9.90060335e-01,  9.90088981e-01,  9.90120659e-01,  9.90157502e-01,
     9.90202395e-01,  9.90257541e-01,  9.90325529e-01,  9.90408791e-01,
     9.90509649e-01,  9.90630379e-01,  9.90772711e-01,  9.90938744e-01,
     9.91129889e-01,  9.91347632e-01,  9.91592856e-01,  9.91866549e-01,
     9.92169132e-01,  9.92501085e-01,  9.92861973e-01,  9.93251918e-01,
     9.93670021e-01,  9.94115607e-01,  9.94587315e-01,  9.95083740e-01,
     9.95603378e-01,  9.96143992e-01,  9.96703453e-01,  9.97279311e-01,
     9.97869086e-01,  9.98469709e-01,  9.99078484e-01,  9.99691901e-01,
     1.00030819e+00,  1.00092237e+00,  1.00153264e+00,  1.00213546e+00,
     1.00272811e+00,  1.00330745e+00,  1.00387093e+00,  1.00441604e+00,
     1.00494055e+00,  1.00544214e+00,  1.00591922e+00,  1.00637030e+00,
     1.00679393e+00,  1.00718935e+00,  1.00755557e+00,  1.00789267e+00,
     1.00820015e+00,  1.00847842e+00,  1.00872788e+00,  1.00894949e+00,
     1.00914411e+00,  1.00931322e+00,  1.00945824e+00,  1.00958128e+00,
     1.00968409e+00,  1.00976898e+00,  1.00983831e+00,  1.00989455e+00,
     1.00994034e+00,  1.00997792e+00,  1.01001023e+00,  1.01003945e+00,
     1.01006820e+00,  1.01009839e+00,  1.01013232e+00,  1.01017166e+00,
     1.01021810e+00,  1.01027252e+00,  1.01033649e+00,  1.01041022e+00,
     1.01049435e+00,  1.01058887e+00,  1.01069350e+00,  1.01080807e+00,
     1.01093144e+00,  1.01106288e+00,  1.01120107e+00,  1.01134470e+00,
     1.01149190e+00,  1.01164127e+00,  1.01179028e+00,  1.01193757e+00,
     1.01208013e+00,  1.01221624e+00,  1.01234291e+00,  1.01245818e+00,
     1.01255888e+00,  1.01264286e+00,  1.01270696e+00,  1.01274895e+00,
     1.01276580e+00,  1.01275501e+00,  1.01271380e+00,  1.01263978e+00,
     1.01253013e+00,  1.01238231e+00,  1.01219407e+00,  1.01196233e+00,
     1.01168517e+00,  1.01135914e+00,  1.01098214e+00,  1.01055072e+00,
     1.01006213e+00,  1.00951244e+00,  1.00889869e+00,  1.00821592e+00,
     1.00746086e+00,  1.00662774e+00,  1.00571234e+00,  1.00470868e+00,
     1.00361147e+00,  1.00241429e+00,  1.00111141e+00,  9.99696165e-01,
     9.98162595e-01,  9.96504102e-01,  9.94714888e-01,  9.92789191e-01,
     9.90720000e-01,  9.88479371e-01,  9.85534766e-01,  9.82376587e-01,
     9.78974733e-01,  9.75162381e-01,  9.70882175e-01,  9.66080552e-01,
     9.60697640e-01,  9.54673298e-01,  9.47947935e-01,  9.40460905e-01,
     9.32155386e-01,  9.22977548e-01,  9.12874535e-01,  9.01800368e-01,
     8.89716328e-01,  8.76590897e-01,  8.62398408e-01,  8.47120080e-01,
     8.30747973e-01,  8.13281737e-01,  7.94729145e-01,  7.75110884e-01,
     7.54455197e-01,  7.32796355e-01,  7.10179084e-01,  6.86658072e-01,
     6.62296243e-01,  6.37168412e-01,  6.11348804e-01,  5.84920660e-01,
     5.57974743e-01,  5.30618165e-01,  5.02952396e-01,  4.75086883e-01,
     4.47130985e-01,  4.19204992e-01,  3.91425291e-01,  3.63911468e-01,
     3.36783777e-01,  3.10162784e-01,  2.84164703e-01,  2.58903371e-01,
     2.34488060e-01,  2.11020945e-01,  1.88599764e-01,  1.67310081e-01,
     1.47228797e-01,  1.28422307e-01,  1.10942255e-01,  9.48266535e-02,
     8.00991437e-02,  6.67676585e-02,  5.48243661e-02,  4.42458885e-02,
     3.49936100e-02,  2.70146141e-02,  2.02437018e-02,  1.46079676e-02,
     9.99674359e-03,  5.30523510e-03,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_32K = np.array([
    -3.02115349e-04, -5.86773749e-04, -8.36650400e-04, -1.12663536e-03,
    -1.47049294e-03, -1.87347339e-03, -2.33929236e-03, -2.87200807e-03,
    -3.47625639e-03, -4.15596382e-03, -4.91456379e-03, -5.75517250e-03,
    -6.68062338e-03, -7.69381692e-03, -8.79676075e-03, -9.99050307e-03,
    -1.12757412e-02, -1.26533415e-02, -1.41243899e-02, -1.56888962e-02,
    -1.73451209e-02, -1.90909737e-02, -2.09254671e-02, -2.28468479e-02,
    -2.48520772e-02, -2.69374670e-02, -2.90995249e-02, -3.13350463e-02,
    -3.36396073e-02, -3.60082097e-02, -3.84360174e-02, -4.09174603e-02,
    -4.34465489e-02, -4.60178672e-02, -4.86259851e-02, -5.12647420e-02,
    -5.39264475e-02, -5.66038431e-02, -5.92911675e-02, -6.19826820e-02,
    -6.46702555e-02, -6.73454222e-02, -7.00009902e-02, -7.26305701e-02,
    -7.52278496e-02, -7.77852594e-02, -8.02948025e-02, -8.27492454e-02,
    -8.51412546e-02, -8.74637912e-02, -8.97106934e-02, -9.18756408e-02,
    -9.39517698e-02, -9.59313774e-02, -9.78084326e-02, -9.95785130e-02,
    -1.01236117e-01, -1.02774104e-01, -1.04186122e-01, -1.05468025e-01,
    -1.06616088e-01, -1.07625538e-01, -1.08491230e-01, -1.09208742e-01,
    -1.09773615e-01, -1.10180886e-01, -1.10427188e-01, -1.10510836e-01,
    -1.10428147e-01, -1.10173922e-01, -1.09743736e-01, -1.09135313e-01,
    -1.08346734e-01, -1.07373994e-01, -1.06213016e-01, -1.04860615e-01,
    -1.03313240e-01, -1.01567316e-01, -9.96200551e-02, -9.74680323e-02,
    -9.51072362e-02, -9.25330338e-02, -8.97412522e-02, -8.67287769e-02,
    -8.34921384e-02, -8.00263990e-02, -7.63267954e-02, -7.23880616e-02,
    -6.82057680e-02, -6.37761143e-02, -5.90938600e-02, -5.41531632e-02,
    -4.89481272e-02, -4.34734711e-02, -3.77246130e-02, -3.16958761e-02,
    -2.53817983e-02, -1.87768910e-02, -1.18746138e-02, -4.66909925e-03,
     2.84409675e-03,  1.06697612e-02,  1.88135595e-02,  2.72815601e-02,
     3.60781047e-02,  4.52070276e-02,  5.46723880e-02,  6.44786605e-02,
     7.46286220e-02,  8.51249057e-02,  9.59698399e-02,  1.07165078e-01,
     1.18711585e-01,  1.30610107e-01,  1.42859645e-01,  1.55458473e-01,
     1.68404161e-01,  1.81694789e-01,  1.95327388e-01,  2.09296321e-01,
     2.23594564e-01,  2.38216022e-01,  2.53152972e-01,  2.68396157e-01,
     2.83936139e-01,  2.99762426e-01,  3.15861908e-01,  3.32221055e-01,
     3.48826468e-01,  3.65664038e-01,  3.82715297e-01,  3.99961186e-01,
     4.17384327e-01,  4.34966962e-01,  4.52687640e-01,  4.70524201e-01,
     4.88453925e-01,  5.06454555e-01,  5.24500675e-01,  5.42567437e-01,
     5.60631204e-01,  5.78667265e-01,  5.96647704e-01,  6.14545890e-01,
     6.32336194e-01,  6.49992632e-01,  6.67487403e-01,  6.84793267e-01,
     7.01883546e-01,  7.18732254e-01,  7.35312821e-01,  7.51600199e-01,
     7.67569925e-01,  7.83197457e-01,  7.98458386e-01,  8.13329535e-01,
     8.27789227e-01,  8.41817856e-01,  8.55396130e-01,  8.68506898e-01,
     8.81133444e-01,  8.93259678e-01,  9.04874884e-01,  9.15965761e-01,
     9.26521530e-01,  9.36533999e-01,  9.45997703e-01,  9.54908841e-01,
     9.63265812e-01,  9.71068890e-01,  9.78320416e-01,  9.85022676e-01,
     9.91179208e-01,  9.96798994e-01,  1.00189402e+00,  1.00647434e+00,
     1.01055206e+00,  1.01414254e+00,  1.01726259e+00,  1.01992884e+00,
     1.02215987e+00,  1.02397632e+00,  1.02540073e+00,  1.02645534e+00,
     1.02716451e+00,  1.02755273e+00,  1.02764446e+00,  1.02746325e+00,
     1.02703590e+00,  1.02638907e+00,  1.02554820e+00,  1.02453713e+00,
     1.02338080e+00,  1.02210370e+00,  1.02072836e+00,  1.01927533e+00,
     1.01776518e+00,  1.01621736e+00,  1.01466531e+00,  1.01324907e+00,
     1.01194801e+00,  1.01018909e+00,  1.00855796e+00,  1.00701129e+00,
     1.00554876e+00,  1.00416842e+00,  1.00286727e+00,  1.00164177e+00,
     1.00048907e+00,  9.99406080e-01,  9.98389887e-01,  9.97437085e-01,
     9.96544484e-01,  9.95709855e-01,  9.94930241e-01,  9.94202405e-01,
     9.93524160e-01,  9.92893043e-01,  9.92306810e-01,  9.91763378e-01,
     9.91259764e-01,  9.90795450e-01,  9.90367789e-01,  9.89975161e-01,
     9.89616034e-01,  9.89289016e-01,  9.88992851e-01,  9.88726033e-01,
     9.88486872e-01,  9.88275104e-01,  9.88089217e-01,  9.87927711e-01,
     9.87789826e-01,  9.87674344e-01,  9.87580750e-01,  9.87507202e-01,
     9.87452945e-01,  9.87416974e-01,  9.87398469e-01,  9.87395830e-01,
     9.87408003e-01,  9.87434340e-01,  9.87473624e-01,  9.87524314e-01,
     9.87585620e-01,  9.87656379e-01,  9.87735892e-01,  9.87822558e-01,
     9.87915097e-01,  9.88013273e-01,  9.88115695e-01,  9.88221131e-01,
     9.88328903e-01,  9.88437831e-01,  9.88547679e-01,  9.88656841e-01,
     9.88764587e-01,  9.88870854e-01,  9.88974432e-01,  9.89074727e-01,
     9.89171004e-01,  9.89263102e-01,  9.89350722e-01,  9.89433065e-01,
     9.89509692e-01,  9.89581081e-01,  9.89646747e-01,  9.89706737e-01,
     9.89760693e-01,  9.89809448e-01,  9.89853013e-01,  9.89891471e-01,
     9.89925419e-01,  9.89955420e-01,  9.89982449e-01,  9.90006512e-01,
     9.90028481e-01,  9.90049748e-01,  9.90070956e-01,  9.90092836e-01,
     9.90116392e-01,  9.90142748e-01,  9.90173428e-01,  9.90208733e-01,
     9.90249864e-01,  9.90298369e-01,  9.90354850e-01,  9.90420508e-01,
     9.90495930e-01,  9.90582515e-01,  9.90681257e-01,  9.90792209e-01,
     9.90916546e-01,  9.91055074e-01,  9.91208461e-01,  9.91376861e-01,
     9.91560583e-01,  9.91760421e-01,  9.91976718e-01,  9.92209110e-01,
     9.92457914e-01,  9.92723123e-01,  9.93004954e-01,  9.93302728e-01,
     9.93616108e-01,  9.93945371e-01,  9.94289515e-01,  9.94648168e-01,
     9.95020303e-01,  9.95405817e-01,  9.95803871e-01,  9.96213027e-01,
     9.96632469e-01,  9.97061531e-01,  9.97499058e-01,  9.97943743e-01,
     9.98394057e-01,  9.98849312e-01,  9.99308343e-01,  9.99768922e-01,
     1.00023113e+00,  1.00069214e+00,  1.00115201e+00,  1.00160853e+00,
     1.00206049e+00,  1.00250721e+00,  1.00294713e+00,  1.00337891e+00,
     1.00380137e+00,  1.00421381e+00,  1.00461539e+00,  1.00500462e+00,
     1.00538063e+00,  1.00574328e+00,  1.00609151e+00,  1.00642491e+00,
     1.00674243e+00,  1.00704432e+00,  1.00733022e+00,  1.00759940e+00,
     1.00785206e+00,  1.00808818e+00,  1.00830803e+00,  1.00851125e+00,
     1.00869814e+00,  1.00886952e+00,  1.00902566e+00,  1.00916672e+00,
     1.00929336e+00,  1.00940640e+00,  1.00950702e+00,  1.00959526e+00,
     1.00967215e+00,  1.00973908e+00,  1.00979668e+00,  1.00984614e+00,
     1.00988808e+00,  1.00992409e+00,  1.00995538e+00,  1.00998227e+00,
     1.01000630e+00,  1.01002862e+00,  1.01005025e+00,  1.01007195e+00,
     1.01009437e+00,  1.01011892e+00,  1.01014650e+00,  1.01017711e+00,
     1.01021176e+00,  1.01025100e+00,  1.01029547e+00,  1.01034523e+00,
     1.01040032e+00,  1.01046156e+00,  1.01052862e+00,  1.01060152e+00,
     1.01067979e+00,  1.01076391e+00,  1.01085343e+00,  1.01094755e+00,
     1.01104595e+00,  1.01114849e+00,  1.01125440e+00,  1.01136308e+00,
     1.01147330e+00,  1.01158500e+00,  1.01169742e+00,  1.01180892e+00,
     1.01191926e+00,  1.01202724e+00,  1.01213215e+00,  1.01223273e+00,
     1.01232756e+00,  1.01241638e+00,  1.01249789e+00,  1.01257043e+00,
     1.01263330e+00,  1.01268528e+00,  1.01272556e+00,  1.01275258e+00,
     1.01276506e+00,  1.01276236e+00,  1.01274338e+00,  1.01270648e+00,
     1.01265084e+00,  1.01257543e+00,  1.01247947e+00,  1.01236111e+00,
     1.01221981e+00,  1.01205436e+00,  1.01186400e+00,  1.01164722e+00,
     1.01140252e+00,  1.01112965e+00,  1.01082695e+00,  1.01049292e+00,
     1.01012635e+00,  1.00972589e+00,  1.00929006e+00,  1.00881730e+00,
     1.00830503e+00,  1.00775283e+00,  1.00715783e+00,  1.00651805e+00,
     1.00583140e+00,  1.00509559e+00,  1.00430863e+00,  1.00346750e+00,
     1.00256950e+00,  1.00161271e+00,  1.00059427e+00,  9.99511170e-01,
     9.98360922e-01,  9.97140929e-01,  9.95848886e-01,  9.94481854e-01,
     9.93037528e-01,  9.91514656e-01,  9.89913680e-01,  9.88193062e-01,
     9.85942259e-01,  9.83566790e-01,  9.81142303e-01,  9.78521444e-01,
     9.75663604e-01,  9.72545344e-01,  9.69145663e-01,  9.65440618e-01,
     9.61404362e-01,  9.57011307e-01,  9.52236767e-01,  9.47054884e-01,
     9.41440374e-01,  9.35369161e-01,  9.28819009e-01,  9.21766289e-01,
     9.14189628e-01,  9.06069468e-01,  8.97389168e-01,  8.88133200e-01,
     8.78289389e-01,  8.67846957e-01,  8.56797064e-01,  8.45133465e-01,
     8.32854281e-01,  8.19959478e-01,  8.06451101e-01,  7.92334648e-01,
     7.77620449e-01,  7.62320618e-01,  7.46448649e-01,  7.30020573e-01,
     7.13056738e-01,  6.95580544e-01,  6.77617323e-01,  6.59195531e-01,
     6.40348643e-01,  6.21107220e-01,  6.01504928e-01,  5.81578761e-01,
     5.61367451e-01,  5.40918863e-01,  5.20273683e-01,  4.99478073e-01,
     4.78577418e-01,  4.57617260e-01,  4.36649021e-01,  4.15722146e-01,
     3.94885659e-01,  3.74190319e-01,  3.53686890e-01,  3.33426002e-01,
     3.13458647e-01,  2.93833790e-01,  2.74599264e-01,  2.55803064e-01,
     2.37490219e-01,  2.19703603e-01,  2.02485542e-01,  1.85874992e-01,
     1.69906780e-01,  1.54613227e-01,  1.40023821e-01,  1.26163740e-01,
     1.13053443e-01,  1.00708497e-01,  8.91402439e-02,  7.83561210e-02,
     6.83582123e-02,  5.91421154e-02,  5.06989301e-02,  4.30171776e-02,
     3.60802073e-02,  2.98631634e-02,  2.43372266e-02,  1.94767524e-02,
     1.52571017e-02,  1.16378749e-02,  8.43308778e-03,  4.44966900e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_48K = np.array([
    -2.35303215e-04, -4.61989875e-04, -6.26293154e-04, -7.92918043e-04,
    -9.74716672e-04, -1.18025689e-03, -1.40920904e-03, -1.66447310e-03,
    -1.94659161e-03, -2.25708173e-03, -2.59710692e-03, -2.96760762e-03,
    -3.37045488e-03, -3.80628516e-03, -4.27687377e-03, -4.78246990e-03,
    -5.32460872e-03, -5.90340381e-03, -6.52041973e-03, -7.17588528e-03,
    -7.87142282e-03, -8.60658604e-03, -9.38248086e-03, -1.01982718e-02,
    -1.10552055e-02, -1.19527030e-02, -1.28920591e-02, -1.38726348e-02,
    -1.48952816e-02, -1.59585662e-02, -1.70628856e-02, -1.82066640e-02,
    -1.93906598e-02, -2.06135542e-02, -2.18757093e-02, -2.31752632e-02,
    -2.45122745e-02, -2.58847194e-02, -2.72926374e-02, -2.87339090e-02,
    -3.02086274e-02, -3.17144037e-02, -3.32509886e-02, -3.48159779e-02,
    -3.64089241e-02, -3.80274232e-02, -3.96706799e-02, -4.13357542e-02,
    -4.30220337e-02, -4.47269805e-02, -4.64502229e-02, -4.81889149e-02,
    -4.99422586e-02, -5.17069080e-02, -5.34816204e-02, -5.52633479e-02,
    -5.70512315e-02, -5.88427175e-02, -6.06371724e-02, -6.24310403e-02,
    -6.42230355e-02, -6.60096152e-02, -6.77896227e-02, -6.95599687e-02,
    -7.13196627e-02, -7.30658127e-02, -7.47975891e-02, -7.65117823e-02,
    -7.82071142e-02, -7.98801069e-02, -8.15296401e-02, -8.31523735e-02,
    -8.47472895e-02, -8.63113754e-02, -8.78437445e-02, -8.93416436e-02,
    -9.08041129e-02, -9.22279576e-02, -9.36123287e-02, -9.49537776e-02,
    -9.62515531e-02, -9.75028462e-02, -9.87073651e-02, -9.98627129e-02,
    -1.00968022e-01, -1.02020268e-01, -1.03018380e-01, -1.03959636e-01,
    -1.04843883e-01, -1.05668684e-01, -1.06434282e-01, -1.07138231e-01,
    -1.07779996e-01, -1.08357063e-01, -1.08869014e-01, -1.09313559e-01,
    -1.09690356e-01, -1.09996966e-01, -1.10233226e-01, -1.10397281e-01,
    -1.10489847e-01, -1.10508642e-01, -1.10453743e-01, -1.10322584e-01,
    -1.10114583e-01, -1.09827693e-01, -1.09462175e-01, -1.09016396e-01,
    -1.08490885e-01, -1.07883429e-01, -1.07193718e-01, -1.06419636e-01,
    -1.05561251e-01, -1.04616281e-01, -1.03584904e-01, -1.02465016e-01,
    -1.01256900e-01, -9.99586457e-02, -9.85701457e-02, -9.70891114e-02,
    -9.55154582e-02, -9.38468492e-02, -9.20830006e-02, -9.02217102e-02,
    -8.82630999e-02, -8.62049382e-02, -8.40474215e-02, -8.17879272e-02,
    -7.94262503e-02, -7.69598078e-02, -7.43878560e-02, -7.17079700e-02,
    -6.89199478e-02, -6.60218980e-02, -6.30134942e-02, -5.98919191e-02,
    -5.66565564e-02, -5.33040616e-02, -4.98342724e-02, -4.62445689e-02,
    -4.25345569e-02, -3.87019577e-02, -3.47458578e-02, -3.06634152e-02,
    -2.64542508e-02, -2.21158161e-02, -1.76474054e-02, -1.30458136e-02,
    -8.31042570e-03, -3.43826866e-03,  1.57031548e-03,  6.71769764e-03,
     1.20047702e-02,  1.74339832e-02,  2.30064206e-02,  2.87248142e-02,
     3.45889635e-02,  4.06010646e-02,  4.67610292e-02,  5.30713391e-02,
     5.95323909e-02,  6.61464781e-02,  7.29129318e-02,  7.98335419e-02,
     8.69080741e-02,  9.41381377e-02,  1.01523314e-01,  1.09065152e-01,
     1.16762655e-01,  1.24617139e-01,  1.32627295e-01,  1.40793819e-01,
     1.49115252e-01,  1.57592141e-01,  1.66222480e-01,  1.75006740e-01,
     1.83943194e-01,  1.93031818e-01,  2.02269985e-01,  2.11656743e-01,
     2.21188852e-01,  2.30865538e-01,  2.40683799e-01,  2.50642064e-01,
     2.60736512e-01,  2.70965907e-01,  2.81325902e-01,  2.91814469e-01,
     3.02427028e-01,  3.13160350e-01,  3.24009570e-01,  3.34971959e-01,
     3.46042294e-01,  3.57217518e-01,  3.68491565e-01,  3.79859512e-01,
     3.91314689e-01,  4.02853287e-01,  4.14468833e-01,  4.26157164e-01,
     4.37911390e-01,  4.49725632e-01,  4.61592545e-01,  4.73506703e-01,
     4.85460018e-01,  4.97447159e-01,  5.09459723e-01,  5.21490984e-01,
     5.33532682e-01,  5.45578981e-01,  5.57621716e-01,  5.69654673e-01,
     5.81668558e-01,  5.93656062e-01,  6.05608382e-01,  6.17519206e-01,
     6.29379661e-01,  6.41183084e-01,  6.52920354e-01,  6.64584079e-01,
     6.76165350e-01,  6.87657395e-01,  6.99051154e-01,  7.10340055e-01,
     7.21514933e-01,  7.32569177e-01,  7.43494372e-01,  7.54284633e-01,
     7.64931365e-01,  7.75428189e-01,  7.85767017e-01,  7.95941465e-01,
     8.05943723e-01,  8.15768707e-01,  8.25408622e-01,  8.34858937e-01,
     8.44112583e-01,  8.53165119e-01,  8.62010834e-01,  8.70645634e-01,
     8.79063156e-01,  8.87259971e-01,  8.95231329e-01,  9.02975168e-01,
     9.10486312e-01,  9.17762555e-01,  9.24799743e-01,  9.31596250e-01,
     9.38149486e-01,  9.44458839e-01,  9.50522086e-01,  9.56340292e-01,
     9.61911452e-01,  9.67236671e-01,  9.72315664e-01,  9.77150119e-01,
     9.81739750e-01,  9.86086587e-01,  9.90190638e-01,  9.94055718e-01,
     9.97684240e-01,  1.00108096e+00,  1.00424751e+00,  1.00718858e+00,
     1.00990665e+00,  1.01240743e+00,  1.01469470e+00,  1.01677466e+00,
     1.01865099e+00,  1.02033046e+00,  1.02181733e+00,  1.02311884e+00,
     1.02424026e+00,  1.02518972e+00,  1.02597245e+00,  1.02659694e+00,
     1.02706918e+00,  1.02739752e+00,  1.02758790e+00,  1.02764895e+00,
     1.02758583e+00,  1.02740852e+00,  1.02712299e+00,  1.02673867e+00,
     1.02626166e+00,  1.02570100e+00,  1.02506178e+00,  1.02435398e+00,
     1.02358239e+00,  1.02275651e+00,  1.02188060e+00,  1.02096387e+00,
     1.02000914e+00,  1.01902729e+00,  1.01801944e+00,  1.01699650e+00,
     1.01595743e+00,  1.01492344e+00,  1.01391595e+00,  1.01304757e+00,
     1.01221613e+00,  1.01104487e+00,  1.00991459e+00,  1.00882489e+00,
     1.00777386e+00,  1.00676170e+00,  1.00578665e+00,  1.00484875e+00,
     1.00394608e+00,  1.00307885e+00,  1.00224501e+00,  1.00144473e+00,
     1.00067619e+00,  9.99939317e-01,  9.99232085e-01,  9.98554813e-01,
     9.97905542e-01,  9.97284268e-01,  9.96689095e-01,  9.96120338e-01,
     9.95576126e-01,  9.95056572e-01,  9.94559753e-01,  9.94086038e-01,
     9.93633779e-01,  9.93203161e-01,  9.92792187e-01,  9.92401518e-01,
     9.92029727e-01,  9.91676778e-01,  9.91340877e-01,  9.91023065e-01,
     9.90721643e-01,  9.90436680e-01,  9.90166895e-01,  9.89913101e-01,
     9.89673564e-01,  9.89448837e-01,  9.89237484e-01,  9.89040193e-01,
     9.88855636e-01,  9.88684347e-01,  9.88524761e-01,  9.88377852e-01,
     9.88242327e-01,  9.88118564e-01,  9.88005163e-01,  9.87903202e-01,
     9.87811174e-01,  9.87729546e-01,  9.87657198e-01,  9.87594984e-01,
     9.87541274e-01,  9.87496906e-01,  9.87460625e-01,  9.87432981e-01,
     9.87412641e-01,  9.87400475e-01,  9.87394992e-01,  9.87396916e-01,
     9.87404906e-01,  9.87419705e-01,  9.87439972e-01,  9.87466328e-01,
     9.87497321e-01,  9.87533893e-01,  9.87574654e-01,  9.87620124e-01,
     9.87668980e-01,  9.87722156e-01,  9.87778192e-01,  9.87837649e-01,
     9.87899199e-01,  9.87963798e-01,  9.88030030e-01,  9.88098468e-01,
     9.88167801e-01,  9.88239030e-01,  9.88310769e-01,  9.88383520e-01,
     9.88456016e-01,  9.88529420e-01,  9.88602222e-01,  9.88674940e-01,
     9.88746626e-01,  9.88818277e-01,  9.88888248e-01,  9.88957438e-01,
     9.89024798e-01,  9.89091125e-01,  9.89155170e-01,  9.89217866e-01,
     9.89277956e-01,  9.89336519e-01,  9.89392368e-01,  9.89446283e-01,
     9.89497212e-01,  9.89546334e-01,  9.89592362e-01,  9.89636265e-01,
     9.89677201e-01,  9.89716220e-01,  9.89752029e-01,  9.89785920e-01,
     9.89817027e-01,  9.89846207e-01,  9.89872536e-01,  9.89897514e-01,
     9.89920005e-01,  9.89941079e-01,  9.89960061e-01,  9.89978226e-01,
     9.89994556e-01,  9.90010350e-01,  9.90024832e-01,  9.90039402e-01,
     9.90053211e-01,  9.90067475e-01,  9.90081472e-01,  9.90096693e-01,
     9.90112245e-01,  9.90129379e-01,  9.90147465e-01,  9.90168060e-01,
     9.90190227e-01,  9.90215190e-01,  9.90242442e-01,  9.90273445e-01,
     9.90307127e-01,  9.90344891e-01,  9.90386228e-01,  9.90432448e-01,
     9.90482565e-01,  9.90537983e-01,  9.90598060e-01,  9.90664037e-01,
     9.90734883e-01,  9.90812038e-01,  9.90894786e-01,  9.90984259e-01,
     9.91079525e-01,  9.91181924e-01,  9.91290512e-01,  9.91406471e-01,
     9.91528801e-01,  9.91658694e-01,  9.91795272e-01,  9.91939622e-01,
     9.92090615e-01,  9.92249503e-01,  9.92415240e-01,  9.92588721e-01,
     9.92768871e-01,  9.92956911e-01,  9.93151653e-01,  9.93353924e-01,
     9.93562689e-01,  9.93779087e-01,  9.94001643e-01,  9.94231202e-01,
     9.94466818e-01,  9.94709344e-01,  9.94957285e-01,  9.95211663e-01,
     9.95471264e-01,  9.95736795e-01,  9.96006862e-01,  9.96282303e-01,
     9.96561799e-01,  9.96846133e-01,  9.97133827e-01,  9.97425669e-01,
     9.97720337e-01,  9.98018509e-01,  9.98318587e-01,  9.98621352e-01,
     9.98925543e-01,  9.99231731e-01,  9.99538258e-01,  9.99846116e-01,
     1.00015391e+00,  1.00046196e+00,  1.00076886e+00,  1.00107561e+00,
     1.00138055e+00,  1.00168424e+00,  1.00198543e+00,  1.00228487e+00,
     1.00258098e+00,  1.00287441e+00,  1.00316385e+00,  1.00345006e+00,
     1.00373157e+00,  1.00400915e+00,  1.00428146e+00,  1.00454934e+00,
     1.00481138e+00,  1.00506827e+00,  1.00531880e+00,  1.00556397e+00,
     1.00580227e+00,  1.00603455e+00,  1.00625986e+00,  1.00647902e+00,
     1.00669054e+00,  1.00689557e+00,  1.00709305e+00,  1.00728380e+00,
     1.00746662e+00,  1.00764273e+00,  1.00781104e+00,  1.00797244e+00,
     1.00812588e+00,  1.00827260e+00,  1.00841147e+00,  1.00854357e+00,
     1.00866802e+00,  1.00878601e+00,  1.00889653e+00,  1.00900077e+00,
     1.00909776e+00,  1.00918888e+00,  1.00927316e+00,  1.00935176e+00,
     1.00942394e+00,  1.00949118e+00,  1.00955240e+00,  1.00960889e+00,
     1.00965997e+00,  1.00970709e+00,  1.00974924e+00,  1.00978774e+00,
     1.00982209e+00,  1.00985371e+00,  1.00988150e+00,  1.00990696e+00,
     1.00992957e+00,  1.00995057e+00,  1.00996902e+00,  1.00998650e+00,
     1.01000236e+00,  1.01001789e+00,  1.01003217e+00,  1.01004672e+00,
     1.01006081e+00,  1.01007567e+00,  1.01009045e+00,  1.01010656e+00,
     1.01012323e+00,  1.01014176e+00,  1.01016113e+00,  1.01018264e+00,
     1.01020559e+00,  1.01023108e+00,  1.01025795e+00,  1.01028773e+00,
     1.01031948e+00,  1.01035408e+00,  1.01039064e+00,  1.01043047e+00,
     1.01047227e+00,  1.01051710e+00,  1.01056410e+00,  1.01061427e+00,
     1.01066629e+00,  1.01072136e+00,  1.01077842e+00,  1.01083825e+00,
     1.01089966e+00,  1.01096373e+00,  1.01102919e+00,  1.01109699e+00,
     1.01116586e+00,  1.01123661e+00,  1.01130817e+00,  1.01138145e+00,
     1.01145479e+00,  1.01152919e+00,  1.01160368e+00,  1.01167880e+00,
     1.01175301e+00,  1.01182748e+00,  1.01190094e+00,  1.01197388e+00,
     1.01204489e+00,  1.01211499e+00,  1.01218284e+00,  1.01224902e+00,
     1.01231210e+00,  1.01237303e+00,  1.01243046e+00,  1.01248497e+00,
     1.01253506e+00,  1.01258168e+00,  1.01262347e+00,  1.01266098e+00,
     1.01269276e+00,  1.01271979e+00,  1.01274058e+00,  1.01275575e+00,
     1.01276395e+00,  1.01276592e+00,  1.01276030e+00,  1.01274782e+00,
     1.01272696e+00,  1.01269861e+00,  1.01266140e+00,  1.01261590e+00,
     1.01256083e+00,  1.01249705e+00,  1.01242289e+00,  1.01233923e+00,
     1.01224492e+00,  1.01214046e+00,  1.01202430e+00,  1.01189756e+00,
     1.01175881e+00,  1.01160845e+00,  1.01144516e+00,  1.01126996e+00,
     1.01108126e+00,  1.01087961e+00,  1.01066368e+00,  1.01043418e+00,
     1.01018968e+00,  1.00993075e+00,  1.00965566e+00,  1.00936525e+00,
     1.00905825e+00,  1.00873476e+00,  1.00839308e+00,  1.00803431e+00,
     1.00765666e+00,  1.00726014e+00,  1.00684335e+00,  1.00640701e+00,
     1.00594915e+00,  1.00547001e+00,  1.00496799e+00,  1.00444353e+00,
     1.00389477e+00,  1.00332190e+00,  1.00272313e+00,  1.00209885e+00,
     1.00144728e+00,  1.00076851e+00,  1.00006069e+00,  9.99324268e-01,
     9.98557350e-01,  9.97760020e-01,  9.96930604e-01,  9.96069427e-01,
     9.95174643e-01,  9.94246644e-01,  9.93283713e-01,  9.92286108e-01,
     9.91252309e-01,  9.90182742e-01,  9.89075787e-01,  9.87931302e-01,
     9.86355322e-01,  9.84736245e-01,  9.83175095e-01,  9.81558334e-01,
     9.79861353e-01,  9.78061749e-01,  9.76157432e-01,  9.74137862e-01,
     9.71999011e-01,  9.69732741e-01,  9.67333198e-01,  9.64791512e-01,
     9.62101150e-01,  9.59253976e-01,  9.56242718e-01,  9.53060091e-01,
     9.49698408e-01,  9.46149812e-01,  9.42407161e-01,  9.38463416e-01,
     9.34311297e-01,  9.29944987e-01,  9.25356797e-01,  9.20540463e-01,
     9.15489628e-01,  9.10198679e-01,  9.04662060e-01,  8.98875519e-01,
     8.92833832e-01,  8.86533719e-01,  8.79971272e-01,  8.73143784e-01,
     8.66047653e-01,  8.58681252e-01,  8.51042044e-01,  8.43129723e-01,
     8.34943514e-01,  8.26483991e-01,  8.17750537e-01,  8.08744982e-01,
     7.99468149e-01,  7.89923516e-01,  7.80113773e-01,  7.70043128e-01,
     7.59714574e-01,  7.49133097e-01,  7.38302860e-01,  7.27229876e-01,
     7.15920192e-01,  7.04381434e-01,  6.92619693e-01,  6.80643883e-01,
     6.68461648e-01,  6.56083014e-01,  6.43517927e-01,  6.30775533e-01,
     6.17864165e-01,  6.04795463e-01,  5.91579959e-01,  5.78228937e-01,
     5.64753589e-01,  5.51170316e-01,  5.37490509e-01,  5.23726350e-01,
     5.09891542e-01,  4.96000807e-01,  4.82066294e-01,  4.68101711e-01,
     4.54121700e-01,  4.40142182e-01,  4.26177297e-01,  4.12241789e-01,
     3.98349961e-01,  3.84517234e-01,  3.70758372e-01,  3.57088679e-01,
     3.43522867e-01,  3.30076376e-01,  3.16764033e-01,  3.03600465e-01,
     2.90599616e-01,  2.77775850e-01,  2.65143468e-01,  2.52716188e-01,
     2.40506985e-01,  2.28528397e-01,  2.16793343e-01,  2.05313990e-01,
     1.94102191e-01,  1.83168087e-01,  1.72522195e-01,  1.62173542e-01,
     1.52132068e-01,  1.42405280e-01,  1.33001524e-01,  1.23926066e-01,
     1.15185830e-01,  1.06784043e-01,  9.87263751e-02,  9.10137900e-02,
     8.36505724e-02,  7.66350831e-02,  6.99703341e-02,  6.36518811e-02,
     5.76817602e-02,  5.20524422e-02,  4.67653841e-02,  4.18095054e-02,
     3.71864025e-02,  3.28807275e-02,  2.88954850e-02,  2.52098057e-02,
     2.18305756e-02,  1.87289619e-02,  1.59212782e-02,  1.33638143e-02,
     1.10855888e-02,  8.94347419e-03,  6.75812489e-03,  3.50443813e-03,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_48K_HR = np.array([
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     9.42341174e-08,  6.19838374e-07,  1.82603810e-06,  4.22741550e-06,
     8.56822135e-06,  1.59013834e-05,  2.76738483e-05,  4.58246141e-05,
     7.28956657e-05,  1.12155336e-04,  1.67733029e-04,  2.44763592e-04,
     3.49539070e-04,  4.89664846e-04,  6.74216484e-04,  9.13893222e-04,
     1.22116262e-03,  1.61039189e-03,  2.09795963e-03,  2.70234118e-03,
     3.44416290e-03,  4.34621749e-03,  5.43343695e-03,  6.73281262e-03,
     8.27326626e-03,  1.00854570e-02,  1.22015327e-02,  1.46548180e-02,
     1.74794346e-02,  2.07098722e-02,  2.43804958e-02,  2.85249949e-02,
     3.31758074e-02,  3.83635014e-02,  4.41161096e-02,  5.04585020e-02,
     5.74117042e-02,  6.49922863e-02,  7.32117295e-02,  8.20759088e-02,
     9.15845558e-02,  1.01730898e-01,  1.12501279e-01,  1.23875007e-01,
     1.35824218e-01,  1.48313895e-01,  1.61302090e-01,  1.74740151e-01,
     1.88573152e-01,  2.02740535e-01,  2.17176691e-01,  2.31811777e-01,
     2.46572644e-01,  2.61383832e-01,  2.76168495e-01,  2.90849626e-01,
     3.05351138e-01,  3.19598824e-01,  3.33521664e-01,  3.47052664e-01,
     3.60129982e-01,  3.72697920e-01,  3.84707332e-01,  3.96116525e-01,
     4.06891733e-01,  4.17007536e-01,  4.26446915e-01,  4.35201406e-01,
     4.43271041e-01,  4.50664014e-01,  4.57396388e-01,  4.63491529e-01,
     4.68979478e-01,  4.73896384e-01,  4.78283674e-01,  4.82187212e-01,
     4.85656589e-01,  4.88744229e-01,  4.91504699e-01,  4.93993789e-01,
     4.96267974e-01,  4.98383760e-01,  5.00396967e-01,  5.02362430e-01,
     5.04333496e-01,  5.06361604e-01,  5.08496106e-01,  5.10783911e-01,
     5.13269365e-01,  5.15994072e-01,  5.18996596e-01,  5.22312462e-01,
     5.25973916e-01,  5.30009925e-01,  5.34445822e-01,  5.39303243e-01,
     5.44600070e-01,  5.50350249e-01,  5.56563497e-01,  5.63245535e-01,
     5.70397854e-01,  5.78017771e-01,  5.86098313e-01,  5.94628513e-01,
     6.03593290e-01,  6.12973869e-01,  6.22747838e-01,  6.32889450e-01,
     6.43370092e-01,  6.54158235e-01,  6.65220201e-01,  6.76520288e-01,
     6.88021243e-01,  6.99684739e-01,  7.11471498e-01,  7.23342001e-01,
     7.35256732e-01,  7.47176409e-01,  7.59062469e-01,  7.70877421e-01,
     7.82584906e-01,  7.94150114e-01,  8.05540025e-01,  8.16723466e-01,
     8.27671409e-01,  8.38356972e-01,  8.48755658e-01,  8.58845115e-01,
     8.68605733e-01,  8.78019989e-01,  8.87072980e-01,  8.95752132e-01,
     9.04047191e-01,  9.11950290e-01,  9.19455826e-01,  9.26560223e-01,
     9.33262229e-01,  9.39562619e-01,  9.45464134e-01,  9.50971425e-01,
     9.56090987e-01,  9.60831106e-01,  9.65201676e-01,  9.69214201e-01,
     9.72881556e-01,  9.76217866e-01,  9.79238510e-01,  9.81959701e-01,
     9.84398544e-01,  9.86572623e-01,  9.88499999e-01,  9.90198970e-01,
     9.91687655e-01,  9.92984235e-01,  9.94106293e-01,  9.95071113e-01,
     9.95895147e-01,  9.96594131e-01,  9.97182965e-01,  9.97675478e-01,
     9.98084545e-01,  9.98421967e-01,  9.98698533e-01,  9.98923838e-01,
     9.99106586e-01,  9.99254227e-01,  9.99373496e-01,  9.99470055e-01,
     9.99548733e-01,  9.99613643e-01,  9.99668002e-01,  9.99714673e-01,
     9.99755740e-01,  9.99792874e-01,  9.99827385e-01,  9.99860168e-01,
     9.99891937e-01,  9.99923110e-01,  9.99953985e-01,  9.99984682e-01,
     1.00001526e+00,  1.00004578e+00,  1.00007617e+00,  1.00010622e+00,
     1.00013602e+00,  1.00016546e+00,  1.00019431e+00,  1.00022256e+00,
     1.00025010e+00,  1.00027692e+00,  1.00030291e+00,  1.00032794e+00,
     1.00035203e+00,  1.00037491e+00,  1.00039685e+00,  1.00041747e+00,
     1.00043690e+00,  1.00045502e+00,  1.00047183e+00,  1.00048721e+00,
     1.00050116e+00,  1.00051367e+00,  1.00052476e+00,  1.00053418e+00,
     1.00054228e+00,  1.00054872e+00,  1.00055361e+00,  1.00055695e+00,
     1.00055885e+00,  1.00055909e+00,  1.00055790e+00,  1.00055504e+00,
     1.00055087e+00,  1.00054502e+00,  1.00053787e+00,  1.00052929e+00,
     1.00051928e+00,  1.00050783e+00,  1.00049520e+00,  1.00048113e+00,
     1.00046599e+00,  1.00044954e+00,  1.00043201e+00,  1.00041330e+00,
     1.00039363e+00,  1.00037301e+00,  1.00035143e+00,  1.00032890e+00,
     1.00030565e+00,  1.00028157e+00,  1.00025690e+00,  1.00023150e+00,
     1.00020564e+00,  1.00017929e+00,  1.00015235e+00,  1.00012517e+00,
     1.00009763e+00,  1.00006998e+00,  1.00004208e+00,  1.00001407e+00,
     9.99985993e-01,  9.99957979e-01,  9.99930084e-01,  9.99902308e-01,
     9.99874830e-01,  9.99847591e-01,  9.99820769e-01,  9.99794364e-01,
     9.99768496e-01,  9.99743164e-01,  9.99718428e-01,  9.99694467e-01,
     9.99671161e-01,  9.99648750e-01,  9.99627173e-01,  9.99606490e-01,
     9.99586821e-01,  9.99568224e-01,  9.99550641e-01,  9.99534249e-01,
     9.99519050e-01,  9.99505103e-01,  9.99492407e-01,  9.99481022e-01,
     9.99471009e-01,  9.99462426e-01,  9.99455214e-01,  9.99449492e-01,
     9.99445200e-01,  9.99442458e-01,  9.99441206e-01,  9.99441504e-01,
     9.99443293e-01,  9.99446690e-01,  9.99451578e-01,  9.99458075e-01,
     9.99466062e-01,  9.99475598e-01,  9.99486566e-01,  9.99499083e-01,
     9.99513030e-01,  9.99528408e-01,  9.99545157e-01,  9.99563277e-01,
     9.99582708e-01,  9.99603331e-01,  9.99625206e-01,  9.99648154e-01,
     9.99672174e-01,  9.99697208e-01,  9.99723136e-01,  9.99749959e-01,
     9.99777496e-01,  9.99805748e-01,  9.99834597e-01,  9.99863982e-01,
     9.99893785e-01,  9.99923885e-01,  9.99954224e-01,  9.99984741e-01,
     1.00001526e+00,  1.00004578e+00,  1.00007617e+00,  1.00010622e+00,
     1.00013602e+00,  1.00016546e+00,  1.00019431e+00,  1.00022256e+00,
     1.00025010e+00,  1.00027692e+00,  1.00030291e+00,  1.00032794e+00,
     1.00035203e+00,  1.00037491e+00,  1.00039685e+00,  1.00041747e+00,
     1.00043690e+00,  1.00045502e+00,  1.00047183e+00,  1.00048721e+00,
     1.00050116e+00,  1.00051367e+00,  1.00052476e+00,  1.00053418e+00,
     1.00054228e+00,  1.00054872e+00,  1.00055361e+00,  1.00055695e+00,
     1.00055885e+00,  1.00055909e+00,  1.00055790e+00,  1.00055504e+00,
     1.00055087e+00,  1.00054502e+00,  1.00053787e+00,  1.00052929e+00,
     1.00051928e+00,  1.00050783e+00,  1.00049520e+00,  1.00048113e+00,
     1.00046599e+00,  1.00044954e+00,  1.00043201e+00,  1.00041330e+00,
     1.00039363e+00,  1.00037301e+00,  1.00035143e+00,  1.00032890e+00,
     1.00030565e+00,  1.00028157e+00,  1.00025690e+00,  1.00023150e+00,
     1.00020564e+00,  1.00017929e+00,  1.00015235e+00,  1.00012517e+00,
     1.00009763e+00,  1.00006998e+00,  1.00004208e+00,  1.00001407e+00,
     9.99985993e-01,  9.99957979e-01,  9.99930084e-01,  9.99902308e-01,
     9.99874830e-01,  9.99847591e-01,  9.99820769e-01,  9.99794364e-01,
     9.99768496e-01,  9.99743164e-01,  9.99718428e-01,  9.99694467e-01,
     9.99671161e-01,  9.99648750e-01,  9.99627173e-01,  9.99606490e-01,
     9.99586821e-01,  9.99568224e-01,  9.99550641e-01,  9.99534249e-01,
     9.99519050e-01,  9.99505103e-01,  9.99492407e-01,  9.99481022e-01,
     9.99471009e-01,  9.99462426e-01,  9.99455214e-01,  9.99449492e-01,
     9.99445200e-01,  9.99442458e-01,  9.99441206e-01,  9.99441504e-01,
     9.99443293e-01,  9.99446690e-01,  9.99451578e-01,  9.99458075e-01,
     9.99466062e-01,  9.99475598e-01,  9.99486566e-01,  9.99499083e-01,
     9.99513030e-01,  9.99528408e-01,  9.99545157e-01,  9.99563277e-01,
     9.99582708e-01,  9.99603331e-01,  9.99625206e-01,  9.99648154e-01,
     9.99672174e-01,  9.99697208e-01,  9.99723136e-01,  9.99749959e-01,
     9.99777496e-01,  9.99805748e-01,  9.99834597e-01,  9.99863982e-01,
     9.99893785e-01,  9.99923885e-01,  9.99954224e-01,  9.99984741e-01,
     1.00001526e+00,  1.00004578e+00,  1.00007617e+00,  1.00010622e+00,
     1.00013602e+00,  1.00016546e+00,  1.00019431e+00,  1.00022256e+00,
     1.00025010e+00,  1.00027692e+00,  1.00030291e+00,  1.00032794e+00,
     1.00035203e+00,  1.00037491e+00,  1.00039685e+00,  1.00041747e+00,
     1.00043690e+00,  1.00045502e+00,  1.00047183e+00,  1.00048721e+00,
     1.00050116e+00,  1.00051367e+00,  1.00052476e+00,  1.00053418e+00,
     1.00054228e+00,  1.00054872e+00,  1.00055361e+00,  1.00055695e+00,
     1.00055885e+00,  1.00055909e+00,  1.00055790e+00,  1.00055504e+00,
     1.00055087e+00,  1.00054502e+00,  1.00053787e+00,  1.00052929e+00,
     1.00051928e+00,  1.00050783e+00,  1.00049520e+00,  1.00048113e+00,
     1.00046599e+00,  1.00044954e+00,  1.00043201e+00,  1.00041330e+00,
     1.00039363e+00,  1.00037301e+00,  1.00035143e+00,  1.00032890e+00,
     1.00030565e+00,  1.00028157e+00,  1.00025690e+00,  1.00023150e+00,
     1.00020564e+00,  1.00017929e+00,  1.00015235e+00,  1.00012517e+00,
     1.00009763e+00,  1.00006998e+00,  1.00004208e+00,  1.00001407e+00,
     9.99985993e-01,  9.99957979e-01,  9.99930084e-01,  9.99902308e-01,
     9.99874830e-01,  9.99847591e-01,  9.99820769e-01,  9.99794364e-01,
     9.99768496e-01,  9.99743164e-01,  9.99718428e-01,  9.99694467e-01,
     9.99671161e-01,  9.99648750e-01,  9.99627173e-01,  9.99606490e-01,
     9.99586821e-01,  9.99568224e-01,  9.99550641e-01,  9.99534249e-01,
     9.99519050e-01,  9.99505103e-01,  9.99492407e-01,  9.99481022e-01,
     9.99471009e-01,  9.99462426e-01,  9.99455214e-01,  9.99449492e-01,
     9.99445200e-01,  9.99442458e-01,  9.99441206e-01,  9.99441504e-01,
     9.99443293e-01,  9.99446690e-01,  9.99451578e-01,  9.99458075e-01,
     9.99466062e-01,  9.99475598e-01,  9.99486566e-01,  9.99499083e-01,
     9.99513030e-01,  9.99528408e-01,  9.99545157e-01,  9.99563277e-01,
     9.99582708e-01,  9.99603331e-01,  9.99625206e-01,  9.99648154e-01,
     9.99672174e-01,  9.99697208e-01,  9.99723136e-01,  9.99749959e-01,
     9.99777496e-01,  9.99805748e-01,  9.99834597e-01,  9.99863982e-01,
     9.99893785e-01,  9.99923885e-01,  9.99954224e-01,  9.99984741e-01,
     1.00001526e+00,  1.00004554e+00,  1.00007534e+00,  1.00010443e+00,
     1.00013220e+00,  1.00015819e+00,  1.00018132e+00,  1.00020075e+00,
     1.00021482e+00,  1.00022173e+00,  1.00021923e+00,  1.00020432e+00,
     1.00017369e+00,  1.00012279e+00,  1.00004685e+00,  9.99939978e-01,
     9.99795198e-01,  9.99604583e-01,  9.99359250e-01,  9.99048889e-01,
     9.98662114e-01,  9.98186171e-01,  9.97606814e-01,  9.96908367e-01,
     9.96073723e-01,  9.95083988e-01,  9.93918717e-01,  9.92555678e-01,
     9.90970671e-01,  9.89137888e-01,  9.87029374e-01,  9.84615326e-01,
     9.81863916e-01,  9.78741586e-01,  9.75212753e-01,  9.71240282e-01,
     9.66785491e-01,  9.61808383e-01,  9.56268132e-01,  9.50123310e-01,
     9.43332374e-01,  9.35854316e-01,  9.27648962e-01,  9.18677926e-01,
     9.08904910e-01,  8.98296535e-01,  8.86823177e-01,  8.74459147e-01,
     8.61183822e-01,  8.46981943e-01,  8.31844091e-01,  8.15767467e-01,
     7.98755884e-01,  7.80820429e-01,  7.61979520e-01,  7.42259145e-01,
     7.21692860e-01,  7.00321794e-01,  6.78194642e-01,  6.55367255e-01,
     6.31902635e-01,  6.07870460e-01,  5.83346546e-01,  5.58412433e-01,
     5.33154905e-01,  5.07664979e-01,  4.82037485e-01,  4.56370175e-01,
     4.30762708e-01,  4.05315757e-01,  3.80130053e-01,  3.55305195e-01,
     3.30938727e-01,  3.07124883e-01,  2.83953428e-01,  2.61508703e-01,
     2.39868388e-01,  2.19102606e-01,  1.99272946e-01,  1.80431694e-01,
     1.62621215e-01,  1.45873442e-01,  1.30209655e-01,  1.15640387e-01,
     1.02165572e-01,  8.97749513e-02,  7.84486011e-02,  6.81576878e-02,
     5.88653944e-02,  5.05279638e-02,  4.30957973e-02,  3.65146622e-02,
     3.07268873e-02,  2.56725382e-02,  2.12905537e-02,  1.75197981e-02,
     1.43000064e-02,  1.15726292e-02,  9.28153656e-03,  7.37359654e-03,
     5.79912262e-03,  4.51218896e-03,  3.47083295e-03,  2.63714185e-03,
     1.97724649e-03,  1.46123092e-03,  1.06297329e-03,  7.59930001e-04,
     5.32880833e-04,  3.65644053e-04,  2.44775380e-04,  1.59260671e-04,
     1.00211051e-04,  6.05685127e-05,  3.48275607e-05,  1.87775731e-05,
     9.26902067e-06,  4.00523413e-06,  1.35989160e-06,  2.06769442e-07,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])

W_10M_96K_HR = np.array([
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     6.66310811e-08,  2.23723916e-07,  4.87541854e-07,  8.99672727e-07,
     1.51141830e-06,  2.38590815e-06,  3.60002150e-06,  5.24645884e-06,
     7.43599958e-06,  1.02999529e-05,  1.39928125e-05,  1.86951092e-05,
     2.46164800e-05,  3.19989194e-05,  4.11202636e-05,  5.22978444e-05,
     6.58923600e-05,  8.23118899e-05,  1.02016144e-04,  1.25520819e-04,
     1.53402099e-04,  1.86301360e-04,  2.24929841e-04,  2.70073535e-04,
     3.22598062e-04,  3.83453589e-04,  4.53679706e-04,  5.34410414e-04,
     6.26878755e-04,  7.32421642e-04,  8.52484489e-04,  9.88625223e-04,
     1.14251883e-03,  1.31596089e-03,  1.51087111e-03,  1.72929652e-03,
     1.97341433e-03,  2.24553375e-03,  2.54809810e-03,  2.88368552e-03,
     3.25501012e-03,  3.66492104e-03,  4.11640201e-03,  4.61257016e-03,
     5.15667303e-03,  5.75208431e-03,  6.40230207e-03,  7.11094262e-03,
     7.88173359e-03,  8.71850923e-03,  9.62519925e-03,  1.06058242e-02,
     1.16644828e-02,  1.28053408e-02,  1.40326228e-02,  1.53505951e-02,
     1.67635549e-02,  1.82758160e-02,  1.98916886e-02,  2.16154736e-02,
     2.34514344e-02,  2.54037846e-02,  2.74766665e-02,  2.96741407e-02,
     3.20001543e-02,  3.44585292e-02,  3.70529443e-02,  3.97869013e-02,
     4.26637232e-02,  4.56865206e-02,  4.88581695e-02,  5.21813035e-02,
     5.56582808e-02,  5.92911765e-02,  6.30817562e-02,  6.70314580e-02,
     7.11413696e-02,  7.54122287e-02,  7.98443928e-02,  8.44378322e-02,
     8.91921073e-02,  9.41063836e-02,  9.91793722e-02,  1.04409374e-01,
     1.09794252e-01,  1.15331404e-01,  1.21017799e-01,  1.26849949e-01,
     1.32823929e-01,  1.38935357e-01,  1.45179421e-01,  1.51550874e-01,
     1.58044025e-01,  1.64652810e-01,  1.71370730e-01,  1.78190947e-01,
     1.85106188e-01,  1.92108899e-01,  1.99191183e-01,  2.06344813e-01,
     2.13561311e-01,  2.20831960e-01,  2.28147790e-01,  2.35499650e-01,
     2.42878228e-01,  2.50274092e-01,  2.57677704e-01,  2.65079439e-01,
     2.72469670e-01,  2.79838771e-01,  2.87177145e-01,  2.94475257e-01,
     3.01723719e-01,  3.08913231e-01,  3.16034675e-01,  3.23079228e-01,
     3.30038190e-01,  3.36903185e-01,  3.43666196e-01,  3.50319386e-01,
     3.56855512e-01,  3.63267571e-01,  3.69548947e-01,  3.75693500e-01,
     3.81695598e-01,  3.87549996e-01,  3.93251985e-01,  3.98797333e-01,
     4.04182315e-01,  4.09403801e-01,  4.14459109e-01,  4.19346124e-01,
     4.24063236e-01,  4.28609401e-01,  4.32984143e-01,  4.37187403e-01,
     4.41219747e-01,  4.45082188e-01,  4.48776275e-01,  4.52303976e-01,
     4.55667824e-01,  4.58870709e-01,  4.61916000e-01,  4.64807451e-01,
     4.67549264e-01,  4.70145911e-01,  4.72602278e-01,  4.74923581e-01,
     4.77115244e-01,  4.79183048e-01,  4.81132984e-01,  4.82971221e-01,
     4.84704226e-01,  4.86338496e-01,  4.87880766e-01,  4.89337832e-01,
     4.90716666e-01,  4.92024213e-01,  4.93267536e-01,  4.94453669e-01,
     4.95589703e-01,  4.96682733e-01,  4.97739762e-01,  4.98767793e-01,
     4.99773741e-01,  5.00764489e-01,  5.01746774e-01,  5.02727270e-01,
     5.03712595e-01,  5.04709125e-01,  5.05723178e-01,  5.06760955e-01,
     5.07828474e-01,  5.08931518e-01,  5.10075927e-01,  5.11267185e-01,
     5.12510598e-01,  5.13811469e-01,  5.15174806e-01,  5.16605377e-01,
     5.18107831e-01,  5.19686580e-01,  5.21345973e-01,  5.23089945e-01,
     5.24922311e-01,  5.26846766e-01,  5.28866649e-01,  5.30985177e-01,
     5.33205211e-01,  5.35529494e-01,  5.37960529e-01,  5.40500462e-01,
     5.43151379e-01,  5.45914948e-01,  5.48792660e-01,  5.51785827e-01,
     5.54895282e-01,  5.58121800e-01,  5.61465800e-01,  5.64927518e-01,
     5.68506777e-01,  5.72203338e-01,  5.76016545e-01,  5.79945564e-01,
     5.83989203e-01,  5.88146091e-01,  5.92414677e-01,  5.96792936e-01,
     6.01278901e-01,  6.05870068e-01,  6.10563993e-01,  6.15357757e-01,
     6.20248437e-01,  6.25232756e-01,  6.30307317e-01,  6.35468543e-01,
     6.40712619e-01,  6.46035612e-01,  6.51433527e-01,  6.56902015e-01,
     6.62436843e-01,  6.68033481e-01,  6.73687398e-01,  6.79393888e-01,
     6.85148239e-01,  6.90945625e-01,  6.96781278e-01,  7.02650130e-01,
     7.08547413e-01,  7.14468122e-01,  7.20407307e-01,  7.26359963e-01,
     7.32321203e-01,  7.38286138e-01,  7.44249880e-01,  7.50207603e-01,
     7.56154597e-01,  7.62086034e-01,  7.67997444e-01,  7.73884177e-01,
     7.79741824e-01,  7.85566032e-01,  7.91352570e-01,  7.97097266e-01,
     8.02796185e-01,  8.08445334e-01,  8.14041018e-01,  8.19579542e-01,
     8.25057447e-01,  8.30471396e-01,  8.35818112e-01,  8.41094613e-01,
     8.46297920e-01,  8.51425231e-01,  8.56473923e-01,  8.61441612e-01,
     8.66325855e-01,  8.71124566e-01,  8.75835657e-01,  8.80457282e-01,
     8.84987772e-01,  8.89425457e-01,  8.93768966e-01,  8.98017049e-01,
     9.02168512e-01,  9.06222403e-01,  9.10177886e-01,  9.14034188e-01,
     9.17790771e-01,  9.21447217e-01,  9.25003231e-01,  9.28458691e-01,
     9.31813419e-01,  9.35067594e-01,  9.38221455e-01,  9.41275299e-01,
     9.44229603e-01,  9.47084904e-01,  9.49841976e-01,  9.52501595e-01,
     9.55064654e-01,  9.57532167e-01,  9.59905326e-01,  9.62185323e-01,
     9.64373529e-01,  9.66471374e-01,  9.68480289e-01,  9.70402002e-01,
     9.72238123e-01,  9.73990440e-01,  9.75660801e-01,  9.77251112e-01,
     9.78763342e-01,  9.80199575e-01,  9.81561780e-01,  9.82852161e-01,
     9.84072864e-01,  9.85226095e-01,  9.86314118e-01,  9.87339139e-01,
     9.88303483e-01,  9.89209354e-01,  9.90059078e-01,  9.90854919e-01,
     9.91599143e-01,  9.92294014e-01,  9.92941797e-01,  9.93544638e-01,
     9.94104803e-01,  9.94624376e-01,  9.95105505e-01,  9.95550215e-01,
     9.95960534e-01,  9.96338427e-01,  9.96685863e-01,  9.97004628e-01,
     9.97296572e-01,  9.97563362e-01,  9.97806728e-01,  9.98028338e-01,
     9.98229563e-01,  9.98412073e-01,  9.98577118e-01,  9.98726189e-01,
     9.98860478e-01,  9.98981178e-01,  9.99089479e-01,  9.99186397e-01,
     9.99273062e-01,  9.99350369e-01,  9.99419153e-01,  9.99480307e-01,
     9.99534547e-01,  9.99582708e-01,  9.99625325e-01,  9.99663055e-01,
     9.99696434e-01,  9.99726057e-01,  9.99752283e-01,  9.99775589e-01,
     9.99796331e-01,  9.99814928e-01,  9.99831557e-01,  9.99846578e-01,
     9.99860287e-01,  9.99872804e-01,  9.99884307e-01,  9.99895036e-01,
     9.99905109e-01,  9.99914587e-01,  9.99923646e-01,  9.99932408e-01,
     9.99940872e-01,  9.99949098e-01,  9.99957144e-01,  9.99965072e-01,
     9.99972939e-01,  9.99980748e-01,  9.99988437e-01,  9.99996126e-01,
     1.00000381e+00,  1.00001144e+00,  1.00001907e+00,  1.00002670e+00,
     1.00003433e+00,  1.00004184e+00,  1.00004935e+00,  1.00005686e+00,
     1.00006437e+00,  1.00007176e+00,  1.00007904e+00,  1.00008631e+00,
     1.00009358e+00,  1.00010073e+00,  1.00010777e+00,  1.00011480e+00,
     1.00012159e+00,  1.00012839e+00,  1.00013518e+00,  1.00014174e+00,
     1.00014830e+00,  1.00015461e+00,  1.00016093e+00,  1.00016701e+00,
     1.00017309e+00,  1.00017893e+00,  1.00018466e+00,  1.00019026e+00,
     1.00019574e+00,  1.00020099e+00,  1.00020623e+00,  1.00021124e+00,
     1.00021613e+00,  1.00022078e+00,  1.00022531e+00,  1.00022972e+00,
     1.00023389e+00,  1.00023794e+00,  1.00024176e+00,  1.00024545e+00,
     1.00024891e+00,  1.00025225e+00,  1.00025535e+00,  1.00025833e+00,
     1.00026107e+00,  1.00026357e+00,  1.00026596e+00,  1.00026822e+00,
     1.00027013e+00,  1.00027204e+00,  1.00027359e+00,  1.00027502e+00,
     1.00027621e+00,  1.00027728e+00,  1.00027812e+00,  1.00027883e+00,
     1.00027919e+00,  1.00027955e+00,  1.00027955e+00,  1.00027943e+00,
     1.00027919e+00,  1.00027859e+00,  1.00027800e+00,  1.00027704e+00,
     1.00027597e+00,  1.00027478e+00,  1.00027335e+00,  1.00027168e+00,
     1.00026989e+00,  1.00026786e+00,  1.00026572e+00,  1.00026345e+00,
     1.00026095e+00,  1.00025821e+00,  1.00025535e+00,  1.00025237e+00,
     1.00024927e+00,  1.00024593e+00,  1.00024235e+00,  1.00023878e+00,
     1.00023496e+00,  1.00023091e+00,  1.00022686e+00,  1.00022256e+00,
     1.00021827e+00,  1.00021374e+00,  1.00020909e+00,  1.00020421e+00,
     1.00019932e+00,  1.00019431e+00,  1.00018907e+00,  1.00018382e+00,
     1.00017846e+00,  1.00017297e+00,  1.00016737e+00,  1.00016165e+00,
     1.00015581e+00,  1.00014985e+00,  1.00014389e+00,  1.00013781e+00,
     1.00013161e+00,  1.00012529e+00,  1.00011897e+00,  1.00011253e+00,
     1.00010610e+00,  1.00009954e+00,  1.00009298e+00,  1.00008631e+00,
     1.00007963e+00,  1.00007284e+00,  1.00006604e+00,  1.00005913e+00,
     1.00005233e+00,  1.00004542e+00,  1.00003850e+00,  1.00003147e+00,
     1.00002456e+00,  1.00001752e+00,  1.00001049e+00,  1.00000346e+00,
     9.99996483e-01,  9.99989510e-01,  9.99982476e-01,  9.99975502e-01,
     9.99968529e-01,  9.99961555e-01,  9.99954641e-01,  9.99947727e-01,
     9.99940813e-01,  9.99933958e-01,  9.99927163e-01,  9.99920428e-01,
     9.99913692e-01,  9.99907076e-01,  9.99900460e-01,  9.99893904e-01,
     9.99887466e-01,  9.99881029e-01,  9.99874711e-01,  9.99868453e-01,
     9.99862254e-01,  9.99856174e-01,  9.99850154e-01,  9.99844253e-01,
     9.99838412e-01,  9.99832690e-01,  9.99827087e-01,  9.99821603e-01,
     9.99816179e-01,  9.99810934e-01,  9.99805748e-01,  9.99800682e-01,
     9.99795794e-01,  9.99791026e-01,  9.99786317e-01,  9.99781847e-01,
     9.99777436e-01,  9.99773204e-01,  9.99769092e-01,  9.99765158e-01,
     9.99761343e-01,  9.99757707e-01,  9.99754190e-01,  9.99750853e-01,
     9.99747694e-01,  9.99744654e-01,  9.99741852e-01,  9.99739170e-01,
     9.99736667e-01,  9.99734342e-01,  9.99732137e-01,  9.99730170e-01,
     9.99728382e-01,  9.99726772e-01,  9.99725342e-01,  9.99724090e-01,
     9.99723017e-01,  9.99722123e-01,  9.99721408e-01,  9.99720931e-01,
     9.99720633e-01,  9.99720514e-01,  9.99720573e-01,  9.99720812e-01,
     9.99721289e-01,  9.99721944e-01,  9.99722779e-01,  9.99723792e-01,
     9.99725044e-01,  9.99726474e-01,  9.99728084e-01,  9.99729872e-01,
     9.99731898e-01,  9.99734104e-01,  9.99736488e-01,  9.99739051e-01,
     9.99741793e-01,  9.99744713e-01,  9.99747872e-01,  9.99751151e-01,
     9.99754667e-01,  9.99758303e-01,  9.99762177e-01,  9.99766171e-01,
     9.99770403e-01,  9.99774754e-01,  9.99779284e-01,  9.99783993e-01,
     9.99788821e-01,  9.99793828e-01,  9.99799013e-01,  9.99804318e-01,
     9.99809742e-01,  9.99815404e-01,  9.99821126e-01,  9.99826968e-01,
     9.99832988e-01,  9.99839127e-01,  9.99845386e-01,  9.99851763e-01,
     9.99858260e-01,  9.99864876e-01,  9.99871552e-01,  9.99878347e-01,
     9.99885261e-01,  9.99892235e-01,  9.99899328e-01,  9.99906480e-01,
     9.99913692e-01,  9.99920964e-01,  9.99928296e-01,  9.99935687e-01,
     9.99943137e-01,  9.99950647e-01,  9.99958158e-01,  9.99965727e-01,
     9.99973297e-01,  9.99980927e-01,  9.99988556e-01,  9.99996185e-01,
     1.00000381e+00,  1.00001144e+00,  1.00001907e+00,  1.00002670e+00,
     1.00003433e+00,  1.00004184e+00,  1.00004935e+00,  1.00005686e+00,
     1.00006437e+00,  1.00007176e+00,  1.00007904e+00,  1.00008631e+00,
     1.00009358e+00,  1.00010073e+00,  1.00010777e+00,  1.00011480e+00,
     1.00012159e+00,  1.00012839e+00,  1.00013518e+00,  1.00014174e+00,
     1.00014830e+00,  1.00015461e+00,  1.00016093e+00,  1.00016701e+00,
     1.00017309e+00,  1.00017893e+00,  1.00018466e+00,  1.00019026e+00,
     1.00019574e+00,  1.00020099e+00,  1.00020623e+00,  1.00021124e+00,
     1.00021613e+00,  1.00022078e+00,  1.00022531e+00,  1.00022972e+00,
     1.00023389e+00,  1.00023794e+00,  1.00024176e+00,  1.00024545e+00,
     1.00024891e+00,  1.00025225e+00,  1.00025535e+00,  1.00025833e+00,
     1.00026107e+00,  1.00026357e+00,  1.00026596e+00,  1.00026822e+00,
     1.00027013e+00,  1.00027204e+00,  1.00027359e+00,  1.00027502e+00,
     1.00027621e+00,  1.00027728e+00,  1.00027812e+00,  1.00027883e+00,
     1.00027919e+00,  1.00027955e+00,  1.00027955e+00,  1.00027943e+00,
     1.00027919e+00,  1.00027859e+00,  1.00027800e+00,  1.00027704e+00,
     1.00027597e+00,  1.00027478e+00,  1.00027335e+00,  1.00027168e+00,
     1.00026989e+00,  1.00026786e+00,  1.00026572e+00,  1.00026345e+00,
     1.00026095e+00,  1.00025821e+00,  1.00025535e+00,  1.00025237e+00,
     1.00024927e+00,  1.00024593e+00,  1.00024235e+00,  1.00023878e+00,
     1.00023496e+00,  1.00023091e+00,  1.00022686e+00,  1.00022256e+00,
     1.00021827e+00,  1.00021374e+00,  1.00020909e+00,  1.00020421e+00,
     1.00019932e+00,  1.00019431e+00,  1.00018907e+00,  1.00018382e+00,
     1.00017846e+00,  1.00017297e+00,  1.00016737e+00,  1.00016165e+00,
     1.00015581e+00,  1.00014985e+00,  1.00014389e+00,  1.00013781e+00,
     1.00013161e+00,  1.00012529e+00,  1.00011897e+00,  1.00011253e+00,
     1.00010610e+00,  1.00009954e+00,  1.00009298e+00,  1.00008631e+00,
     1.00007963e+00,  1.00007284e+00,  1.00006604e+00,  1.00005913e+00,
     1.00005233e+00,  1.00004542e+00,  1.00003850e+00,  1.00003147e+00,
     1.00002456e+00,  1.00001752e+00,  1.00001049e+00,  1.00000346e+00,
     9.99996483e-01,  9.99989510e-01,  9.99982476e-01,  9.99975502e-01,
     9.99968529e-01,  9.99961555e-01,  9.99954641e-01,  9.99947727e-01,
     9.99940813e-01,  9.99933958e-01,  9.99927163e-01,  9.99920428e-01,
     9.99913692e-01,  9.99907076e-01,  9.99900460e-01,  9.99893904e-01,
     9.99887466e-01,  9.99881029e-01,  9.99874711e-01,  9.99868453e-01,
     9.99862254e-01,  9.99856174e-01,  9.99850154e-01,  9.99844253e-01,
     9.99838412e-01,  9.99832690e-01,  9.99827087e-01,  9.99821603e-01,
     9.99816179e-01,  9.99810934e-01,  9.99805748e-01,  9.99800682e-01,
     9.99795794e-01,  9.99791026e-01,  9.99786317e-01,  9.99781847e-01,
     9.99777436e-01,  9.99773204e-01,  9.99769092e-01,  9.99765158e-01,
     9.99761343e-01,  9.99757707e-01,  9.99754190e-01,  9.99750853e-01,
     9.99747694e-01,  9.99744654e-01,  9.99741852e-01,  9.99739170e-01,
     9.99736667e-01,  9.99734342e-01,  9.99732137e-01,  9.99730170e-01,
     9.99728382e-01,  9.99726772e-01,  9.99725342e-01,  9.99724090e-01,
     9.99723017e-01,  9.99722123e-01,  9.99721408e-01,  9.99720931e-01,
     9.99720633e-01,  9.99720514e-01,  9.99720573e-01,  9.99720812e-01,
     9.99721289e-01,  9.99721944e-01,  9.99722779e-01,  9.99723792e-01,
     9.99725044e-01,  9.99726474e-01,  9.99728084e-01,  9.99729872e-01,
     9.99731898e-01,  9.99734104e-01,  9.99736488e-01,  9.99739051e-01,
     9.99741793e-01,  9.99744713e-01,  9.99747872e-01,  9.99751151e-01,
     9.99754667e-01,  9.99758303e-01,  9.99762177e-01,  9.99766171e-01,
     9.99770403e-01,  9.99774754e-01,  9.99779284e-01,  9.99783993e-01,
     9.99788821e-01,  9.99793828e-01,  9.99799013e-01,  9.99804318e-01,
     9.99809742e-01,  9.99815404e-01,  9.99821126e-01,  9.99826968e-01,
     9.99832988e-01,  9.99839127e-01,  9.99845386e-01,  9.99851763e-01,
     9.99858260e-01,  9.99864876e-01,  9.99871552e-01,  9.99878347e-01,
     9.99885261e-01,  9.99892235e-01,  9.99899328e-01,  9.99906480e-01,
     9.99913692e-01,  9.99920964e-01,  9.99928296e-01,  9.99935687e-01,
     9.99943137e-01,  9.99950647e-01,  9.99958158e-01,  9.99965727e-01,
     9.99973297e-01,  9.99980927e-01,  9.99988556e-01,  9.99996185e-01,
     1.00000381e+00,  1.00001144e+00,  1.00001907e+00,  1.00002670e+00,
     1.00003433e+00,  1.00004184e+00,  1.00004935e+00,  1.00005686e+00,
     1.00006437e+00,  1.00007176e+00,  1.00007904e+00,  1.00008631e+00,
     1.00009358e+00,  1.00010073e+00,  1.00010777e+00,  1.00011480e+00,
     1.00012159e+00,  1.00012839e+00,  1.00013518e+00,  1.00014174e+00,
     1.00014830e+00,  1.00015461e+00,  1.00016093e+00,  1.00016701e+00,
     1.00017309e+00,  1.00017893e+00,  1.00018466e+00,  1.00019026e+00,
     1.00019574e+00,  1.00020099e+00,  1.00020623e+00,  1.00021124e+00,
     1.00021613e+00,  1.00022078e+00,  1.00022531e+00,  1.00022972e+00,
     1.00023389e+00,  1.00023794e+00,  1.00024176e+00,  1.00024545e+00,
     1.00024891e+00,  1.00025225e+00,  1.00025535e+00,  1.00025833e+00,
     1.00026107e+00,  1.00026357e+00,  1.00026596e+00,  1.00026822e+00,
     1.00027013e+00,  1.00027204e+00,  1.00027359e+00,  1.00027502e+00,
     1.00027621e+00,  1.00027728e+00,  1.00027812e+00,  1.00027883e+00,
     1.00027919e+00,  1.00027955e+00,  1.00027955e+00,  1.00027943e+00,
     1.00027919e+00,  1.00027859e+00,  1.00027800e+00,  1.00027704e+00,
     1.00027597e+00,  1.00027478e+00,  1.00027335e+00,  1.00027168e+00,
     1.00026989e+00,  1.00026786e+00,  1.00026572e+00,  1.00026345e+00,
     1.00026095e+00,  1.00025821e+00,  1.00025535e+00,  1.00025237e+00,
     1.00024927e+00,  1.00024593e+00,  1.00024235e+00,  1.00023878e+00,
     1.00023496e+00,  1.00023091e+00,  1.00022686e+00,  1.00022256e+00,
     1.00021827e+00,  1.00021374e+00,  1.00020909e+00,  1.00020421e+00,
     1.00019932e+00,  1.00019431e+00,  1.00018907e+00,  1.00018382e+00,
     1.00017846e+00,  1.00017297e+00,  1.00016737e+00,  1.00016165e+00,
     1.00015581e+00,  1.00014985e+00,  1.00014389e+00,  1.00013781e+00,
     1.00013161e+00,  1.00012529e+00,  1.00011897e+00,  1.00011253e+00,
     1.00010610e+00,  1.00009954e+00,  1.00009298e+00,  1.00008631e+00,
     1.00007963e+00,  1.00007284e+00,  1.00006604e+00,  1.00005913e+00,
     1.00005233e+00,  1.00004542e+00,  1.00003850e+00,  1.00003147e+00,
     1.00002456e+00,  1.00001752e+00,  1.00001049e+00,  1.00000346e+00,
     9.99996483e-01,  9.99989510e-01,  9.99982476e-01,  9.99975502e-01,
     9.99968529e-01,  9.99961555e-01,  9.99954641e-01,  9.99947727e-01,
     9.99940813e-01,  9.99933958e-01,  9.99927163e-01,  9.99920428e-01,
     9.99913692e-01,  9.99907076e-01,  9.99900460e-01,  9.99893904e-01,
     9.99887466e-01,  9.99881029e-01,  9.99874711e-01,  9.99868453e-01,
     9.99862254e-01,  9.99856174e-01,  9.99850154e-01,  9.99844253e-01,
     9.99838412e-01,  9.99832690e-01,  9.99827087e-01,  9.99821603e-01,
     9.99816179e-01,  9.99810934e-01,  9.99805748e-01,  9.99800682e-01,
     9.99795794e-01,  9.99791026e-01,  9.99786317e-01,  9.99781847e-01,
     9.99777436e-01,  9.99773204e-01,  9.99769092e-01,  9.99765158e-01,
     9.99761343e-01,  9.99757707e-01,  9.99754190e-01,  9.99750853e-01,
     9.99747694e-01,  9.99744654e-01,  9.99741852e-01,  9.99739170e-01,
     9.99736667e-01,  9.99734342e-01,  9.99732137e-01,  9.99730170e-01,
     9.99728382e-01,  9.99726772e-01,  9.99725342e-01,  9.99724090e-01,
     9.99723017e-01,  9.99722123e-01,  9.99721408e-01,  9.99720931e-01,
     9.99720633e-01,  9.99720514e-01,  9.99720573e-01,  9.99720812e-01,
     9.99721289e-01,  9.99721944e-01,  9.99722779e-01,  9.99723792e-01,
     9.99725044e-01,  9.99726474e-01,  9.99728084e-01,  9.99729872e-01,
     9.99731898e-01,  9.99734104e-01,  9.99736488e-01,  9.99739051e-01,
     9.99741793e-01,  9.99744713e-01,  9.99747872e-01,  9.99751151e-01,
     9.99754667e-01,  9.99758303e-01,  9.99762177e-01,  9.99766171e-01,
     9.99770403e-01,  9.99774754e-01,  9.99779284e-01,  9.99783993e-01,
     9.99788821e-01,  9.99793828e-01,  9.99799013e-01,  9.99804318e-01,
     9.99809742e-01,  9.99815404e-01,  9.99821126e-01,  9.99826968e-01,
     9.99832988e-01,  9.99839127e-01,  9.99845386e-01,  9.99851763e-01,
     9.99858260e-01,  9.99864876e-01,  9.99871552e-01,  9.99878347e-01,
     9.99885261e-01,  9.99892235e-01,  9.99899328e-01,  9.99906480e-01,
     9.99913692e-01,  9.99920964e-01,  9.99928296e-01,  9.99935687e-01,
     9.99943137e-01,  9.99950647e-01,  9.99958158e-01,  9.99965727e-01,
     9.99973297e-01,  9.99980927e-01,  9.99988556e-01,  9.99996185e-01,
     1.00000381e+00,  1.00001132e+00,  1.00001884e+00,  1.00002635e+00,
     1.00003362e+00,  1.00004077e+00,  1.00004780e+00,  1.00005460e+00,
     1.00006104e+00,  1.00006711e+00,  1.00007272e+00,  1.00007772e+00,
     1.00008214e+00,  1.00008571e+00,  1.00008833e+00,  1.00008976e+00,
     1.00008988e+00,  1.00008845e+00,  1.00008512e+00,  1.00007975e+00,
     1.00007200e+00,  1.00006139e+00,  1.00004768e+00,  1.00003028e+00,
     1.00000894e+00,  9.99982893e-01,  9.99951661e-01,  9.99914646e-01,
     9.99871135e-01,  9.99820411e-01,  9.99761701e-01,  9.99694109e-01,
     9.99616742e-01,  9.99528646e-01,  9.99428689e-01,  9.99315858e-01,
     9.99188840e-01,  9.99046445e-01,  9.98887360e-01,  9.98710036e-01,
     9.98513043e-01,  9.98294711e-01,  9.98053491e-01,  9.97787535e-01,
     9.97494996e-01,  9.97173846e-01,  9.96822178e-01,  9.96437728e-01,
     9.96018291e-01,  9.95561540e-01,  9.95064974e-01,  9.94526088e-01,
     9.93942142e-01,  9.93310452e-01,  9.92628038e-01,  9.91891921e-01,
     9.91099000e-01,  9.90245998e-01,  9.89329517e-01,  9.88346159e-01,
     9.87292290e-01,  9.86164153e-01,  9.84957933e-01,  9.83669639e-01,
     9.82295156e-01,  9.80830312e-01,  9.79270697e-01,  9.77612019e-01,
     9.75849628e-01,  9.73978817e-01,  9.71994996e-01,  9.69893157e-01,
     9.67668533e-01,  9.65315938e-01,  9.62830484e-01,  9.60206985e-01,
     9.57440197e-01,  9.54525113e-01,  9.51456368e-01,  9.48228836e-01,
     9.44837391e-01,  9.41276729e-01,  9.37541902e-01,  9.33627844e-01,
     9.29529607e-01,  9.25242424e-01,  9.20761466e-01,  9.16082382e-01,
     9.11200643e-01,  9.06112134e-01,  9.00812864e-01,  8.95299196e-01,
     8.89567554e-01,  8.83614719e-01,  8.77437830e-01,  8.71034324e-01,
     8.64401877e-01,  8.57538521e-01,  8.50442827e-01,  8.43113542e-01,
     8.35549891e-01,  8.27751517e-01,  8.19718421e-01,  8.11451137e-01,
     8.02950621e-01,  7.94218183e-01,  7.85255671e-01,  7.76065350e-01,
     7.66650081e-01,  7.57013023e-01,  7.47157931e-01,  7.37088978e-01,
     7.26810873e-01,  7.16328681e-01,  7.05648124e-01,  6.94775164e-01,
     6.83716357e-01,  6.72478795e-01,  6.61069810e-01,  6.49497330e-01,
     6.37769580e-01,  6.25895321e-01,  6.13883674e-01,  6.01744056e-01,
     5.89486361e-01,  5.77120781e-01,  5.64657867e-01,  5.52108407e-01,
     5.39483547e-01,  5.26794672e-01,  5.14053404e-01,  5.01271665e-01,
     4.88461435e-01,  4.75634992e-01,  4.62804615e-01,  4.49982822e-01,
     4.37182158e-01,  4.24415171e-01,  4.11694527e-01,  3.99032772e-01,
     3.86442453e-01,  3.73936087e-01,  3.61525953e-01,  3.49224269e-01,
     3.37043047e-01,  3.24994087e-01,  3.13088894e-01,  3.01338732e-01,
     2.89754450e-01,  2.78346658e-01,  2.67125458e-01,  2.56100595e-01,
     2.45281324e-01,  2.34676436e-01,  2.24294156e-01,  2.14142203e-01,
     2.04227716e-01,  1.94557235e-01,  1.85136691e-01,  1.75971389e-01,
     1.67065978e-01,  1.58424467e-01,  1.50050193e-01,  1.41945809e-01,
     1.34113312e-01,  1.26554012e-01,  1.19268581e-01,  1.12257004e-01,
     1.05518632e-01,  9.90521908e-02,  9.28557739e-02,  8.69268849e-02,
     8.12624842e-02,  7.58589506e-02,  7.07121640e-02,  6.58175275e-02,
     6.11699894e-02,  5.67640625e-02,  5.25939018e-02,  4.86532971e-02,
     4.49357443e-02,  4.14344519e-02,  3.81424055e-02,  3.50523964e-02,
     3.21570449e-02,  2.94488575e-02,  2.69202497e-02,  2.45635863e-02,
     2.23712083e-02,  2.03354694e-02,  1.84487645e-02,  1.67035554e-02,
     1.50924018e-02,  1.36079816e-02,  1.22431125e-02,  1.09907771e-02,
     9.84413363e-03,  8.79654102e-03,  7.84156192e-03,  6.97298534e-03,
     6.18482940e-03,  5.47135156e-03,  4.82705561e-03,  4.24669450e-03,
     3.72527563e-03,  3.25805834e-03,  2.84055714e-03,  2.46853800e-03,
     2.13801605e-03,  1.84525200e-03,  1.58674677e-03,  1.35923503e-03,
     1.15967961e-03,  9.85263032e-04,  8.33379803e-04,  7.01628160e-04,
     5.87800692e-04,  4.89875500e-04,  4.06006613e-04,  3.34514218e-04,
     2.73875427e-04,  2.22714254e-04,  1.79792376e-04,  1.43999539e-04,
     1.14344395e-04,  8.99455481e-05,  7.00227974e-05,  5.38887325e-05,
     4.09407221e-05,  3.06531692e-05,  2.25702297e-05,  1.62988836e-05,
     1.15024377e-05,  7.89443584e-06,  5.23298331e-06,  3.31548563e-06,
     1.97379018e-06,  1.06971811e-06,  4.90905393e-07,  1.46209757e-07,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
     0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
])


### 3.7.4 ###

SNS_LFCB = np.array([

    [  2.26283366e+00,  8.13311269e-01, -5.30193495e-01, -1.35664836e+00,
      -1.59952177e+00, -1.44098768e+00, -1.14381648e+00, -7.55203768e-01 ],

    [  2.94516479e+00,  2.41143318e+00,  9.60455106e-01, -4.43226488e-01,
      -1.22913612e+00, -1.55590039e+00, -1.49688656e+00, -1.11689987e+00 ],

    [ -2.18610707e+00, -1.97152136e+00, -1.78718620e+00, -1.91865896e+00,
      -1.79399122e+00, -1.35738404e+00, -7.05444279e-01, -4.78172945e-02 ],

    [  6.93688237e-01,  9.55609857e-01,  5.75230787e-01, -1.14603419e-01,
      -6.46050637e-01, -9.52351370e-01, -1.07405247e+00, -7.58087707e-01 ],

    [ -1.29752132e+00, -7.40369057e-01, -3.45372484e-01, -3.13285696e-01,
      -4.02977243e-01, -3.72020853e-01, -7.83414177e-02,  9.70441304e-02 ],

    [  9.14652038e-01,  1.74293043e+00,  1.90906627e+00,  1.54408484e+00,
       1.09344961e+00,  6.47479550e-01,  3.61790752e-02, -2.97092807e-01 ],

    [ -2.51428813e+00, -2.89175271e+00, -2.00450667e+00, -7.50912274e-01,
       4.41202105e-01,  1.20190988e+00,  1.32742857e+00,  1.22049081e+00 ],

    [ -9.22188405e-01,  6.32495141e-01,  1.08736431e+00,  6.08628625e-01,
       1.31174568e-01, -2.96149158e-01, -2.07013517e-01,  1.34924917e-01 ],

    [  7.90322288e-01,  6.28401262e-01,  3.93117924e-01,  4.80007711e-01,
       4.47815138e-01,  2.09734215e-01,  6.56691996e-03, -8.61242342e-02 ],

    [  1.44775580e+00,  2.72399952e+00,  2.31083269e+00,  9.35051270e-01,
      -2.74743911e-01, -9.02077697e-01, -9.40681512e-01, -6.33697039e-01 ],

    [  7.93354526e-01,  1.43931186e-02, -5.67834845e-01, -6.54760468e-01,
      -4.79458998e-01, -1.73894662e-01,  6.80162706e-02,  2.95125948e-01 ],

    [  2.72425347e+00,  2.95947572e+00,  1.84953559e+00,  5.63284922e-01,
       1.39917088e-01,  3.59641093e-01,  6.89461355e-01,  6.39790177e-01 ],

    [ -5.30830198e-01, -2.12690683e-01,  5.76613628e-03,  4.24871484e-01,
       4.73128952e-01,  8.58894199e-01,  1.19111161e+00,  9.96189670e-01 ],

    [  1.68728411e+00,  2.43614509e+00,  2.33019429e+00,  1.77983778e+00,
       1.44411295e+00,  1.51995177e+00,  1.47199394e+00,  9.77682474e-01 ],

    [ -2.95183273e+00, -1.59393497e+00, -1.09918773e-01,  3.88609073e-01,
       5.12932650e-01,  6.28112597e-01,  8.22621796e-01,  8.75891425e-01 ],

    [  1.01878343e-01,  5.89857324e-01,  6.19047647e-01,  1.26731314e+00,
       2.41961048e+00,  2.25174253e+00,  5.26537031e-01, -3.96591513e-01 ],

    [  2.68254575e+00,  1.32738011e+00,  1.30185274e-01, -3.38533089e-01,
      -3.68219236e-01, -1.91689947e-01, -1.54782377e-01, -2.34207178e-01 ],

    [  4.82697924e+00,  3.11947804e+00,  1.39513671e+00,  2.50295316e-01,
      -3.93613839e-01, -6.43458173e-01, -6.42570737e-01, -7.23193223e-01 ],

    [  8.78419936e-02, -5.69586840e-01, -1.14506016e+00, -1.66968488e+00,
      -1.84534418e+00, -1.56468027e+00, -1.11746759e+00, -5.33981663e-01 ],

    [  1.39102308e+00,  1.98146479e+00,  1.11265796e+00, -2.20107509e-01,
      -7.74965612e-01, -5.94063874e-01,  1.36937681e-01,  8.18242891e-01 ],

    [  3.84585894e-01, -1.60588786e-01, -5.39366810e-01, -5.29309079e-01,
       1.90433547e-01,  2.56062918e+00,  2.81896398e+00,  6.56670876e-01 ],

    [  1.93227399e+00,  3.01030180e+00,  3.06543894e+00,  2.50110161e+00,
       1.93089593e+00,  5.72153811e-01, -8.11741794e-01, -1.17641811e+00 ],

    [  1.75080463e-01, -7.50522832e-01, -1.03943893e+00, -1.13577509e+00,
      -1.04197904e+00, -1.52060099e-02,  2.07048392e+00,  3.42948918e+00 ],

    [ -1.18817020e+00,  3.66792874e-01,  1.30957830e+00,  1.68330687e+00,
       1.25100924e+00,  9.42375752e-01,  8.26250483e-01,  4.39952741e-01 ],

    [  2.53322203e+00,  2.11274643e+00,  1.26288412e+00,  7.61513512e-01,
       5.22117938e-01,  1.18680070e-01, -4.52346828e-01, -7.00352426e-01 ],

    [  3.99889837e+00,  4.07901751e+00,  2.82285661e+00,  1.72607213e+00,
       6.47144377e-01, -3.31148521e-01, -8.84042571e-01, -1.12697341e+00 ],

    [  5.07902593e-01,  1.58838450e+00,  1.72899024e+00,  1.00692230e+00,
       3.77121232e-01,  4.76370767e-01,  1.08754740e+00,  1.08756266e+00 ],

    [  3.16856825e+00,  3.25853458e+00,  2.42230591e+00,  1.79446078e+00,
       1.52177911e+00,  1.17196707e+00,  4.89394597e-01, -6.22795716e-02 ],

    [  1.89414767e+00,  1.25108695e+00,  5.90451211e-01,  6.08358583e-01,
       8.78171010e-01,  1.11912511e+00,  1.01857662e+00,  6.20453891e-01 ],

    [  9.48880605e-01,  2.13239439e+00,  2.72345350e+00,  2.76986077e+00,
       2.54286973e+00,  2.02046264e+00,  8.30045859e-01, -2.75569174e-02 ],

    [ -1.88026757e+00, -1.26431073e+00,  3.11424977e-01,  1.83670210e+00,
       2.25634192e+00,  2.04818998e+00,  2.19526837e+00,  2.02659614e+00 ],

    [  2.46375746e-01,  9.55621773e-01,  1.52046777e+00,  1.97647400e+00,
       1.94043867e+00,  2.23375847e+00,  1.98835978e+00,  1.27232673e+00 ],

])

SNS_HFCB = np.array([

    [  2.32028419e-01, -1.00890271e+00, -2.14223503e+00, -2.37533814e+00,
      -2.23041933e+00, -2.17595881e+00, -2.29065914e+00, -2.53286398e+00 ],

    [ -1.29503937e+00, -1.79929965e+00, -1.88703148e+00, -1.80991660e+00,
      -1.76340038e+00, -1.83418428e+00, -1.80480981e+00, -1.73679545e+00 ],

    [  1.39285716e-01, -2.58185126e-01, -6.50804573e-01, -1.06815732e+00,
      -1.61928742e+00, -2.18762566e+00, -2.63757587e+00, -2.97897750e+00 ],

    [ -3.16513102e-01, -4.77747657e-01, -5.51162076e-01, -4.84788283e-01,
      -2.38388394e-01, -1.43024507e-01,  6.83186674e-02,  8.83061717e-02 ],

    [  8.79518405e-01,  2.98340096e-01, -9.15386396e-01, -2.20645975e+00,
      -2.74142181e+00, -2.86139074e+00, -2.88841597e+00, -2.95182608e+00 ],

    [ -2.96701922e-01, -9.75004919e-01, -1.35857500e+00, -9.83721106e-01,
      -6.52956939e-01, -9.89986993e-01, -1.61467225e+00, -2.40712302e+00 ],

    [  3.40981100e-01,  2.68899789e-01,  5.63335685e-02,  4.99114047e-02,
      -9.54130727e-02, -7.60166146e-01, -2.32758120e+00, -3.77155485e+00 ],

    [ -1.41229759e+00, -1.48522119e+00, -1.18603580e+00, -6.25001634e-01,
       1.53902497e-01,  5.76386498e-01,  7.95092604e-01,  5.96564632e-01 ],

    [ -2.28839512e-01, -3.33719070e-01, -8.09321359e-01, -1.63587877e+00,
      -1.88486397e+00, -1.64496691e+00, -1.40515778e+00, -1.46666471e+00 ],

    [ -1.07148629e+00, -1.41767015e+00, -1.54891762e+00, -1.45296062e+00,
      -1.03182970e+00, -6.90642640e-01, -4.28843805e-01, -4.94960215e-01 ],

    [ -5.90988511e-01, -7.11737759e-02,  3.45719523e-01,  3.00549461e-01,
      -1.11865218e+00, -2.44089151e+00, -2.22854732e+00, -1.89509228e+00 ],

    [ -8.48434099e-01, -5.83226811e-01,  9.00423688e-02,  8.45025008e-01,
       1.06572385e+00,  7.37582999e-01,  2.56590452e-01, -4.91963360e-01 ],

    [  1.14069146e+00,  9.64016892e-01,  3.81461206e-01, -4.82849341e-01,
      -1.81632721e+00, -2.80279513e+00, -3.23385725e+00, -3.45908714e+00 ],

    [ -3.76283238e-01,  4.25675462e-02,  5.16547697e-01,  2.51716882e-01,
      -2.16179968e-01, -5.34074091e-01, -6.40786096e-01, -8.69745032e-01 ],

    [  6.65004121e-01,  1.09790765e+00,  1.38342667e+00,  1.34327359e+00,
       8.22978837e-01,  2.15876799e-01, -4.04925753e-01, -1.07025606e+00 ],

    [ -8.26265954e-01, -6.71181233e-01, -2.28495593e-01,  5.18980853e-01,
       1.36721896e+00,  2.18023038e+00,  2.53596093e+00,  2.20121099e+00 ],

    [  1.41008327e+00,  7.54441908e-01, -1.30550585e+00, -1.87133711e+00,
      -1.24008685e+00, -1.26712925e+00, -2.03670813e+00, -2.89685162e+00 ],

    [  3.61386818e-01, -2.19991705e-02, -5.79368834e-01, -8.79427961e-01,
      -8.50685023e-01, -7.79397050e-01, -7.32182927e-01, -8.88348515e-01 ],

    [  4.37469239e-01,  3.05440420e-01, -7.38786566e-03, -4.95649855e-01,
      -8.06651271e-01, -1.22431892e+00, -1.70157770e+00, -2.24491914e+00 ],

    [  6.48100319e-01,  6.82299134e-01,  2.53247464e-01,  7.35842144e-02,
       3.14216709e-01,  2.34729881e-01,  1.44600134e-01, -6.82120179e-02 ],

    [  1.11919833e+00,  1.23465533e+00,  5.89170238e-01, -1.37192460e+00,
      -2.37095707e+00, -2.00779783e+00, -1.66688540e+00, -1.92631846e+00 ],

    [  1.41847497e-01, -1.10660071e-01, -2.82824593e-01, -6.59813475e-03,
       2.85929280e-01,  4.60445530e-02, -6.02596416e-01, -2.26568729e+00 ],

    [  5.04046955e-01,  8.26982163e-01,  1.11981236e+00,  1.17914044e+00,
       1.07987429e+00,  6.97536239e-01, -9.12548817e-01, -3.57684747e+00 ],

    [ -5.01076050e-01, -3.25678006e-01,  2.80798195e-02,  2.62054555e-01,
       3.60590806e-01,  6.35623722e-01,  9.59012467e-01,  1.30745157e+00 ],

    [  3.74970983e+00,  1.52342612e+00, -4.57715662e-01, -7.98711008e-01,
      -3.86819329e-01, -3.75901062e-01, -6.57836900e-01, -1.28163964e+00 ],

    [ -1.15258991e+00, -1.10800886e+00, -5.62615117e-01, -2.20562124e-01,
      -3.49842880e-01, -7.53432770e-01, -9.88596593e-01, -1.28790472e+00 ],

    [  1.02827246e+00,  1.09770519e+00,  7.68645546e-01,  2.06081978e-01,
      -3.42805735e-01, -7.54939405e-01, -1.04196178e+00, -1.50335653e+00 ],

    [  1.28831972e-01,  6.89439395e-01,  1.12346905e+00,  1.30934523e+00,
       1.35511965e+00,  1.42311381e+00,  1.15706449e+00,  4.06319438e-01 ],

    [  1.34033030e+00,  1.38996825e+00,  1.04467922e+00,  6.35822746e-01,
      -2.74733756e-01, -1.54923372e+00, -2.44239710e+00, -3.02457607e+00 ],

    [  2.13843105e+00,  4.24711267e+00,  2.89734110e+00,  9.32730658e-01,
      -2.92822250e-01, -8.10404297e-01, -7.88868099e-01, -9.35353149e-01 ],

    [  5.64830487e-01,  1.59184978e+00,  2.39771699e+00,  3.03697344e+00,
       2.66424350e+00,  1.39304485e+00,  4.03834024e-01, -6.56270971e-01 ],

    [ -4.22460548e-01,  3.26149625e-01,  1.39171313e+00,  2.23146615e+00,
       2.61179442e+00,  2.66540340e+00,  2.40103554e+00,  1.75920380e+00 ],

])

SNS_VQ_REG_ADJ_GAINS = \
    np.array([ 8915, 12054 ]) / 4096

SNS_VQ_REG_LF_ADJ_GAINS = \
    np.array([ 6245, 15043, 17861, 21014 ]) / 4096

SNS_VQ_NEAR_ADJ_GAINS = \
    np.array([ 7099,  9132, 11253, 14808 ]) / 4096

SNS_VQ_FAR_ADJ_GAINS = \
    np.array([ 4336,  5067,  5895,  8149, 10235, 12825, 16868, 19882 ]) / 4096

SNS_MPVQ_OFFSETS = np.array([
    [ 0, 1,  1,   1,    1,     1,      1,      1,      1,       1,       1 ],
    [ 0, 1,  3,   5,    7,     9,     11,     13,     15,      17,      19 ],
    [ 0, 1,  5,  13,   25,    41,     61,     85,    113,     145,     181 ],
    [ 0, 1,  7,  25,   63,   129,    231,    377,    575,     833,    1159 ],
    [ 0, 1,  9,  41,  129,   321,    681,   1289,   2241,    3649,    5641 ],
    [ 0, 1, 11,  61,  231,   681,   1683,   3653,   7183,   13073  , 22363 ],
    [ 0, 1, 13,  85,  377,  1289,   3653,   8989,  19825,   40081,   75517 ],
    [ 0, 1, 15, 113,  575,  2241,   7183,  19825,  48639,  108545,  224143 ],
    [ 0, 1, 17, 145,  833,  3649,  13073,  40081, 108545,  265729,  598417 ],
    [ 0, 1, 19, 181, 1159,  5641,  22363,  75517, 224143,  598417, 1462563 ],
    [ 0, 1, 21, 221, 1561,  8361,  36365, 134245, 433905, 1256465, 3317445 ],
    [ 0, 1, 23, 265, 2047, 11969,  56695, 227305, 795455, 2485825, 7059735 ],
    [ 0, 1, 25, 313, 2625, 16641,  85305, 369305,1392065, 4673345,14218905 ],
    [ 0, 1, 27, 365, 3303, 22569, 124515, 579125,2340495, 8405905,27298155 ],
    [ 0, 1, 29, 421, 4089, 29961, 177045, 880685,3800305,14546705,50250765 ],
    [ 0, 1, 31, 481, 4991, 39041, 246047,1303777,5984767,24331777,89129247 ],
])

### 3.7.5 ###

TNS_ORDER_BITS = np.array([
    [ 0, 17234, 13988, 11216, 8694, 6566, 4977, 3961, 3040 ],
    [ 0, 12683,  9437,  6874, 5541, 5121, 5170, 5359, 5056 ]
])

TNS_ORDER_FREQ = np.array([
    [  3,  9,  23,  54, 111, 190, 268, 366 ],
    [ 14, 42, 100, 157, 181, 178, 167, 185 ]
])

TNS_ORDER_CUMFREQ = np.array([
    [ 0,  3, 12,  35,  89, 200, 390, 658 ],
    [ 0, 14, 56, 156, 313, 494, 672, 839 ]
])

TNS_COEF_BITS = np.array([

    [ 20480, 15725, 12479, 10334,  8694,  7320,  6964,  6335,
       5504,  5637,  6566,  6758,  8433, 11348, 15186, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 12902,  9368,  7057,  5901,
       5254,  5485,  5598,  6076,  7608, 10742, 15186, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 13988,  9368,  6702,  4841,
       4585,  4682,  5859,  7764, 12109, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 18432, 13396,  8982,  4767,
       3779,  3658,  6335,  9656, 13988, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 14731,  9437,  4275,
       3249,  3493,  8483, 13988, 17234, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 12902,  4753,
       3040,  2953,  9105, 15725, 20480, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 12902,  3821,
       3346,  3000, 12109, 20480, 20480, 20480, 20480, 20480, 20480 ],

    [ 20480, 20480, 20480, 20480, 20480, 20480, 15725,  3658,
      20480,  1201, 10854, 18432, 20480, 20480, 20480, 20480, 20480 ]

])

TNS_COEF_FREQ = np.array([
    [ 1, 5, 15, 31, 54, 86,  97, 120, 159, 152, 111, 104, 59, 22, 6, 1, 1 ],
    [ 1, 1,  1,  1, 13, 43,  94, 139, 173, 160, 154, 131, 78, 27, 6, 1, 1 ],
    [ 1, 1,  1,  1,  9, 43, 106, 199, 217, 210, 141,  74, 17,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  2, 11,  49, 204, 285, 297, 120,  39,  9,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  7,  42, 241, 341, 314,  58,   9,  3,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,  13, 205, 366, 377,  47,   5,  1,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,  13, 281, 330, 371,  17,   1,  1,  1, 1, 1, 1 ],
    [ 1, 1,  1,  1,  1,  1,   5, 297,   1, 682,  26,   2,  1,  1, 1, 1, 1 ]
])

TNS_COEF_CUMFREQ = np.array([

    [    0,    1,    6,   21,   52,  106,  192,  289,
       409,  568,  720,  831,  935,  994, 1016, 1022, 1023 ],

    [    0,    1,    2,    3,    4,   17,   60,  154,
       293,  466,  626,  780,  911,  989, 1016, 1022, 1023 ],

    [    0,    1,    2,    3,    4,   13,   56,  162,
       361,  578,  788,  929, 1003, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    6,   17,   66,
       270,  555,  852,  972, 1011, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,   12,   54,
       295,  636,  950, 1008, 1017, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   19,
       224,  590,  967, 1014, 1019, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   19,
       300,  630, 1001, 1018, 1019, 1020, 1021, 1022, 1023 ],

    [    0,    1,    2,    3,    4,    5,    6,   11,
       308,  309,  991, 1017, 1019, 1020, 1021, 1022, 1023 ],

])


### 3.7.6 ###

LTPF_H12K8 = np.array([
    -2.04305583e-05, -4.46345894e-05, -7.16366399e-05, -1.00101113e-04,
    -1.28372848e-04, -1.54543830e-04, -1.76544567e-04, -1.92256960e-04,
    -1.99643819e-04, -1.96888686e-04, -1.82538332e-04, -1.55639427e-04,
    -1.15860365e-04, -6.35893034e-05,  2.81006480e-19,  7.29218021e-05,
     1.52397076e-04,  2.34920777e-04,  3.16378650e-04,  3.92211738e-04,
     4.57623849e-04,  5.07824294e-04,  5.38295523e-04,  5.45072918e-04,
     5.25022155e-04,  4.76098424e-04,  3.97571380e-04,  2.90200217e-04,
     1.56344667e-04, -5.81880142e-19, -1.73252713e-04, -3.56385965e-04,
    -5.41155231e-04, -7.18414023e-04, -8.78505232e-04, -1.01171451e-03,
    -1.10876706e-03, -1.16134522e-03, -1.16260169e-03, -1.10764097e-03,
    -9.93941563e-04, -8.21692190e-04, -5.94017766e-04, -3.17074654e-04,
     9.74695082e-19,  3.45293760e-04,  7.04480871e-04,  1.06133447e-03,
     1.39837473e-03,  1.69763080e-03,  1.94148675e-03,  2.11357591e-03,
     2.19968245e-03,  2.18860625e-03,  2.07294546e-03,  1.84975249e-03,
     1.52102188e-03,  1.09397426e-03,  5.81108062e-04, -1.42248266e-18,
    -6.27153730e-04, -1.27425140e-03, -1.91223839e-03, -2.51026925e-03,
    -3.03703830e-03, -3.46222687e-03, -3.75800672e-03, -3.90053247e-03,
    -3.87135231e-03, -3.65866558e-03, -3.25835851e-03, -2.67475555e-03,
    -1.92103305e-03, -1.01925433e-03,  1.86962369e-18,  1.09841545e-03,
     2.23113197e-03,  3.34830927e-03,  4.39702277e-03,  5.32342672e-03,
     6.07510531e-03,  6.60352025e-03,  6.86645399e-03,  6.83034270e-03,
     6.47239234e-03,  5.78237521e-03,  4.76401273e-03,  3.43586351e-03,
     1.83165284e-03, -2.25189837e-18, -1.99647619e-03, -4.08266886e-03,
    -6.17308037e-03, -8.17444895e-03, -9.98882386e-03, -1.15169871e-02,
    -1.26621006e-02, -1.33334458e-02, -1.34501120e-02, -1.29444881e-02,
    -1.17654154e-02, -9.88086732e-03, -7.28003640e-03, -3.97473021e-03,
     2.50961778e-18,  4.58604422e-03,  9.70324900e-03,  1.52512477e-02,
     2.11120585e-02,  2.71533724e-02,  3.32324245e-02,  3.92003203e-02,
     4.49066644e-02,  5.02043309e-02,  5.49542017e-02,  5.90297032e-02,
     6.23209727e-02,  6.47385023e-02,  6.62161245e-02,  6.67132287e-02,
     6.62161245e-02,  6.47385023e-02,  6.23209727e-02,  5.90297032e-02,
     5.49542017e-02,  5.02043309e-02,  4.49066644e-02,  3.92003203e-02,
     3.32324245e-02,  2.71533724e-02,  2.11120585e-02,  1.52512477e-02,
     9.70324900e-03,  4.58604422e-03,  2.50961778e-18, -3.97473021e-03,
    -7.28003640e-03, -9.88086732e-03, -1.17654154e-02, -1.29444881e-02,
    -1.34501120e-02, -1.33334458e-02, -1.26621006e-02, -1.15169871e-02,
    -9.98882386e-03, -8.17444895e-03, -6.17308037e-03, -4.08266886e-03,
    -1.99647619e-03, -2.25189837e-18,  1.83165284e-03,  3.43586351e-03,
     4.76401273e-03,  5.78237521e-03,  6.47239234e-03,  6.83034270e-03,
     6.86645399e-03,  6.60352025e-03,  6.07510531e-03,  5.32342672e-03,
     4.39702277e-03,  3.34830927e-03,  2.23113197e-03,  1.09841545e-03,
     1.86962369e-18, -1.01925433e-03, -1.92103305e-03, -2.67475555e-03,
    -3.25835851e-03, -3.65866558e-03, -3.87135231e-03, -3.90053247e-03,
    -3.75800672e-03, -3.46222687e-03, -3.03703830e-03, -2.51026925e-03,
    -1.91223839e-03, -1.27425140e-03, -6.27153730e-04, -1.42248266e-18,
     5.81108062e-04,  1.09397426e-03,  1.52102188e-03,  1.84975249e-03,
     2.07294546e-03,  2.18860625e-03,  2.19968245e-03,  2.11357591e-03,
     1.94148675e-03,  1.69763080e-03,  1.39837473e-03,  1.06133447e-03,
     7.04480871e-04,  3.45293760e-04,  9.74695082e-19, -3.17074654e-04,
    -5.94017766e-04, -8.21692190e-04, -9.93941563e-04, -1.10764097e-03,
    -1.16260169e-03, -1.16134522e-03, -1.10876706e-03, -1.01171451e-03,
    -8.78505232e-04, -7.18414023e-04, -5.41155231e-04, -3.56385965e-04,
    -1.73252713e-04, -5.81880142e-19,  1.56344667e-04,  2.90200217e-04,
     3.97571380e-04,  4.76098424e-04,  5.25022155e-04,  5.45072918e-04,
     5.38295523e-04,  5.07824294e-04,  4.57623849e-04,  3.92211738e-04,
     3.16378650e-04,  2.34920777e-04,  1.52397076e-04,  7.29218021e-05,
     2.81006480e-19, -6.35893034e-05, -1.15860365e-04, -1.55639427e-04,
    -1.82538332e-04, -1.96888686e-04, -1.99643819e-04, -1.92256960e-04,
    -1.76544567e-04, -1.54543830e-04, -1.28372848e-04, -1.00101113e-04,
    -7.16366399e-05, -4.46345894e-05, -2.04305583e-05
])

LTPF_H4 = np.array([
    -2.87456116e-03, -3.00125103e-03,  2.74547165e-03,  1.53572770e-02,
     2.86823405e-02,  2.95038503e-02,  4.59833449e-03, -4.72963246e-02,
    -1.05835916e-01, -1.30305021e-01, -7.54404636e-02,  8.35788573e-02,
     3.30182571e-01,  6.03297008e-01,  8.17488686e-01,  8.98638285e-01,
     8.17488686e-01,  6.03297008e-01,  3.30182571e-01,  8.35788573e-02,
    -7.54404636e-02, -1.30305021e-01, -1.05835916e-01, -4.72963246e-02,
     4.59833449e-03,  2.95038503e-02,  2.86823405e-02,  1.53572770e-02,
     2.74547165e-03, -3.00125103e-03, -2.87456116e-03
])

LTPF_HI = np.array([
     6.69885837e-03,  3.96711478e-02,  1.06999186e-01,  2.09880463e-01,
     3.35690625e-01,  4.59220930e-01,  5.50075002e-01,  5.83527575e-01,
     5.50075002e-01,  4.59220930e-01,  3.35690625e-01,  2.09880463e-01,
     1.06999186e-01,  3.96711478e-02,  6.69885837e-03
])

LTPF_N_8K = np.array([
    [  6.02361821e-01,  4.19760926e-01, -1.88342453e-02 ],
    [  5.99476858e-01,  4.19760926e-01, -1.59492828e-02 ],
    [  5.96776466e-01,  4.19760926e-01, -1.32488910e-02 ],
    [  5.94241012e-01,  4.19760926e-01, -1.07134366e-02 ],
])

LTPF_N_16K = np.array([
    [  6.02361821e-01,  4.19760926e-01, -1.88342453e-02 ],
    [  5.99476858e-01,  4.19760926e-01, -1.59492828e-02 ],
    [  5.96776466e-01,  4.19760926e-01, -1.32488910e-02 ],
    [  5.94241012e-01,  4.19760926e-01, -1.07134366e-02 ],
])

LTPF_N_24K = np.array([

    [  3.98969559e-01,  5.14250861e-01,  1.00438297e-01, -1.27889396e-02,
      -1.57228008e-03 ],

    [  3.94863491e-01,  5.12381921e-01,  1.04319493e-01, -1.09199996e-02,
      -1.34740833e-03 ],

    [  3.90984448e-01,  5.10605352e-01,  1.07983252e-01, -9.14343107e-03,
      -1.13212462e-03 ],

    [  3.87309389e-01,  5.08912208e-01,  1.11451738e-01, -7.45028713e-03,
      -9.25551405e-04 ],

])

LTPF_N_32K = np.array([

    [  2.98237945e-01,  4.65280920e-01,  2.10599743e-01,  3.76678038e-02,
      -1.01569616e-02, -2.53588100e-03, -3.18294617e-04 ],

    [  2.94383415e-01,  4.61929400e-01,  2.12946577e-01,  4.06617500e-02,
      -8.69327230e-03, -2.17830711e-03, -2.74288806e-04 ],

    [  2.90743921e-01,  4.58746191e-01,  2.15145697e-01,  4.35010477e-02,
      -7.29549535e-03, -1.83439564e-03, -2.31692019e-04 ],

    [  2.87297585e-01,  4.55714889e-01,  2.17212695e-01,  4.62008888e-02,
      -5.95746380e-03, -1.50293428e-03, -1.90385191e-04 ],

])

LTPF_N_48K = np.array([

    [  1.98136374e-01,  3.52449490e-01,  2.51369527e-01,  1.42414624e-01,
       5.70473102e-02,  9.29336624e-03, -7.22602537e-03, -3.17267989e-03,
      -1.12183596e-03, -2.90295724e-04, -4.27081559e-05 ],

    [  1.95070943e-01,  3.48466041e-01,  2.50998846e-01,  1.44116741e-01,
       5.92894732e-02,  1.10892383e-02, -6.19290811e-03, -2.72670551e-03,
      -9.66712583e-04, -2.50810092e-04, -3.69993877e-05 ],

    [  1.92181006e-01,  3.44694556e-01,  2.50622009e-01,  1.45710245e-01,
       6.14113213e-02,  1.27994140e-02, -5.20372109e-03, -2.29732451e-03,
      -8.16560813e-04, -2.12385575e-04, -3.14127133e-05 ],

    [  1.89448531e-01,  3.41113925e-01,  2.50240688e-01,  1.47206563e-01,
       6.34247723e-02,  1.44320343e-02, -4.25444914e-03, -1.88308147e-03,
      -6.70961906e-04, -1.74936334e-04, -2.59386474e-05 ],

])

LTPF_D_8K = np.array([

    [  0.00000000e+00,  2.09880463e-01,  5.83527575e-01,  2.09880463e-01,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.06999186e-01,  5.50075002e-01,  3.35690625e-01,
       6.69885837e-03 ],

    [  0.00000000e+00,  3.96711478e-02,  4.59220930e-01,  4.59220930e-01,
       3.96711478e-02 ],

    [  0.00000000e+00,  6.69885837e-03,  3.35690625e-01,  5.50075002e-01,
       1.06999186e-01 ],

])

LTPF_D_16K = np.array([

    [  0.00000000e+00,  2.09880463e-01,  5.83527575e-01,  2.09880463e-01,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.06999186e-01,  5.50075002e-01,  3.35690625e-01,
       6.69885837e-03 ],

    [  0.00000000e+00,  3.96711478e-02,  4.59220930e-01,  4.59220930e-01,
       3.96711478e-02 ],

    [  0.00000000e+00,  6.69885837e-03,  3.35690625e-01,  5.50075002e-01,
       1.06999186e-01 ],

])

LTPF_D_24K = np.array([

    [  0.00000000e+00,  6.32223163e-02,  2.50730961e-01,  3.71390943e-01,
       2.50730961e-01,  6.32223163e-02,  0.00000000e+00 ],

    [  0.00000000e+00,  3.45927217e-02,  1.98651560e-01,  3.62641173e-01,
       2.98675055e-01,  1.01309287e-01,  4.26354371e-03 ],

    [  0.00000000e+00,  1.53574678e-02,  1.47434488e-01,  3.37425955e-01,
       3.37425955e-01,  1.47434488e-01,  1.53574678e-02 ],

    [  0.00000000e+00,  4.26354371e-03,  1.01309287e-01,  2.98675055e-01,
       3.62641173e-01,  1.98651560e-01,  3.45927217e-02 ],

])

LTPF_D_32K = np.array([

    [  0.00000000e+00,  2.90040188e-02,  1.12985742e-01,  2.21202403e-01,
       2.72390947e-01,  2.21202403e-01,  1.12985742e-01,  2.90040188e-02,
       0.00000000e+00 ],

    [  0.00000000e+00,  1.70315342e-02,  8.72250379e-02,  1.96140776e-01,
       2.68923798e-01,  2.42499910e-01,  1.40577336e-01,  4.47487717e-02,
       3.12703024e-03 ],

    [  0.00000000e+00,  8.56367375e-03,  6.42622294e-02,  1.68767671e-01,
       2.58744594e-01,  2.58744594e-01,  1.68767671e-01,  6.42622294e-02,
       8.56367375e-03 ],

    [  0.00000000e+00,  3.12703024e-03,  4.47487717e-02,  1.40577336e-01,
       2.42499910e-01,  2.68923798e-01,  1.96140776e-01,  8.72250379e-02,
       1.70315342e-02 ],

])

LTPF_D_48K = np.array([

    [  0.00000000e+00,  1.08235939e-02,  3.60896922e-02,  7.67640147e-02,
       1.24153058e-01,  1.62759644e-01,  1.77677142e-01,  1.62759644e-01,
       1.24153058e-01,  7.67640147e-02,  3.60896922e-02,  1.08235939e-02,
       0.00000000e+00 ],

    [  0.00000000e+00,  7.04140493e-03,  2.81970232e-02,  6.54704494e-02,
       1.12464799e-01,  1.54841896e-01,  1.76712238e-01,  1.69150721e-01,
       1.35290158e-01,  8.85142501e-02,  4.49935385e-02,  1.55761371e-02,
       2.03972196e-03 ],

    [  0.00000000e+00,  4.14699847e-03,  2.13575731e-02,  5.48273558e-02,
       1.00497144e-01,  1.45606034e-01,  1.73843984e-01,  1.73843984e-01,
       1.45606034e-01,  1.00497144e-01,  5.48273558e-02,  2.13575731e-02,
       4.14699847e-03 ],

    [  0.00000000e+00,  2.03972196e-03,  1.55761371e-02,  4.49935385e-02,
       8.85142501e-02,  1.35290158e-01,  1.69150721e-01,  1.76712238e-01,
       1.54841896e-01,  1.12464799e-01,  6.54704494e-02,  2.81970232e-02,
       7.04140493e-03 ],

])

### 3.7.7 ###

AC_SPEC_LOOKUP = np.array([
     1, 39,  7, 25, 22, 22, 28, 22, 22, 22, 22, 28, 28, 28, 34, 31,
    31, 40, 43, 46, 49, 52, 14, 17, 36, 36, 36, 38,  0, 57, 38, 22,
     0,  8,  9, 11, 47, 14, 14, 17, 36, 36, 36, 38, 59, 59, 38, 22,
    22, 26, 46, 29, 30, 32, 33, 35, 36, 36, 36, 38,  0, 59, 23, 22,
    46, 46, 45, 47, 48, 50, 50, 18, 54, 54, 54, 38, 59, 59, 59, 22,
     0, 62, 63,  3, 33,  2,  2, 61, 20, 20, 20, 21, 59, 59, 39, 28,
    28, 63, 63,  3, 33,  2,  2, 61, 38, 38, 38, 21, 59, 59, 39, 28,
    28,  6,  6,  6,  2, 18, 61, 20, 21, 21, 21, 59, 39, 39,  7, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 51, 51, 51, 53, 54, 20, 38, 38, 57, 39, 39, 39,  7, 24, 34,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4, 56, 38, 57, 57, 59,  7,  7,  7, 42, 42, 34,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  5,  4,  4,  5, 21, 21, 59,  7,  7,  7,  7, 25, 25, 25, 34,
     4,  4,  4,  4,  5, 23, 23, 39,  7,  7,  7, 42, 25, 25, 22, 31,
    31, 39, 39, 39, 39,  7,  7, 42,  0, 25, 22, 22, 22, 28, 34, 31,
    55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
    55, 55, 40,  8,  9, 49, 49, 52, 17, 17, 17,  4,  0, 20, 17, 60,
    40, 40,  8, 43, 27, 49, 49, 14, 17, 17, 17, 36, 42, 42, 17, 57,
    57, 40,  8, 26, 27, 49, 12, 14, 17, 17, 17, 36,  0, 38, 36,  1,
     8,  8, 43,  9, 11, 49, 12, 14, 14, 33, 50, 50, 50, 61, 36, 39,
     8,  8, 43, 46, 49, 52, 30, 14, 14, 33, 50, 50, 50, 50, 18, 25,
     8,  8, 43, 46, 49, 52, 30, 14, 14, 18,  5,  5,  5, 61, 18, 23,
    43, 43, 43,  9, 49, 52,  3, 14, 14, 50, 50, 50, 50, 61, 17, 24,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
    43, 43, 43,  9, 11, 52, 52, 14, 14, 17, 61, 61, 61, 54, 17, 39,
    45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 44, 27, 29, 52, 48, 52, 52, 17, 17, 17, 17,  2, 17,  7,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27,  9, 27, 27, 12, 52, 14, 14, 58, 41, 41, 41,  6, 17, 37,
     9,  9,  9, 27, 11, 49, 12, 52, 14, 14, 14, 50,  0, 53, 17, 28,
    52, 52, 49, 52, 12, 52, 30, 14, 14, 17,  2,  2,  2, 38, 38, 34,
    31, 34, 34, 31, 31, 31, 31, 19, 19, 19, 19, 19, 19, 19, 31, 19,
    44, 44, 62, 30, 32, 58, 35, 36, 36, 38,  0, 59,  7,  7, 39, 34,
    34, 45, 47, 48, 33, 35, 35, 36, 38, 38, 38, 59,  7,  7, 39, 34,
    34, 62, 30, 15, 50, 53, 53, 54, 21, 21, 21, 59,  7,  7,  7, 34,
    30, 30, 48, 33, 58, 18, 18, 56, 23, 23, 23, 59,  7,  7, 24, 34,
    34,  6,  6, 58, 53, 54, 54, 21, 59, 59, 59, 39,  7,  7, 42, 34,
     6,  6, 33, 58, 53, 54, 61, 21, 59, 59, 59, 39,  7,  7, 42, 34,
    34, 51, 51, 53, 54, 56, 56, 57, 39, 39, 39,  7, 42, 42, 25, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  4,  4,  4,  5, 23, 23, 39,  7,  7,  7, 42, 25, 25, 22, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  5,  5,  5,  5, 57, 57, 39, 24, 24, 24, 42, 22, 22, 28, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 41, 41, 41, 41, 39, 39,  7, 42, 42, 42, 25, 28, 28, 28, 31,
    31, 41, 41, 41, 41, 39, 39, 24, 25, 25, 25, 22, 28, 28, 34, 31,
    31, 10, 10, 10, 10, 10, 10, 28, 34, 34, 34, 34, 34, 34, 31, 19,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  9, 11, 47, 32, 50, 18, 18, 20, 21, 21, 21, 39, 59, 34,
    26, 26, 27, 29, 30, 33, 50, 18, 18, 20, 57, 57, 57, 59, 59, 34,
    27, 27, 11, 12, 48, 50, 58, 61, 61, 56, 57, 57, 57, 59, 39, 34,
    45, 45, 12, 30, 32,  2,  2, 61, 38, 38, 38, 57,  0, 59, 39, 34,
    63, 63,  3, 32, 58, 18, 18, 20, 21, 21, 21, 59, 39, 39,  7, 31,
    31,  3,  3, 33, 58, 18, 18, 20, 21, 21, 21, 59,  7,  7,  7, 31,
     6,  6, 51, 51, 53, 54, 54, 38, 57, 57, 57, 39,  7,  7, 42, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 51, 53, 53, 54, 56, 56, 57, 59, 59, 59,  7, 24, 24, 25, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  4,  4,  4, 54, 21, 21, 57, 39, 39, 39,  7, 42, 42, 22, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31,  5,  5,  5,  5, 23, 23, 59,  7,  7,  7, 42, 22, 22, 28, 31,
    31,  4,  4,  4,  5, 23, 23, 39, 24, 24, 24, 25, 28, 28, 34, 31,
    31, 10, 10, 10, 10, 10, 10, 28, 34, 34, 34, 31, 31, 31, 31, 19,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 16,
    16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 60,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,
     0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 16,
    60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 16,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 13,  0, 13, 13, 13, 13, 13, 13, 13, 60, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 16,
    13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 37,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 13,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13,  0, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0, 19, 13, 13, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 19,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    60, 13, 13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 60, 16,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 60, 60, 60, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 60,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 60,
    13, 13, 13, 13, 13, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0, 13, 13, 13, 13,  0,  0,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 60,
    60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
])

AC_SPEC_BITS = np.array([

    [ 20480, 20480,  5220,  9042, 20480, 20480,  6619,  9892,
       5289,  6619,  9105, 11629,  8982,  9892, 11629, 13677,  4977 ],

    [ 11940, 10854, 12109, 13677, 10742,  9812, 11090, 12288,
      11348, 10240, 11348, 12683, 12109, 10854, 11629, 12902,  1197 ],

    [  7886,  7120,  8982, 10970,  7496,  6815,  8334, 10150,
       9437,  8535,  9656, 11216, 11348, 10431, 11348, 12479,  4051 ],

    [  5485,  6099,  9168, 11940,  6311,  6262,  8640, 11090,
       9233,  8640, 10334, 12479, 11781, 11090, 12479, 13988,  6009 ],

    [  7886,  7804, 10150, 11940,  7886,  7685,  9368, 10854,
      10061,  9300, 10431, 11629, 11629, 10742, 11485, 12479,  2763 ],

    [  9042,  8383, 10240, 11781,  8483,  8013,  9437, 10742,
      10334,  9437, 10431, 11485, 11781, 10742, 11485, 12288,  2346 ],

    [  5922,  6619,  9368, 11940,  6566,  6539,  8750, 10970,
       9168,  8640, 10240, 12109, 11485, 10742, 11940, 13396,  5009 ],

    [ 12288, 11090, 11348, 12109, 11090,  9892, 10334, 10970,
      11629, 10431, 10970, 11629, 12479, 11348, 11781, 12288,  1289 ],

    [  1685,  5676, 13138, 18432,  5598,  7804, 13677, 18432,
      12683, 13396, 17234, 20480, 17234, 17234, 20480, 20480, 15725 ],

    [  2793,  5072, 10970, 15725,  5204,  6487, 11216, 15186,
      10970, 11216, 14336, 17234, 15186, 15186, 17234, 18432, 12109 ],

    [ 12902, 11485, 11940, 13396, 11629, 10531, 11348, 12479,
      12683, 11629, 12288, 13138, 13677, 12683, 13138, 13677,   854 ],

    [  3821,  5088,  9812, 13988,  5289,  5901,  9812, 13677,
       9976,  9892, 12479, 15186, 13988, 13677, 15186, 17234,  9812 ],

    [  4856,  5412,  9168, 12902,  5598,  5736,  8863, 12288,
       9368,  8982, 11090, 13677, 12902, 12288, 13677, 15725,  8147 ],

    [ 20480, 20480,  7088,  9300, 20480, 20480,  7844,  9733,
       7320,  7928,  9368, 10970,  9581,  9892, 10970, 12288,  2550 ],

    [  6031,  5859,  8192, 10635,  6410,  6286,  8433, 10742,
       9656,  9042, 10531, 12479, 12479, 11629, 12902, 14336,  5756 ],

    [  6144,  6215,  8982, 11940,  6262,  6009,  8433, 11216,
       8982,  8433, 10240, 12479, 11781, 11090, 12479, 13988,  5817 ],

    [ 20480, 20480, 11216, 12109, 20480, 20480, 11216, 11940,
      11629, 11485, 11940, 12479, 12479, 12109, 12683, 13138,   704 ],

    [  7928,  6994,  8239,  9733,  7218,  6539,  8147,  9892,
       9812,  9105, 10240, 11629, 12109, 11216, 12109, 13138,  4167 ],

    [  8640,  7724,  9233, 10970,  8013,  7185,  8483, 10150,
       9656,  8694,  9656, 10970, 11348, 10334, 11090, 12288,  3391 ],

    [ 20480, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
      18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,    91 ],

    [ 10061,  8863,  9733, 11090,  8982,  7970,  8806,  9976,
      10061,  9105,  9812, 10742, 11485, 10334, 10970, 11781,  2557 ],

    [ 10431,  9368, 10240, 11348,  9368,  8433,  9233, 10334,
      10431,  9437, 10061, 10970, 11781, 10635, 11216, 11940,  2119 ],

    [ 13988, 12479, 12683, 12902, 12683, 11348, 11485, 11940,
      12902, 11629, 11940, 12288, 13396, 12109, 12479, 12683,   828 ],

    [ 10431,  9300, 10334, 11629,  9508,  8483,  9437, 10635,
      10635,  9656, 10431, 11348, 11940, 10854, 11485, 12288,  1946 ],

    [ 12479, 11216, 11629, 12479, 11348, 10150, 10635, 11348,
      11940, 10854, 11216, 11940, 12902, 11629, 11940, 12479,  1146 ],

    [ 13396, 12109, 12288, 12902, 12109, 10854, 11216, 11781,
      12479, 11348, 11629, 12109, 13138, 11940, 12288, 12683,   928 ],

    [  2443,  5289, 11629, 16384,  5170,  6730, 11940, 16384,
      11216, 11629, 14731, 18432, 15725, 15725, 18432, 20480, 13396 ],

    [  3328,  5009, 10531, 15186,  5040,  6031, 10531, 14731,
      10431, 10431, 13396, 16384, 15186, 14731, 16384, 18432, 11629 ],

    [ 14336, 12902, 12902, 13396, 12902, 11629, 11940, 12288,
      13138, 12109, 12288, 12902, 13677, 12683, 12902, 13138,   711 ],

    [  4300,  5204,  9437, 13396,  5430,  5776,  9300, 12902,
       9656,  9437, 11781, 14731, 13396, 12902, 14731, 16384,  8982 ],

    [  5394,  5776,  8982, 12288,  5922,  5901,  8640, 11629,
       9105,  8694, 10635, 13138, 12288, 11629, 13138, 14731,  6844 ],

    [ 17234, 15725, 15725, 15725, 15725, 14731, 14731, 14731,
      16384, 14731, 14731, 15186, 16384, 15186, 15186, 15186,   272 ],

    [  6461,  6286,  8806, 11348,  6566,  6215,  8334, 10742,
       9233,  8535, 10061, 12109, 11781, 10970, 12109, 13677,  5394 ],

    [  6674,  6487,  8863, 11485,  6702,  6286,  8334, 10635,
       9168,  8483,  9976, 11940, 11629, 10854, 11940, 13396,  5105 ],

    [ 15186, 13677, 13677, 13988, 13677, 12479, 12479, 12683,
      13988, 12683, 12902, 13138, 14336, 13138, 13396, 13677,   565 ],

    [  7844,  7252,  8922, 10854,  7389,  6815,  8383, 10240,
       9508,  8750,  9892, 11485, 11629, 10742, 11629, 12902,  3842 ],

    [  9233,  8239,  9233, 10431,  8334,  7424,  8483,  9892,
      10061,  9105, 10061, 11216, 11781, 10742, 11485, 12479,  2906 ],

    [ 20480, 20480, 14731, 14731, 20480, 20480, 14336, 14336,
      15186, 14336, 14731, 14731, 15186, 14731, 14731, 15186,   266 ],

    [ 10531,  9300,  9976, 11090,  9437,  8286,  9042, 10061,
      10431,  9368,  9976, 10854, 11781, 10531, 11090, 11781,  2233 ],

    [ 11629, 10334, 10970, 12109, 10431,  9368, 10061, 10970,
      11348, 10240, 10854, 11485, 12288, 11216, 11629, 12288,  1469 ],

    [   952,  6787, 15725, 20480,  6646,  9733, 16384, 20480,
      14731, 15725, 18432, 20480, 18432, 20480, 20480, 20480, 18432 ],

    [  9437,  8806, 10742, 12288,  8982,  8483,  9892, 11216,
      10742,  9892, 10854, 11940, 12109, 11090, 11781, 12683,  1891 ],

    [ 12902, 11629, 11940, 12479, 11781, 10531, 10854, 11485,
      12109, 10970, 11348, 11940, 12902, 11781, 12109, 12479,  1054 ],

    [  2113,  5323, 11781, 16384,  5579,  7252, 12288, 16384,
      11781, 12288, 15186, 18432, 15725, 16384, 18432, 20480, 12902 ],

    [  2463,  5965, 11348, 15186,  5522,  6934, 11216, 14731,
      10334, 10635, 13677, 16384, 13988, 13988, 15725, 18432, 10334 ],

    [  3779,  5541,  9812, 13677,  5467,  6122,  9656, 13138,
       9581,  9437, 11940, 14731, 13138, 12683, 14336, 16384,  8982 ],

    [  3181,  5154, 10150, 14336,  5448,  6311, 10334, 13988,
      10334, 10431, 13138, 15725, 14336, 13988, 15725, 18432, 10431 ],

    [  4841,  5560,  9105, 12479,  5756,  5944,  8922, 12109,
       9300,  8982, 11090, 13677, 12479, 12109, 13677, 15186,  7460 ],

    [  5859,  6009,  8922, 11940,  6144,  5987,  8483, 11348,
       9042,  8535, 10334, 12683, 11940, 11216, 12683, 14336,  6215 ],

    [  4250,  4916,  8587, 12109,  5901,  6191,  9233, 12288,
      10150,  9892, 11940, 14336, 13677, 13138, 14731, 16384,  8383 ],

    [  7153,  6702,  8863, 11216,  6904,  6410,  8239, 10431,
       9233,  8433,  9812, 11629, 11629, 10742, 11781, 13138,  4753 ],

    [  6674,  7057,  9508, 11629,  7120,  6964,  8806, 10635,
       9437,  8750, 10061, 11629, 11485, 10531, 11485, 12683,  4062 ],

    [  5341,  5289,  8013, 10970,  6311,  6262,  8640, 11090,
      10061,  9508, 11090, 13138, 12902, 12288, 13396, 15186,  6539 ],

    [  8057,  7533,  9300, 11216,  7685,  7057,  8535, 10334,
       9508,  8694,  9812, 11216, 11485, 10431, 11348, 12479,  3541 ],

    [  9168,  8239,  9656, 11216,  8483,  7608,  8806, 10240,
       9892,  8982,  9812, 11090, 11485, 10431, 11090, 12109,  2815 ],

    [   558,  7928, 18432, 20480,  7724, 12288, 20480, 20480,
      18432, 20480, 20480, 20480, 20480, 20480, 20480, 20480, 20480 ],

    [  9892,  8806,  9976, 11348,  9042,  8057,  9042, 10240,
      10240,  9233,  9976, 11090, 11629, 10531, 11216, 12109,  2371 ],

    [ 11090,  9812, 10531, 11629,  9976,  8863,  9508, 10531,
      10854,  9733, 10334, 11090, 11940, 10742, 11216, 11940,  1821 ],

    [  7354,  6964,  9042, 11216,  7153,  6592,  8334, 10431,
       9233,  8483,  9812, 11485, 11485, 10531, 11629, 12902,  4349 ],

    [ 11348, 10150, 10742, 11629, 10150,  9042,  9656, 10431,
      10854,  9812, 10431, 11216, 12109, 10970, 11485, 12109,  1700 ],

    [ 20480, 20480,  8694, 10150, 20480, 20480,  8982, 10240,
       8982,  9105,  9976, 10970, 10431, 10431, 11090, 11940,  1610 ],

    [  9233,  8192,  9368, 10970,  8286,  7496,  8587,  9976,
       9812,  8863,  9733, 10854, 11348, 10334, 11090, 11940,  3040 ],

    [  4202,  5716,  9733, 13138,  5598,  6099,  9437, 12683,
       9300,  9168, 11485, 13988, 12479, 12109, 13988, 15725,  7804 ],

    [  4400,  5965,  9508, 12479,  6009,  6360,  9105, 11781,
       9300,  8982, 10970, 13138, 12109, 11629, 13138, 14731,  6994 ]
])

AC_SPEC_CUMFREQ = np.array([

    [    0,    1,    2,  177,  225,  226,  227,  336,
       372,  543,  652,  699,  719,  768,  804,  824,  834 ],

    [    0,   18,   44,   61,   71,   98,  135,  159,
       175,  197,  229,  251,  265,  282,  308,  328,  341 ],

    [    0,   71,  163,  212,  237,  318,  420,  481,
       514,  556,  613,  652,  675,  697,  727,  749,  764 ],

    [    0,  160,  290,  336,  354,  475,  598,  653,
       677,  722,  777,  808,  823,  842,  866,  881,  890 ],

    [    0,   71,  144,  177,  195,  266,  342,  385,
       411,  445,  489,  519,  539,  559,  586,  607,  622 ],

    [    0,   48,  108,  140,  159,  217,  285,  327,
       354,  385,  427,  457,  478,  497,  524,  545,  561 ],

    [    0,  138,  247,  290,  308,  419,  531,  584,
       609,  655,  710,  742,  759,  780,  807,  825,  836 ],

    [    0,   16,   40,   62,   79,  103,  139,  170,
       195,  215,  245,  270,  290,  305,  327,  346,  362 ],

    [    0,  579,  729,  741,  743,  897,  970,  980,
       982,  996, 1007, 1010, 1011, 1014, 1017, 1018, 1019 ],

    [    0,  398,  582,  607,  612,  788,  902,  925,
       931,  956,  979,  987,  990,  996, 1002, 1005, 1007 ],

    [    0,   13,   34,   52,   63,   83,  112,  134,
       149,  163,  183,  199,  211,  221,  235,  247,  257 ],

    [    0,  281,  464,  501,  510,  681,  820,  857,
       867,  902,  938,  953,  959,  968,  978,  984,  987 ],

    [    0,  198,  362,  408,  421,  575,  722,  773,
       789,  832,  881,  905,  915,  928,  944,  954,  959 ],

    [    0,    1,    2,   95,  139,  140,  141,  213,
       251,  337,  407,  450,  475,  515,  551,  576,  592 ],

    [    0,  133,  274,  338,  366,  483,  605,  664,
       691,  730,  778,  807,  822,  837,  857,  870,  878 ],

    [    0,  128,  253,  302,  320,  443,  577,  636,
       659,  708,  767,  799,  814,  833,  857,  872,  881 ],

    [    0,    1,    2,   25,   42,   43,   44,   67,
        85,  105,  126,  144,  159,  174,  191,  205,  217 ],

    [    0,   70,  166,  229,  267,  356,  468,  533,
       569,  606,  653,  685,  705,  722,  745,  762,  774 ],

    [    0,   55,  130,  175,  200,  268,  358,  416,
       449,  488,  542,  581,  606,  628,  659,  683,  699 ],

    [    0,    1,    3,    5,    7,    9,   11,   13,
        15,   17,   19,   21,   23,   25,   27,   29,   31 ],

    [    0,   34,   85,  123,  147,  196,  265,  317,
       352,  386,  433,  470,  497,  518,  549,  574,  593 ],

    [    0,   30,   73,  105,  127,  170,  229,  274,
       305,  335,  377,  411,  436,  455,  483,  506,  524 ],

    [    0,    9,   24,   38,   51,   65,   87,  108,
       126,  139,  159,  177,  193,  204,  221,  236,  250 ],

    [    0,   30,   74,  105,  125,  166,  224,  266,
       294,  322,  361,  391,  413,  431,  457,  478,  494 ],

    [    0,   15,   38,   58,   73,   95,  128,  156,
       178,  196,  222,  245,  263,  276,  296,  314,  329 ],

    [    0,   11,   28,   44,   57,   74,  100,  123,
       142,  157,  179,  199,  216,  228,  246,  262,  276 ],

    [    0,  448,  619,  639,  643,  821,  926,  944,
       948,  971,  991,  998, 1000, 1005, 1010, 1012, 1013 ],

    [    0,  332,  520,  549,  555,  741,  874,  903,
       910,  940,  970,  981,  985,  991,  998, 1002, 1004 ],

    [    0,    8,   21,   34,   45,   58,   78,   96,
       112,  124,  141,  157,  170,  180,  194,  207,  219 ],

    [    0,  239,  415,  457,  468,  631,  776,  820,
       833,  872,  914,  933,  940,  951,  964,  971,  975 ],

    [    0,  165,  310,  359,  375,  513,  652,  707,
       727,  774,  828,  856,  868,  884,  904,  916,  923 ],

    [    0,    3,    8,   13,   18,   23,   30,   37,
        44,   48,   55,   62,   68,   72,   78,   84,   90 ],

    [    0,  115,  237,  289,  311,  422,  547,  608,
       635,  680,  737,  771,  788,  807,  832,  849,  859 ],

    [    0,  107,  221,  272,  293,  399,  521,  582,
       610,  656,  714,  749,  767,  787,  813,  831,  842 ],

    [    0,    6,   16,   26,   35,   45,   60,   75,
        89,   98,  112,  125,  137,  145,  157,  168,  178 ],

    [    0,   72,  160,  210,  236,  320,  422,  482,
       514,  555,  608,  644,  665,  685,  712,  732,  745 ],

    [    0,   45,  108,  153,  183,  244,  327,  385,
       421,  455,  502,  536,  559,  578,  605,  626,  641 ],

    [    0,    1,    2,    9,   16,   17,   18,   26,
        34,   40,   48,   55,   62,   68,   75,   82,   88 ],

    [    0,   29,   73,  108,  132,  174,  236,  284,
       318,  348,  391,  426,  452,  471,  500,  524,  543 ],

    [    0,   20,   51,   76,   93,  123,  166,  200,
       225,  247,  279,  305,  326,  342,  365,  385,  401 ],

    [    0,  742,  845,  850,  851,  959,  997, 1001,
      1002, 1009, 1014, 1016, 1017, 1019, 1020, 1021, 1022 ],

    [    0,   42,   94,  121,  137,  186,  244,  280,
       303,  330,  366,  392,  410,  427,  451,  470,  484 ],

    [    0,   13,   33,   51,   66,   85,  114,  140,
       161,  178,  203,  225,  243,  256,  275,  292,  307 ],

    [    0,  501,  670,  689,  693,  848,  936,  952,
       956,  975,  991,  997,  999, 1004, 1008, 1010, 1011 ],

    [    0,  445,  581,  603,  609,  767,  865,  888,
       895,  926,  954,  964,  968,  977,  986,  991,  993 ],

    [    0,  285,  442,  479,  489,  650,  779,  818,
       830,  870,  912,  930,  937,  949,  963,  971,  975 ],

    [    0,  349,  528,  561,  569,  731,  852,  883,
       892,  923,  953,  965,  970,  978,  987,  992,  994 ],

    [    0,  199,  355,  402,  417,  563,  700,  750,
       767,  811,  860,  884,  894,  909,  926,  936,  942 ],

    [    0,  141,  275,  325,  343,  471,  606,  664,
       686,  734,  791,  822,  836,  854,  877,  891,  899 ],

    [    0,  243,  437,  493,  510,  649,  775,  820,
       836,  869,  905,  923,  931,  941,  953,  960,  964 ],

    [    0,   91,  197,  248,  271,  370,  487,  550,
       580,  625,  684,  721,  741,  761,  788,  807,  819 ],

    [    0,  107,  201,  242,  262,  354,  451,  503,
       531,  573,  626,  660,  680,  701,  730,  751,  765 ],

    [    0,  168,  339,  407,  432,  553,  676,  731,
       755,  789,  830,  854,  866,  879,  895,  906,  912 ],

    [    0,   67,  147,  191,  214,  290,  384,  441,
       472,  513,  567,  604,  627,  648,  678,  700,  715 ],

    [    0,   46,  109,  148,  171,  229,  307,  359,
       391,  427,  476,  513,  537,  558,  588,  612,  629 ],

    [    0,  848,  918,  920,  921,  996, 1012, 1013,
      1014, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023 ],

    [    0,   36,   88,  123,  145,  193,  260,  308,
       340,  372,  417,  452,  476,  496,  525,  548,  565 ],

    [    0,   24,   61,   90,  110,  145,  196,  237,
       266,  292,  330,  361,  385,  403,  430,  453,  471 ],

    [    0,   85,  182,  230,  253,  344,  454,  515,
       545,  590,  648,  685,  706,  727,  756,  776,  789 ],

    [    0,   22,   55,   82,  102,  135,  183,  222,
       252,  278,  315,  345,  368,  385,  410,  431,  448 ],

    [    0,    1,    2,   56,   89,   90,   91,  140,
       172,  221,  268,  303,  328,  358,  388,  412,  430 ],

    [    0,   45,  109,  152,  177,  239,  320,  376,
       411,  448,  499,  537,  563,  585,  616,  640,  658 ],

    [    0,  247,  395,  433,  445,  599,  729,  771,
       785,  829,  875,  896,  905,  920,  937,  946,  951 ],

    [    0,  231,  367,  408,  423,  557,  676,  723,
       742,  786,  835,  860,  872,  889,  909,  921,  928 ]

])

AC_SPEC_FREQ = np.array([

    [    1,    1,  175,   48,    1,    1,  109,   36,
       171,  109,   47,   20,   49,   36,   20,   10,  190 ],

    [   18,   26,   17,   10,   27,   37,   24,   16,
        22,   32,   22,   14,   17,   26,   20,   13,  683 ],

    [   71,   92,   49,   25,   81,  102,   61,   33,
        42,   57,   39,   23,   22,   30,   22,   15,  260 ],

    [  160,  130,   46,   18,  121,  123,   55,   24,
        45,   55,   31,   15,   19,   24,   15,    9,  134 ],

    [   71,   73,   33,   18,   71,   76,   43,   26,
        34,   44,   30,   20,   20,   27,   21,   15,  402 ],

    [   48,   60,   32,   19,   58,   68,   42,   27,
        31,   42,   30,   21,   19,   27,   21,   16,  463 ],

    [  138,  109,   43,   18,  111,  112,   53,   25,
        46,   55,   32,   17,   21,   27,   18,   11,  188 ],

    [   16,   24,   22,   17,   24,   36,   31,   25,
        20,   30,   25,   20,   15,   22,   19,   16,  662 ],

    [  579,  150,   12,    2,  154,   73,   10,    2,
        14,   11,    3,    1,    3,    3,    1,    1,    5 ],

    [  398,  184,   25,    5,  176,  114,   23,    6,
        25,   23,    8,    3,    6,    6,    3,    2,   17 ],

    [   13,   21,   18,   11,   20,   29,   22,   15,
        14,   20,   16,   12,   10,   14,   12,   10,  767 ],

    [  281,  183,   37,    9,  171,  139,   37,   10,
        35,   36,   15,    6,    9,   10,    6,    3,   37 ],

    [  198,  164,   46,   13,  154,  147,   51,   16,
        43,   49,   24,   10,   13,   16,   10,    5,   65 ],

    [    1,    1,   93,   44,    1,    1,   72,   38,
        86,   70,   43,   25,   40,   36,   25,   16,  432 ],

    [  133,  141,   64,   28,  117,  122,   59,   27,
        39,   48,   29,   15,   15,   20,   13,    8,  146 ],

    [  128,  125,   49,   18,  123,  134,   59,   23,
        49,   59,   32,   15,   19,   24,   15,    9,  143 ],

    [    1,    1,   23,   17,    1,    1,   23,   18,
        20,   21,   18,   15,   15,   17,   14,   12,  807 ],

    [   70,   96,   63,   38,   89,  112,   65,   36,
        37,   47,   32,   20,   17,   23,   17,   12,  250 ],

    [   55,   75,   45,   25,   68,   90,   58,   33,
        39,   54,   39,   25,   22,   31,   24,   16,  325 ],

    [    1,    2,    2,    2,    2,    2,    2,    2,
         2,    2,    2,    2,    2,    2,    2,    2,  993 ],

    [   34,   51,   38,   24,   49,   69,   52,   35,
        34,   47,   37,   27,   21,   31,   25,   19,  431 ],

    [   30,   43,   32,   22,   43,   59,   45,   31,
        30,   42,   34,   25,   19,   28,   23,   18,  500 ],

    [    9,   15,   14,   13,   14,   22,   21,   18,
        13,   20,   18,   16,   11,   17,   15,   14,  774 ],

    [   30,   44,   31,   20,   41,   58,   42,   28,
        28,   39,   30,   22,   18,   26,   21,   16,  530 ],

    [   15,   23,   20,   15,   22,   33,   28,   22,
        18,   26,   23,   18,   13,   20,   18,   15,  695 ],

    [   11,   17,   16,   13,   17,   26,   23,   19,
        15,   22,   20,   17,   12,   18,   16,   14,  748 ],

    [  448,  171,   20,    4,  178,  105,   18,    4,
        23,   20,    7,    2,    5,    5,    2,    1,   11 ],

    [  332,  188,   29,    6,  186,  133,   29,    7,
        30,   30,   11,    4,    6,    7,    4,    2,   20 ],

    [    8,   13,   13,   11,   13,   20,   18,   16,
        12,   17,   16,   13,   10,   14,   13,   12,  805 ],

    [  239,  176,   42,   11,  163,  145,   44,   13,
        39,   42,   19,    7,   11,   13,    7,    4,   49 ],

    [  165,  145,   49,   16,  138,  139,   55,   20,
        47,   54,   28,   12,   16,   20,   12,    7,  101 ],

    [    3,    5,    5,    5,    5,    7,    7,    7,
         4,    7,    7,    6,    4,    6,    6,    6,  934 ],

    [  115,  122,   52,   22,  111,  125,   61,   27,
        45,   57,   34,   17,   19,   25,   17,   10,  165 ],

    [  107,  114,   51,   21,  106,  122,   61,   28,
        46,   58,   35,   18,   20,   26,   18,   11,  182 ],

    [    6,   10,   10,    9,   10,   15,   15,   14,
         9,   14,   13,   12,    8,   12,   11,   10,  846 ],

    [   72,   88,   50,   26,   84,  102,   60,   32,
        41,   53,   36,   21,   20,   27,   20,   13,  279 ],

    [   45,   63,   45,   30,   61,   83,   58,   36,
        34,   47,   34,   23,   19,   27,   21,   15,  383 ],

    [    1,    1,    7,    7,    1,    1,    8,    8,
         6,    8,    7,    7,    6,    7,    7,    6,  936 ],

    [   29,   44,   35,   24,   42,   62,   48,   34,
        30,   43,   35,   26,   19,   29,   24,   19,  481 ],

    [   20,   31,   25,   17,   30,   43,   34,   25,
        22,   32,   26,   21,   16,   23,   20,   16,  623 ],

    [  742,  103,    5,    1,  108,   38,    4,    1,
         7,    5,    2,    1,    2,    1,    1,    1,    2 ],

    [   42,   52,   27,   16,   49,   58,   36,   23,
        27,   36,   26,   18,   17,   24,   19,   14,  540 ],

    [   13,   20,   18,   15,   19,   29,   26,   21,
        17,   25,   22,   18,   13,   19,   17,   15,  717 ],

    [  501,  169,   19,    4,  155,   88,   16,    4,
        19,   16,    6,    2,    5,    4,    2,    1,   13 ],

    [  445,  136,   22,    6,  158,   98,   23,    7,
        31,   28,   10,    4,    9,    9,    5,    2,   31 ],

    [  285,  157,   37,   10,  161,  129,   39,   12,
        40,   42,   18,    7,   12,   14,    8,    4,   49 ],

    [  349,  179,   33,    8,  162,  121,   31,    9,
        31,   30,   12,    5,    8,    9,    5,    2,   30 ],

    [  199,  156,   47,   15,  146,  137,   50,   17,
        44,   49,   24,   10,   15,   17,   10,    6,   82 ],

    [  141,  134,   50,   18,  128,  135,   58,   22,
        48,   57,   31,   14,   18,   23,   14,    8,  125 ],

    [  243,  194,   56,   17,  139,  126,   45,   16,
        33,   36,   18,    8,   10,   12,    7,    4,   60 ],

    [   91,  106,   51,   23,   99,  117,   63,   30,
        45,   59,   37,   20,   20,   27,   19,   12,  205 ],

    [  107,   94,   41,   20,   92,   97,   52,   28,
        42,   53,   34,   20,   21,   29,   21,   14,  259 ],

    [  168,  171,   68,   25,  121,  123,   55,   24,
        34,   41,   24,   12,   13,   16,   11,    6,  112 ],

    [   67,   80,   44,   23,   76,   94,   57,   31,
        41,   54,   37,   23,   21,   30,   22,   15,  309 ],

    [   46,   63,   39,   23,   58,   78,   52,   32,
        36,   49,   37,   24,   21,   30,   24,   17,  395 ],

    [  848,   70,    2,    1,   75,   16,    1,    1,
         2,    1,    1,    1,    1,    1,    1,    1,    1 ],

    [   36,   52,   35,   22,   48,   67,   48,   32,
        32,   45,   35,   24,   20,   29,   23,   17,  459 ],

    [   24,   37,   29,   20,   35,   51,   41,   29,
        26,   38,   31,   24,   18,   27,   23,   18,  553 ],

    [   85,   97,   48,   23,   91,  110,   61,   30,
        45,   58,   37,   21,   21,   29,   20,   13,  235 ],

    [   22,   33,   27,   20,   33,   48,   39,   30,
        26,   37,   30,   23,   17,   25,   21,   17,  576 ],

    [    1,    1,   54,   33,    1,    1,   49,   32,
        49,   47,   35,   25,   30,   30,   24,   18,  594 ],

    [   45,   64,   43,   25,   62,   81,   56,   35,
        37,   51,   38,   26,   22,   31,   24,   18,  366 ],

    [  247,  148,   38,   12,  154,  130,   42,   14,
        44,   46,   21,    9,   15,   17,    9,    5,   73 ],

    [  231,  136,   41,   15,  134,  119,   47,   19,
        44,   49,   25,   12,   17,   20,   12,    7,   96 ]

])
