'''OpenGL extension OES.sample_shading

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.sample_shading to provide a more 
Python-friendly API

Overview (from the spec)
	
	In standard multisample rendering, an implementation is allowed to
	assign the same sets of fragment shader input values to each sample.
	This can cause aliasing where the fragment shader input values are
	used to generate a result that doesn't antialias itself, for example
	with alpha-tested transparency.
	
	This extension adds the ability to explicitly request that an
	implementation use a minimum number of unique set of fragment
	computation inputs when multisampling a pixel. Specifying such a
	requirement can reduce aliasing that results from evaluating the
	fragment computations too few times per pixel.
	
	This extension adds new global state that controls the minimum
	number of samples for which attribute data is independently
	interpolated. When enabled, all fragment-shading operations
	are executed independently on each sample.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/sample_shading.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.sample_shading import *
from OpenGL.raw.GLES2.OES.sample_shading import _EXTENSION_NAME

def glInitSampleShadingOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION