% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineGroupedPValues.R
\name{combineGroupedPValues}
\alias{combineGroupedPValues}
\title{Combine grouped p-values}
\usage{
combineGroupedPValues(
  p.values,
  grouping,
  method = c("simes", "holm-min", "berger", "fisher", "pearson", "wilkinson",
    "stouffer"),
  weights = NULL,
  log.p = FALSE,
  min.n = 1,
  min.prop = 0.5
)
}
\arguments{
\item{p.values}{A numeric vector containing p-values for individual tests.}

\item{grouping}{A vector or factor of length equal to \code{p.values}, specifying the group to which each test is assigned.

Alternatively, an \link{rle} object where each run corresponds to a group and specifies the entries of \code{p.values} belonging to that group.
This assumes that \code{p.values} is ordered such that all entries in the same group are adjacent to each other.}

\item{method}{String specifying the method to use to combine p-values.}

\item{weights}{A numeric vector of length equal to \code{p.values}, containing a positive weight for each test.
Alternatively \code{NULL}, in which case equal weights are assigned to all tests.}

\item{log.p}{Logical scalar indicating whether the p-values in \code{p.values} are log-transformed.}

\item{min.n}{Integer scalar specifying the minimum number of individual nulls to reject when testing the joint null.}

\item{min.prop}{Numeric scalar in [0, 1], specifying the minimum proportion of individual nulls to reject when testing the joint null.}
}
\value{
A list containing:
\itemize{
\item \code{p.value}, a named numeric vector of length equal to the number of unique levels in \code{grouping}.
This contains the combined p-value for each group, log-transformed if \code{log.p=TRUE}.
Each entry is named according to the group.
\item \code{representative}, a named integer scalar specifying the index of representative test for each group.
Each index refers to an entry of \code{p.values} and is named according to its group.
\item \code{influential}, a logical vector of length equal to \code{p.values}.
Entries are \code{TRUE} for any p-value that is deemed \dQuote{influential} to the final combined p-value for its group.
}
}
\description{
Combine p-values from grouped hypothesis tests using a variety of meta-analysis methods.
Each group of p-values is defined as those assigned to the same level of the grouping factor.
}
\details{
\code{min.prop} and \code{min.n} only have an effect for \code{method="wilkinson"} and \code{"holm-min"}.

\code{weights} only has an effect for \code{method="simes"}, \code{"holm-min"} and \code{"stouffer"}.
}
\examples{
p <- runif(10000)
g <- sample(100, 10000, replace=TRUE)

fish <- combineGroupedPValues(p, g, method="fisher")
hist(fish$p.value)

z <- combineGroupedPValues(p, g, method="stouffer", weights=rexp(10000))
hist(z$p.value)

simes <- combineGroupedPValues(p, g, method="simes")
hist(simes$p.value)

berger <- combineGroupedPValues(p, g, method="berger")
hist(berger$p.value)

}
\author{
Aaron Lun
}
