% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZicoSeq.R
\name{ZicoSeq.plot}
\alias{ZicoSeq.plot}
\title{A Plot Function for Visualizing the ZicoSeq Results}

\description{
\code{ZicoSeq.plot} produces volcano plots with the y-axis being the log10 (adjusted) p-value and the x-axis being the signed  R^2^ 
with the sign indicating the association direction determined based on  the sign of the regression coefficients (for multi-categorical
 variables, sign is not applicable). The names of differential taxa passing a specific cutoff will be printed on the figure.
  When data types are counts and proportions, the mean abundance and prevalence will be visualized; when the data type is `other`, 
  mean and standard deviation of the features will be visualized. Users need to set \code{return.feature.dat = T} when using the plot function.
}


\usage{
ZicoSeq.plot(
  ZicoSeq.obj,
  meta.dat, 
  pvalue.type = c('p.adj.fdr','p.raw','p.adj.fwer'), 
  cutoff = 0.1, 
  text.size = 10,
  out.dir = NULL, 
  file.name = 'ZicoSeq.plot.pdf', 
  width = 10, 
  height = 6)
}
\arguments{

\item{ZicoSeq.obj}{object from calling the function \code{ZicoSeq}.}
\item{meta.dat}{the same meta.dat used in the \code{ZicoSeq}.}
\item{pvalue.type}{character string, one of 'p.adj.fdr','p.raw' and 'p.adj.fwer'.}
\item{cutoff}{a cutoff between 0 and 1 for pvalue.type, below which the names of the features will be printed.}
\item{text.size}{text size for the plots.}
\item{out.dir}{character string; the directory to save the figure, e.g., \code{getwd()}. Default is NULL. If NULL, figure will not be saved.}
\item{file.name }{character string; name of the file to be saved. }
\item{width}{the width of the graphics region in inches. See R function \code{ggsave}.}
\item{height}{the height of the graphics region in inches. See R function \code{ggsave}.}

}
\value{
gtable of aligned plots from \code{ggarrange}.
}

\references{
Yang, L. & Chen, J. 2022. A comprehensive evaluation of differential abundance analysis methods: current status and potential solutions.
Microbiome. In Press.
}


\author{Lu Yang, Jun Chen}

\examples{

data(throat.otu.tab)
data(throat.tree)
data(throat.meta)

comm <- t(throat.otu.tab)
meta.dat <- throat.meta

set.seed(123)
# For count data
zico.obj <- ZicoSeq(meta.dat = meta.dat, feature.dat = comm, 
		grp.name = 'SmokingStatus', adj.name = 'Sex', feature.dat.type = "count",
		# Filter to remove rare taxa
		prev.filter = 0.2, mean.abund.filter = 0,  max.abund.filter = 0.002, min.prop = 0, 
		# Winsorization to replace outliers
		is.winsor = TRUE, outlier.pct = 0.03, winsor.end = 'top',
		# Posterior sampling to impute zeros
		is.post.sample = TRUE, post.sample.no = 25, 
		# Multiple link functions to capture diverse taxon-covariate relation
		link.func = list(function (x) x^0.25, function (x) x^0.5, function (x) x^0.75), 
		stats.combine.func = max,
		# Permutation-based multiple testing correction
		perm.no = 99,  strata = NULL, 
		# Reference-based multiple stage normalization
		ref.pct = 0.5, stage.no = 6, excl.pct = 0.2,
		# Family-wise error rate control
		is.fwer = FALSE,
		verbose = TRUE, return.feature.dat = TRUE)

which(zico.obj$p.adj.fdr <= 0.1)

ZicoSeq.plot(ZicoSeq.obj = zico.obj, meta.dat = meta.dat, pvalue.type = 'p.adj.fdr', 
             cutoff = 0.1, text.size = 10, out.dir = NULL, width = 15, height = 10)    

}


\keyword{visualization}





