% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_family.R
\name{get_family}
\alias{get_family}
\title{A robust alternative to stats::family}
\usage{
get_family(x, ...)
}
\arguments{
\item{x}{A statistical model.}

\item{...}{Further arguments passed to methods.}
}
\description{
A robust and resilient alternative to \code{stats::family}. To avoid issues
with models like \code{gamm4}.
}
\examples{
data(mtcars)
x <- glm(vs ~ wt, data = mtcars, family = "binomial")
get_family(x)

if (require("mgcv")) {
  x <- mgcv::gamm(
    vs ~ am + s(wt),
    random = list(cyl = ~1),
    data = mtcars,
    family = "binomial"
  )
  get_family(x)
}
}
