//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2022-2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

import Benchmark
import func Benchmark.blackHole

#if FOUNDATION_FRAMEWORK
import Foundation
#else
import FoundationEssentials
#endif

let benchmarks = {
    Benchmark.defaultConfiguration.maxIterations = 1_000
    Benchmark.defaultConfiguration.maxDuration = .seconds(3)
    Benchmark.defaultConfiguration.scalingFactor = .kilo
    Benchmark.defaultConfiguration.metrics = [.cpuTotal, .wallClock, .throughput]
        
    let date = Date(timeIntervalSinceReferenceDate: 665076946.0)

    let iso8601 = Date.ISO8601FormatStyle()
    let formats: [Date.ISO8601FormatStyle] = [
        iso8601.year().month().day().dateSeparator(.dash),
        iso8601.year().month().day().dateSeparator(.omitted),
        iso8601.weekOfYear().day().dateSeparator(.dash),
        iso8601.day().time(includingFractionalSeconds: false).timeSeparator(.colon),
        iso8601.time(includingFractionalSeconds: false).timeSeparator(.colon),
        iso8601.time(includingFractionalSeconds: false).timeZone(separator: .omitted),
        iso8601.time(includingFractionalSeconds: false).timeZone(separator: .colon),
        iso8601.timeZone(separator: .colon).time(includingFractionalSeconds: false).timeSeparator(.colon),
    ]
    
    let preformatted = formats.map { ($0, $0.format(date)) }

    Benchmark("iso860-format", configuration: .init(scalingFactor: .kilo)) { benchmark in
        for _ in benchmark.scaledIterations {
            for fmt in formats {
                blackHole(fmt.format(date))
            }
        }
    }

    Benchmark("iso860-parse", configuration: .init(scalingFactor: .kilo)) { benchmark in
        for _ in benchmark.scaledIterations {
            for fmt in preformatted {
                let result = try? fmt.0.parse(fmt.1)
                blackHole(result)
            }
        }
    }
}
