/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.generic.ReferenceType;

public final class ObjectType
extends ReferenceType {
    private String class_name;

    public ObjectType(String class_name) {
        super((byte)14, ObjectType.toSignature(class_name));
        this.class_name = class_name.replace('/', '.');
    }

    private static String toSignature(String classname) {
        StringBuffer sig = new StringBuffer();
        sig.append("L").append(classname.replace('.', '/'));
        sig.append(";");
        return sig.toString();
    }

    public String getClassName() {
        return this.class_name;
    }

    public int hashCode() {
        return this.class_name.hashCode();
    }

    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    public boolean referencesClass() {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc == null) {
            return false;
        }
        return jc.isClass();
    }

    public boolean referencesInterface() {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc == null) {
            return false;
        }
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) {
        if (this.referencesInterface() || superclass.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public boolean accessibleTo(ObjectType accessor) {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

