/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import jd.xml.util.DescendantsEnum;
import jd.xml.util.UriUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DomUtil {
    public static Node getParentOrOwner(Node node) {
        return node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
    }

    public static Attr getInheritedAttribute(Node node, String string, String string2) {
        Attr attr = null;
        while (node != null) {
            short s = node.getNodeType();
            if (s == 1 && node.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                Attr attr2 = attr = string == null ? (Attr)namedNodeMap.getNamedItem(string2) : (Attr)namedNodeMap.getNamedItemNS(string, string2);
                if (attr != null) break;
            }
            node = DomUtil.getParentOrOwner(node);
        }
        return attr;
    }

    public static String getXmlBaseUri(Node node, String string) {
        Attr attr = DomUtil.getInheritedAttribute(node, "http://www.w3.org/XML/1998/namespace", "base");
        return attr == null ? string : UriUtil.getUri(attr.getNodeValue(), string);
    }

    public static String getXmlLanguage(Node node) {
        Attr attr = DomUtil.getInheritedAttribute(node, "http://www.w3.org/XML/1998/namespace", "lang");
        return attr == null ? null : attr.getValue();
    }

    public static boolean getPreserveXmlSpace(Node node) {
        Attr attr = DomUtil.getInheritedAttribute(node, "http://www.w3.org/XML/1998/namespace", "space");
        return attr == null ? false : attr.getValue().equals("preserve");
    }

    public static Node getFirstSibling(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        if (node3 != null) {
            return node3.getFirstChild();
        }
        while ((node2 = node.getPreviousSibling()) != null) {
            node = node2;
        }
        return node;
    }

    public static int getNodeLevel(Node node) {
        int n = -1;
        while (node != null) {
            ++n;
            node = node.getParentNode();
        }
        return n;
    }

    public static boolean isNamespaceNode(Node node) {
        return DomUtil.isNamespaceNode(node.getNodeName());
    }

    public static boolean isNamespaceNode(String string) {
        return string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':');
    }

    public static String getNamespaceUri(Node node, String string) {
        if (node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        while (node != null) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!DomUtil.isNamespaceNode(attr) || !string.equals(attr.getLocalName())) continue;
                return attr.getNodeValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static void stripWhitespace(Document document) {
        Node node;
        try {
            document.normalize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DescendantsEnum descendantsEnum = new DescendantsEnum(document);
        block2: while ((node = descendantsEnum.next()) != null) {
            while (node != null && node.getNodeType() == 3) {
                String string = node.getNodeValue().trim();
                if (string.length() == 0) {
                    Node node2 = descendantsEnum.next();
                    node.getParentNode().removeChild(node);
                    node = node2;
                    continue;
                }
                node.setNodeValue(string);
                continue block2;
            }
        }
    }
}

