# Usage: execute
# $ python support/generate.py
# at wpt/upgrade-insecure-requests/.
#
# Note: Some tests (link-upgrade.sub.https.html and
# websocket-upgrade.https.html) are not covered by this generator script.

template = '''<!DOCTYPE html>
<html>
<head>
<!-- Generated by wpt/upgrade-insecure-requests/support/generate.py -->
<title>Upgrade Insecure Requests: %(name)s.</title>
<script src="/resources/testharness.js"></script>
<script src="/resources/testharnessreport.js"></script>
<script src="./support/testharness-helper.sub.js"></script>
<script src="/common/security-features/resources/common.js"></script>

<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
</head>
<body>
<script>
const tests = %(generatorName)s(ResourceType.%(resourceType)s, %(sameOriginOnly)s);
tests.forEach(test => testMap['%(name)s'](test));
</script>
</body>
</html>
'''

# resourceType is |ResourceType| in testharness-helper.sub.js.
for name, resourceType in [
  ('image', 'IMAGE'), ('iframe', 'FRAME'),
  ('animation-worklet', 'WORKLET'), ('audio-worklet', 'WORKLET'),
  ('layout-worklet', 'WORKLET'), ('paint-worklet', 'WORKLET'),
  ('worker', 'WORKER'),
  ('module-worker', 'WORKER'),
  ('worker-subresource-xhr', 'IMAGE'),
  ('worker-subresource-fetch', 'IMAGE')]:
  sameOriginOnly = 'true' if resourceType == 'WORKER' else 'false'
  types = [('', 'generateTests'), ('-redirect', 'generateRedirectTests')]
  if name == 'module-worker' or resourceType == 'WORKLET':
    types.append(('-import', 'generateModuleImportTests'))
  for typeName, generatorName in types:
    with open('%s%s-upgrade.https.html' % (name, typeName), 'w') as html_file:
      html_file.write(template % {
          'name': name,
          'resourceType': resourceType,
          'generatorName': generatorName,
          'sameOriginOnly': sameOriginOnly})
