// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gobject_sys as gobject;
use gstreamer_sys as gst;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstAggregatorStartTimeSelection = c_int;
pub const GST_AGGREGATOR_START_TIME_SELECTION_ZERO: GstAggregatorStartTimeSelection = 0;
pub const GST_AGGREGATOR_START_TIME_SELECTION_FIRST: GstAggregatorStartTimeSelection = 1;
pub const GST_AGGREGATOR_START_TIME_SELECTION_SET: GstAggregatorStartTimeSelection = 2;

// Constants
pub const GST_BASE_PARSE_FLAG_DRAINING: c_int = 2;
pub const GST_BASE_PARSE_FLAG_LOST_SYNC: c_int = 1;
pub const GST_BASE_TRANSFORM_SINK_NAME: &[u8] = b"sink\0";
pub const GST_BASE_TRANSFORM_SRC_NAME: &[u8] = b"src\0";

// Flags
pub type GstBaseParseFrameFlags = c_uint;
pub const GST_BASE_PARSE_FRAME_FLAG_NONE: GstBaseParseFrameFlags = 0;
pub const GST_BASE_PARSE_FRAME_FLAG_NEW_FRAME: GstBaseParseFrameFlags = 1;
pub const GST_BASE_PARSE_FRAME_FLAG_NO_FRAME: GstBaseParseFrameFlags = 2;
pub const GST_BASE_PARSE_FRAME_FLAG_CLIP: GstBaseParseFrameFlags = 4;
pub const GST_BASE_PARSE_FRAME_FLAG_DROP: GstBaseParseFrameFlags = 8;
pub const GST_BASE_PARSE_FRAME_FLAG_QUEUE: GstBaseParseFrameFlags = 16;

pub type GstBaseSrcFlags = c_uint;
pub const GST_BASE_SRC_FLAG_STARTING: GstBaseSrcFlags = 16384;
pub const GST_BASE_SRC_FLAG_STARTED: GstBaseSrcFlags = 32768;
pub const GST_BASE_SRC_FLAG_LAST: GstBaseSrcFlags = 1048576;

pub type GstCollectPadsStateFlags = c_uint;
pub const GST_COLLECT_PADS_STATE_EOS: GstCollectPadsStateFlags = 1;
pub const GST_COLLECT_PADS_STATE_FLUSHING: GstCollectPadsStateFlags = 2;
pub const GST_COLLECT_PADS_STATE_NEW_SEGMENT: GstCollectPadsStateFlags = 4;
pub const GST_COLLECT_PADS_STATE_WAITING: GstCollectPadsStateFlags = 8;
pub const GST_COLLECT_PADS_STATE_LOCKED: GstCollectPadsStateFlags = 16;

// Unions
#[derive(Copy, Clone)]
#[repr(C)]
pub union GstCollectData_ABI {
    pub abi: GstCollectData_ABI_abi,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstCollectData_ABI {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstCollectData_ABI @ {self:p}"))
            .field("abi", unsafe { &self.abi })
            .finish()
    }
}

// Callbacks
pub type GstCollectDataDestroyNotify = Option<unsafe extern "C" fn(*mut GstCollectData)>;
pub type GstCollectPadsBufferFunction = Option<
    unsafe extern "C" fn(
        *mut GstCollectPads,
        *mut GstCollectData,
        *mut gst::GstBuffer,
        gpointer,
    ) -> gst::GstFlowReturn,
>;
pub type GstCollectPadsClipFunction = Option<
    unsafe extern "C" fn(
        *mut GstCollectPads,
        *mut GstCollectData,
        *mut gst::GstBuffer,
        *mut *mut gst::GstBuffer,
        gpointer,
    ) -> gst::GstFlowReturn,
>;
pub type GstCollectPadsCompareFunction = Option<
    unsafe extern "C" fn(
        *mut GstCollectPads,
        *mut GstCollectData,
        gst::GstClockTime,
        *mut GstCollectData,
        gst::GstClockTime,
        gpointer,
    ) -> c_int,
>;
pub type GstCollectPadsEventFunction = Option<
    unsafe extern "C" fn(
        *mut GstCollectPads,
        *mut GstCollectData,
        *mut gst::GstEvent,
        gpointer,
    ) -> gboolean,
>;
pub type GstCollectPadsFlushFunction = Option<unsafe extern "C" fn(*mut GstCollectPads, gpointer)>;
pub type GstCollectPadsFunction =
    Option<unsafe extern "C" fn(*mut GstCollectPads, gpointer) -> gst::GstFlowReturn>;
pub type GstCollectPadsQueryFunction = Option<
    unsafe extern "C" fn(
        *mut GstCollectPads,
        *mut GstCollectData,
        *mut gst::GstQuery,
        gpointer,
    ) -> gboolean,
>;
pub type GstDataQueueCheckFullFunction =
    Option<unsafe extern "C" fn(*mut GstDataQueue, c_uint, c_uint, u64, gpointer) -> gboolean>;
pub type GstDataQueueEmptyCallback = Option<unsafe extern "C" fn(*mut GstDataQueue, gpointer)>;
pub type GstDataQueueFullCallback = Option<unsafe extern "C" fn(*mut GstDataQueue, gpointer)>;
pub type GstTypeFindHelperGetRangeFunction = Option<
    unsafe extern "C" fn(
        *mut gst::GstObject,
        *mut gst::GstObject,
        u64,
        c_uint,
        *mut *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn,
>;

// Records
#[repr(C)]
#[allow(dead_code)]
pub struct _GstAdapterClass {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstAdapterClass = _GstAdapterClass;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAggregatorClass {
    pub parent_class: gst::GstElementClass,
    pub flush: Option<unsafe extern "C" fn(*mut GstAggregator) -> gst::GstFlowReturn>,
    pub clip: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstBuffer,
        ) -> *mut gst::GstBuffer,
    >,
    pub finish_buffer:
        Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub sink_event: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstEvent,
        ) -> gboolean,
    >,
    pub sink_query: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub src_event: Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstEvent) -> gboolean>,
    pub src_query: Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstQuery) -> gboolean>,
    pub src_activate:
        Option<unsafe extern "C" fn(*mut GstAggregator, gst::GstPadMode, gboolean) -> gboolean>,
    pub aggregate: Option<unsafe extern "C" fn(*mut GstAggregator, gboolean) -> gst::GstFlowReturn>,
    pub stop: Option<unsafe extern "C" fn(*mut GstAggregator) -> gboolean>,
    pub start: Option<unsafe extern "C" fn(*mut GstAggregator) -> gboolean>,
    pub get_next_time: Option<unsafe extern "C" fn(*mut GstAggregator) -> gst::GstClockTime>,
    pub create_new_pad: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut gst::GstPadTemplate,
            *const c_char,
            *const gst::GstCaps,
        ) -> *mut GstAggregatorPad,
    >,
    pub update_src_caps: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut gst::GstCaps,
            *mut *mut gst::GstCaps,
        ) -> gst::GstFlowReturn,
    >,
    pub fixate_src_caps:
        Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub negotiated_src_caps:
        Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstCaps) -> gboolean>,
    pub decide_allocation:
        Option<unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstQuery) -> gboolean>,
    pub propose_allocation: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstQuery,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub negotiate: Option<unsafe extern "C" fn(*mut GstAggregator) -> gboolean>,
    pub sink_event_pre_queue: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstEvent,
        ) -> gst::GstFlowReturn,
    >,
    pub sink_query_pre_queue: Option<
        unsafe extern "C" fn(
            *mut GstAggregator,
            *mut GstAggregatorPad,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub finish_buffer_list: Option<
        unsafe extern "C" fn(*mut GstAggregator, *mut gst::GstBufferList) -> gst::GstFlowReturn,
    >,
    pub peek_next_sample: Option<
        unsafe extern "C" fn(*mut GstAggregator, *mut GstAggregatorPad) -> *mut gst::GstSample,
    >,
    pub _gst_reserved: [gpointer; 15],
}

impl ::std::fmt::Debug for GstAggregatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAggregatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("flush", &self.flush)
            .field("clip", &self.clip)
            .field("finish_buffer", &self.finish_buffer)
            .field("sink_event", &self.sink_event)
            .field("sink_query", &self.sink_query)
            .field("src_event", &self.src_event)
            .field("src_query", &self.src_query)
            .field("src_activate", &self.src_activate)
            .field("aggregate", &self.aggregate)
            .field("stop", &self.stop)
            .field("start", &self.start)
            .field("get_next_time", &self.get_next_time)
            .field("create_new_pad", &self.create_new_pad)
            .field("update_src_caps", &self.update_src_caps)
            .field("fixate_src_caps", &self.fixate_src_caps)
            .field("negotiated_src_caps", &self.negotiated_src_caps)
            .field("decide_allocation", &self.decide_allocation)
            .field("propose_allocation", &self.propose_allocation)
            .field("negotiate", &self.negotiate)
            .field("sink_event_pre_queue", &self.sink_event_pre_queue)
            .field("sink_query_pre_queue", &self.sink_query_pre_queue)
            .field("finish_buffer_list", &self.finish_buffer_list)
            .field("peek_next_sample", &self.peek_next_sample)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAggregatorPadClass {
    pub parent_class: gst::GstPadClass,
    pub flush: Option<
        unsafe extern "C" fn(*mut GstAggregatorPad, *mut GstAggregator) -> gst::GstFlowReturn,
    >,
    pub skip_buffer: Option<
        unsafe extern "C" fn(
            *mut GstAggregatorPad,
            *mut GstAggregator,
            *mut gst::GstBuffer,
        ) -> gboolean,
    >,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstAggregatorPadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAggregatorPadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("flush", &self.flush)
            .field("skip_buffer", &self.skip_buffer)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstAggregatorPadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstAggregatorPadPrivate = _GstAggregatorPadPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct _GstAggregatorPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstAggregatorPrivate = _GstAggregatorPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseParseClass {
    pub parent_class: gst::GstElementClass,
    pub start: Option<unsafe extern "C" fn(*mut GstBaseParse) -> gboolean>,
    pub stop: Option<unsafe extern "C" fn(*mut GstBaseParse) -> gboolean>,
    pub set_sink_caps:
        Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstCaps) -> gboolean>,
    pub handle_frame: Option<
        unsafe extern "C" fn(
            *mut GstBaseParse,
            *mut GstBaseParseFrame,
            *mut c_int,
        ) -> gst::GstFlowReturn,
    >,
    pub pre_push_frame: Option<
        unsafe extern "C" fn(*mut GstBaseParse, *mut GstBaseParseFrame) -> gst::GstFlowReturn,
    >,
    pub convert: Option<
        unsafe extern "C" fn(
            *mut GstBaseParse,
            gst::GstFormat,
            i64,
            gst::GstFormat,
            *mut i64,
        ) -> gboolean,
    >,
    pub sink_event: Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstEvent) -> gboolean>,
    pub src_event: Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstEvent) -> gboolean>,
    pub get_sink_caps:
        Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub detect:
        Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub sink_query: Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstQuery) -> gboolean>,
    pub src_query: Option<unsafe extern "C" fn(*mut GstBaseParse, *mut gst::GstQuery) -> gboolean>,
    pub _gst_reserved: [gpointer; 18],
}

impl ::std::fmt::Debug for GstBaseParseClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseParseClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("start", &self.start)
            .field("stop", &self.stop)
            .field("set_sink_caps", &self.set_sink_caps)
            .field("handle_frame", &self.handle_frame)
            .field("pre_push_frame", &self.pre_push_frame)
            .field("convert", &self.convert)
            .field("sink_event", &self.sink_event)
            .field("src_event", &self.src_event)
            .field("get_sink_caps", &self.get_sink_caps)
            .field("detect", &self.detect)
            .field("sink_query", &self.sink_query)
            .field("src_query", &self.src_query)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseParseFrame {
    pub buffer: *mut gst::GstBuffer,
    pub out_buffer: *mut gst::GstBuffer,
    pub flags: c_uint,
    pub offset: u64,
    pub overhead: c_int,
    pub size: c_int,
    pub _gst_reserved_i: [c_uint; 2],
    pub _gst_reserved_p: [gpointer; 2],
    pub _private_flags: c_uint,
}

impl ::std::fmt::Debug for GstBaseParseFrame {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseParseFrame @ {self:p}"))
            .field("buffer", &self.buffer)
            .field("out_buffer", &self.out_buffer)
            .field("flags", &self.flags)
            .field("offset", &self.offset)
            .field("overhead", &self.overhead)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstBaseParsePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstBaseParsePrivate = _GstBaseParsePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseSinkClass {
    pub parent_class: gst::GstElementClass,
    pub get_caps:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub set_caps: Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstCaps) -> gboolean>,
    pub fixate:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub activate_pull: Option<unsafe extern "C" fn(*mut GstBaseSink, gboolean) -> gboolean>,
    pub get_times: Option<
        unsafe extern "C" fn(
            *mut GstBaseSink,
            *mut gst::GstBuffer,
            *mut gst::GstClockTime,
            *mut gst::GstClockTime,
        ),
    >,
    pub propose_allocation:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstQuery) -> gboolean>,
    pub start: Option<unsafe extern "C" fn(*mut GstBaseSink) -> gboolean>,
    pub stop: Option<unsafe extern "C" fn(*mut GstBaseSink) -> gboolean>,
    pub unlock: Option<unsafe extern "C" fn(*mut GstBaseSink) -> gboolean>,
    pub unlock_stop: Option<unsafe extern "C" fn(*mut GstBaseSink) -> gboolean>,
    pub query: Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstQuery) -> gboolean>,
    pub event: Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstEvent) -> gboolean>,
    pub wait_event:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstEvent) -> gst::GstFlowReturn>,
    pub prepare:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub prepare_list: Option<
        unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstBufferList) -> gst::GstFlowReturn,
    >,
    pub preroll:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub render:
        Option<unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub render_list: Option<
        unsafe extern "C" fn(*mut GstBaseSink, *mut gst::GstBufferList) -> gst::GstFlowReturn,
    >,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstBaseSinkClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseSinkClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_caps", &self.get_caps)
            .field("set_caps", &self.set_caps)
            .field("fixate", &self.fixate)
            .field("activate_pull", &self.activate_pull)
            .field("get_times", &self.get_times)
            .field("propose_allocation", &self.propose_allocation)
            .field("start", &self.start)
            .field("stop", &self.stop)
            .field("unlock", &self.unlock)
            .field("unlock_stop", &self.unlock_stop)
            .field("query", &self.query)
            .field("event", &self.event)
            .field("wait_event", &self.wait_event)
            .field("prepare", &self.prepare)
            .field("prepare_list", &self.prepare_list)
            .field("preroll", &self.preroll)
            .field("render", &self.render)
            .field("render_list", &self.render_list)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstBaseSinkPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstBaseSinkPrivate = _GstBaseSinkPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseSrcClass {
    pub parent_class: gst::GstElementClass,
    pub get_caps:
        Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub negotiate: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub fixate:
        Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstCaps) -> *mut gst::GstCaps>,
    pub set_caps: Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstCaps) -> gboolean>,
    pub decide_allocation:
        Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstQuery) -> gboolean>,
    pub start: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub stop: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub get_times: Option<
        unsafe extern "C" fn(
            *mut GstBaseSrc,
            *mut gst::GstBuffer,
            *mut gst::GstClockTime,
            *mut gst::GstClockTime,
        ),
    >,
    pub get_size: Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut u64) -> gboolean>,
    pub is_seekable: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub prepare_seek_segment: Option<
        unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstEvent, *mut gst::GstSegment) -> gboolean,
    >,
    pub do_seek: Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstSegment) -> gboolean>,
    pub unlock: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub unlock_stop: Option<unsafe extern "C" fn(*mut GstBaseSrc) -> gboolean>,
    pub query: Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstQuery) -> gboolean>,
    pub event: Option<unsafe extern "C" fn(*mut GstBaseSrc, *mut gst::GstEvent) -> gboolean>,
    pub create: Option<
        unsafe extern "C" fn(
            *mut GstBaseSrc,
            u64,
            c_uint,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub alloc: Option<
        unsafe extern "C" fn(
            *mut GstBaseSrc,
            u64,
            c_uint,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub fill: Option<
        unsafe extern "C" fn(
            *mut GstBaseSrc,
            u64,
            c_uint,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstBaseSrcClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseSrcClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_caps", &self.get_caps)
            .field("negotiate", &self.negotiate)
            .field("fixate", &self.fixate)
            .field("set_caps", &self.set_caps)
            .field("decide_allocation", &self.decide_allocation)
            .field("start", &self.start)
            .field("stop", &self.stop)
            .field("get_times", &self.get_times)
            .field("get_size", &self.get_size)
            .field("is_seekable", &self.is_seekable)
            .field("prepare_seek_segment", &self.prepare_seek_segment)
            .field("do_seek", &self.do_seek)
            .field("unlock", &self.unlock)
            .field("unlock_stop", &self.unlock_stop)
            .field("query", &self.query)
            .field("event", &self.event)
            .field("create", &self.create)
            .field("alloc", &self.alloc)
            .field("fill", &self.fill)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstBaseSrcPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstBaseSrcPrivate = _GstBaseSrcPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseTransformClass {
    pub parent_class: gst::GstElementClass,
    pub passthrough_on_same_caps: gboolean,
    pub transform_ip_on_passthrough: gboolean,
    pub transform_caps: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gst::GstPadDirection,
            *mut gst::GstCaps,
            *mut gst::GstCaps,
        ) -> *mut gst::GstCaps,
    >,
    pub fixate_caps: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gst::GstPadDirection,
            *mut gst::GstCaps,
            *mut gst::GstCaps,
        ) -> *mut gst::GstCaps,
    >,
    pub accept_caps: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gst::GstPadDirection,
            *mut gst::GstCaps,
        ) -> gboolean,
    >,
    pub set_caps: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstCaps,
            *mut gst::GstCaps,
        ) -> gboolean,
    >,
    pub query: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gst::GstPadDirection,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub decide_allocation:
        Option<unsafe extern "C" fn(*mut GstBaseTransform, *mut gst::GstQuery) -> gboolean>,
    pub filter_meta: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstQuery,
            GType,
            *const gst::GstStructure,
        ) -> gboolean,
    >,
    pub propose_allocation: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstQuery,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub transform_size: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gst::GstPadDirection,
            *mut gst::GstCaps,
            size_t,
            *mut gst::GstCaps,
            *mut size_t,
        ) -> gboolean,
    >,
    pub get_unit_size: Option<
        unsafe extern "C" fn(*mut GstBaseTransform, *mut gst::GstCaps, *mut size_t) -> gboolean,
    >,
    pub start: Option<unsafe extern "C" fn(*mut GstBaseTransform) -> gboolean>,
    pub stop: Option<unsafe extern "C" fn(*mut GstBaseTransform) -> gboolean>,
    pub sink_event:
        Option<unsafe extern "C" fn(*mut GstBaseTransform, *mut gst::GstEvent) -> gboolean>,
    pub src_event:
        Option<unsafe extern "C" fn(*mut GstBaseTransform, *mut gst::GstEvent) -> gboolean>,
    pub prepare_output_buffer: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstBuffer,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub copy_metadata: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstBuffer,
            *mut gst::GstBuffer,
        ) -> gboolean,
    >,
    pub transform_meta: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstBuffer,
            *mut gst::GstMeta,
            *mut gst::GstBuffer,
        ) -> gboolean,
    >,
    pub before_transform: Option<unsafe extern "C" fn(*mut GstBaseTransform, *mut gst::GstBuffer)>,
    pub transform: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            *mut gst::GstBuffer,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub transform_ip: Option<
        unsafe extern "C" fn(*mut GstBaseTransform, *mut *mut gst::GstBuffer) -> gst::GstFlowReturn,
    >,
    pub submit_input_buffer: Option<
        unsafe extern "C" fn(
            *mut GstBaseTransform,
            gboolean,
            *mut gst::GstBuffer,
        ) -> gst::GstFlowReturn,
    >,
    pub generate_output: Option<
        unsafe extern "C" fn(*mut GstBaseTransform, *mut *mut gst::GstBuffer) -> gst::GstFlowReturn,
    >,
    pub _gst_reserved: [gpointer; 18],
}

impl ::std::fmt::Debug for GstBaseTransformClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseTransformClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("passthrough_on_same_caps", &self.passthrough_on_same_caps)
            .field(
                "transform_ip_on_passthrough",
                &self.transform_ip_on_passthrough,
            )
            .field("transform_caps", &self.transform_caps)
            .field("fixate_caps", &self.fixate_caps)
            .field("accept_caps", &self.accept_caps)
            .field("set_caps", &self.set_caps)
            .field("query", &self.query)
            .field("decide_allocation", &self.decide_allocation)
            .field("filter_meta", &self.filter_meta)
            .field("propose_allocation", &self.propose_allocation)
            .field("transform_size", &self.transform_size)
            .field("get_unit_size", &self.get_unit_size)
            .field("start", &self.start)
            .field("stop", &self.stop)
            .field("sink_event", &self.sink_event)
            .field("src_event", &self.src_event)
            .field("prepare_output_buffer", &self.prepare_output_buffer)
            .field("copy_metadata", &self.copy_metadata)
            .field("transform_meta", &self.transform_meta)
            .field("before_transform", &self.before_transform)
            .field("transform", &self.transform)
            .field("transform_ip", &self.transform_ip)
            .field("submit_input_buffer", &self.submit_input_buffer)
            .field("generate_output", &self.generate_output)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstBaseTransformPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstBaseTransformPrivate = _GstBaseTransformPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBitReader {
    pub data: *const u8,
    pub size: c_uint,
    pub byte: c_uint,
    pub bit: c_uint,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstBitReader {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBitReader @ {self:p}"))
            .field("data", &self.data)
            .field("size", &self.size)
            .field("byte", &self.byte)
            .field("bit", &self.bit)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBitWriter {
    pub data: *mut u8,
    pub bit_size: c_uint,
    pub bit_capacity: c_uint,
    pub auto_grow: gboolean,
    pub owned: gboolean,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstBitWriter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBitWriter @ {self:p}"))
            .field("data", &self.data)
            .field("bit_size", &self.bit_size)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstByteReader {
    pub data: *const u8,
    pub size: c_uint,
    pub byte: c_uint,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstByteReader {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstByteReader @ {self:p}"))
            .field("data", &self.data)
            .field("size", &self.size)
            .field("byte", &self.byte)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstByteWriter {
    pub parent: GstByteReader,
    pub alloc_size: c_uint,
    pub fixed: gboolean,
    pub owned: gboolean,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstByteWriter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstByteWriter @ {self:p}"))
            .field("parent", &self.parent)
            .field("alloc_size", &self.alloc_size)
            .field("fixed", &self.fixed)
            .field("owned", &self.owned)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstCollectData {
    pub collect: *mut GstCollectPads,
    pub pad: *mut gst::GstPad,
    pub buffer: *mut gst::GstBuffer,
    pub pos: c_uint,
    pub segment: gst::GstSegment,
    pub state: GstCollectPadsStateFlags,
    pub priv_: *mut GstCollectDataPrivate,
    pub ABI: GstCollectData_ABI,
}

impl ::std::fmt::Debug for GstCollectData {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstCollectData @ {self:p}"))
            .field("collect", &self.collect)
            .field("pad", &self.pad)
            .field("buffer", &self.buffer)
            .field("pos", &self.pos)
            .field("segment", &self.segment)
            .field("ABI", &self.ABI)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstCollectDataPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstCollectDataPrivate = _GstCollectDataPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstCollectData_ABI_abi {
    pub dts: i64,
}

impl ::std::fmt::Debug for GstCollectData_ABI_abi {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstCollectData_ABI_abi @ {self:p}"))
            .field("dts", &self.dts)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstCollectPadsClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstCollectPadsClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstCollectPadsClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstCollectPadsPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstCollectPadsPrivate = _GstCollectPadsPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstDataQueueClass {
    pub parent_class: gobject::GObjectClass,
    pub empty: Option<unsafe extern "C" fn(*mut GstDataQueue)>,
    pub full: Option<unsafe extern "C" fn(*mut GstDataQueue)>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstDataQueueClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstDataQueueClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("empty", &self.empty)
            .field("full", &self.full)
            .field("_gst_reserved", &self._gst_reserved)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstDataQueueItem {
    pub object: *mut gst::GstMiniObject,
    pub size: c_uint,
    pub duration: u64,
    pub visible: gboolean,
    pub destroy: glib::GDestroyNotify,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstDataQueueItem {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstDataQueueItem @ {self:p}"))
            .field("object", &self.object)
            .field("size", &self.size)
            .field("duration", &self.duration)
            .field("visible", &self.visible)
            .field("destroy", &self.destroy)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstDataQueuePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstDataQueuePrivate = _GstDataQueuePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstDataQueueSize {
    pub visible: c_uint,
    pub bytes: c_uint,
    pub time: u64,
}

impl ::std::fmt::Debug for GstDataQueueSize {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstDataQueueSize @ {self:p}"))
            .field("visible", &self.visible)
            .field("bytes", &self.bytes)
            .field("time", &self.time)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstFlowCombiner {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstFlowCombiner {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstFlowCombiner @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstPushSrcClass {
    pub parent_class: GstBaseSrcClass,
    pub create:
        Option<unsafe extern "C" fn(*mut GstPushSrc, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub alloc:
        Option<unsafe extern "C" fn(*mut GstPushSrc, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub fill:
        Option<unsafe extern "C" fn(*mut GstPushSrc, *mut gst::GstBuffer) -> gst::GstFlowReturn>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstPushSrcClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstPushSrcClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("create", &self.create)
            .field("alloc", &self.alloc)
            .field("fill", &self.fill)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstQueueArray {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstQueueArray = _GstQueueArray;

#[repr(C)]
#[allow(dead_code)]
pub struct _GstTypeFindData {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstTypeFindData = _GstTypeFindData;

// Classes
#[repr(C)]
#[allow(dead_code)]
pub struct GstAdapter {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstAdapter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAdapter @ {self:p}")).finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAggregator {
    pub parent: gst::GstElement,
    pub srcpad: *mut gst::GstPad,
    pub priv_: *mut GstAggregatorPrivate,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstAggregator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAggregator @ {self:p}"))
            .field("parent", &self.parent)
            .field("srcpad", &self.srcpad)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstAggregatorPad {
    pub parent: gst::GstPad,
    pub segment: gst::GstSegment,
    pub priv_: *mut GstAggregatorPadPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstAggregatorPad {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstAggregatorPad @ {self:p}"))
            .field("parent", &self.parent)
            .field("segment", &self.segment)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseParse {
    pub element: gst::GstElement,
    pub sinkpad: *mut gst::GstPad,
    pub srcpad: *mut gst::GstPad,
    pub flags: c_uint,
    pub segment: gst::GstSegment,
    pub _gst_reserved: [gpointer; 20],
    pub priv_: *mut GstBaseParsePrivate,
}

impl ::std::fmt::Debug for GstBaseParse {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseParse @ {self:p}"))
            .field("element", &self.element)
            .field("sinkpad", &self.sinkpad)
            .field("srcpad", &self.srcpad)
            .field("flags", &self.flags)
            .field("segment", &self.segment)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseSink {
    pub element: gst::GstElement,
    pub sinkpad: *mut gst::GstPad,
    pub pad_mode: gst::GstPadMode,
    pub offset: u64,
    pub can_activate_pull: gboolean,
    pub can_activate_push: gboolean,
    pub preroll_lock: glib::GMutex,
    pub preroll_cond: glib::GCond,
    pub eos: gboolean,
    pub need_preroll: gboolean,
    pub have_preroll: gboolean,
    pub playing_async: gboolean,
    pub have_newsegment: gboolean,
    pub segment: gst::GstSegment,
    pub clock_id: gst::GstClockID,
    pub sync: gboolean,
    pub flushing: gboolean,
    pub running: gboolean,
    pub max_lateness: i64,
    pub priv_: *mut GstBaseSinkPrivate,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstBaseSink {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseSink @ {self:p}"))
            .field("element", &self.element)
            .field("sinkpad", &self.sinkpad)
            .field("pad_mode", &self.pad_mode)
            .field("offset", &self.offset)
            .field("can_activate_pull", &self.can_activate_pull)
            .field("can_activate_push", &self.can_activate_push)
            .field("preroll_lock", &self.preroll_lock)
            .field("preroll_cond", &self.preroll_cond)
            .field("eos", &self.eos)
            .field("need_preroll", &self.need_preroll)
            .field("have_preroll", &self.have_preroll)
            .field("playing_async", &self.playing_async)
            .field("have_newsegment", &self.have_newsegment)
            .field("segment", &self.segment)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseSrc {
    pub element: gst::GstElement,
    pub srcpad: *mut gst::GstPad,
    pub live_lock: glib::GMutex,
    pub live_cond: glib::GCond,
    pub is_live: gboolean,
    pub live_running: gboolean,
    pub blocksize: c_uint,
    pub can_activate_push: gboolean,
    pub random_access: gboolean,
    pub clock_id: gst::GstClockID,
    pub segment: gst::GstSegment,
    pub need_newsegment: gboolean,
    pub num_buffers: c_int,
    pub num_buffers_left: c_int,
    pub typefind: gboolean,
    pub running: gboolean,
    pub pending_seek: *mut gst::GstEvent,
    pub priv_: *mut GstBaseSrcPrivate,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstBaseSrc {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseSrc @ {self:p}"))
            .field("element", &self.element)
            .field("srcpad", &self.srcpad)
            .field("live_lock", &self.live_lock)
            .field("live_cond", &self.live_cond)
            .field("is_live", &self.is_live)
            .field("live_running", &self.live_running)
            .field("blocksize", &self.blocksize)
            .field("can_activate_push", &self.can_activate_push)
            .field("random_access", &self.random_access)
            .field("clock_id", &self.clock_id)
            .field("segment", &self.segment)
            .field("need_newsegment", &self.need_newsegment)
            .field("num_buffers", &self.num_buffers)
            .field("num_buffers_left", &self.num_buffers_left)
            .field("typefind", &self.typefind)
            .field("running", &self.running)
            .field("pending_seek", &self.pending_seek)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstBaseTransform {
    pub element: gst::GstElement,
    pub sinkpad: *mut gst::GstPad,
    pub srcpad: *mut gst::GstPad,
    pub have_segment: gboolean,
    pub segment: gst::GstSegment,
    pub queued_buf: *mut gst::GstBuffer,
    pub priv_: *mut GstBaseTransformPrivate,
    pub _gst_reserved: [gpointer; 19],
}

impl ::std::fmt::Debug for GstBaseTransform {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstBaseTransform @ {self:p}"))
            .field("element", &self.element)
            .field("sinkpad", &self.sinkpad)
            .field("srcpad", &self.srcpad)
            .field("have_segment", &self.have_segment)
            .field("segment", &self.segment)
            .field("queued_buf", &self.queued_buf)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstCollectPads {
    pub object: gst::GstObject,
    pub data: *mut glib::GSList,
    pub stream_lock: glib::GRecMutex,
    pub priv_: *mut GstCollectPadsPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstCollectPads {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstCollectPads @ {self:p}"))
            .field("object", &self.object)
            .field("data", &self.data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstDataQueue {
    pub object: gobject::GObject,
    pub priv_: *mut GstDataQueuePrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstDataQueue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstDataQueue @ {self:p}"))
            .field("object", &self.object)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstPushSrc {
    pub parent: GstBaseSrc,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstPushSrc {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstPushSrc @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

extern "C" {

    //=========================================================================
    // GstAggregatorStartTimeSelection
    //=========================================================================
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_start_time_selection_get_type() -> GType;

    //=========================================================================
    // GstBaseParseFrame
    //=========================================================================
    pub fn gst_base_parse_frame_get_type() -> GType;
    pub fn gst_base_parse_frame_new(
        buffer: *mut gst::GstBuffer,
        flags: GstBaseParseFrameFlags,
        overhead: c_int,
    ) -> *mut GstBaseParseFrame;
    pub fn gst_base_parse_frame_copy(frame: *mut GstBaseParseFrame) -> *mut GstBaseParseFrame;
    pub fn gst_base_parse_frame_free(frame: *mut GstBaseParseFrame);
    pub fn gst_base_parse_frame_init(frame: *mut GstBaseParseFrame);

    //=========================================================================
    // GstBitReader
    //=========================================================================
    pub fn gst_bit_reader_free(reader: *mut GstBitReader);
    pub fn gst_bit_reader_get_bits_uint16(
        reader: *mut GstBitReader,
        val: *mut u16,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_get_bits_uint32(
        reader: *mut GstBitReader,
        val: *mut u32,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_get_bits_uint64(
        reader: *mut GstBitReader,
        val: *mut u64,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_get_bits_uint8(
        reader: *mut GstBitReader,
        val: *mut u8,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_get_pos(reader: *const GstBitReader) -> c_uint;
    pub fn gst_bit_reader_get_remaining(reader: *const GstBitReader) -> c_uint;
    pub fn gst_bit_reader_get_size(reader: *const GstBitReader) -> c_uint;
    pub fn gst_bit_reader_init(reader: *mut GstBitReader, data: *const u8, size: c_uint);
    pub fn gst_bit_reader_peek_bits_uint16(
        reader: *const GstBitReader,
        val: *mut u16,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_peek_bits_uint32(
        reader: *const GstBitReader,
        val: *mut u32,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_peek_bits_uint64(
        reader: *const GstBitReader,
        val: *mut u64,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_peek_bits_uint8(
        reader: *const GstBitReader,
        val: *mut u8,
        nbits: c_uint,
    ) -> gboolean;
    pub fn gst_bit_reader_set_pos(reader: *mut GstBitReader, pos: c_uint) -> gboolean;
    pub fn gst_bit_reader_skip(reader: *mut GstBitReader, nbits: c_uint) -> gboolean;
    pub fn gst_bit_reader_skip_to_byte(reader: *mut GstBitReader) -> gboolean;
    pub fn gst_bit_reader_new(data: *const u8, size: c_uint) -> *mut GstBitReader;

    //=========================================================================
    // GstBitWriter
    //=========================================================================
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_align_bytes(bitwriter: *mut GstBitWriter, trailing_bit: u8) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_free(bitwriter: *mut GstBitWriter);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_free_and_get_buffer(bitwriter: *mut GstBitWriter) -> *mut gst::GstBuffer;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_free_and_get_data(bitwriter: *mut GstBitWriter) -> *mut u8;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_get_data(bitwriter: *const GstBitWriter) -> *mut u8;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_get_remaining(bitwriter: *const GstBitWriter) -> c_uint;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_get_size(bitwriter: *const GstBitWriter) -> c_uint;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_init(bitwriter: *mut GstBitWriter);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_init_with_data(
        bitwriter: *mut GstBitWriter,
        data: *mut u8,
        size: c_uint,
        initialized: gboolean,
    );
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_init_with_size(bitwriter: *mut GstBitWriter, size: u32, fixed: gboolean);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_put_bits_uint16(
        bitwriter: *mut GstBitWriter,
        value: u16,
        nbits: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_put_bits_uint32(
        bitwriter: *mut GstBitWriter,
        value: u32,
        nbits: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_put_bits_uint64(
        bitwriter: *mut GstBitWriter,
        value: u64,
        nbits: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_put_bits_uint8(
        bitwriter: *mut GstBitWriter,
        value: u8,
        nbits: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_put_bytes(
        bitwriter: *mut GstBitWriter,
        data: *const u8,
        nbytes: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_reset(bitwriter: *mut GstBitWriter);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_reset_and_get_buffer(bitwriter: *mut GstBitWriter)
        -> *mut gst::GstBuffer;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_reset_and_get_data(bitwriter: *mut GstBitWriter) -> *mut u8;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_set_pos(bitwriter: *mut GstBitWriter, pos: c_uint) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_new() -> *mut GstBitWriter;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_new_with_data(
        data: *mut u8,
        size: c_uint,
        initialized: gboolean,
    ) -> *mut GstBitWriter;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_bit_writer_new_with_size(size: u32, fixed: gboolean) -> *mut GstBitWriter;

    //=========================================================================
    // GstByteReader
    //=========================================================================
    pub fn gst_byte_reader_dup_data(
        reader: *mut GstByteReader,
        size: c_uint,
        val: *mut *mut u8,
    ) -> gboolean;
    pub fn gst_byte_reader_dup_string_utf16(
        reader: *mut GstByteReader,
        str: *mut *mut u16,
    ) -> gboolean;
    pub fn gst_byte_reader_dup_string_utf32(
        reader: *mut GstByteReader,
        str: *mut *mut u32,
    ) -> gboolean;
    pub fn gst_byte_reader_dup_string_utf8(
        reader: *mut GstByteReader,
        str: *mut *mut c_char,
    ) -> gboolean;
    pub fn gst_byte_reader_free(reader: *mut GstByteReader);
    pub fn gst_byte_reader_get_data(
        reader: *mut GstByteReader,
        size: c_uint,
        val: *mut *const u8,
    ) -> gboolean;
    pub fn gst_byte_reader_get_float32_be(
        reader: *mut GstByteReader,
        val: *mut c_float,
    ) -> gboolean;
    pub fn gst_byte_reader_get_float32_le(
        reader: *mut GstByteReader,
        val: *mut c_float,
    ) -> gboolean;
    pub fn gst_byte_reader_get_float64_be(
        reader: *mut GstByteReader,
        val: *mut c_double,
    ) -> gboolean;
    pub fn gst_byte_reader_get_float64_le(
        reader: *mut GstByteReader,
        val: *mut c_double,
    ) -> gboolean;
    pub fn gst_byte_reader_get_int16_be(reader: *mut GstByteReader, val: *mut i16) -> gboolean;
    pub fn gst_byte_reader_get_int16_le(reader: *mut GstByteReader, val: *mut i16) -> gboolean;
    pub fn gst_byte_reader_get_int24_be(reader: *mut GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_get_int24_le(reader: *mut GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_get_int32_be(reader: *mut GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_get_int32_le(reader: *mut GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_get_int64_be(reader: *mut GstByteReader, val: *mut i64) -> gboolean;
    pub fn gst_byte_reader_get_int64_le(reader: *mut GstByteReader, val: *mut i64) -> gboolean;
    pub fn gst_byte_reader_get_int8(reader: *mut GstByteReader, val: *mut i8) -> gboolean;
    pub fn gst_byte_reader_get_pos(reader: *const GstByteReader) -> c_uint;
    pub fn gst_byte_reader_get_remaining(reader: *const GstByteReader) -> c_uint;
    pub fn gst_byte_reader_get_size(reader: *const GstByteReader) -> c_uint;
    pub fn gst_byte_reader_get_string_utf8(
        reader: *mut GstByteReader,
        str: *mut *const c_char,
    ) -> gboolean;
    pub fn gst_byte_reader_get_sub_reader(
        reader: *mut GstByteReader,
        sub_reader: *mut GstByteReader,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_byte_reader_get_uint16_be(reader: *mut GstByteReader, val: *mut u16) -> gboolean;
    pub fn gst_byte_reader_get_uint16_le(reader: *mut GstByteReader, val: *mut u16) -> gboolean;
    pub fn gst_byte_reader_get_uint24_be(reader: *mut GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_get_uint24_le(reader: *mut GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_get_uint32_be(reader: *mut GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_get_uint32_le(reader: *mut GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_get_uint64_be(reader: *mut GstByteReader, val: *mut u64) -> gboolean;
    pub fn gst_byte_reader_get_uint64_le(reader: *mut GstByteReader, val: *mut u64) -> gboolean;
    pub fn gst_byte_reader_get_uint8(reader: *mut GstByteReader, val: *mut u8) -> gboolean;
    pub fn gst_byte_reader_init(reader: *mut GstByteReader, data: *const u8, size: c_uint);
    pub fn gst_byte_reader_masked_scan_uint32(
        reader: *const GstByteReader,
        mask: u32,
        pattern: u32,
        offset: c_uint,
        size: c_uint,
    ) -> c_uint;
    pub fn gst_byte_reader_masked_scan_uint32_peek(
        reader: *const GstByteReader,
        mask: u32,
        pattern: u32,
        offset: c_uint,
        size: c_uint,
        value: *mut u32,
    ) -> c_uint;
    pub fn gst_byte_reader_peek_data(
        reader: *const GstByteReader,
        size: c_uint,
        val: *mut *const u8,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_float32_be(
        reader: *const GstByteReader,
        val: *mut c_float,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_float32_le(
        reader: *const GstByteReader,
        val: *mut c_float,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_float64_be(
        reader: *const GstByteReader,
        val: *mut c_double,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_float64_le(
        reader: *const GstByteReader,
        val: *mut c_double,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_int16_be(reader: *const GstByteReader, val: *mut i16) -> gboolean;
    pub fn gst_byte_reader_peek_int16_le(reader: *const GstByteReader, val: *mut i16) -> gboolean;
    pub fn gst_byte_reader_peek_int24_be(reader: *const GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_peek_int24_le(reader: *const GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_peek_int32_be(reader: *const GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_peek_int32_le(reader: *const GstByteReader, val: *mut i32) -> gboolean;
    pub fn gst_byte_reader_peek_int64_be(reader: *const GstByteReader, val: *mut i64) -> gboolean;
    pub fn gst_byte_reader_peek_int64_le(reader: *const GstByteReader, val: *mut i64) -> gboolean;
    pub fn gst_byte_reader_peek_int8(reader: *const GstByteReader, val: *mut i8) -> gboolean;
    pub fn gst_byte_reader_peek_string_utf8(
        reader: *const GstByteReader,
        str: *mut *const c_char,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_sub_reader(
        reader: *mut GstByteReader,
        sub_reader: *mut GstByteReader,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_byte_reader_peek_uint16_be(reader: *const GstByteReader, val: *mut u16) -> gboolean;
    pub fn gst_byte_reader_peek_uint16_le(reader: *const GstByteReader, val: *mut u16) -> gboolean;
    pub fn gst_byte_reader_peek_uint24_be(reader: *const GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_peek_uint24_le(reader: *const GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_peek_uint32_be(reader: *const GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_peek_uint32_le(reader: *const GstByteReader, val: *mut u32) -> gboolean;
    pub fn gst_byte_reader_peek_uint64_be(reader: *const GstByteReader, val: *mut u64) -> gboolean;
    pub fn gst_byte_reader_peek_uint64_le(reader: *const GstByteReader, val: *mut u64) -> gboolean;
    pub fn gst_byte_reader_peek_uint8(reader: *const GstByteReader, val: *mut u8) -> gboolean;
    pub fn gst_byte_reader_set_pos(reader: *mut GstByteReader, pos: c_uint) -> gboolean;
    pub fn gst_byte_reader_skip(reader: *mut GstByteReader, nbytes: c_uint) -> gboolean;
    pub fn gst_byte_reader_skip_string_utf16(reader: *mut GstByteReader) -> gboolean;
    pub fn gst_byte_reader_skip_string_utf32(reader: *mut GstByteReader) -> gboolean;
    pub fn gst_byte_reader_skip_string_utf8(reader: *mut GstByteReader) -> gboolean;
    pub fn gst_byte_reader_new(data: *const u8, size: c_uint) -> *mut GstByteReader;

    //=========================================================================
    // GstByteWriter
    //=========================================================================
    pub fn gst_byte_writer_ensure_free_space(writer: *mut GstByteWriter, size: c_uint) -> gboolean;
    pub fn gst_byte_writer_fill(writer: *mut GstByteWriter, value: u8, size: c_uint) -> gboolean;
    pub fn gst_byte_writer_free(writer: *mut GstByteWriter);
    pub fn gst_byte_writer_free_and_get_buffer(writer: *mut GstByteWriter) -> *mut gst::GstBuffer;
    pub fn gst_byte_writer_free_and_get_data(writer: *mut GstByteWriter) -> *mut u8;
    pub fn gst_byte_writer_get_remaining(writer: *const GstByteWriter) -> c_uint;
    pub fn gst_byte_writer_init(writer: *mut GstByteWriter);
    pub fn gst_byte_writer_init_with_data(
        writer: *mut GstByteWriter,
        data: *mut u8,
        size: c_uint,
        initialized: gboolean,
    );
    pub fn gst_byte_writer_init_with_size(
        writer: *mut GstByteWriter,
        size: c_uint,
        fixed: gboolean,
    );
    pub fn gst_byte_writer_put_buffer(
        writer: *mut GstByteWriter,
        buffer: *mut gst::GstBuffer,
        offset: size_t,
        size: ssize_t,
    ) -> gboolean;
    pub fn gst_byte_writer_put_data(
        writer: *mut GstByteWriter,
        data: *const u8,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_byte_writer_put_float32_be(writer: *mut GstByteWriter, val: c_float) -> gboolean;
    pub fn gst_byte_writer_put_float32_le(writer: *mut GstByteWriter, val: c_float) -> gboolean;
    pub fn gst_byte_writer_put_float64_be(writer: *mut GstByteWriter, val: c_double) -> gboolean;
    pub fn gst_byte_writer_put_float64_le(writer: *mut GstByteWriter, val: c_double) -> gboolean;
    pub fn gst_byte_writer_put_int16_be(writer: *mut GstByteWriter, val: i16) -> gboolean;
    pub fn gst_byte_writer_put_int16_le(writer: *mut GstByteWriter, val: i16) -> gboolean;
    pub fn gst_byte_writer_put_int24_be(writer: *mut GstByteWriter, val: i32) -> gboolean;
    pub fn gst_byte_writer_put_int24_le(writer: *mut GstByteWriter, val: i32) -> gboolean;
    pub fn gst_byte_writer_put_int32_be(writer: *mut GstByteWriter, val: i32) -> gboolean;
    pub fn gst_byte_writer_put_int32_le(writer: *mut GstByteWriter, val: i32) -> gboolean;
    pub fn gst_byte_writer_put_int64_be(writer: *mut GstByteWriter, val: i64) -> gboolean;
    pub fn gst_byte_writer_put_int64_le(writer: *mut GstByteWriter, val: i64) -> gboolean;
    pub fn gst_byte_writer_put_int8(writer: *mut GstByteWriter, val: i8) -> gboolean;
    pub fn gst_byte_writer_put_string_utf16(
        writer: *mut GstByteWriter,
        data: *const u16,
    ) -> gboolean;
    pub fn gst_byte_writer_put_string_utf32(
        writer: *mut GstByteWriter,
        data: *const u32,
    ) -> gboolean;
    pub fn gst_byte_writer_put_string_utf8(
        writer: *mut GstByteWriter,
        data: *const c_char,
    ) -> gboolean;
    pub fn gst_byte_writer_put_uint16_be(writer: *mut GstByteWriter, val: u16) -> gboolean;
    pub fn gst_byte_writer_put_uint16_le(writer: *mut GstByteWriter, val: u16) -> gboolean;
    pub fn gst_byte_writer_put_uint24_be(writer: *mut GstByteWriter, val: u32) -> gboolean;
    pub fn gst_byte_writer_put_uint24_le(writer: *mut GstByteWriter, val: u32) -> gboolean;
    pub fn gst_byte_writer_put_uint32_be(writer: *mut GstByteWriter, val: u32) -> gboolean;
    pub fn gst_byte_writer_put_uint32_le(writer: *mut GstByteWriter, val: u32) -> gboolean;
    pub fn gst_byte_writer_put_uint64_be(writer: *mut GstByteWriter, val: u64) -> gboolean;
    pub fn gst_byte_writer_put_uint64_le(writer: *mut GstByteWriter, val: u64) -> gboolean;
    pub fn gst_byte_writer_put_uint8(writer: *mut GstByteWriter, val: u8) -> gboolean;
    pub fn gst_byte_writer_reset(writer: *mut GstByteWriter);
    pub fn gst_byte_writer_reset_and_get_buffer(writer: *mut GstByteWriter) -> *mut gst::GstBuffer;
    pub fn gst_byte_writer_reset_and_get_data(writer: *mut GstByteWriter) -> *mut u8;
    pub fn gst_byte_writer_new() -> *mut GstByteWriter;
    pub fn gst_byte_writer_new_with_data(
        data: *mut u8,
        size: c_uint,
        initialized: gboolean,
    ) -> *mut GstByteWriter;
    pub fn gst_byte_writer_new_with_size(size: c_uint, fixed: gboolean) -> *mut GstByteWriter;

    //=========================================================================
    // GstFlowCombiner
    //=========================================================================
    pub fn gst_flow_combiner_get_type() -> GType;
    pub fn gst_flow_combiner_new() -> *mut GstFlowCombiner;
    pub fn gst_flow_combiner_add_pad(combiner: *mut GstFlowCombiner, pad: *mut gst::GstPad);
    pub fn gst_flow_combiner_clear(combiner: *mut GstFlowCombiner);
    pub fn gst_flow_combiner_free(combiner: *mut GstFlowCombiner);
    pub fn gst_flow_combiner_ref(combiner: *mut GstFlowCombiner) -> *mut GstFlowCombiner;
    pub fn gst_flow_combiner_remove_pad(combiner: *mut GstFlowCombiner, pad: *mut gst::GstPad);
    pub fn gst_flow_combiner_reset(combiner: *mut GstFlowCombiner);
    pub fn gst_flow_combiner_unref(combiner: *mut GstFlowCombiner);
    pub fn gst_flow_combiner_update_flow(
        combiner: *mut GstFlowCombiner,
        fret: gst::GstFlowReturn,
    ) -> gst::GstFlowReturn;
    pub fn gst_flow_combiner_update_pad_flow(
        combiner: *mut GstFlowCombiner,
        pad: *mut gst::GstPad,
        fret: gst::GstFlowReturn,
    ) -> gst::GstFlowReturn;

    //=========================================================================
    // GstQueueArray
    //=========================================================================
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_queue_array_clear(array: *mut GstQueueArray);
    pub fn gst_queue_array_drop_element(array: *mut GstQueueArray, idx: c_uint) -> gpointer;
    pub fn gst_queue_array_drop_struct(
        array: *mut GstQueueArray,
        idx: c_uint,
        p_struct: gpointer,
    ) -> gboolean;
    pub fn gst_queue_array_find(
        array: *mut GstQueueArray,
        func: glib::GCompareFunc,
        data: gpointer,
    ) -> c_uint;
    pub fn gst_queue_array_free(array: *mut GstQueueArray);
    pub fn gst_queue_array_get_length(array: *mut GstQueueArray) -> c_uint;
    pub fn gst_queue_array_is_empty(array: *mut GstQueueArray) -> gboolean;
    pub fn gst_queue_array_peek_head(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_peek_head_struct(array: *mut GstQueueArray) -> gpointer;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_queue_array_peek_nth(array: *mut GstQueueArray, idx: c_uint) -> gpointer;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_queue_array_peek_nth_struct(array: *mut GstQueueArray, idx: c_uint) -> gpointer;
    pub fn gst_queue_array_peek_tail(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_peek_tail_struct(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_pop_head(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_pop_head_struct(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_pop_tail(array: *mut GstQueueArray) -> gpointer;
    pub fn gst_queue_array_pop_tail_struct(array: *mut GstQueueArray) -> gpointer;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_queue_array_push_sorted(
        array: *mut GstQueueArray,
        data: gpointer,
        func: glib::GCompareDataFunc,
        user_data: gpointer,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_queue_array_push_sorted_struct(
        array: *mut GstQueueArray,
        p_struct: gpointer,
        func: glib::GCompareDataFunc,
        user_data: gpointer,
    );
    pub fn gst_queue_array_push_tail(array: *mut GstQueueArray, data: gpointer);
    pub fn gst_queue_array_push_tail_struct(array: *mut GstQueueArray, p_struct: gpointer);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_queue_array_set_clear_func(
        array: *mut GstQueueArray,
        clear_func: glib::GDestroyNotify,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_queue_array_sort(
        array: *mut GstQueueArray,
        compare_func: glib::GCompareDataFunc,
        user_data: gpointer,
    );
    pub fn gst_queue_array_new(initial_size: c_uint) -> *mut GstQueueArray;
    pub fn gst_queue_array_new_for_struct(
        struct_size: size_t,
        initial_size: c_uint,
    ) -> *mut GstQueueArray;

    //=========================================================================
    // GstTypeFindData
    //=========================================================================
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_data_free(data: *mut GstTypeFindData);
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_data_get_caps(data: *mut GstTypeFindData) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_data_get_probability(
        data: *mut GstTypeFindData,
    ) -> gst::GstTypeFindProbability;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_data_get_typefind(data: *mut GstTypeFindData) -> *mut gst::GstTypeFind;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_data_new(
        obj: *mut gst::GstObject,
        data: *const u8,
        size: size_t,
    ) -> *mut GstTypeFindData;

    //=========================================================================
    // GstAdapter
    //=========================================================================
    pub fn gst_adapter_get_type() -> GType;
    pub fn gst_adapter_new() -> *mut GstAdapter;
    pub fn gst_adapter_available(adapter: *mut GstAdapter) -> size_t;
    pub fn gst_adapter_available_fast(adapter: *mut GstAdapter) -> size_t;
    pub fn gst_adapter_clear(adapter: *mut GstAdapter);
    pub fn gst_adapter_copy(adapter: *mut GstAdapter, dest: gpointer, offset: size_t, size: size_t);
    pub fn gst_adapter_copy_bytes(
        adapter: *mut GstAdapter,
        offset: size_t,
        size: size_t,
    ) -> *mut glib::GBytes;
    pub fn gst_adapter_distance_from_discont(adapter: *mut GstAdapter) -> u64;
    pub fn gst_adapter_dts_at_discont(adapter: *mut GstAdapter) -> gst::GstClockTime;
    pub fn gst_adapter_flush(adapter: *mut GstAdapter, flush: size_t);
    pub fn gst_adapter_get_buffer(adapter: *mut GstAdapter, nbytes: size_t) -> *mut gst::GstBuffer;
    pub fn gst_adapter_get_buffer_fast(
        adapter: *mut GstAdapter,
        nbytes: size_t,
    ) -> *mut gst::GstBuffer;
    pub fn gst_adapter_get_buffer_list(
        adapter: *mut GstAdapter,
        nbytes: size_t,
    ) -> *mut gst::GstBufferList;
    pub fn gst_adapter_get_list(adapter: *mut GstAdapter, nbytes: size_t) -> *mut glib::GList;
    pub fn gst_adapter_map(adapter: *mut GstAdapter, size: size_t) -> gconstpointer;
    pub fn gst_adapter_masked_scan_uint32(
        adapter: *mut GstAdapter,
        mask: u32,
        pattern: u32,
        offset: size_t,
        size: size_t,
    ) -> ssize_t;
    pub fn gst_adapter_masked_scan_uint32_peek(
        adapter: *mut GstAdapter,
        mask: u32,
        pattern: u32,
        offset: size_t,
        size: size_t,
        value: *mut u32,
    ) -> ssize_t;
    pub fn gst_adapter_offset_at_discont(adapter: *mut GstAdapter) -> u64;
    pub fn gst_adapter_prev_dts(adapter: *mut GstAdapter, distance: *mut u64) -> gst::GstClockTime;
    pub fn gst_adapter_prev_dts_at_offset(
        adapter: *mut GstAdapter,
        offset: size_t,
        distance: *mut u64,
    ) -> gst::GstClockTime;
    pub fn gst_adapter_prev_offset(adapter: *mut GstAdapter, distance: *mut u64) -> u64;
    pub fn gst_adapter_prev_pts(adapter: *mut GstAdapter, distance: *mut u64) -> gst::GstClockTime;
    pub fn gst_adapter_prev_pts_at_offset(
        adapter: *mut GstAdapter,
        offset: size_t,
        distance: *mut u64,
    ) -> gst::GstClockTime;
    pub fn gst_adapter_pts_at_discont(adapter: *mut GstAdapter) -> gst::GstClockTime;
    pub fn gst_adapter_push(adapter: *mut GstAdapter, buf: *mut gst::GstBuffer);
    pub fn gst_adapter_take(adapter: *mut GstAdapter, nbytes: size_t) -> gpointer;
    pub fn gst_adapter_take_buffer(adapter: *mut GstAdapter, nbytes: size_t)
        -> *mut gst::GstBuffer;
    pub fn gst_adapter_take_buffer_fast(
        adapter: *mut GstAdapter,
        nbytes: size_t,
    ) -> *mut gst::GstBuffer;
    pub fn gst_adapter_take_buffer_list(
        adapter: *mut GstAdapter,
        nbytes: size_t,
    ) -> *mut gst::GstBufferList;
    pub fn gst_adapter_take_list(adapter: *mut GstAdapter, nbytes: size_t) -> *mut glib::GList;
    pub fn gst_adapter_unmap(adapter: *mut GstAdapter);

    //=========================================================================
    // GstAggregator
    //=========================================================================
    pub fn gst_aggregator_get_type() -> GType;
    pub fn gst_aggregator_finish_buffer(
        aggregator: *mut GstAggregator,
        buffer: *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_finish_buffer_list(
        aggregator: *mut GstAggregator,
        bufferlist: *mut gst::GstBufferList,
    ) -> gst::GstFlowReturn;
    pub fn gst_aggregator_get_allocator(
        self_: *mut GstAggregator,
        allocator: *mut *mut gst::GstAllocator,
        params: *mut gst::GstAllocationParams,
    );
    pub fn gst_aggregator_get_buffer_pool(self_: *mut GstAggregator) -> *mut gst::GstBufferPool;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_aggregator_get_force_live(self_: *mut GstAggregator) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_aggregator_get_ignore_inactive_pads(self_: *mut GstAggregator) -> gboolean;
    pub fn gst_aggregator_get_latency(self_: *mut GstAggregator) -> gst::GstClockTime;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_negotiate(self_: *mut GstAggregator) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_peek_next_sample(
        self_: *mut GstAggregator,
        pad: *mut GstAggregatorPad,
    ) -> *mut gst::GstSample;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_aggregator_push_src_event(
        aggregator: *mut GstAggregator,
        event: *mut gst::GstEvent,
    ) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_selected_samples(
        self_: *mut GstAggregator,
        pts: gst::GstClockTime,
        dts: gst::GstClockTime,
        duration: gst::GstClockTime,
        info: *mut gst::GstStructure,
    );
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_aggregator_set_force_live(self_: *mut GstAggregator, force_live: gboolean);
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_aggregator_set_ignore_inactive_pads(self_: *mut GstAggregator, ignore: gboolean);
    pub fn gst_aggregator_set_latency(
        self_: *mut GstAggregator,
        min_latency: gst::GstClockTime,
        max_latency: gst::GstClockTime,
    );
    pub fn gst_aggregator_set_src_caps(self_: *mut GstAggregator, caps: *mut gst::GstCaps);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_aggregator_simple_get_next_time(self_: *mut GstAggregator) -> gst::GstClockTime;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_aggregator_update_segment(
        self_: *mut GstAggregator,
        segment: *const gst::GstSegment,
    );

    //=========================================================================
    // GstAggregatorPad
    //=========================================================================
    pub fn gst_aggregator_pad_get_type() -> GType;
    pub fn gst_aggregator_pad_drop_buffer(pad: *mut GstAggregatorPad) -> gboolean;
    #[cfg(feature = "v1_14_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_14_1")))]
    pub fn gst_aggregator_pad_has_buffer(pad: *mut GstAggregatorPad) -> gboolean;
    pub fn gst_aggregator_pad_is_eos(pad: *mut GstAggregatorPad) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_aggregator_pad_is_inactive(pad: *mut GstAggregatorPad) -> gboolean;
    pub fn gst_aggregator_pad_peek_buffer(pad: *mut GstAggregatorPad) -> *mut gst::GstBuffer;
    pub fn gst_aggregator_pad_pop_buffer(pad: *mut GstAggregatorPad) -> *mut gst::GstBuffer;

    //=========================================================================
    // GstBaseParse
    //=========================================================================
    pub fn gst_base_parse_get_type() -> GType;
    pub fn gst_base_parse_add_index_entry(
        parse: *mut GstBaseParse,
        offset: u64,
        ts: gst::GstClockTime,
        key: gboolean,
        force: gboolean,
    ) -> gboolean;
    pub fn gst_base_parse_convert_default(
        parse: *mut GstBaseParse,
        src_format: gst::GstFormat,
        src_value: i64,
        dest_format: gst::GstFormat,
        dest_value: *mut i64,
    ) -> gboolean;
    pub fn gst_base_parse_drain(parse: *mut GstBaseParse);
    pub fn gst_base_parse_finish_frame(
        parse: *mut GstBaseParse,
        frame: *mut GstBaseParseFrame,
        size: c_int,
    ) -> gst::GstFlowReturn;
    pub fn gst_base_parse_merge_tags(
        parse: *mut GstBaseParse,
        tags: *mut gst::GstTagList,
        mode: gst::GstTagMergeMode,
    );
    pub fn gst_base_parse_push_frame(
        parse: *mut GstBaseParse,
        frame: *mut GstBaseParseFrame,
    ) -> gst::GstFlowReturn;
    pub fn gst_base_parse_set_average_bitrate(parse: *mut GstBaseParse, bitrate: c_uint);
    pub fn gst_base_parse_set_duration(
        parse: *mut GstBaseParse,
        fmt: gst::GstFormat,
        duration: i64,
        interval: c_int,
    );
    pub fn gst_base_parse_set_frame_rate(
        parse: *mut GstBaseParse,
        fps_num: c_uint,
        fps_den: c_uint,
        lead_in: c_uint,
        lead_out: c_uint,
    );
    pub fn gst_base_parse_set_has_timing_info(parse: *mut GstBaseParse, has_timing: gboolean);
    pub fn gst_base_parse_set_infer_ts(parse: *mut GstBaseParse, infer_ts: gboolean);
    pub fn gst_base_parse_set_latency(
        parse: *mut GstBaseParse,
        min_latency: gst::GstClockTime,
        max_latency: gst::GstClockTime,
    );
    pub fn gst_base_parse_set_min_frame_size(parse: *mut GstBaseParse, min_size: c_uint);
    pub fn gst_base_parse_set_passthrough(parse: *mut GstBaseParse, passthrough: gboolean);
    pub fn gst_base_parse_set_pts_interpolation(
        parse: *mut GstBaseParse,
        pts_interpolate: gboolean,
    );
    pub fn gst_base_parse_set_syncable(parse: *mut GstBaseParse, syncable: gboolean);
    pub fn gst_base_parse_set_ts_at_offset(parse: *mut GstBaseParse, offset: size_t);

    //=========================================================================
    // GstBaseSink
    //=========================================================================
    pub fn gst_base_sink_get_type() -> GType;
    pub fn gst_base_sink_do_preroll(
        sink: *mut GstBaseSink,
        obj: *mut gst::GstMiniObject,
    ) -> gst::GstFlowReturn;
    pub fn gst_base_sink_get_blocksize(sink: *mut GstBaseSink) -> c_uint;
    pub fn gst_base_sink_get_drop_out_of_segment(sink: *mut GstBaseSink) -> gboolean;
    pub fn gst_base_sink_get_last_sample(sink: *mut GstBaseSink) -> *mut gst::GstSample;
    pub fn gst_base_sink_get_latency(sink: *mut GstBaseSink) -> gst::GstClockTime;
    pub fn gst_base_sink_get_max_bitrate(sink: *mut GstBaseSink) -> u64;
    pub fn gst_base_sink_get_max_lateness(sink: *mut GstBaseSink) -> i64;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_base_sink_get_processing_deadline(sink: *mut GstBaseSink) -> gst::GstClockTime;
    pub fn gst_base_sink_get_render_delay(sink: *mut GstBaseSink) -> gst::GstClockTime;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_base_sink_get_stats(sink: *mut GstBaseSink) -> *mut gst::GstStructure;
    pub fn gst_base_sink_get_sync(sink: *mut GstBaseSink) -> gboolean;
    pub fn gst_base_sink_get_throttle_time(sink: *mut GstBaseSink) -> u64;
    pub fn gst_base_sink_get_ts_offset(sink: *mut GstBaseSink) -> gst::GstClockTimeDiff;
    pub fn gst_base_sink_is_async_enabled(sink: *mut GstBaseSink) -> gboolean;
    pub fn gst_base_sink_is_last_sample_enabled(sink: *mut GstBaseSink) -> gboolean;
    pub fn gst_base_sink_is_qos_enabled(sink: *mut GstBaseSink) -> gboolean;
    pub fn gst_base_sink_query_latency(
        sink: *mut GstBaseSink,
        live: *mut gboolean,
        upstream_live: *mut gboolean,
        min_latency: *mut gst::GstClockTime,
        max_latency: *mut gst::GstClockTime,
    ) -> gboolean;
    pub fn gst_base_sink_set_async_enabled(sink: *mut GstBaseSink, enabled: gboolean);
    pub fn gst_base_sink_set_blocksize(sink: *mut GstBaseSink, blocksize: c_uint);
    pub fn gst_base_sink_set_drop_out_of_segment(
        sink: *mut GstBaseSink,
        drop_out_of_segment: gboolean,
    );
    pub fn gst_base_sink_set_last_sample_enabled(sink: *mut GstBaseSink, enabled: gboolean);
    pub fn gst_base_sink_set_max_bitrate(sink: *mut GstBaseSink, max_bitrate: u64);
    pub fn gst_base_sink_set_max_lateness(sink: *mut GstBaseSink, max_lateness: i64);
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_base_sink_set_processing_deadline(
        sink: *mut GstBaseSink,
        processing_deadline: gst::GstClockTime,
    );
    pub fn gst_base_sink_set_qos_enabled(sink: *mut GstBaseSink, enabled: gboolean);
    pub fn gst_base_sink_set_render_delay(sink: *mut GstBaseSink, delay: gst::GstClockTime);
    pub fn gst_base_sink_set_sync(sink: *mut GstBaseSink, sync: gboolean);
    pub fn gst_base_sink_set_throttle_time(sink: *mut GstBaseSink, throttle: u64);
    pub fn gst_base_sink_set_ts_offset(sink: *mut GstBaseSink, offset: gst::GstClockTimeDiff);
    pub fn gst_base_sink_wait(
        sink: *mut GstBaseSink,
        time: gst::GstClockTime,
        jitter: *mut gst::GstClockTimeDiff,
    ) -> gst::GstFlowReturn;
    pub fn gst_base_sink_wait_clock(
        sink: *mut GstBaseSink,
        time: gst::GstClockTime,
        jitter: *mut gst::GstClockTimeDiff,
    ) -> gst::GstClockReturn;
    pub fn gst_base_sink_wait_preroll(sink: *mut GstBaseSink) -> gst::GstFlowReturn;

    //=========================================================================
    // GstBaseSrc
    //=========================================================================
    pub fn gst_base_src_get_type() -> GType;
    pub fn gst_base_src_get_allocator(
        src: *mut GstBaseSrc,
        allocator: *mut *mut gst::GstAllocator,
        params: *mut gst::GstAllocationParams,
    );
    pub fn gst_base_src_get_blocksize(src: *mut GstBaseSrc) -> c_uint;
    pub fn gst_base_src_get_buffer_pool(src: *mut GstBaseSrc) -> *mut gst::GstBufferPool;
    pub fn gst_base_src_get_do_timestamp(src: *mut GstBaseSrc) -> gboolean;
    pub fn gst_base_src_is_async(src: *mut GstBaseSrc) -> gboolean;
    pub fn gst_base_src_is_live(src: *mut GstBaseSrc) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_base_src_negotiate(src: *mut GstBaseSrc) -> gboolean;
    pub fn gst_base_src_new_seamless_segment(
        src: *mut GstBaseSrc,
        start: i64,
        stop: i64,
        time: i64,
    ) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_base_src_new_segment(
        src: *mut GstBaseSrc,
        segment: *const gst::GstSegment,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_base_src_push_segment(
        src: *mut GstBaseSrc,
        segment: *const gst::GstSegment,
    ) -> gboolean;
    pub fn gst_base_src_query_latency(
        src: *mut GstBaseSrc,
        live: *mut gboolean,
        min_latency: *mut gst::GstClockTime,
        max_latency: *mut gst::GstClockTime,
    ) -> gboolean;
    pub fn gst_base_src_set_async(src: *mut GstBaseSrc, async_: gboolean);
    pub fn gst_base_src_set_automatic_eos(src: *mut GstBaseSrc, automatic_eos: gboolean);
    pub fn gst_base_src_set_blocksize(src: *mut GstBaseSrc, blocksize: c_uint);
    pub fn gst_base_src_set_caps(src: *mut GstBaseSrc, caps: *mut gst::GstCaps) -> gboolean;
    pub fn gst_base_src_set_do_timestamp(src: *mut GstBaseSrc, timestamp: gboolean);
    pub fn gst_base_src_set_dynamic_size(src: *mut GstBaseSrc, dynamic: gboolean);
    pub fn gst_base_src_set_format(src: *mut GstBaseSrc, format: gst::GstFormat);
    pub fn gst_base_src_set_live(src: *mut GstBaseSrc, live: gboolean);
    pub fn gst_base_src_start_complete(basesrc: *mut GstBaseSrc, ret: gst::GstFlowReturn);
    pub fn gst_base_src_start_wait(basesrc: *mut GstBaseSrc) -> gst::GstFlowReturn;
    pub fn gst_base_src_submit_buffer_list(
        src: *mut GstBaseSrc,
        buffer_list: *mut gst::GstBufferList,
    );
    pub fn gst_base_src_wait_playing(src: *mut GstBaseSrc) -> gst::GstFlowReturn;

    //=========================================================================
    // GstBaseTransform
    //=========================================================================
    pub fn gst_base_transform_get_type() -> GType;
    pub fn gst_base_transform_get_allocator(
        trans: *mut GstBaseTransform,
        allocator: *mut *mut gst::GstAllocator,
        params: *mut gst::GstAllocationParams,
    );
    pub fn gst_base_transform_get_buffer_pool(
        trans: *mut GstBaseTransform,
    ) -> *mut gst::GstBufferPool;
    pub fn gst_base_transform_is_in_place(trans: *mut GstBaseTransform) -> gboolean;
    pub fn gst_base_transform_is_passthrough(trans: *mut GstBaseTransform) -> gboolean;
    pub fn gst_base_transform_is_qos_enabled(trans: *mut GstBaseTransform) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_base_transform_reconfigure(trans: *mut GstBaseTransform) -> gboolean;
    pub fn gst_base_transform_reconfigure_sink(trans: *mut GstBaseTransform);
    pub fn gst_base_transform_reconfigure_src(trans: *mut GstBaseTransform);
    pub fn gst_base_transform_set_gap_aware(trans: *mut GstBaseTransform, gap_aware: gboolean);
    pub fn gst_base_transform_set_in_place(trans: *mut GstBaseTransform, in_place: gboolean);
    pub fn gst_base_transform_set_passthrough(trans: *mut GstBaseTransform, passthrough: gboolean);
    pub fn gst_base_transform_set_prefer_passthrough(
        trans: *mut GstBaseTransform,
        prefer_passthrough: gboolean,
    );
    pub fn gst_base_transform_set_qos_enabled(trans: *mut GstBaseTransform, enabled: gboolean);
    pub fn gst_base_transform_update_qos(
        trans: *mut GstBaseTransform,
        proportion: c_double,
        diff: gst::GstClockTimeDiff,
        timestamp: gst::GstClockTime,
    );
    pub fn gst_base_transform_update_src_caps(
        trans: *mut GstBaseTransform,
        updated_caps: *mut gst::GstCaps,
    ) -> gboolean;

    //=========================================================================
    // GstCollectPads
    //=========================================================================
    pub fn gst_collect_pads_get_type() -> GType;
    pub fn gst_collect_pads_new() -> *mut GstCollectPads;
    pub fn gst_collect_pads_add_pad(
        pads: *mut GstCollectPads,
        pad: *mut gst::GstPad,
        size: c_uint,
        destroy_notify: GstCollectDataDestroyNotify,
        lock: gboolean,
    ) -> *mut GstCollectData;
    pub fn gst_collect_pads_available(pads: *mut GstCollectPads) -> c_uint;
    pub fn gst_collect_pads_clip_running_time(
        pads: *mut GstCollectPads,
        cdata: *mut GstCollectData,
        buf: *mut gst::GstBuffer,
        outbuf: *mut *mut gst::GstBuffer,
        user_data: gpointer,
    ) -> gst::GstFlowReturn;
    pub fn gst_collect_pads_event_default(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        event: *mut gst::GstEvent,
        discard: gboolean,
    ) -> gboolean;
    pub fn gst_collect_pads_flush(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        size: c_uint,
    ) -> c_uint;
    pub fn gst_collect_pads_peek(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
    ) -> *mut gst::GstBuffer;
    pub fn gst_collect_pads_pop(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
    ) -> *mut gst::GstBuffer;
    pub fn gst_collect_pads_query_default(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        query: *mut gst::GstQuery,
        discard: gboolean,
    ) -> gboolean;
    pub fn gst_collect_pads_read_buffer(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        size: c_uint,
    ) -> *mut gst::GstBuffer;
    pub fn gst_collect_pads_remove_pad(
        pads: *mut GstCollectPads,
        pad: *mut gst::GstPad,
    ) -> gboolean;
    pub fn gst_collect_pads_set_buffer_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsBufferFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_clip_function(
        pads: *mut GstCollectPads,
        clipfunc: GstCollectPadsClipFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_compare_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsCompareFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_event_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsEventFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_flush_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsFlushFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_flushing(pads: *mut GstCollectPads, flushing: gboolean);
    pub fn gst_collect_pads_set_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_query_function(
        pads: *mut GstCollectPads,
        func: GstCollectPadsQueryFunction,
        user_data: gpointer,
    );
    pub fn gst_collect_pads_set_waiting(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        waiting: gboolean,
    );
    pub fn gst_collect_pads_src_event_default(
        pads: *mut GstCollectPads,
        pad: *mut gst::GstPad,
        event: *mut gst::GstEvent,
    ) -> gboolean;
    pub fn gst_collect_pads_start(pads: *mut GstCollectPads);
    pub fn gst_collect_pads_stop(pads: *mut GstCollectPads);
    pub fn gst_collect_pads_take_buffer(
        pads: *mut GstCollectPads,
        data: *mut GstCollectData,
        size: c_uint,
    ) -> *mut gst::GstBuffer;

    //=========================================================================
    // GstDataQueue
    //=========================================================================
    pub fn gst_data_queue_get_type() -> GType;
    pub fn gst_data_queue_new(
        checkfull: GstDataQueueCheckFullFunction,
        fullcallback: GstDataQueueFullCallback,
        emptycallback: GstDataQueueEmptyCallback,
        checkdata: gpointer,
    ) -> *mut GstDataQueue;
    pub fn gst_data_queue_drop_head(queue: *mut GstDataQueue, type_: GType) -> gboolean;
    pub fn gst_data_queue_flush(queue: *mut GstDataQueue);
    pub fn gst_data_queue_get_level(queue: *mut GstDataQueue, level: *mut GstDataQueueSize);
    pub fn gst_data_queue_is_empty(queue: *mut GstDataQueue) -> gboolean;
    pub fn gst_data_queue_is_full(queue: *mut GstDataQueue) -> gboolean;
    pub fn gst_data_queue_limits_changed(queue: *mut GstDataQueue);
    pub fn gst_data_queue_peek(
        queue: *mut GstDataQueue,
        item: *mut *mut GstDataQueueItem,
    ) -> gboolean;
    pub fn gst_data_queue_pop(
        queue: *mut GstDataQueue,
        item: *mut *mut GstDataQueueItem,
    ) -> gboolean;
    pub fn gst_data_queue_push(queue: *mut GstDataQueue, item: *mut GstDataQueueItem) -> gboolean;
    pub fn gst_data_queue_push_force(
        queue: *mut GstDataQueue,
        item: *mut GstDataQueueItem,
    ) -> gboolean;
    pub fn gst_data_queue_set_flushing(queue: *mut GstDataQueue, flushing: gboolean);

    //=========================================================================
    // GstPushSrc
    //=========================================================================
    pub fn gst_push_src_get_type() -> GType;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_type_find_helper(src: *mut gst::GstPad, size: u64) -> *mut gst::GstCaps;
    pub fn gst_type_find_helper_for_buffer(
        obj: *mut gst::GstObject,
        buf: *mut gst::GstBuffer,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_helper_for_buffer_with_caps(
        obj: *mut gst::GstObject,
        buf: *mut gst::GstBuffer,
        caps: *mut gst::GstCaps,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_type_find_helper_for_buffer_with_extension(
        obj: *mut gst::GstObject,
        buf: *mut gst::GstBuffer,
        extension: *const c_char,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    pub fn gst_type_find_helper_for_data(
        obj: *mut gst::GstObject,
        data: *const u8,
        size: size_t,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_helper_for_data_with_caps(
        obj: *mut gst::GstObject,
        data: *const u8,
        size: size_t,
        caps: *mut gst::GstCaps,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_type_find_helper_for_data_with_extension(
        obj: *mut gst::GstObject,
        data: *const u8,
        size: size_t,
        extension: *const c_char,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    pub fn gst_type_find_helper_for_extension(
        obj: *mut gst::GstObject,
        extension: *const c_char,
    ) -> *mut gst::GstCaps;
    pub fn gst_type_find_helper_get_range(
        obj: *mut gst::GstObject,
        parent: *mut gst::GstObject,
        func: GstTypeFindHelperGetRangeFunction,
        size: u64,
        extension: *const c_char,
        prob: *mut gst::GstTypeFindProbability,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_14_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_14_3")))]
    pub fn gst_type_find_helper_get_range_full(
        obj: *mut gst::GstObject,
        parent: *mut gst::GstObject,
        func: GstTypeFindHelperGetRangeFunction,
        size: u64,
        extension: *const c_char,
        caps: *mut *mut gst::GstCaps,
        prob: *mut gst::GstTypeFindProbability,
    ) -> gst::GstFlowReturn;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_type_find_list_factories_for_caps(
        obj: *mut gst::GstObject,
        caps: *mut gst::GstCaps,
    ) -> *mut glib::GList;

}
