/* unity.vapi generated by valac 0.18.0, do not modify. */

namespace Unity {
	namespace IO {
		[CCode (cheader_filename = "unity.h")]
		public static string[] get_system_data_dirs ();
		[CCode (cheader_filename = "unity.h")]
		public static async GLib.FileInputStream? open_from_data_dirs (string filename) throws GLib.Error;
		[CCode (cheader_filename = "unity.h")]
		public static async GLib.FileInputStream? open_from_dirs (string filename, string[] dirs) throws GLib.Error;
		[CCode (cheader_filename = "unity.h")]
		public static async void read_stream_async (GLib.InputStream input, int io_priority = GLib.Priority.LOW, GLib.Cancellable? cancellable = null, out uint8[] data, out size_t size) throws GLib.IOError;
	}
	[CCode (cheader_filename = "unity.h")]
	public class ActivationResponse : GLib.InitiallyUnowned {
		public ActivationResponse (Unity.HandledType handled, string goto_uri = "");
		public ActivationResponse.with_preview (Unity.Preview preview);
		public string goto_uri { get; set construct; }
		public Unity.HandledType handled { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AnnotatedIcon : GLib.Object {
		public AnnotatedIcon (GLib.Icon base_icon);
		public string to_string ();
		public Unity.CategoryType category { get; set; }
		public GLib.Icon icon { get; set; }
		public string ribbon { get; set; }
		public Unity.IconSizeHint size_hint { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AppInfoManager : GLib.Object {
		public void clear ();
		public unowned string[]? get_categories (string id);
		public static Unity.AppInfoManager get_default ();
		[Deprecated (replacement = "AppInfoManager.get_default")]
		public static Unity.AppInfoManager get_instance ();
		public unowned string[]? get_keywords (string id);
		public string? get_path (string id);
		public GLib.AppInfo? lookup (string id);
		public async GLib.AppInfo? lookup_async (string id) throws GLib.Error;
		public signal void changed (string id, GLib.AppInfo? new_appinfo);
	}
	[CCode (cheader_filename = "unity.h")]
	public class ApplicationPreview : Unity.Preview {
		public ApplicationPreview (string title, string subtitle, string description, GLib.Icon? icon, GLib.Icon? screenshot);
		public void set_rating (float rating, uint num_ratings);
		public GLib.Icon app_icon { get; set; }
		public string copyright { get; set; }
		public string last_update { get; set; }
		public string license { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AsyncPreview : Unity.Preview {
		public AsyncPreview ();
		[CCode (name = "unity_async_preview_preview_ready")]
		public void emit_preview_ready (Unity.Preview? preview);
		public AsyncPreview.with_cancellable (GLib.Cancellable cancellable);
		public GLib.Cancellable cancellable { get; set construct; }
		public signal void preview_ready (Unity.Preview? preview);
	}
	[CCode (cheader_filename = "unity.h")]
	public class Category : GLib.Object {
		public Category (string name, GLib.Icon icon_hint, Unity.CategoryRenderer renderer = CategoryRenderer.VERTICAL_TILE);
		public Unity.CategoryRenderer default_renderer { get; construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class CheckOptionFilter : Unity.OptionsFilter {
		public CheckOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity.h")]
	public class CheckOptionFilterCompact : Unity.OptionsFilter {
		public CheckOptionFilterCompact (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class Filter : GLib.Object {
		public Filter ();
		public bool collapsed { get; construct; }
		public string display_name { get; internal set construct; }
		public bool filtering { get; internal set construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
		public Unity.FilterRenderer renderer { get; construct; }
		public bool visible { get; set construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class FilterOption : GLib.Object {
		public FilterOption (string id, string display_name, GLib.Icon? icon_hint = null, bool active = false);
		public bool active { get; internal set construct; }
		public string display_name { get; construct; }
		public GLib.Icon icon_hint { get; construct; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class GenericPreview : Unity.Preview {
		public GenericPreview (string title, string description, GLib.Icon? image);
	}
	[CCode (cheader_filename = "unity.h")]
	public class InfoHint : GLib.InitiallyUnowned {
		public InfoHint (string id, string display_name, GLib.Icon? icon_hint, string data);
		public InfoHint.with_variant (string id, string display_name, GLib.Icon? icon_hint, GLib.Variant data);
		public GLib.Variant data { get; construct; }
		public string display_name { get; construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class Inspector : GLib.Object {
		public static unowned Unity.Inspector get_default ();
		public string? unity_bus_name { get; }
		public bool unity_running { get; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class LauncherEntry : Dee.Serializable, GLib.Object {
		public static Unity.LauncherEntry get_for_app_uri (string app_uri);
		public static Unity.LauncherEntry get_for_desktop_file (string desktop_file);
		public static Unity.LauncherEntry get_for_desktop_id (string desktop_id);
		public string app_uri { get; set construct; }
		public int64 count { get; set; }
		public bool count_visible { get; set; }
		public double progress { get; set; }
		public bool progress_visible { get; set; }
		public Dbusmenu.Menuitem? quicklist { get; set; }
		public bool urgent { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class LauncherFavorites : GLib.Object {
		public GLib.AppInfo[] enumerate_app_infos ();
		public string[] enumerate_ids ();
		public static unowned Unity.LauncherFavorites get_default ();
		public bool has_app_id (string app_id);
		public bool has_app_info (GLib.AppInfo appinfo);
		public GLib.AppInfo? lookup (string app_id);
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class Lens : GLib.Object {
		public Lens (string dbus_path_, string id_);
		public void add_local_scope (Unity.Scope scope);
		public void export () throws GLib.IOError;
		public bool active { get; private set; }
		public GLib.List<Unity.Category> categories { get; set; }
		public string dbus_path { get; construct; }
		public bool exported { get; private set; }
		public GLib.List<Unity.Filter> filters { get; set; }
		public Unity.MergeStrategy global_merge_strategy { get; set; }
		public string home_lens_default_name { get; set; }
		public string id { get; construct; }
		public Unity.MergeStrategy merge_strategy { get; set; }
		public string search_hint { get; set; }
		public bool search_in_global { get; set; }
		public bool searching { get; private set; }
		public string sources_display_name { get; set construct; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class LensSearch : GLib.InitiallyUnowned {
		public LensSearch (string search_string, GLib.HashTable<string,GLib.Variant> hints, Dee.SerializableModel results_model);
		[CCode (cname = "unity_lens_search_finished")]
		public void emit_finished ();
		public bool equals (Unity.LensSearch? other);
		public void set_reply_hint (string key, GLib.Variant variant);
		public GLib.HashTable<string,GLib.Variant> hints { get; construct; }
		public Dee.SerializableModel results_model { get; construct; }
		public string search_string { get; construct; }
		[Signal (action = true)]
		public signal void finished ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MoviePreview : Unity.Preview {
		public MoviePreview (string title, string subtitle, string description, GLib.Icon? image);
		public void set_rating (float rating, uint num_ratings);
		public string year { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class MultiRangeFilter : Unity.OptionsFilter {
		public MultiRangeFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_first_active ();
		public Unity.FilterOption? get_last_active ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MusicPlayer : GLib.Object {
		public MusicPlayer (string desktop);
		public bool add_playlist (Unity.Playlist p);
		public void edit_playlist_name (string id, string name);
		public void export ();
		public Unity.Playlist[] get_playlists ();
		public bool remove_playlist (Unity.Playlist p);
		public void unexport ();
		public GLib.AppInfo app_info { get; construct; }
		public bool can_go_next { get; set; }
		public bool can_go_previous { get; set; }
		public bool can_pause { get; set; }
		public bool can_play { get; set; }
		public Unity.Playlist current_playlist { get; set; }
		public Unity.TrackMetadata current_track { get; set; }
		public string desktop_file_name { get; construct; }
		public bool is_blacklisted { get; set; }
		public Unity.PlaybackState playback_state { get; set; }
		public Dbusmenu.Menuitem? player_menu { get; set; }
		public string title { get; set; }
		public Dbusmenu.Menuitem? track_menu { get; set; }
		public signal void activate_playlist (GLib.ObjectPath playlist_id);
		public signal void next ();
		public signal void play_pause ();
		public signal void previous ();
		public signal void raise ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MusicPreview : Unity.Preview {
		public enum TrackState {
			STOPPED,
			PLAYING,
			PAUSED
		}
		public MusicPreview (string title, string subtitle, GLib.Icon? image);
		public void add_track (Unity.TrackMetadata track);
		public float current_progress { get; set; }
		public Unity.MusicPreview.TrackState current_track_state { get; set; }
		public string current_track_uri { get; set; }
		public signal void pause (string uri);
		public signal void play (string uri);
	}
	[CCode (cheader_filename = "unity.h")]
	public class OptionsFilter : Unity.Filter {
		public enum SortType {
			MANUAL,
			DISPLAY_NAME,
			ID
		}
		public GLib.List<Unity.FilterOption> options;
		public OptionsFilter ();
		public Unity.FilterOption add_option (string id, string display_name, GLib.Icon? icon_hint = null);
		public Unity.FilterOption? get_option (string id);
		public bool remove_option (string id);
		public Unity.OptionsFilter.SortType sort_type { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class Playlist : GLib.Object {
		public Playlist (string id);
		public GLib.DateTime creation_date { get; set; }
		public GLib.Icon icon { get; set; }
		public string id { get; construct; }
		public GLib.DateTime last_play_date { get; set; }
		public GLib.DateTime modification_date { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class PreferencesManager : GLib.Object {
		public enum RemoteContent {
			ALL,
			NONE
		}
		public static Unity.PreferencesManager get_default ();
		public Unity.PreferencesManager.RemoteContent remote_content_search { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class Preview : GLib.Object, Dee.Serializable {
		public Preview ();
		public void add_action (Unity.PreviewAction action);
		public void add_info (Unity.InfoHint info_hint);
		public string description_markup { get; set; }
		public GLib.Icon? image { get; set; }
		public string image_source_uri { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
		public signal void closed ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class PreviewAction : GLib.Object, Dee.Serializable {
		public PreviewAction (string id, string display_name, GLib.Icon? icon_hint);
		public PreviewAction.with_layout_hint (string id, string display_name, GLib.Icon? icon_hint, Unity.LayoutHint layout);
		public string display_name { get; construct; }
		public string extra_text { get; set; }
		public GLib.HashTable<string,GLib.Variant>? hints { get; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
		public Unity.LayoutHint layout_hint { get; construct; }
		public signal Unity.ActivationResponse activated (string uri);
	}
	[CCode (cheader_filename = "unity.h")]
	public class RadioOptionFilter : Unity.OptionsFilter {
		public RadioOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_active_option ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class RatingsFilter : Unity.Filter {
		public RatingsFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public float rating { get; internal set construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class Scope : GLib.Object {
		public Scope (string dbus_path_);
		public void export () throws GLib.IOError;
		public Unity.Filter? get_filter (string id);
		public void invalidate_search (Unity.SearchType search_type);
		public void queue_search_changed (Unity.SearchType search_type);
		public bool active { get; set; }
		public string dbus_path { get; construct; }
		public bool exported { get; private set; }
		public GLib.List<Unity.Filter> filters { get; }
		public Dee.SerializableModel global_results_model { get; }
		public bool provides_personal_content { get; set; }
		public Dee.SerializableModel results_model { get; }
		public bool search_in_global { get; set; }
		public Unity.OptionsFilter sources { get; internal set; }
		public signal Unity.ActivationResponse? activate_uri (string uri);
		public signal void active_sources_changed (string[] active_ids);
		public signal void filters_changed ();
		[Signal (detailed = true)]
		public signal string generate_search_key (Unity.LensSearch search);
		public signal Unity.Preview? preview_uri (string uri);
		public signal void search_changed (Unity.LensSearch search, Unity.SearchType search_type, GLib.Cancellable cancellable);
	}
	[CCode (cheader_filename = "unity.h")]
	public class SocialPreview : Unity.Preview {
		public class Comment : GLib.InitiallyUnowned {
			public Comment (string id, string name, string text, string time);
			public string id { get; construct; }
			public string name { get; construct; }
			public string text { get; construct; }
			public string time { get; construct; }
		}
		public SocialPreview (string sender, string subtitle, string content, GLib.Icon? avatar);
		public void add_comment (Unity.SocialPreview.Comment comment);
		public GLib.Icon avatar { get; set; }
		public string content { get; set; }
		public string sender { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class TrackMetadata : GLib.Object {
		public TrackMetadata ();
		public TrackMetadata.full (string uri, int track_no, string title, string artist, string album, uint length);
		public string album { get; set; }
		public GLib.Icon art_icon { get; set; }
		public GLib.File art_location { get; set; }
		public string artist { get; set; }
		public uint length { get; set; }
		public string title { get; set; }
		public int track_no { get; set; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public interface MergeStrategy : GLib.Object {
		public abstract unowned Dee.ModelIter? merge_result (Dee.Model target, GLib.Variant[] row);
	}
	[CCode (cheader_filename = "unity.h")]
	public struct ActivePlaylistContainer {
		public bool valid;
		public Unity.PlaylistDetails details;
	}
	[CCode (cheader_filename = "unity.h")]
	public struct PlaylistDetails {
		public GLib.ObjectPath id;
		public string name;
		public string icon_name;
	}
	[CCode (cheader_filename = "unity.h")]
	public enum CategoryRenderer {
		VERTICAL_TILE,
		HORIZONTAL_TILE,
		LIST_TILE,
		FLOW
	}
	[CCode (cheader_filename = "unity.h")]
	public enum CategoryType {
		NONE,
		APPLICATION,
		BOOK,
		MUSIC,
		MOVIE,
		GAMES,
		ELECTRONICS,
		COMPUTERS,
		OFFICE,
		HOME,
		GARDEN,
		PETS,
		TOYS,
		CHILDREN,
		BABY,
		CLOTHES,
		SHOES,
		WATCHES,
		SPORTS,
		OUTDOORS,
		GROCERY,
		HEALTH,
		BEAUTY,
		DIY,
		TOOLS,
		CAR,
		N_CATEGORIES
	}
	[CCode (cheader_filename = "unity.h")]
	public enum FilterRenderer {
		CHECK_OPTIONS,
		RADIO_OPTIONS,
		MULTIRANGE,
		RATINGS,
		CHECK_OPTIONS_COMPACT
	}
	[CCode (cheader_filename = "unity.h")]
	public enum HandledType {
		NOT_HANDLED,
		SHOW_DASH,
		HIDE_DASH,
		GOTO_DASH_URI,
		SHOW_PREVIEW
	}
	[CCode (cheader_filename = "unity.h")]
	public enum IconSizeHint {
		DEFAULT,
		SMALL,
		LARGE
	}
	[CCode (cheader_filename = "unity.h")]
	public enum LayoutHint {
		NONE,
		LEFT,
		RIGHT,
		TOP,
		BOTTOM
	}
	[CCode (cheader_filename = "unity.h")]
	public enum PlaybackState {
		PLAYING,
		PAUSED
	}
	[CCode (cheader_filename = "unity.h")]
	public enum SearchType {
		DEFAULT,
		GLOBAL,
		N_TYPES
	}
}
