/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.utils.Utils;

public class MissingArgumentValueException
extends ArgumentException {
    public MissingArgumentValueException(ArgumentDefinition ... missingArguments) {
        super(MissingArgumentValueException.formatArguments(missingArguments));
    }

    private static String formatArguments(ArgumentDefinition ... missingArguments) {
        StringBuilder sb = new StringBuilder();
        for (ArgumentDefinition missingArgument : missingArguments) {
            if (missingArgument.shortName != null) {
                sb.append(String.format("%nValue for argument with name '--%s' (-%s) is missing.", missingArgument.fullName, missingArgument.shortName));
            } else {
                sb.append(String.format("%nValue for argument with name '--%s' is missing.", missingArgument.fullName));
            }
            if (missingArgument.validOptions == null) continue;
            sb.append(String.format("  Valid options are (%s).", Utils.join(",", missingArgument.validOptions)));
        }
        return sb.toString();
    }
}

