/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;

public abstract class SimplifiedInvocationUnit
extends SimplifiedVisitor
implements InvocationUnit,
ParameterVisitor,
ConstantVisitor {
    private final MemberVisitor parameterInitializer = new AllParameterVisitor(true, this);
    private Variables variables;
    protected boolean isStatic;
    protected boolean isLoad;
    protected Stack stack;

    @Override
    public void enterMethod(Clazz clazz, Method method, Variables variables) {
        int n = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        variables.reset(n);
        this.variables = variables;
        method.accept(clazz, this.parameterInitializer);
        this.variables = null;
    }

    @Override
    public void visitParameter(Clazz clazz, Member member, int n, int n2, int n3, int n4, String string, Clazz clazz2) {
        Method method = (Method)member;
        Value value = this.getMethodParameterValue(clazz, method, n, string, clazz2);
        this.variables.store(n3, value);
    }

    @Override
    public void exitMethod(Clazz clazz, Method method, Value value) {
        this.setMethodReturnValue(clazz, method, value);
    }

    @Override
    public void enterExceptionHandler(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2, Stack stack) {
        ClassConstant classConstant = (ClassConstant)((ProgramClass)clazz).getConstant(n2);
        stack.push(this.getExceptionValue(clazz, classConstant));
    }

    @Override
    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction, Stack stack) {
        int n2 = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case -78: {
                this.isStatic = true;
                this.isLoad = true;
                break;
            }
            case -77: {
                this.isStatic = true;
                this.isLoad = false;
                break;
            }
            case -76: {
                this.isStatic = false;
                this.isLoad = true;
                break;
            }
            case -75: {
                this.isStatic = false;
                this.isLoad = false;
                break;
            }
            case -72: 
            case -70: {
                this.isStatic = true;
                break;
            }
            case -74: 
            case -73: 
            case -71: {
                this.isStatic = false;
            }
        }
        this.stack = stack;
        clazz.constantPoolEntryAccept(n2, this);
        this.stack = null;
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (!this.isLoad) {
            this.setFieldValue(clazz, fieldrefConstant, this.stack.pop());
        }
        if (!this.isStatic) {
            this.setFieldClassValue(clazz, fieldrefConstant, this.stack.apop());
        }
        if (this.isLoad) {
            String string = fieldrefConstant.getType(clazz);
            this.stack.push(this.getFieldValue(clazz, fieldrefConstant, string));
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        String string = refConstant.getType(clazz);
        int n = ClassUtil.internalMethodParameterCount(string);
        if (!this.isStatic) {
            ++n;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.setMethodParameterValue(clazz, refConstant, i, this.stack.pop());
        }
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (string2.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, refConstant, string2));
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String string = invokeDynamicConstant.getType(clazz);
        int n = ClassUtil.internalMethodParameterCount(string);
        if (!this.isStatic) {
            ++n;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.stack.pop();
        }
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (string2.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, invokeDynamicConstant, string2));
        }
    }

    public abstract Value getExceptionValue(Clazz var1, ClassConstant var2);

    public abstract void setFieldClassValue(Clazz var1, RefConstant var2, ReferenceValue var3);

    public abstract Value getFieldClassValue(Clazz var1, RefConstant var2, String var3);

    public abstract void setFieldValue(Clazz var1, RefConstant var2, Value var3);

    public abstract Value getFieldValue(Clazz var1, RefConstant var2, String var3);

    public abstract void setMethodParameterValue(Clazz var1, RefConstant var2, int var3, Value var4);

    public abstract Value getMethodParameterValue(Clazz var1, Method var2, int var3, String var4, Clazz var5);

    public abstract void setMethodReturnValue(Clazz var1, Method var2, Value var3);

    public abstract Value getMethodReturnValue(Clazz var1, RefConstant var2, String var3);

    public abstract Value getMethodReturnValue(Clazz var1, InvokeDynamicConstant var2, String var3);
}

