/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchValue;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatches;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.EnumerationArgumentDefault;
import org.broadinstitute.gatk.utils.commandline.IntervalBindingArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.MissingArgumentValueException;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.commandline.RodBindingArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.RodBindingCollectionArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.commandline.UnknownEnumeratedValueException;
import org.broadinstitute.gatk.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;

class SimpleArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    private static Map<Class, Class> primitiveToWrapperMap = new HashMap<Class, Class>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    SimpleArgumentTypeDescriptor() {
    }

    private boolean isBinding(Class type) {
        return RodBindingArgumentTypeDescriptor.isRodBinding(type) || IntervalBindingArgumentTypeDescriptor.isIntervalBinding(type) || RodBindingCollectionArgumentTypeDescriptor.isRodBindingCollection(type);
    }

    @Override
    public boolean supports(Class type) {
        if (this.isBinding(type)) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        if (primitiveToWrapperMap.containsValue(type)) {
            return true;
        }
        try {
            type.getConstructor(String.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type fulltype, ArgumentMatches matches) {
        Object result;
        Tags tags;
        block17: {
            int len$;
            T[] arr$;
            Object defaultEnumeration;
            ArgumentMatchValue value;
            Class type;
            block18: {
                type = SimpleArgumentTypeDescriptor.makeRawTypeIfNecessary(fulltype);
                if (source.isFlag()) {
                    return true;
                }
                ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
                value = this.getArgumentValue(defaultDefinition, matches);
                tags = this.getArgumentTags(matches);
                try {
                    if (type.isPrimitive()) {
                        Method valueOf = primitiveToWrapperMap.get(type).getMethod("valueOf", String.class);
                        if (value == null) {
                            throw new MissingArgumentValueException(this.createDefaultArgumentDefinition(source));
                        }
                        result = valueOf.invoke(null, value.asString().trim());
                        break block17;
                    }
                    if (type.isEnum()) {
                        T[] vals = type.getEnumConstants();
                        defaultEnumeration = null;
                        arr$ = vals;
                        len$ = arr$.length;
                        break block18;
                    }
                    if (type.equals(File.class)) {
                        result = value == null ? null : value.asFile();
                        break block17;
                    } else {
                        Constructor ctor = type.getConstructor(String.class);
                        result = ctor.newInstance(value == null ? null : value.asString());
                    }
                    break block17;
                }
                catch (UserException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s.  This is most commonly caused by providing an incorrect data type (e.g. a double when an int is required)", value, source.field.getName()));
                }
                catch (Exception e) {
                    throw new DynamicClassResolutionException(String.class, e);
                }
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                Object val = arr$[i$];
                if (String.valueOf(val).equalsIgnoreCase(value == null ? null : value.asString())) {
                    return val;
                }
                try {
                    if (!type.getField(val.toString()).isAnnotationPresent(EnumerationArgumentDefault.class)) continue;
                    defaultEnumeration = val;
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new ReviewedGATKException("parsing " + type.toString() + "doesn't contain the field " + val.toString());
                }
            }
            if (defaultEnumeration != null && value == null) {
                result = defaultEnumeration;
            } else {
                if (value == null) {
                    throw new MissingArgumentValueException(this.createDefaultArgumentDefinition(source));
                }
                throw new UnknownEnumeratedValueException(this.createDefaultArgumentDefinition(source), value.asString());
            }
        }
        parsingEngine.addTags(result, tags);
        return result;
    }
}

