#include <argagg/argagg.hpp>
#include <iostream>
#include <string>

int main(int argc, char** argv) {
    argagg::parser parser {{
        {"help", {"-h", "--help"}, "show help", 0},
        {"name", {"-n", "--name"}, "username", 1}
    }};
    argagg::parser_results args = parser.parse(argc, argv);

    if (args["help"]) {
        std::cout << parser << std::endl;
        return 0;
    }

    std::string name = "world";
    if (args["name"]) {
        name = args["name"].as<std::string>();
    }

    std::cout << "Hello, " << name << "!" << std::endl;
    return 0;
}
