static const char *html_attributes_shared[] = {
  "accesskey",
  "class",
  "contenteditable",
  "contextmenu",
  "dir",
  "draggable",
  "dropzone",
  "hidden",
  "id",
  "lang",
  "spellcheck",
  "style",
  "tabindex",
  "title",
  "translate",
};

static const struct {
  const char *element;
  const char *attr;
} html_attributes[] = {
  { "a", "href" },
  { "a", "hreflang" },
  { "a", "media" },
  { "a", "rel" },
  { "a", "target" },
  { "a", "type" },

  { "area", "alt" },
  { "area", "coords" },
  { "area", "href" },
  { "area", "hreflang" },
  { "area", "media" },
  { "area", "rel" },
  { "area", "shape" },
  { "area", "target" },
  { "area", "type" },

  { "audio", "autoplay" },
  { "audio", "controls" },
  { "audio", "loop" },
  { "audio", "mediagroup" },
  { "audio", "muted" },
  { "audio", "preload" },
  { "audio", "src" },

  { "base", "href" },
  { "base", "target" },

  { "blockquote", "cite" },

  { "button", "autofocus" },
  { "button", "disabled" },
  { "button", "form" },
  { "button", "formaction" },
  { "button", "formmethod" },
  { "button", "formnovalidate" },
  { "button", "formtarget" },
  { "button", "name" },
  { "button", "type" },
  { "button", "value" },

  { "canvas", "height" },
  { "canvas", "width" },

  { "col", "span" },

  { "colgroup", "span" },

  { "command", "checked" },
  { "command", "icon" },
  { "command", "label" },
  { "command", "radiogroup" },
  { "command", "type" },
  { "command", "type" },

  { "del", "cite" },
  { "del", "datetime" },

  { "details", "open" },

  { "embed", "height" },
  { "embed", "src" },
  { "embed", "type" },
  { "embed", "width" },

  { "fieldset", "disabled" },
  { "fieldset", "form" },
  { "fieldset", "name" },

  { "form", "accept-charset" },
  { "form", "action" },
  { "form", "autocomplete" },
  { "form", "enctype" },
  { "form", "method" },
  { "form", "name" },
  { "form", "novalidate" },
  { "form", "target" },

  { "html", "manifest" },

  { "iframe", "height" },
  { "iframe", "name" },
  { "iframe", "sandbox" },
  { "iframe", "seamless" },
  { "iframe", "src" },
  { "iframe", "srcdoc" },
  { "iframe", "width" },

  { "img", "alt" },
  { "img", "height" },
  { "img", "ismap" },
  { "img", "src" },
  { "img", "usemap" },
  { "img", "width" },

  { "input", "accept" },
  { "input", "alt" },
  { "input", "autocomplete" },
  { "input", "autofocus" },
  { "input", "dirname" },
  { "input", "disabled" },
  { "input", "form" },
  { "input", "formaction" },
  { "input", "formenctype" },
  { "input", "formmethod" },
  { "input", "formnovalidate" },
  { "input", "formtarget" },
  { "input", "height" },
  { "input", "list" },
  { "input", "list" },
  { "input", "max" },
  { "input", "maxlength" },
  { "input", "min" },
  { "input", "multiple" },
  { "input", "name" },
  { "input", "pattern" },
  { "input", "placeholder" },
  { "input", "readonly" },
  { "input", "required" },
  { "input", "size" },
  { "input", "src" },
  { "input", "step" },
  { "input", "type" },
  { "input", "value" },
  { "input", "width" },

  { "ins", "cite" },
  { "ins", "datetime" },

  { "keygen", "autofocus" },
  { "keygen", "challenge" },
  { "keygen", "disabled" },
  { "keygen", "form" },
  { "keygen", "keytype" },
  { "keygen", "name" },

  { "label", "for" },
  { "label", "form" },

  { "li", "value" },

  { "link", "href" },
  { "link", "hreflang" },
  { "link", "media" },
  { "link", "rel" },
  { "link", "sizes" },
  { "link", "type" },

  { "map", "name" },

  { "menu", "label" },
  { "menu", "type" },

  { "meta", "charset" },
  { "meta", "content" },
  { "meta", "http-equiv" },

  { "meter", "high" },
  { "meter", "low" },
  { "meter", "max" },
  { "meter", "min" },
  { "meter", "optimum" },
  { "meter", "value" },

  { "object", "data" },
  { "object", "form" },
  { "object", "height" },
  { "object", "name" },
  { "object", "type" },
  { "object", "usemap" },
  { "object", "width" },

  { "ol", "reversed" },
  { "ol", "start" },
  { "ol", "type" },

  { "optgroup", "disabled" },
  { "optgroup", "label" },

  { "option", "disabled" },
  { "option", "label" },
  { "option", "selected" },
  { "option", "value" },

  { "output", "for" },
  { "output", "form" },
  { "output", "name" },

  { "param", "name" },
  { "param", "value" },

  { "progress", "max" },
  { "progress", "value" },

  { "q", "cite" },

  { "script", "async" },
  { "script", "charset" },
  { "script", "defer" },
  { "script", "language" },
  { "script", "src" },
  { "script", "type" },

  { "select", "autofocus" },
  { "select", "disabled" },
  { "select", "form" },
  { "select", "multiple" },
  { "select", "name" },
  { "select", "required" },
  { "select", "size" },

  { "source", "media" },
  { "source", "src" },
  { "source", "type" },

  { "style", "media" },
  { "style", "scoped" },
  { "style", "type" },

  { "table", "border" },

  { "td", "colspan" },
  { "td", "headers" },
  { "td", "rowspan" },

  { "textarea", "autofocus" },
  { "textarea", "cols" },
  { "textarea", "dirname" },
  { "textarea", "disabled" },
  { "textarea", "form" },
  { "textarea", "maxlength" },
  { "textarea", "name" },
  { "textarea", "placeholder" },
  { "textarea", "readonly" },
  { "textarea", "required" },
  { "textarea", "rows" },
  { "textarea", "wrap" },

  { "th", "colspan" },
  { "th", "headers" },
  { "th", "rowspan" },
  { "th", "scope" },

  { "time", "datetime" },

  { "track", "default" },
  { "track", "kind" },
  { "track", "label" },
  { "track", "src" },
  { "track", "srclang" },

  { "video", "autoplay" },
  { "video", "controls" },
  { "video", "height" },
  { "video", "loop" },
  { "video", "mediagroup" },
  { "video", "muted" },
  { "video", "poster" },
  { "video", "preload" },
  { "video", "src" },
  { "video", "width" },
};

