; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define void @test_ult_rhsc(i8 %x) {
; CHECK-LABEL: define void @test_ult_rhsc(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    switch i8 [[X]], label [[BB1:%.*]] [
; CHECK-NEXT:      i8 2, label [[BB2:%.*]]
; CHECK-NEXT:      i8 12, label [[BB3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       bb1:
; CHECK-NEXT:    call void @func1()
; CHECK-NEXT:    unreachable
; CHECK:       bb2:
; CHECK-NEXT:    call void @func2()
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    call void @func3()
; CHECK-NEXT:    unreachable
;
  %val = add nsw i8 %x, -2
  %cmp = icmp ult i8 %val, 11
  %cond = select i1 %cmp, i8 %val, i8 6
  switch i8 %cond, label %bb1 [
  i8 0, label %bb2
  i8 10, label %bb3
  ]

bb1:
  call void @func1()
  unreachable
bb2:
  call void @func2()
  unreachable
bb3:
  call void @func3()
  unreachable
}

define void @test_eq_lhsc(i8 %x) {
; CHECK-LABEL: define void @test_eq_lhsc(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    switch i8 [[X]], label [[BB1:%.*]] [
; CHECK-NEXT:      i8 0, label [[BB2:%.*]]
; CHECK-NEXT:      i8 10, label [[BB3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       bb1:
; CHECK-NEXT:    call void @func1()
; CHECK-NEXT:    unreachable
; CHECK:       bb2:
; CHECK-NEXT:    call void @func2()
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    call void @func3()
; CHECK-NEXT:    unreachable
;
  %cmp = icmp eq i8 %x, 4
  %cond = select i1 %cmp, i8 6, i8 %x
  switch i8 %cond, label %bb1 [
  i8 0, label %bb2
  i8 10, label %bb3
  ]

bb1:
  call void @func1()
  unreachable
bb2:
  call void @func2()
  unreachable
bb3:
  call void @func3()
  unreachable
}

define void @test_ult_rhsc_invalid_cond(i8 %x, i8 %y) {
; CHECK-LABEL: define void @test_ult_rhsc_invalid_cond(
; CHECK-SAME: i8 [[X:%.*]], i8 [[Y:%.*]]) {
; CHECK-NEXT:    [[VAL:%.*]] = add nsw i8 [[X]], -2
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[Y]], 11
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i8 [[VAL]], i8 6
; CHECK-NEXT:    switch i8 [[COND]], label [[BB1:%.*]] [
; CHECK-NEXT:      i8 0, label [[BB2:%.*]]
; CHECK-NEXT:      i8 10, label [[BB3:%.*]]
; CHECK-NEXT:      i8 13, label [[BB3]]
; CHECK-NEXT:    ]
; CHECK:       bb1:
; CHECK-NEXT:    call void @func1()
; CHECK-NEXT:    unreachable
; CHECK:       bb2:
; CHECK-NEXT:    call void @func2()
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    call void @func3()
; CHECK-NEXT:    unreachable
;
  %val = add nsw i8 %x, -2
  %cmp = icmp ult i8 %y, 11
  %cond = select i1 %cmp, i8 %val, i8 6
  switch i8 %cond, label %bb1 [
  i8 0, label %bb2
  i8 10, label %bb3
  i8 13, label %bb3
  ]

bb1:
  call void @func1()
  unreachable
bb2:
  call void @func2()
  unreachable
bb3:
  call void @func3()
  unreachable
}

define void @test_ult_rhsc_fail(i8 %x) {
; CHECK-LABEL: define void @test_ult_rhsc_fail(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[VAL:%.*]] = add nsw i8 [[X]], -2
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[VAL]], 11
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], i8 [[VAL]], i8 6
; CHECK-NEXT:    switch i8 [[COND]], label [[BB1:%.*]] [
; CHECK-NEXT:      i8 0, label [[BB2:%.*]]
; CHECK-NEXT:      i8 10, label [[BB3:%.*]]
; CHECK-NEXT:      i8 13, label [[BB3]]
; CHECK-NEXT:    ]
; CHECK:       bb1:
; CHECK-NEXT:    call void @func1()
; CHECK-NEXT:    unreachable
; CHECK:       bb2:
; CHECK-NEXT:    call void @func2()
; CHECK-NEXT:    unreachable
; CHECK:       bb3:
; CHECK-NEXT:    call void @func3()
; CHECK-NEXT:    unreachable
;
  %val = add nsw i8 %x, -2
  %cmp = icmp ult i8 %val, 11
  %cond = select i1 %cmp, i8 %val, i8 6
  switch i8 %cond, label %bb1 [
  i8 0, label %bb2
  i8 10, label %bb3
  i8 13, label %bb3
  ]

bb1:
  call void @func1()
  unreachable
bb2:
  call void @func2()
  unreachable
bb3:
  call void @func3()
  unreachable
}

declare void @func1()
declare void @func2()
declare void @func3()
