/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfOrcaInterpretor.h
    \brief Definition of the Template class NetcdfOrcaInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#ifndef NetcdfOrcaInterpretor_H
#define NetcdfOrcaInterpretor_H

#include "magics.h"

#include "NetcdfOrcaInterpretorAttributes.h"
#include "NetcdfInterpretor.h"
#include "Matrix.h"
#include "MagException.h"
#include "VectorOfPointers.h"

namespace magics {

class NetcdfOrcaInterpretor: 
        public NetcdfOrcaInterpretorAttributes,
		public NetcdfInterpretor {

public:
	NetcdfOrcaInterpretor();
	virtual ~NetcdfOrcaInterpretor();
    
    void set(const map<string, string>& params) { 
        MagLog::debug() << "NetcdfOrcaInterpretor::set(params)" << "\n";
        NetcdfInterpretorAttributes::set(params); 
        NetcdfOrcaInterpretorAttributes::set(params);
    }

    bool interpretAsPoints(PointsList&);
    bool interpretAsMatrix(Matrix**);
    void customisedPoints(const Transformation& transformation, const std::set<string>&, CustomisedPointsList& out, int thinning);

    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
   
     
private:
    //! Copy constructor - No copy allowed
	NetcdfOrcaInterpretor(const NetcdfOrcaInterpretor&);
    //! Overloaded << operator to copy - No copy allowed
	NetcdfOrcaInterpretor& operator=(const NetcdfOrcaInterpretor&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NetcdfOrcaInterpretor& p)
		{ p.print(s); return s; }

};

} // namespace magics
#endif
