Minutes from 20th OpenVDB TSC meeting, June 13, 2019

Attendees: *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel)

Regrets: *Ken* M.

Agenda:

1) Quorum
2) Chair and Secretary Selection
3) AX Update
4) Security Policy
5) Namespacing/SyncNodeVersion/GetVersion
6) OpHiding
7) Delayed Loading
8) File Format Version
9) 64-bit Metadata
10) Speed of hasActiveTiles/voxelizeActiveTiles
11) GCC and Dual ABI
12) Memory Allocators
13) Topology Replace
14) Schedule Next Meeting

1) A quorum was confirmed.

2) Secretary - Nick Avramoussis. Chair - Dan Bailey.

3) AX Update

Significant changes on the way for AX, primarily focused around future proofing
the code base and upstreaming improvements and new features in preparation for
migration into a feature branch. Currently time-line is for this to become
available at the start of July. There was some discussion on the best migration
plan. Consensus was to simply copy the codebase directly onto a feature branch
once TSC members had a chance to look at the proposed repository structure,
which will be available in the current OpenVDB AX repository. No PR is to be
required for the initial migration. Subsequent changes and feedback will then go
through full review. It is expected there won't be a complete merge into the
mainline branch of OpenVDB for Siggraph and there should be no rush with this
process.

4) Security Policy

Jeff to make a PR of the proposed security policy which all members should
accept before merge. A private email alias still needs to be created and
advertised on the website for users to report security concerns. Noted that
this is the only thing that is actually required for the CII best practices
badge.

5) Namespacing/SyncNodeVersion/GetVersion

Discussion on the best way to proceed with node versioning. SyncNodeVersion
is specific to the Houdini Verison. GetVersion is a method on the Operator class
which has been designed not to incorporate any VDB dependencies. Ideally we would
be looking for methods on the node class. It was suggested to investigate using
sparedata/metadata which should solve both current use cases (ophiding for native
naming and the new OpenVDB Scatter default behavior). We would attach version
string information via this approach which would avoid introducing new dependencies
to the base houdini utility library. Note that this version information would have
to correlate to the OpenVDB release or commit version for this to work. General
consensus was that we should feel comfortable bumping the library version with
problems like these, which are clear examples of changes in behavior. Peter
to look at updating the OP Builder workflow to support this.

6) OpHiding

Two solutions put forward are named simply as the compile side and script side
solutions. To avoid both workflows being active in a given installation, CMake
could be used to configure the OpenVDB install to only activate one or the other.
Concerns were raised that this could cause confusion even if documented well.
Peter to look at the script side solution. Dan to put in a simpler PR for the
compiled solution.

7) Delayed Loading

No major concerns with the current solution, however it would be better if the
problem was solved on a larger scale by tackling the file format rather than
the proposed temporary metadata. Note that for the proposed solution to work,
all users must adopt the metadata changes.

8) File Format Version

The file format version warning can cause confusion for users loading OpenVDB files
into different readers. If subsequent problems arise, this is generally highlighted
as the fault when it may be irrelevant. One solution would be to save out each VDB
file with the lowest possible file format version number corresponding to the
feature set required by the file. This would be extremely tricky to do with VDB
currently and it also changes the interpretation of the file format number to a file
"feature" version.

9) 64-bit Metadata

Currently metadata size is capped at the value of an unsigned 32 bit integer.
The goal suggested here is to provide the ability to write out metadata with a size
up to a 64 bit integer. The proposed solution is to limit current VDB metadata
serialization to the size of a signed 32 bit integer so that the last bit can be
used to represent metadata that exceeds signed 32 bits in the future. This is not
guaranteed to be 100% safe - old readers will either crash or produce undefined
behavior with larger metadata sizes. It was proposed that VDB should ideally
check the full size of the file prior to seeking so that overflows can be safely
caught.

Concerns were raised that the general metadata workflow in OpenVDB assumes metadata
to be relatively small and trivial to copy/read (methods such as copying OpenVDB
grids and file deserialization). 64 bit support would require some restructuring to how
these methods and others deal with that assumption, highlighting the possibility that
a new framework would be needed. It was suggested that all these changes could be
bundled into one massive file version update, which would also include all the
necessary IO hooks that have been identified.

10) Topology Replace

There are no methods to perform topology replacement given two OpenVDB trees
(specifically, no methods akin to the topologyIntersction/Difference/Union member
functions). The desired outcome given a->topologyReplace(b), would be 'a' containing
active topology that matches 'b', leaving other node values and topology hierarchy
untouched but inactive. This can be achieved through a combination of Intersection +
Union, however this can be slightly more expensive and even produce 'incorrect' value
results due to Intersection potentially deleting branches of 'a'. A more efficient
method would be to perform a deactivation of all nodes in 'a' followed by a union.
Note that an ideal solution would only have to deactivate the values not represented
in 'b'.

11) Speed of hasActiveTiles/voxelizeActiveTiles
12) GCC and Dual ABI
13) Memory Allocators

Time.

14) Schedule Next Meeting

June 20th 2019.  3pm-4pm EDT (GMT-4).
