Minutes from 21st OpenVDB TSC meeting, June 20, 2019

Attendees: *Nick* A., *Dan* B., *Peter* C., *Jeff* L., *Ken* M.

Additional Attendees: Bruce Chernia (Intel)

Agenda:

1) Quorum
2) Secretary
3) Siggraph planning
4) PagedArray unit test fix
5) SOP unification and hiding
6) SOP tab sub-menu and suffix
7) Static Pointer Memory Leaks (PR 227)
7a) CI Update
7b) Houdini status
8) Memory Allocators
9) VDB Points MMB bug (OVDB-100)
10) Speed of hasActiveTiles/voxelizeActiveTiles
11) GCC and Dual ABI
12) Next Meeting

1) Quorum was confirmed.

2) Secretary was Jeff Lait

3) Siggraph planning

We have a dedicated meeting slot in the BoF for discussing development
issues rather than as an open forum.  The plan is Wednesday 11am-Noon
to discuss with Autodesk the MultiResolution issues.

With both a course and a BoF, it is unclear how to handle the BoF.  Less
need to just dump new updates as the course will cover that.  "What would
you like to see?" was a goo conversation starter in the past.  Previous
answers were Multi Res and Delayed Loading.

4) PagedArray unit test fix

Still trying to build a PR for this.  Unfortunately, git is very
painful to work with.   Might end up just being a patch forwarded.
gitk is listed as a good tool to figure out what git is trying to do.

5) SOP unification and hiding

We now have separate PRs for both adding spare data to OP_Operator
and for creating a pythonrc to do the hiding.  Consensus is both the
env-variable and pythonrc can go in as the overlap has been minimized.
It would be a good if it triggered a warning if you turned both on.

The SpareData technique should be adopted by Houdini some day to allow
generic sparedata on all OP_Operators.  RFE: 97588 has been submitted
for this.

The environment variable should match the pythonrc, so be a three way toggle.

CMake should let you set both, but with a warning that you likely will
confuse yourself.

6) SOP tab sub-menu and suffix

Previous default menu was Custom.  Instead, by using a named menu we
can ensure conflicts get a suffix automatically.  ASWF isn't a good
top level menu as no one will know to look in it.  Renaming nodes is
finicky, so consensus is the tab suffixing is a better approach to
deal with ambiguity.

Bug: 97465 for suffixes not working has been fixed in 17.0.620, 17.5.295.

7) Static Pointer Memory Leaks (PR 227)

This is a long standing PR from Autodesk.  We should at least answer.

It wasn't merged because older versions of MSVC did not conform to C++11
for function statics.  It also isn't a memory leak, as it will be
freed on destruction in either case.  Further, destruction order causes
its own risks so safest to not delete.  OTOH, C++11 is now a requirement
and going forward we can support function statics.

Next version will be C++14 so this implies 2017 MSVC.  We should
state this on the upgrade.

While this PR isn't necessary, it would be a good test for the new CLA
process.  Jeff will comment on the PR and ask them to wait for the
CLA mechanism to be active.

7a) CI Update

Switching over to a host repository on a ASWF docker.  This will have
a pre-installed CentoS7 with all the dependencies pre-built.  All is
working except the Houdini install.  Installing glfw is problematic,
however.  Bumping glfw (which is only used by vdbview) to a higher version
will likely simplify.  Unanimous consent to bump to 3.1 to match
Ubunut 16.04.

Minimum is currently 3.0.  But 3.1 is what you get with apt-get.  However,
vdbview crashes on close with unpatched glfw due to EGL problems.
Recommendation is 3.3.

7b) Houdini status

Attempt to upgrade HEAD Houdini to latest VDB ran into a problem with
the VDB Clip changes.  The question of if primitive attributes or vdb
metadata should be authoritative when processing SOPs (and when processing
VDB code) is thorny and error prone.  In this case, file_bbox is generated
on save to .bgeo streams.  So reloaded .vdbs have the value as metadata
and do not have matching primitive and vdb data.  Interestingly,
file_bbox is off in the open source build.  Should it be on by default
in all builds?

8) Memory Allocators

Discussion at Siggraph on memory allocators and file format changes.

9) VDB Points MMB bug (OVDB-100)

Jeff Lait is to look at this.

10) Speed of hasActiveTiles/voxelizeActiveTiles
Time

11) GCC and Dual ABI
Time

12) Schedule Next Meeting

June 27th 2019.  3pm-4pm EDT (GMT-4).
