# NAME

osm2pgsql-expire - Visualize expire output

# SYNOPSIS

**osm2pgsql-expire** \[*OPTIONS*\] *OSM-FILE* (1)
**osm2pgsql-expire** *TILES-FILE* (2)

# DESCRIPTION

**This command is currently experimental.**

The expire command can be used for two things:

1. **To check what tiles some OSM data is in.** If an *OSM-FILE* is specified
   osm2pgsql-expire will calculate the tiles covering the objects in that file.
   Note that the file must not be a change file but a regular OSM data file!
   Output is, by default, a tile file, but GeoJSON is also possible.
2. **Visualize tile list.** If a *TILE-FILE* (presumably generated by osm2pgsql)
   is specified, a GeoJSON file is generated showing all mentioned tiles. In
   this mode all command line options are ignored.

Read the *Expire* chapter of the osm2pgsql manual
(https://osm2pgsql.org/doc/manual.html#expire) for details on how to
interpret the `-m, \--mode` and `\--full-area-limit` options.

# OPTIONS

This program follows the usual GNU command line syntax, with long options
starting with two dashes (`--`). Mandatory arguments to long options are
mandatory for short options too.

# MAIN OPTIONS

-b, \--buffer=VALUE
: Set buffer size around geometry relative to tile size. Example: Set to 0.1
  for a buffer that's 10% of the tile size.

-f, \--format=FORMAT
: Output format. Options are 'tiles' (default) or 'geojson'. The GeoJSON output
  uses the Web Mercator projection (EPSG:3857) which is supported by many
  programs although, strictly speaking, it is not allowed by the GeoJSON spec.

\--full-area-limit=VALUE
: Set full area limit.

-m, \--mode=MODE
: Set expire mode. One of  `boundary_only`, `full_area` (default), and `hybrid`.

-z, \--zoom=ZOOM
: Zoom level on which to calculate tiles.

# HELP/VERSION OPTIONS

-h, \--help
:   Print help.

-V, \--version
:   Print osm2pgsql version.

# LOGGING OPTIONS

\--log-level=LEVEL
:   Set log level ('debug', 'info' (default), 'warn', or 'error').

# SEE ALSO

* [osm2pgsql website](https://osm2pgsql.org)
* [osm2pgsql manual](https://osm2pgsql.org/doc/manual.html)
* **osm2pgsql**(1)
* **postgres**(1)
* **osmcoastline**(1)

