/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ViewAxisArrayAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Init utility for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewAxisArrayAttributes::Init()
{
    domainCoords[0] = 0;
    domainCoords[1] = 1;
    rangeCoords[0] = 0;
    rangeCoords[1] = 1;
    viewportCoords[0] = 0.15;
    viewportCoords[1] = 0.9;
    viewportCoords[2] = 0.1;
    viewportCoords[3] = 0.85;

    ViewAxisArrayAttributes::SelectAll();
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Copy utility for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewAxisArrayAttributes::Copy(const ViewAxisArrayAttributes &obj)
{

    domainCoords[0] = obj.domainCoords[0];
    domainCoords[1] = obj.domainCoords[1];

    rangeCoords[0] = obj.rangeCoords[0];
    rangeCoords[1] = obj.rangeCoords[1];

    for(int i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];


    ViewAxisArrayAttributes::SelectAll();
}

// Type map format string
const char *ViewAxisArrayAttributes::TypeMapFormatString = VIEWAXISARRAYATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ViewAxisArrayAttributes::TmfsStruct = {VIEWAXISARRAYATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Default constructor for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes::ViewAxisArrayAttributes() : 
    AttributeSubject(ViewAxisArrayAttributes::TypeMapFormatString)
{
    ViewAxisArrayAttributes::Init();
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Constructor for the derived classes of ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes::ViewAxisArrayAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewAxisArrayAttributes::Init();
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Copy constructor for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes::ViewAxisArrayAttributes(const ViewAxisArrayAttributes &obj) : 
    AttributeSubject(ViewAxisArrayAttributes::TypeMapFormatString)
{
    ViewAxisArrayAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::ViewAxisArrayAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes::ViewAxisArrayAttributes(const ViewAxisArrayAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewAxisArrayAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::~ViewAxisArrayAttributes
//
// Purpose: 
//   Destructor for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes::~ViewAxisArrayAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAxisArrayAttributes& 
ViewAxisArrayAttributes::operator = (const ViewAxisArrayAttributes &obj)
{
    if (this == &obj) return *this;

    ViewAxisArrayAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAxisArrayAttributes::operator == (const ViewAxisArrayAttributes &obj) const
{
    // Compare the domainCoords arrays.
    bool domainCoords_equal = true;
    for(int i = 0; i < 2 && domainCoords_equal; ++i)
        domainCoords_equal = (domainCoords[i] == obj.domainCoords[i]);

    // Compare the rangeCoords arrays.
    bool rangeCoords_equal = true;
    for(int i = 0; i < 2 && rangeCoords_equal; ++i)
        rangeCoords_equal = (rangeCoords[i] == obj.rangeCoords[i]);

    // Compare the viewportCoords arrays.
    bool viewportCoords_equal = true;
    for(int i = 0; i < 4 && viewportCoords_equal; ++i)
        viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

    // Create the return value
    return (domainCoords_equal &&
            rangeCoords_equal &&
            viewportCoords_equal);
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAxisArrayAttributes::operator != (const ViewAxisArrayAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::TypeName
//
// Purpose: 
//   Type name method for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewAxisArrayAttributes::TypeName() const
{
    return "ViewAxisArrayAttributes";
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAxisArrayAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewAxisArrayAttributes *tmp = (const ViewAxisArrayAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewAxisArrayAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewAxisArrayAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewAxisArrayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewAxisArrayAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewAxisArrayAttributes(*this);
    else
        retval = new ViewAxisArrayAttributes;

    return retval;
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewAxisArrayAttributes::SelectAll()
{
    Select(ID_domainCoords,   (void *)domainCoords, 2);
    Select(ID_rangeCoords,    (void *)rangeCoords, 2);
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewAxisArrayAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAxisArrayAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewAxisArrayAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ViewAxisArrayAttributes.
    DataNode *node = new DataNode("ViewAxisArrayAttributes");

    if(completeSave || !FieldsEqual(ID_domainCoords, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("domainCoords", domainCoords, 2));
    }

    if(completeSave || !FieldsEqual(ID_rangeCoords, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("rangeCoords", rangeCoords, 2));
    }

    if(completeSave || !FieldsEqual(ID_viewportCoords, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewportCoords", viewportCoords, 4));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewAxisArrayAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewAxisArrayAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("domainCoords")) != 0)
        SetDomainCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("rangeCoords")) != 0)
        SetRangeCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewportCoords")) != 0)
        SetViewportCoords(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewAxisArrayAttributes::SetDomainCoords(const double *domainCoords_)
{
    domainCoords[0] = domainCoords_[0];
    domainCoords[1] = domainCoords_[1];
    Select(ID_domainCoords, (void *)domainCoords, 2);
}

void
ViewAxisArrayAttributes::SetRangeCoords(const double *rangeCoords_)
{
    rangeCoords[0] = rangeCoords_[0];
    rangeCoords[1] = rangeCoords_[1];
    Select(ID_rangeCoords, (void *)rangeCoords, 2);
}

void
ViewAxisArrayAttributes::SetViewportCoords(const double *viewportCoords_)
{
    viewportCoords[0] = viewportCoords_[0];
    viewportCoords[1] = viewportCoords_[1];
    viewportCoords[2] = viewportCoords_[2];
    viewportCoords[3] = viewportCoords_[3];
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
ViewAxisArrayAttributes::GetDomainCoords() const
{
    return domainCoords;
}

double *
ViewAxisArrayAttributes::GetDomainCoords()
{
    return domainCoords;
}

const double *
ViewAxisArrayAttributes::GetRangeCoords() const
{
    return rangeCoords;
}

double *
ViewAxisArrayAttributes::GetRangeCoords()
{
    return rangeCoords;
}

const double *
ViewAxisArrayAttributes::GetViewportCoords() const
{
    return viewportCoords;
}

double *
ViewAxisArrayAttributes::GetViewportCoords()
{
    return viewportCoords;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewAxisArrayAttributes::SelectDomainCoords()
{
    Select(ID_domainCoords, (void *)domainCoords, 2);
}

void
ViewAxisArrayAttributes::SelectRangeCoords()
{
    Select(ID_rangeCoords, (void *)rangeCoords, 2);
}

void
ViewAxisArrayAttributes::SelectViewportCoords()
{
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewAxisArrayAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewAxisArrayAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_domainCoords:   return "domainCoords";
    case ID_rangeCoords:    return "rangeCoords";
    case ID_viewportCoords: return "viewportCoords";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewAxisArrayAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_domainCoords:   return FieldType_doubleArray;
    case ID_rangeCoords:    return FieldType_doubleArray;
    case ID_viewportCoords: return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewAxisArrayAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_domainCoords:   return "doubleArray";
    case ID_rangeCoords:    return "doubleArray";
    case ID_viewportCoords: return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewAxisArrayAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAxisArrayAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ViewAxisArrayAttributes &obj = *((const ViewAxisArrayAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_domainCoords:
        {  // new scope
        // Compare the domainCoords arrays.
        bool domainCoords_equal = true;
        for(int i = 0; i < 2 && domainCoords_equal; ++i)
            domainCoords_equal = (domainCoords[i] == obj.domainCoords[i]);

        retval = domainCoords_equal;
        }
        break;
    case ID_rangeCoords:
        {  // new scope
        // Compare the rangeCoords arrays.
        bool rangeCoords_equal = true;
        for(int i = 0; i < 2 && rangeCoords_equal; ++i)
            rangeCoords_equal = (rangeCoords[i] == obj.rangeCoords[i]);

        retval = rangeCoords_equal;
        }
        break;
    case ID_viewportCoords:
        {  // new scope
        // Compare the viewportCoords arrays.
        bool viewportCoords_equal = true;
        for(int i = 0; i < 4 && viewportCoords_equal; ++i)
            viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

        retval = viewportCoords_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

