# == Class: vmms::keystone::auth
#
# Configures vmms user, service and endpoint in Keystone.
#
# === Parameters
#
# [*password*]
#   (Required) Password for vmms user.
#
# [*auth_name*]
#   (Optional) Username for vmms service.
#   Defaults to 'vmms'.
#
# [*email*]
#   (Optional) Email for vmms user.
#   Defaults to 'vmms@localhost'.
#
# [*tenant*]
#   (Optional) Tenant for vmms user.
#   Defaults to 'services'.
#
# [*roles*]
#   (Optional) List of roles assigned to vmms user.
#   Defaults to ['admin']
#
# [*system_scope*]
#   (Optional) Scope for system operations.
#   Defaults to 'all'
#
# [*system_roles*]
#   (Optional) List of system roles assigned to vmms user.
#   Defaults to []
#
# [*configure_endpoint*]
#   (Optional) Should vmms endpoint be configured?
#   Defaults to true.
#
# [*configure_user*]
#   (Optional) Should the service user be configured?
#   Defaults to true.
#
# [*service_type*]
#   (Optional) Type of service.
#   Defaults to 'workflowv2'.
#
# [*public_url*]
#   (Optional) The endpoint's public url.
#   Defaults to 'http://127.0.0.1:9898/v2'
#
# [*internal_url*]
#   (Optional) The endpoint's internal url.
#   Defaults to 'http://127.0.0.1:9898/v2'
#
# [*admin_url*]
#   (Optional) The endpoint's admin url.
#   Defaults to 'http://127.0.0.1:9898/v2'
#
# [*region*]
#   (Optional) Region for endpoint.
#   Defaults to 'RegionOne'.
#
# [*service_name*]
#   (Optional) Name of the service.
#   Defaults to 'vmms'.
#
# [*configure_service*]
#   (Optional) Should vmms service be configured?
#   Defaults to true.
#
# [*service_description*]
#   (Optional) Description for keystone service.
#   Defaults to 'Openstack workflow Service'.

# [*configure_user_role*]
#   (Optional) Whether to configure the admin role for the service user.
#   Defaults to true
#
class vmms::keystone::auth(
  String[1] $password,
  String[1] $email                        = 'vmms@localhost',
  String[1] $auth_name                    = 'vmms',
  String[1] $service_name                 = 'vmms',
  String[1] $service_type                 = 'vmms',
  Keystone::PublicEndpointUrl $public_url = 'http://127.0.0.1:9898/v2',
  Keystone::EndpointUrl $admin_url        = 'http://127.0.0.1:9898/v2',
  Keystone::EndpointUrl $internal_url     = 'http://127.0.0.1:9898/v2',
  String[1] $region                       = 'RegionOne',
  String[1] $tenant                       = 'services',
  Array[String[1]] $roles                 = ['admin'],
  String[1] $system_scope                 = 'all',
  Array[String[1]] $system_roles          = [],
  Boolean $configure_endpoint             = true,
  Boolean $configure_service              = true,
  Boolean $configure_user                 = true,
  Boolean $configure_user_role            = true,
  String[1] $service_description          = 'OpenStack VM Migration Scheduler',
) {

  include vmms::deps

  Keystone::Resource::Service_identity['vmms'] -> Anchor['vmms::service::end']

  keystone::resource::service_identity { 'vmms':
    configure_user      => $configure_user,
    configure_user_role => $configure_user_role,
    configure_endpoint  => $configure_endpoint,
    service_type        => $service_type,
    service_description => $service_description,
    service_name        => $service_name,
    region              => $region,
    auth_name           => $auth_name,
    password            => $password,
    email               => $email,
    tenant              => $tenant,
    roles               => $roles,
    system_scope        => $system_scope,
    system_roles        => $system_roles,
    public_url          => $public_url,
    admin_url           => $admin_url,
    internal_url        => $internal_url,
  }
}
