# Copyright (c) 2025 Thomas Goirand
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import argparse
try:
    from unittest import mock
except ImportError:
    import mock
import testtools

from vmmsclient import plugin
from vmmsclient.tests import base


class TestPlugin(base.TestCase):
    """Test cases for the plugin module."""

    def test_make_client(self):
        """Test client creation."""
        instance = mock.Mock()
        instance.get_configuration.return_value = {
            plugin.API_VERSION_OPTION: '2'
        }
        instance.session = mock.Mock()
        instance.region_name = 'RegionOne'
        instance.interface = 'public'
        
        client = plugin.make_client(instance)
        
        self.assertIsNotNone(client)

    def test_build_option_parser(self):
        """Test option parser creation."""
        parser = argparse.ArgumentParser()
        result_parser = plugin.build_option_parser(parser)
        
        self.assertEqual(parser, result_parser)
        
        # Test that the option is added
        args = parser.parse_args([])
        self.assertTrue(hasattr(args, 'os_vmms_api_version'))
