% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/Methods-accessors.R,
%   R/Methods-subsetting.R
\docType{class}
\name{Fast5Summary-class}
\alias{Fast5Summary-class}
\alias{length,Fast5Summary-method}
\alias{readInfo,Fast5Summary-method}
\alias{eventData,Fast5Summary-method}
\alias{baseCalled,Fast5Summary-method}
\alias{fastq,Fast5Summary-method}
\alias{[,Fast5Summary,ANY,ANY,ANY-method}
\alias{fastqTemplate,Fast5Summary-method}
\alias{fastqComplement,Fast5Summary-method}
\alias{fastq2D,Fast5Summary-method}
\title{An S4 class for summarised data from a MinION sequencing run}
\usage{
\S4method{length}{Fast5Summary}(x)

\S4method{readInfo}{Fast5Summary}(x)

\S4method{eventData}{Fast5Summary}(x)

\S4method{baseCalled}{Fast5Summary}(x)

\S4method{fastq}{Fast5Summary}(x)

\S4method{[}{Fast5Summary,ANY,ANY,ANY}(x, i)

\S4method{fastqTemplate}{Fast5Summary}(x)

\S4method{fastqComplement}{Fast5Summary}(x)

\S4method{fastq2D}{Fast5Summary}(x)
}
\arguments{
\item{x}{Object of class Fast5Summary}

\item{i}{Vector defining index to subset by.}
}
\value{
An object of class Fast5Summary
}
\description{
An S4 class for summarised data from a MinION sequencing run
}
\section{Methods (by generic)}{
\itemize{
\item \code{length}: Returns the number of files read during creation of the object

\item \code{readInfo}: Returns readInfo data.frame

\item \code{eventData}: Returns eventData data.frame

\item \code{baseCalled}: Returns baseCalled data.frame

\item \code{fastq}: Returns ShortReadQ object stored in fastq slot.

\item \code{[}: Subset object and return an object of the same class.

\item \code{fastqTemplate}: Returns ShortReadQ object containing only template reads

\item \code{fastqComplement}: Returns ShortReadQ object containing only complement reads

\item \code{fastq2D}: Returns ShortReadQ object containing only 2D reads
}}

\section{Slots}{

\describe{
\item{\code{readInfo}}{Object of class tibble.  Contains five columns: 
\itemize{
  \item id - an integer key that allows use to match entries in the separate 
  slots of this object.
  \item file - Basename of the fast5 file the data was read from.
  \item read - Read number from channel.
  \item channel - channel.
  \item mux - Specific pore that was used within the four that are assigned 
  to a single channel. Should be in the range 1-4, but if this isn't 
  available it will be 0.
}}

\item{\code{rawData}}{Object of class tibble.  Intended to hold raw signal data
although reading this is currently not implemented in \code{IONiseR}.}

\item{\code{eventData}}{Object of class tibble.  Holds summary of events data 
prior to base calling. Contains five columns: 
\itemize{
  \item id - an integer key that allows use to match entries in the 
  separate slots of this object.
  \item start_time - time in seconds after the run started that this 
  reading began. 
  \item duration - time in seconds the reading lasted. 
  \item num_events - the number of events that were recorded as part of 
  this reading. 
  \item median_signal - median of the recorded signals for this set of events.
}}

\item{\code{baseCalled}}{Object of class tibble.  For the most part contains 
similar data to the @eventData slot, the base called data is derived from it.
\itemize{
  \item id - an integer key that allows use to match entries in the 
  separate slots of this object.
  \item start_time - time in seconds after the run started that this 
  reading began. 
  \item duration - time in seconds the reading lasted. 
  \item num_events - the number of events that were recorded as part of 
  this reading. 
  \item strand - can be either 'template' or 'complement'
  \item full_2D - boolean value specifying whether the read forms part of a 
  2D pair.  If TRUE the FASTQ data for the template, complement and 2D read 
  will be available in the @fastq slot.
}}

\item{\code{fastq}}{Object of class ShortReadQ.  This slot contains all reads 
(template, complement and 2D).  The read names take the form NUM_STRAND, 
where NUM matches with the id column in the other slots and STRAND indicates 
whether the read is template, complement or 2D.}

\item{\code{versions}}{A list intended to store the version of IONiseR that was used
to create the object.  (May be extended in the future to include the version
of MinKNOW that the original fast5 files were processed, if this can be 
determined accurately.)}
}}

\examples{
if( require(minionSummaryData) ) {
   data(s.typhi.rep2, package = 'minionSummaryData')
   length( s.typhi.rep2 )
}
}
