% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloseq-class.R
\name{splat.phyloseq.objects}
\alias{splat.phyloseq.objects}
\title{Convert \code{\link{phyloseq-class}} into a named list of its non-empty components.}
\usage{
splat.phyloseq.objects(x)
}
\arguments{
\item{x}{A \code{\link{phyloseq-class}} object. Alternatively, a component
data object will work, resulting in named list of length 1.}
}
\value{
A named list, where each element is a component object that was contained 
in the argument, \code{x}. Each element is named according to its slot-name in
the phyloseq-object from which it is derived. 
If \code{x} is already a component data object,
then a list of length (1) is returned, also named.
}
\description{
This is used in internal handling functions, and one of its key features
is that the names in the returned-list match the slot-names, which is useful
for constructing calls with language-computing functions like \code{\link{do.call}}.
Another useful aspect is that it only returns the contents of non-empty slots.
In general, this should only be used by phyloseq-package developers. Standard
users should not need or use this function, and should use the accessors and 
other tools that leave the multi-component object in one piece.
}
\examples{
#
}
\seealso{
merge_phyloseq
}
\keyword{internal}
