write.csv(file="../../extdata/2.4.0/metadata-stoeckius-hashing.csv", 
    data.frame(
        Title = sprintf("Stoeckius %s counts", 
            c("PBMC human RNA", "PBMC mouse RNA", "PBMC HTO", "PBMC ADT-1", "PBMC ADT-2", 
                "mixed cell line RNA", "mixed cell line HTO")),
        Description = sprintf("%s count matrix for %s in the Stoeckius single-cell RNA-seq dataset", 
            c("RNA", "RNA", "HTO", "First ADT", "Second ADT", "RNA", "HTO"),
            c("hashed PBMCs", "unlabelled mouse controls", "hashed PBMCs", "hashed PBMCs", "hashed PBMCs", 
                "a hashed cell line mixture", "a hashed cell line mixture")),
        RDataPath = file.path("scRNAseq", "stoeckius-hashing", "2.4.0", 
            c("counts-pbmc-human.rds", "counts-pbmc-mouse.rds",
                "counts-pbmc-hto.rds", "counts-pbmc-adt1.rds", "counts-pbmc-adt2.rds",
                "counts-mixed-rna.rds", "counts-mixed-hto.rds")),
        BiocVersion="3.12",
        Genome=c("hg19", "mm10", "hg19", "hg19", "hg19", "hg19", "hg19"),
        SourceType=c("TSV", "TSV", "CSV", "CSV", "CSV", "TSV", "CSV"),
        SourceUrl="https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE108313",
        SourceVersion=c(
            "GSM2895282_Hashtag-RNA.umi.txt.gz",
            "GSM2895282_Hashtag-RNA.umi.txt.gz",
            "GSM2895283_Hashtag-HTO-count.csv.gz",
            "GSM2895284_Hashtag-ADT1-count.csv.gz",
            "GSM2895284_Hashtag-ADT2-count.csv.gz",
            "GSM3501446_MixCellLines-RNA.umi.txt.gz",
            "GSM3501447_MixCellLines-HTO-counts.csv.gz"
        ),
        Species=c("Homo sapiens", "Mus musculus", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens"),
        TaxonomyId=c("9606", "10090", "9606", "9606", "9606", "9606", "9606"),
        Coordinate_1_based=NA,
        DataProvider="GEO",
        Maintainer="Aaron Lun <infinite.monkeys.with.keyboards@gmail.com>",
        RDataClass=c("dgCMatrix", "dgCMatrix", "matrix", "matrix", "matrix", "dgCMatrix", "matrix"),
        DispatchClass="Rds",
        stringsAsFactors = FALSE
    ),
    row.names=FALSE)
