% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtdt2.R
\name{mtdt2}
\alias{mtdt2}
\title{Transmission/disequilibrium test of a multiallelic marker by Bradley-Terry model}
\usage{
mtdt2(x, verbose = TRUE, n.sim = NULL, ...)
}
\arguments{
\item{x}{the data table.}

\item{verbose}{To print out test statistics if TRUE.}

\item{n.sim}{Number of simulations.}

\item{...}{other options compatible with the BTm function.}
}
\value{
It returned list contains the following components:
\itemize{
\item c2b A data frame in four-column format showing transmitted vs nontransmitted counts.
\item BTm A fitted Bradley-Terry model object.
\item X2 Allele-wise, genotype-wise and goodness-of-fit Chi-squared statistics.
\item df Degrees of freedom.
\item p P value.
\item pn Monte Carlo p values when n.sim is specified.
}
}
\description{
Transmission/disequilibrium test of a multiallelic marker by Bradley-Terry model
}
\details{
This function calculates transmission-disequilibrium statistics involving
multiallelic marker according to Bradley-Terry model.
}
\examples{
\dontrun{
x <- matrix(c(0,0, 0, 2, 0,0, 0, 0, 0, 0, 0, 0,
              0,0, 1, 3, 0,0, 0, 2, 3, 0, 0, 0,
              2,3,26,35, 7,0, 2,10,11, 3, 4, 1,
              2,3,22,26, 6,2, 4, 4,10, 2, 2, 0,
              0,1, 7,10, 2,0, 0, 2, 2, 1, 1, 0,
              0,0, 1, 4, 0,1, 0, 1, 0, 0, 0, 0,
              0,2, 5, 4, 1,1, 0, 0, 0, 2, 0, 0,
              0,0, 2, 6, 1,0, 2, 0, 2, 0, 0, 0,
              0,3, 6,19, 6,0, 0, 2, 5, 3, 0, 0,
              0,0, 3, 1, 1,0, 0, 0, 1, 0, 0, 0,
              0,0, 0, 2, 0,0, 0, 0, 0, 0, 0, 0,
              0,0, 1, 0, 0,0, 0, 0, 0, 0, 0, 0),nrow=12)

xx <- mtdt2(x,refcat="12")
}

}
\references{
\insertRef{firth05}{gap}

Turner H, Firth D (2010) Bradley-Terry models in R: The BradleyTerry2 package.
https://cran.r-project.org/web/packages/BradleyTerry2/vignettes/BradleyTerry.pdf.
}
\seealso{
\code{\link{mtdt}}
}
\author{
Jing Hua Zhao
keywords models
keywords htest
}
