% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_cache.R
\name{sass_file_cache}
\alias{sass_file_cache}
\title{Create a file cache object}
\usage{
sass_file_cache(dir, max_size = 40 * 1024^2, max_age = Inf)
}
\arguments{
\item{dir}{The directory in which to store the cached files.}

\item{max_size}{The maximum size of the cache, in bytes. If the cache grows
past this size, the least-recently-used objects will be removed until it
fits within this size.}

\item{max_age}{The maximum age of objects in the cache, in seconds. The
default is one week.}
}
\value{
A \link{FileCache} object.
}
\description{
This creates a file cache which is to be used by sass for caching generated
.css files.
}
\examples{
\dontrun{
# Create a cache with the default settings
cache <- sass_file_cache(sass_cache_context_dir())

# Clear the cache
cache$reset()
}

}
\seealso{
\code{\link[=sass_cache_get]{sass_cache_get()}}, \code{\link[=sass_cache_context_dir]{sass_cache_context_dir()}}, \link{FileCache}
}
