/* rygel-plugin-loader.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>
#include <config.h>


#define RYGEL_TYPE_RECURSIVE_MODULE_LOADER (rygel_recursive_module_loader_get_type ())
#define RYGEL_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader))
#define RYGEL_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))

typedef struct _RygelRecursiveModuleLoader RygelRecursiveModuleLoader;
typedef struct _RygelRecursiveModuleLoaderClass RygelRecursiveModuleLoaderClass;
typedef struct _RygelRecursiveModuleLoaderPrivate RygelRecursiveModuleLoaderPrivate;

#define RYGEL_TYPE_PLUGIN_INFORMATION (rygel_plugin_information_get_type ())
#define RYGEL_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation))
#define RYGEL_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))
#define RYGEL_IS_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_IS_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_PLUGIN_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))

typedef struct _RygelPluginInformation RygelPluginInformation;
typedef struct _RygelPluginInformationClass RygelPluginInformationClass;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_SECTION_ENTRY (rygel_section_entry_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
enum  {
	RYGEL_PLUGIN_LOADER_PLUGIN_AVAILABLE_SIGNAL,
	RYGEL_PLUGIN_LOADER_LAST_SIGNAL
};
static guint rygel_plugin_loader_signals[RYGEL_PLUGIN_LOADER_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelRecursiveModuleLoader {
	GObject parent_instance;
	RygelRecursiveModuleLoaderPrivate * priv;
};

struct _RygelRecursiveModuleLoaderClass {
	GObjectClass parent_class;
	gboolean (*load_module_from_file) (RygelRecursiveModuleLoader* self, GFile* file);
	gboolean (*load_module_from_info) (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
};

struct _RygelPluginLoader {
	RygelRecursiveModuleLoader parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	RygelRecursiveModuleLoaderClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelPluginLoaderPrivate {
	GeeHashMap* plugin_hash;
	GeeHashMap* available_plugins;
	GeeHashSet* loaded_modules;
	RygelConfiguration* config;
};

typedef enum  {
	RYGEL_SECTION_ENTRY_TITLE,
	RYGEL_SECTION_ENTRY_ENABLED
} RygelSectionEntry;

typedef void (*RygelPluginLoaderModuleInitFunc) (RygelPluginLoader* loader, void* user_data);

static gpointer rygel_plugin_loader_parent_class = NULL;

GType rygel_recursive_module_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_information_get_type (void) G_GNUC_CONST;
GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderPrivate))
enum  {
	RYGEL_PLUGIN_LOADER_DUMMY_PROPERTY
};
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
static gchar* rygel_plugin_loader_get_config_path (void);
static void rygel_plugin_loader_real_constructed (GObject* base);
const gchar* rygel_recursive_module_loader_get_base_path (RygelRecursiveModuleLoader* self);
void rygel_recursive_module_loader_set_base_path (RygelRecursiveModuleLoader* self, const gchar* value);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_section_entry_get_type (void) G_GNUC_CONST;
static void rygel_plugin_loader_on_section_changed (RygelPluginLoader* self, const gchar* section, RygelSectionEntry entry);
static void _rygel_plugin_loader_on_section_changed_rygel_configuration_section_changed (RygelConfiguration* _sender, const gchar* section, RygelSectionEntry entry, gpointer self);
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static gboolean rygel_plugin_loader_real_load_module_from_file (RygelRecursiveModuleLoader* base, GFile* module_file);
static gboolean rygel_plugin_loader_real_load_module_from_info (RygelRecursiveModuleLoader* base, RygelPluginInformation* info);
const gchar* rygel_plugin_information_get_name (RygelPluginInformation* self);
const gchar* rygel_plugin_information_get_module_path (RygelPluginInformation* self);
gboolean rygel_recursive_module_loader_load_module_from_file (RygelRecursiveModuleLoader* self, GFile* file);
void rygel_plugin_set_active (RygelPlugin* self, gboolean value);
gboolean rygel_recursive_module_loader_load_module_from_info (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static void rygel_plugin_loader_finalize (GObject * obj);


RygelPluginLoader* rygel_plugin_loader_construct (GType object_type) {
	RygelPluginLoader * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = rygel_plugin_loader_get_config_path ();
	_tmp1_ = _tmp0_;
	self = (RygelPluginLoader*) g_object_new (object_type, "base-path", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	return self;
}


RygelPluginLoader* rygel_plugin_loader_new (void) {
	return rygel_plugin_loader_construct (RYGEL_TYPE_PLUGIN_LOADER);
}


static void _rygel_plugin_loader_on_section_changed_rygel_configuration_section_changed (RygelConfiguration* _sender, const gchar* section, RygelSectionEntry entry, gpointer self) {
	rygel_plugin_loader_on_section_changed ((RygelPluginLoader*) self, section, entry);
}


static void rygel_plugin_loader_real_constructed (GObject* base) {
	RygelPluginLoader * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp4_;
	GeeHashSet* _tmp5_;
	RygelMetaConfig* _tmp6_;
	RygelConfiguration* _tmp7_;
	GeeHashMap* _tmp8_;
	self = (RygelPluginLoader*) base;
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader));
	_tmp0_ = rygel_recursive_module_loader_get_base_path ((RygelRecursiveModuleLoader*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_plugin_loader_get_config_path ();
		_tmp3_ = _tmp2_;
		rygel_recursive_module_loader_set_base_path ((RygelRecursiveModuleLoader*) self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_TYPE_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->plugin_hash);
	self->priv->plugin_hash = _tmp4_;
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->loaded_modules);
	self->priv->loaded_modules = _tmp5_;
	_tmp6_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp6_;
	_tmp7_ = self->priv->config;
	g_signal_connect_object (_tmp7_, "section-changed", (GCallback) _rygel_plugin_loader_on_section_changed_rygel_configuration_section_changed, self, 0);
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_TYPE_PLUGIN_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->available_plugins);
	self->priv->available_plugins = _tmp8_;
}


/**
     * Checks if a plugin is disabled by the user
     *
     * @param name the name of plugin to check for.
     *
     * @return true if plugin is disabled, false if not.
     */
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean enabled = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	enabled = TRUE;
	{
		gboolean _tmp0_ = FALSE;
		RygelConfiguration* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->config;
		_tmp2_ = name;
		_tmp3_ = rygel_configuration_get_enabled (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
		enabled = _tmp0_;
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = name;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_debug ("rygel-plugin-loader.vala:80: Could not find plugin '%s' in configurati" \
"on: %s", _tmp4_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = enabled;
	result = !_tmp8_;
	return result;
}


void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin) {
	RygelPlugin* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	RygelPlugin* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	RygelPlugin* _tmp7_;
	RygelPlugin* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = rygel_plugin_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	g_message (_ ("New plugin “%s” available"), _tmp2_);
	_tmp3_ = self->priv->plugin_hash;
	_tmp4_ = plugin;
	_tmp5_ = rygel_plugin_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = plugin;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp6_, _tmp7_);
	_tmp8_ = plugin;
	g_signal_emit (self, rygel_plugin_loader_signals[RYGEL_PLUGIN_LOADER_PLUGIN_AVAILABLE_SIGNAL], 0, _tmp8_);
}


RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name) {
	RygelPlugin* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->plugin_hash;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (RygelPlugin*) _tmp2_;
	return result;
}


GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->plugin_hash;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gboolean rygel_plugin_loader_real_load_module_from_file (RygelRecursiveModuleLoader* base, GFile* module_file) {
	RygelPluginLoader * self;
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GModule* module = NULL;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GModule* _tmp12_;
	GModule* _tmp13_;
	GModule* _tmp14_;
	void* function = NULL;
	GModule* _tmp19_;
	void* _tmp20_ = NULL;
	gboolean _tmp21_;
	RygelPluginLoaderModuleInitFunc module_init = NULL;
	void* _tmp26_;
	void* module_init_target;
	RygelPluginLoaderModuleInitFunc _tmp27_;
	void* _tmp27__target;
	GeeHashSet* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GModule* _tmp32_;
	RygelPluginLoaderModuleInitFunc _tmp33_;
	void* _tmp33__target;
	GModule* _tmp34_;
	const gchar* _tmp35_;
	self = (RygelPluginLoader*) base;
	g_return_val_if_fail (module_file != NULL, FALSE);
	_tmp0_ = self->priv->loaded_modules;
	_tmp1_ = module_file;
	_tmp2_ = g_file_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = module_file;
		_tmp7_ = g_file_get_basename (_tmp6_);
		_tmp8_ = _tmp7_;
		g_warning (_ ("A module named %s is already loaded"), _tmp8_);
		_g_free0 (_tmp8_);
		result = TRUE;
		return result;
	}
	_tmp9_ = module_file;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_module_open (_tmp11_, G_MODULE_BIND_LOCAL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	module = _tmp13_;
	_tmp14_ = module;
	if (_tmp14_ == NULL) {
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = module_file;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_module_error ();
		g_warning (_ ("Failed to load module from path “%s”: %s"), _tmp17_, _tmp18_);
		_g_free0 (_tmp17_);
		result = TRUE;
		_g_module_close0 (module);
		return result;
	}
	_tmp19_ = module;
	_tmp21_ = g_module_symbol (_tmp19_, "module_init", &_tmp20_);
	function = _tmp20_;
	if (!_tmp21_) {
		GFile* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp22_ = module_file;
		_tmp23_ = g_file_get_path (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_module_error ();
		g_warning (_ ("Failed to find entry point function “%s” in “%s”: %s"), "module_init", _tmp24_, _tmp25_);
		_g_free0 (_tmp24_);
		result = TRUE;
		_g_module_close0 (module);
		return result;
	}
	_tmp26_ = function;
	module_init = (RygelPluginLoaderModuleInitFunc) _tmp26_;
	module_init_target = NULL;
	_tmp27_ = module_init;
	_tmp27__target = module_init_target;
	_vala_assert (_tmp27_ != NULL, "module_init != null");
	_tmp28_ = self->priv->loaded_modules;
	_tmp29_ = module_file;
	_tmp30_ = g_file_get_basename (_tmp29_);
	_tmp31_ = _tmp30_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = module;
	g_module_make_resident (_tmp32_);
	_tmp33_ = module_init;
	_tmp33__target = module_init_target;
	_tmp33_ (self, _tmp33__target);
	_tmp34_ = module;
	_tmp35_ = g_module_name (_tmp34_);
	g_debug ("rygel-plugin-loader.vala:140: Loaded module source: '%s'", _tmp35_);
	result = TRUE;
	_g_module_close0 (module);
	return result;
}


static gboolean rygel_plugin_loader_real_load_module_from_info (RygelRecursiveModuleLoader* base, RygelPluginInformation* info) {
	RygelPluginLoader * self;
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	RygelPluginInformation* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelPluginInformation* _tmp4_;
	RygelPluginInformation* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GFile* module_file = NULL;
	RygelPluginInformation* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gboolean _tmp17_;
	self = (RygelPluginLoader*) base;
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = self->priv->available_plugins;
	_tmp1_ = info;
	_tmp2_ = rygel_plugin_information_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = info;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
	_tmp5_ = info;
	_tmp6_ = rygel_plugin_information_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_plugin_loader_plugin_disabled (self, _tmp7_);
	if (_tmp8_) {
		RygelPluginInformation* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = info;
		_tmp10_ = rygel_plugin_information_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		g_debug ("rygel-plugin-loader.vala:148: Module '%s' disabled by user. Ignoring…", _tmp11_);
		result = TRUE;
		return result;
	}
	_tmp12_ = info;
	_tmp13_ = rygel_plugin_information_get_module_path (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_new_for_path (_tmp14_);
	module_file = _tmp15_;
	_tmp16_ = module_file;
	_tmp17_ = rygel_recursive_module_loader_load_module_from_file ((RygelRecursiveModuleLoader*) self, _tmp16_);
	result = _tmp17_;
	_g_object_unref0 (module_file);
	return result;
}


static void rygel_plugin_loader_on_section_changed (RygelPluginLoader* self, const gchar* section, RygelSectionEntry entry) {
	RygelSectionEntry _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = entry;
	if (_tmp0_ == RYGEL_SECTION_ENTRY_ENABLED) {
		{
			gboolean enabled = FALSE;
			RygelConfiguration* _tmp1_;
			const gchar* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp1_ = self->priv->config;
			_tmp2_ = section;
			_tmp3_ = rygel_configuration_get_enabled (_tmp1_, _tmp2_, &_inner_error_);
			enabled = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch42_g_error;
			}
			_tmp4_ = enabled;
			if (!_tmp4_) {
				GeeHashMap* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = self->priv->plugin_hash;
				_tmp6_ = section;
				_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
				if (_tmp7_) {
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					gpointer _tmp10_;
					RygelPlugin* _tmp11_;
					gboolean _tmp12_;
					_tmp8_ = self->priv->plugin_hash;
					_tmp9_ = section;
					_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
					_tmp11_ = (RygelPlugin*) _tmp10_;
					_tmp12_ = enabled;
					rygel_plugin_set_active (_tmp11_, _tmp12_);
					_g_object_unref0 (_tmp11_);
				}
			} else {
				GeeHashMap* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = self->priv->plugin_hash;
				_tmp14_ = section;
				_tmp15_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp13_, _tmp14_);
				if (_tmp15_) {
					GeeHashMap* _tmp16_;
					const gchar* _tmp17_;
					gpointer _tmp18_;
					RygelPlugin* _tmp19_;
					gboolean _tmp20_;
					_tmp16_ = self->priv->plugin_hash;
					_tmp17_ = section;
					_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
					_tmp19_ = (RygelPlugin*) _tmp18_;
					_tmp20_ = enabled;
					rygel_plugin_set_active (_tmp19_, _tmp20_);
					_g_object_unref0 (_tmp19_);
				} else {
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = self->priv->available_plugins;
					_tmp22_ = section;
					_tmp23_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp21_, _tmp22_);
					if (_tmp23_) {
						GeeHashMap* _tmp24_;
						const gchar* _tmp25_;
						gpointer _tmp26_;
						RygelPluginInformation* _tmp27_;
						_tmp24_ = self->priv->available_plugins;
						_tmp25_ = section;
						_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
						_tmp27_ = (RygelPluginInformation*) _tmp26_;
						rygel_recursive_module_loader_load_module_from_info ((RygelRecursiveModuleLoader*) self, _tmp27_);
						_g_object_unref0 (_tmp27_);
					}
				}
			}
		}
		goto __finally42;
		__catch42_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp28_;
			GError* _tmp29_;
			const gchar* _tmp30_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp28_ = section;
			_tmp29_ = _error_;
			_tmp30_ = _tmp29_->message;
			g_debug ("rygel-plugin-loader.vala:178: Failed to get enabled state for %s: %s", _tmp28_, _tmp30_);
			_g_error_free0 (_error_);
		}
		__finally42:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar* rygel_plugin_loader_get_config_path (void) {
	gchar* result = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (PLUGIN_DIR);
	path = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		RygelMetaConfig* _tmp2_;
		RygelMetaConfig* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = rygel_meta_config_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = rygel_configuration_get_plugin_path ((RygelConfiguration*) _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch43_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (path);
		path = _tmp6_;
		_g_free0 (_tmp1_);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = path;
		g_debug ("rygel-plugin-loader.vala:190: Could not get plugin path from config: %" \
"s, using %s", _tmp8_, _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	return result;
}


static void rygel_plugin_loader_class_init (RygelPluginLoaderClass * klass) {
	rygel_plugin_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPluginLoaderPrivate));
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_plugin_loader_real_constructed;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_file = (gboolean (*) (RygelRecursiveModuleLoader *, GFile*)) rygel_plugin_loader_real_load_module_from_file;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_info = (gboolean (*) (RygelRecursiveModuleLoader *, RygelPluginInformation*)) rygel_plugin_loader_real_load_module_from_info;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_loader_finalize;
	rygel_plugin_loader_signals[RYGEL_PLUGIN_LOADER_PLUGIN_AVAILABLE_SIGNAL] = g_signal_new ("plugin-available", RYGEL_TYPE_PLUGIN_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_PLUGIN);
}


static void rygel_plugin_loader_instance_init (RygelPluginLoader * self) {
	self->priv = RYGEL_PLUGIN_LOADER_GET_PRIVATE (self);
}


static void rygel_plugin_loader_finalize (GObject * obj) {
	RygelPluginLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader);
	_g_object_unref0 (self->priv->plugin_hash);
	_g_object_unref0 (self->priv->available_plugins);
	_g_object_unref0 (self->priv->loaded_modules);
	_g_object_unref0 (self->priv->config);
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->finalize (obj);
}


/**
 * This class is responsible for plugin loading.
 *
 * It probes for shared library files in a specific directory, tries to 
 * find a module_init() function with this signature:
 * ``void module_init (RygelPluginLoader* loader);``
 *
 * It then calls that function, passing a pointer to itself. The loaded
 * module can then add plugins to Rygel by calling the
 * rygel_plugin_loader_add_plugin() function.
 */
GType rygel_plugin_loader_get_type (void) {
	static volatile gsize rygel_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginLoader), 0, (GInstanceInitFunc) rygel_plugin_loader_instance_init, NULL };
		GType rygel_plugin_loader_type_id;
		rygel_plugin_loader_type_id = g_type_register_static (RYGEL_TYPE_RECURSIVE_MODULE_LOADER, "RygelPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_loader_type_id__volatile, rygel_plugin_loader_type_id);
	}
	return rygel_plugin_loader_type_id__volatile;
}



