---
title: 2023 Tutorial
---

This tutorial showcases graphical diff, personFlow, plotting tools, analyzing repeated runs, and more!

# Files

- [sumo2023_tutorial.zip](https://sumo.dlr.de/daily/sumo2023_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=3J5KqOPT2qI">Watch the 2023 Tutorial</a>


# Transcription


## Intro
All right, so a brief outline of what we're going to cover. Even though the list is short, we're going to try to cover a lot. So, as always, we're going to talk about how to get started really quickly. This time, we're going to get started really quickly with generated networks. And we'll also take a look at how to compare different networks in a graphical way. Then, something that cannot be missing from any SUMO tutorial is the look at OSMWebWizard. So, we will be generating a scenario with a few clicks. And then we're going to do a simulation on this scenario. We will, this time, look closer at bicycle simulations. And then we will see how we can analyze the scenario and get some nice graphics out of it to summarize what the scenario has been doing. And not only are we going to run the scenario once, but we're going to run it multiple times and do analysis on that. Looking very much forward to that.

## Network generation with netgenerate
All right, so first things first, netgenerate. So, this is a tool that generates synthetic networks. For example, simple Manhattan grid that you can see here. But also other variants up to very random things or things that try to look like a real city. This tool has been in existence for pretty much 20 years right now. I did a little bit of digging. And so, in 2003, Daniel Krajzewicz, the father of SUMO, you can surely call him that, he started with the first commit on the network generator. But now, we have this with a UI, with a graphical user interface. So, let's see how that goes.
Start the netedit. And we have a new menu here. "Generate Network" menu. And here we have a dialog. And I said three clicks. So, don't be too stringy with counting. So, let's say one click to open the dialog. Let's say another click to pick the output file. Let's put this here. And a short name. And of course, we have to pick the type of network we want to generate. I'm going to go to grid and run this. The dialog tells us that everything went all right. And we have our network here. Very nice.
So, this is now the network with the default settings. Let's do something a bit more advanced. So, let's go to the dialog again. And this time, I'm going to give it a new name. And go to the advanced dialog. And here, for all the different kinds of networks that you have, there are settings. So, since we want to generate a grid, we're going to customize the values here. So, the X number, that's the grid in X direction. And the Y number is this. Oh, and by the way, the values you see here, the default values, they're not actually the correct default values. This is already fixed in the next version. Nevertheless, this is just a visual thing. So, you will still have to correct it all when you run it. Just be aware that right now, it doesn't show. All right. So, what else do we set? Let's have a bit of randomness here. Let's randomize the number of lanes that each row gets. And so, you may be wondering, what is the range in which we randomize? Well, it's the number of lanes. This can be set here in the building defaults. So, somewhere here is the default lane number. We're going to set this to two. And then, every edge will have either one or two lanes. Let's run this. That worked all right. And we have our net. As you expected, it's a bit wider. It's not as high. And if you zoom in, you see that the number of lanes varies all over the place. All right. So, this is netgenerate. I hope you can enjoy it.

## Comparing networks with netdiff
And now, we'll look at the difference between those two networks. Well, how do we do this? We can, I'll talk really quickly between them. To see their difference, well, great. Actually, when I work with networks, this is what I sometimes do. The eye is really good at spotting small differences. So, it may work. But there are, of course, better ways. So, let's talk about another tool. So, we talked about netgenerate. Now, let's talk about netdiff. That's a Python tool for computing differences between networks. And you can think of this a bit like math. You have two networks, A and B. And the difference between them, well, that's also some kind of file. And just like with real math, you can undo subtraction. You can do addition. So, if you use this netdiff tool to compute the difference between two network files, then later, you can reconstruct the network based on the difference. So, let's say you started with network A, did some changes in the right, then network B. These changes are, held in this difference file, or rather actually the set of files. And now at a later point, you can apply these differences to network A and get network B. Now, why would you want to do this? You can actually do some semantic versioning on your networks, or you can record manual changes. Let's say you start with an OpenStreetMap-derived network. And as usual, you have to do some manual fixing on that. And then at some later point, you would like to upgrade. You would like to update your OSM data. And you don't want to redo all the fixes. So, what do you do? You take the raw OSM net and the network with your fixes and compute the differences. And then at a later time, you update OSM, get a new raw network, and apply your differences again. And in most instances, most of your differences will still apply. I mean, as always, if you do patches and the part that you type changed, then you have to do some manual corrections. But it can save a lot of work. A lot of manual work that you already did, you don't have to redo. All right. So, that's not actually new. That has been available for quite some time. But what's new is the fact that you can now have a visual impression of the difference between two networks, because the netdiff tool is now integrated in netedit. So, let's start with this thing here. This was the original network. It's called this Network A. And I'm going to start, open the new "Tools" menu. We've seen quite a bit of this today. This is one of the new features in 1.17.0, and here we have the netdiff tool. Now, we have to put in here the paths of the networks that we want to compare. There's this handy little button, "use current network", current item. So, A is going to be the network we looked at first. And then, let's open up the other thing. The second run. And now, I select all the differences that I want to see. The shapes for modified, added, and deleted things. And let's go. So, what do we see here? Compared to the original network, some stuff was added. We see this in green. Some stuff was removed. We see this here in red. And some stuff was modified, we see this as this orange overlap. You recall that the advanced network had some random lane numbers. So, the number of lanes were changed. The edges are still there. Well, they're neither red nor green. So, this gives you an impression of the changes between two networks. And if your colleagues did something to your network, now you're going to find out exactly what they did. So, I hope you can make good use of this.

## Scenario generation with osmWebWizard
Moving on to the next topic. I hope all of you present here in the audience know this tool already. It's a Python tool that helps you to get started with SUMO simulations. Again, with about three clicks. You can find this tool in the "Tools" menu of your SUMO installation. And it will open up the web browser. It will let you select a piece of a map based on the rendering of OpenStreetMap data. You can select the road types that you want to import and the traffic modes that you want to see. Take note that even though the data is the real deal, real as OpenStreetMap provides it, the traffic will be branded. But you can configure which modes you want to see. And the volume of traffic. And also what amount of traffic is coming from outside versus being generated within the network. For example, if you have a small network, then most of it is going to be boot traffic. Presumably, it's a little bit bigger than already. And you can import public transport. This is a mix of real data and generated things. So, it's the real routes and the real stops as they have found in OpenStreetMap. But as OpenStreetMap doesn't have a detailed schedule, at best, it has the periods, the scenario will have a synthetic schedule that follows all the known events. And then, of course, you can configure how long the scenario should run. So, how long the traffic should be coming in. And you will also obtain background shapes and buildings and even satellite background images. And all the files will be downloaded automatically for you to rebuild the scenario and rerun it. And so, as I said, you can find this in the Tools folder of SUMO. Just launch the osmWebWizard.py and here will be the web browser, with the selection, and then the end, you click "Generate Scenario". So, today, I've prepared something that doesn't have any cars in it, only bicycles. So, maybe it's a bit of a preview of the keynote that we're going to hear tomorrow. Here in the Web Wizard, the modes you select have some subtle side effects. So, as soon as you select bicycles, the way the network is being imported, it will generate additional info. It will import all the infrastructure for bicycles. If you do a car only simulation, maybe you don't want all these bike lanes. They just lock up the network, get in the way, detract from what you're interested in. But here, as soon as you select this, you will have all the extra bicycle lanes in the network. I'm not going to run this now because this connection here is notoriously slow. Instead, I'm going to switch over to the files I've already prepared. You can find that in the Wizard folder. All the scenario files are available to download on the tutorial page. So, maybe let's go back real quick to show you what I mean. In the SUMO documentation, there is a tutorials subpage. And here you can find all the past conference tutorials with a link to download of the slide deck and the example. All right. So, when you run the Web Wizard, then it will open up a simulation for you. And it will look like this. And let's just run it and have a look.
As I mentioned, this is a simulation where I activated only bicycles. All bicycles are small. Maybe we have to make them a bit more visible. And let's see. Well, they're still pretty small. Let's make them even bigger. There are, of course, some controls. But, you know, they're not very big. And here you have a random bicycle traffic. And, well, who can spot the location? Who can figure out where this is? Yes. It's here. We are in the "Rotunde", which is this circular thing. And here is the train station, in which many of you presumably arrived. As I said, this is random traffic. That's not terribly realistic. Also, the lack of cars does not reflect the current state of traffic in Adlershof. There is something else that you get when starting the scenario. Maybe you have seen such things in your own Web Wizard scenarios. There is a warning message here about some traffic lights so let's talk about this real quick.
But before we do let's take a brief look at all the files that were generated by the Web Wizard. So you get a whole directory of stuff and don't get overwhelmed, most of these files are simply the inputs for the scenarios you have your SUMO config file which loads all the things, which binds everything together, you have of course the network file these are gzip by default nowadays, you may not know the SUMO can handle all files that end in xml.gz which are gzip and you if you get these as input it will just deflate them and if you use these paths as output files it will already automatically write gzip files which can be quite useful to conserve space, so the web wizard now saves the network in zip format. We have the bicycles which we generated, we have the polygons that we saw in the background (for example the building we're in) and then you have some settings for how the view should look and for rebuilding the scenario you have the raw OSM data and the configuration parts there in building the shapes and also a file for rebuilding the random traffic.
If you're interested in those details go look at the last two tutorials where I spend more time. So we looked at the simulation, there were these warnings so let's briefly discuss what these are about. By default the web wizard doesn't know anything about traffic lights in the real world except for their presence, they are there. So the process that builds the simulation network (netconvert is the application for that) it takes some liberties to generate plausible signal plans and it also takes the liberty to assume that all these traffic lights are traffic actuating, which means the roads are equipped with detection equipment and the traffic lights by default react to the traffic that they detect, basically making the phases longer when there's a large queue and shortening the green phase when there's no more traffic, which makes the flow a lot more efficient and well that's the best we can do when we don't know anything about the traffic lights, let's not make it even less efficient.
And so this warning tells us that this traffic actuation doesn't work for some reason, so the way the phases are laid out doesn't really fit the way detectors are placed on the lanes and so it just tells us this which automatic actuation will not work, and there's actually an option in SUMO to make the traffic lights a bit smarter and deal with these situations where there's an option you can set, then traffic lights will detect jams and automatically switch into the next phase to avoid some bad situations. So this is something that you can set if you want to get rid of the warning, keep it in mind, we will come back to this later. But now that we have our basic scenario let's do a more detailed bicycle simulation. Why bicycles? Well because it's good for the environment and presumably we'll want to have a lot more bicycles in our cities in the future, so let's take this as a forward-looking simulation, and the detail that we want to see is bicycles overtaking each other on the bicycle lane. As you know, the cars in SUMO well they overtake when there are more lanes but on a single lane they don't typically overtake. The bicycles should be able to do so in the bike path, if it's wide enough to overtake. So we should make sure that the bike paths are actually wide enough, 1 meter won't do, and we have to activate the sublane model in SUMO, which does these dynamics within a lane to for example allow this overtaking. We have to add more bicycles, right now in this simulation we saw that there wasn't just enough traffic to see this situations. And then we also have to give the bikes a reason to overtake. So some of them, well, they should have a desire to drive faster than some other bikes. Then we can see these overtaking actions. The good news is, within the last few versions, we did improvements to bicycle simulations and now this distribution of speeds is working out of the box. Going back to SUMO v1.14.0, you would have to do some very detailed steps to actually make them overtake because by default they all wanted to drive at the exact same speed. All right. And as we have managed all these things, then we can make some nice plots and even run the scenario multiple times.

## Preparing the network
Okay, so start with making the bicycle lanes wider. There are two ways to go about this. One way, which I'm only going to mention briefly, is to deal with it at the stage where the scenario is imported from OpenStreetMap. Not every lane in OpenStreetMap comes with a width information attached. So there's a process that puts in default values somewhere. These are of course customizable by the user. So in your SUMO installation, you find a few files that pertain to these defaults. They are all documented here on the slide. So you can look at that and you can change the value from these files and then your network will have different variables. But we're not going to do this now. Instead, we're going to look at how to do this efficiently in netedit. So we want to widen the bicycle. Let's go to the folder 02_netedit. So this is what the simulation looks like. I can launch netedit directly from here with <kbd>Ctrl</kbd> + <kbd>T</kbd>, which can be a convenient way to launch netedit on a specific network. And now I could click on a single bicycle lane and find the width attribute and change this. But while there are lots of bicycle lanes in the network, this is not very efficient and I might forget some. So let's use the selection mode. I press the letter <kbd>S</kbd>, but also press this little button that gives you the hotkeys. So then I'm going to select objects in the network by their attributes. I want to select lanes based on the attribute `allow`. And I want those lanes where `allow` has the exact value "bicycle". The equal sign forces an exact match. And now I have selected 172 bicycle lanes. The next thing I want to do is change the attribute, all of them at once. Now careful here. If I just click on this road somewhere here, I'm going to have this edge object selected, inspected rather, which I don't want. I want to have these lanes. So. I do a shift click on this lane. That's one way to go about it. The other way is to set the checkbox here, which makes every click interact with lanes rather than edges. And now, I am inspecting actually the selection of all these 172 lanes at once. And I can see they even come with different attributes. Some of them have the value 1. Some of them have the value 1.5. And I'm going to change all of them to 1.6 and be done with it. Now I can change the network and they all have the width I want.
But I'm going to do one more thing. As mentioned earlier, I want to activate the sublane model. So now this is an option that gets set when running the simulation. It's not part of the network. So you can run the same network with different values of detail and not change the network, but you can use netedit too, to set the option because now we have a way to configure, to define SUMO config files. This is the new menu item here, <kbd>Shift</kbd> + <kbd>F10</kbd> SUMO options. And there we can define in the processing tab. This value here, lateral-resolution and set it to 0.8. If you notice, that's just half of the width of the bicycle lane. So we're going to split it into sub lanes where bicycles can overtake and also neatly divides the default road width 3.2 meters. And as an added bonus, I'll set this option here about the jam threshold, which I mentioned earlier, to make that warning go. And now I can save the SUMO configuration, wherever I want. All right. Well, so that was that spot. That, that part of the preparation for having the bicycle simulation widen the lanes, define some SUMO configuration. The next thing, of course we'll have to do is define some more bicycles. And during the last tutorial I already discussed how to define flows of cars. So this is boring. Instead, we're going to define flows of persons that happen to ride their bike.
So before we start, let's get rid of this selection here. I'll just go back to select mode and I press <kbd>Esc</kbd>. And so now nothing is selected anymore. And I want to define persons or rather the whole flow of persons. For this, I have to enter another mode right here. These are all the modes you see for modifying the network. And then we have these super modes here, network, demand and data. And I go to this demand super mode. That's hotkey <kbd>F3</kbd>. It goes back to the network and here is the demand. And then I go to the person mode, pressing hotkey <kbd>P</kbd>. It's this little person button here, otherwise. All right. So already we have some color coding of the network. We see some places where persons cannot go. This is here, conflict, cyan. Actually, magenta. And then in dark green, we have all the places where persons could start. So let's have the persons start at the train station, then go to the DLR, take part in the conference and return back to the train station. That's the idea. But we don't want a single person. Instead, we want a whole flow, a person flow here. But for every flow, just like for a vehicle flow, we have to define how long it's going to go and what the spacing is going to be. So let's have a flow for 1,000 seconds. And we could have an even spacing, just setting how many objects per hour we want, or with a fixed period, but we're going to choose the POisson distribution, where an average, every two seconds, one person should start. And now, we pick among this list of things the person could do, the personTrip from one edge to another edge is actually the default already. And by default, those persons could just go. That's the default behavior, but in the modes field here, we can select also that they have their own car or that they can use public transport. And we say, they should ride bicycles. This is what we put in here, modes bicycle. And then of course they will prefer this to walking if they can, unless we happen to define network where bicycles are included. So we have to pick a start somewhere. So let's start on this edge here at the train station and then let's go to the DLR. That would be here. All right. So let's go to the DLR here. And this is the first leg of the journey, right? We confirm this with <kbd>Enter</kbd> and then the person flow is created.

Now we want to add more stages or more legs to this plan. And for this, we need a different mode. We pick the person flow that we want to work on. The one we just created. And now the difference here is in the first mode, we had to pick an origin and a destination. Now we only have to pick destinations because all these things are changed implicitly. And so let's enter a stop. Let's stop at the DLR and take place in the conference. That would be the stop on an edge. And of course, the conference is lengthy affair. Let's say altogether, we spent here eight hours. So I put 8:0:0 to use eight hours. Let's stop here. Let's say what the persons are doing, they are taking place at the SUMO Conference 2023. Alright. I just hit "undo" to do that. Now the final stage, let's go back to the train station. Again, we have the personTrip from edge to edge, modes bicycle, and now we only click final destination on the train station. And that's it. We have defined our person flow that goes by bike and returns by bike. We can go to inspect mode. So inspect mode. And here in the lower left corner, we see those three elements of the plan. Person flow, the stop, and flow again. All right, let's run this simulation. I'm gonna go back to something I prepared. So let's run this. The bicycles, they come in here. You can see them. And they're already riding in pairs next to each other, this is the way they queue at the traffic light. And then they go to the DLR. They're already queued here. Let's stop this. So if I do a right click, I see that they're actually tons of persons stacked in this place. And now if I keep running the simulation, speed this up a bit, then at some point, the conference will be over, sadly enough, and everybody will start to go home. So this is our scenario. Let's do some analysis.

## Analyzing and plotting results
First, all these things. You can find them all if you go back to the slides. You want to look up how we did this. Now, to evaluate the scenario, it's not enough to look at it. The whole purpose of the simulation is to generate all these nice output files. And so let's do that. So, of course, in the pas you would have to put all the output to define all the outputs that you wanted to have in the sumo configuration file, and you would have to write those XML files by hand, or at least write the options on the command line and have sumo generate the config file for you, you don't have to do that anymore. In the sumo config setting dialogue that I already mentioned, you also have this output section. And so we can select all the outputs that we want here. Right now it's still a bit of typing involved, but this will be, well, it's already planned to make this dialogue even nicer. So let's have some trip info output here. And another feature that's rather new is that you can split everything that belongs to the person in a separate output file. So let's have the person input in another file here. And then let's have some statistics. This is very useful. The statistic output basically gives you a summary on all the trips that were part of the simulation. So how long did they take in average, what was the average speed, all these things. And let's also have an edge data output. Defined as a file. So. There it is. All right, so edge data. Some of you may know it. It's one of the outputs that aggregates the values spatially. So for every simulation edge, we have an aggregation of how much cars went along that edge, how fast were they driving, how much time was lost on that edge. And of course you can set all kinds of attributes like this should be aggregated for five minutes or per hour or over the whole simulation. And because there are so many attributes, we have to usually have to define this in the XML file. Put all the attributes down. But if you want something real quick, you just set the option edgedata-output to some file. And it will give you an aggregation that runs over the whole simulation. With the default cycles. All right. And then of course you save the sumo configuration. And run the simulation. I did all this. And the results are here in this one final folder. That's part of the files. And well, then let's look at some data. Let's look, for example, at the stats.xml file. All right. So. This is kind of hard to read. And. Let's see. Okay. Better, right? Yeah. All right. So we have all kinds of statistics. We have the performance, how long will the simulation run. How many vehicles were loaded, how many persons that we have. So as you can see, we had this Poisson distribution. Running for 1000 seconds, generating an expected value of 1.5 persons per second. And if you do random things, well, then you won't get the exact half of it. So we have here 470 persons that were generated. And each of them had two bicycle trips: one from the station and one back to the station. So here we have here twice as many vehicle-trips recorded in the simulation. And something else we can see is that for matter of convenience, the bikes actually have their separate section in the output.

Usually you have one for bikes and then one for all the other vehicles, because they tend to be quite different from other modes. And so we see the average route length, about 1 kilometer. You can walk this, but it's quite convenient to have a bike. The average speed, and the waitingTime here. So the waitingTime is the time the bikes spent stop, mostly at traffic lights. And this is part of the overall timeLoss. Timeloss means, well, they would have liked to go past off but they couldn't, for some reason, so timeLoss includes the parts where they just stood still. But also the parts where there were slowed down by other slower bikes, or some other. 

And so. The time should always be at least as big as the waiting. And then, we have another statistic here. This is a statistic on the rides that the persons did. So obviously it's the same as the number of vehicles, because we only had these bikes. But as you can see here, we have another value for the waitingTime. The route length matches, it's the same value as here, but we have another waitingTime value. So what is this? Well, from the perspective of the bikes, the waitingTime is the time where they couldn't drive. But from the perspective of the persons, the waitingTime is the time before they could start driving. So you will mostly have this, obviously have this in public transport. You're waiting at this bus stop and the bus doesn't come. So this is your waitingTime before the ride actually starts. In this case, the bikes weren't running on any kind of public transport schedule. It was rather the fact that they couldn't all sit on the road at the same time. So you can say they were all in some imaginary bicycle parking area and couldn't get onto the bike lane. So this is the waitingTime. All right. So these are values that we get out of the single file that summarizes the whole simulation, but maybe it's a bit too condensed. Maybe we're not seeing enough for what really happened. So let's use another tool to get a better grip on these statistics. Going back to the slides. All right. So one thing we can do is we could get statistics directly from the tripinfo file. And we compute not only the mean value of all these attributes that we saw here, but also the standard deviation and the different modes and maybe figure out what the minimum and maximum values were as well. This is always a good idea. A good summary statistic to have something, to have more than the mean. For this, we use the tool `attributeStats.py`. It's a Python tool that has been part of SUMO for quite some time. Uh, but probably not so many people knew about it. And now there's a more discoverable form of the tool, where you can use it via the new tools dialog in netedit. Let's go back to netedit and use the tools dialog. So that's in the output section attributeStats.py. We select the data file that we want to do a summary on. So this is whatever came out of the run. We select the tripinfo file and that's it already. When we press run, it will already give us all these statistics. Of course, this is a bit hard to, to see on the screen, on the big screen. So I put this on the slides for you to see in detail. So now for every attribute in every element, that's that was found in this tripinfo file, we have more statistics. So we have statistics on the, on the tripinfo of the bicycles, but also statistics on the rides. And we can see the values that we already discussed in the context of the statistic output, the traveltime, the timeLoss, the waitingTime. And again, the different values for waitingTime for bikes and the rides. Different perspectives. And what we also see here, is the minimum and maximum values, and you even get the ID of the objects. Well, in this case, the ID of the bicycle that we're responsible for those minimum and maximum values. And then we could go back in the simulation and see what exactly this bike has been doing in order to reach this maximum waitingTime. Maybe there was something interesting about this bicycle. But I have highlighted something here. It's we see that there's a huge deviation in the waitingTime. So in the waitingTime of the rides, that is the time it took for the rides to start. And at this point, we should really take a look at a picture rather than all these dry numbers, so let's do that. We go back to the tools menu. This time we're going to use a visualization tool. This is `plotXMLAttributes`. And we're going to plot the waiting times of the bicycles. Actually of the rides. So I'm going to select the recursion info file. And I'm selecting the attributes that I want to plot against each other. So we'll see what I had in mind. Let's put on the X axis, the departure time and on the Y axis let's put the waitingTime, the one with the high deviation. All right. And at least in this version, you still have to click this checkbox, it's going to be defaulted in the next version. And now what we're seeing is this. That's kind of hard to read admittedly. The reason we're seeing these lines is that data points are grouped by ID and each bicycle occurred twice in the simulation once on the leg to the DLR. And again on the leg back. And so by default, these data points are connected with lines. So let's go back. And make this a scatterplot instead. And it will be much cleaner. So now we have this, we clearly see the two distinct phases in the simulation, and now we can start to understand what's happening. So in the first part of the simulation, we have all these bikes this person flow. 

And as we said, we set this to run over 1000 seconds, and start with a random spacing, the departures were spread over time. So pretty much whenever they wanted to start, it didn't take them too long to do so. But on the return leg, we set the conference to run until a fixed time, so regardless when the persons wanted to ride, the conference was over at the same time for all of them. So they all wanted to go back to the train station at the same time but there was still not enough road space and so the guy who got on the road last, or girl, they had to wait quite some time for them to find space on the road, so this is why this time until the ride started was so different between these two phases of the simulation and I think this is really something you need a picture for, this is hard to get from the raw data. All right so this having been satisfactorily explained let's have another look at the workings of the simulation, so we go back again and this time plot the timeLoss, after all that's a that's a very common statistic to evaluate the efficiency of a traffic scenario. And well, again we see these two phases in the simulation but we see something else very clearly in the second half there was quite a bit more timeLoss than in the beginning and why would that be? I mean once they get on the road there's actually space on the road, they should be going as fast in that way as in the other way. So that's unexplained. And in the best clickbaity manner, the answer for this will surprise you. So stay tuned...

All right. So the next thing we want to do to get a deeper understanding of what's happening here is look at some spatial performance measures. We're going back to the edge data. So how much time was lost on different edges of the simulation. And one thing you could do is after the simulation is done, just load the edge data into your simulation. So let's start the simulation again. And now a small trick here. I've used the sumo config to launch the network and take a look at it. But what I launched was this configuration file, whereas I ran the simulation with this other configuration. So look at the difference. The one config had all the outputs defined, and the other config aptly named "no_output" didn't have all these definitions for the output files. And otherwise, by just launching this config again, I would have started to rewrite the output files and all the data that I already recorded would have been overwritten. Now, that wasn't what I wanted, so I prepared another config to just launch this conveniently. And now what I can do is I can load the edge data into my simulation. All you get from this is the summary of all the attributes that were in there. It says data between time zero and time 30,000. And it loaded attributes such as the ride and waiting. It's small for you to read. Nevertheless, it will be there. And now to make use of this, we're going to recolor the rows.

We're going to recolor them by edgeData. And now we're going to recolor the rows. We're going to recolor them by edgeData. And then we have to pick the attribute by which we want to color. We're going to pick the timeLoss. And then we need a coloring scheme. So one way to get this is to build it automatically from the data that is loaded. Apologies, I know that a rainbow is not an appropriate coloring scale for scientific data. There have been lots of papers and reports on that. And I have it cleanly on my agenda to change this. But for now you have to make do with a rainbow. Sorry. So now we have a legend that tells us what these values mean. Red is the lower end, and purple is the high end, and we can look at these values to see very clearly that this bicycle lane here had all the waitingTime. If we don't trust our eyes with the colors, we can of course look at the numbers. One way to do this is by just right-clicking at the respective edge. And then we have the color value here in the attribute box, but that's doable, but we have a better way. We can tick this box "show edge color value". And then we have all the values right here. If it so happens that the colors and the fonts overlap, we can also set a background. And then it's even more readable. So now you can be absolutely sure that the numbers here are bigger than the numbers on the other ones. So this gives us a clear indication that we should look at that part of the simulation while it runs. So let's do that. Well, actually, since we already have the simulation open anyway, why not right now? And let's fast forward to the part where they all depart again. So, oh yes, it's about now. All right. So of course another way to look at the simulation is to color the vehicles, for example, by their speed. And then we could also get the impression that there are lots of red colored vehicles in this area. Actually, let's go back to the edge statement to see exactly which edge we want to look at. This is the road that we want to look at. Now look at it while the simulation is moving. This is the first part where everything is going south, so to say. Now the second part. All right, so what we can see here is that bicycles have to wait at the red light for quite some time. Why is that? Let's have a look at the signal to that. Right click here. And "Show Phases". This is the basic layout here. Now the time is on the horizontal axis and on the vertical we have all the different lights that are being switched by the traffic light. And to really see which lights, which of these horizontal lines we want to look at, we have to show these numbers. This is the link TLS index. Now for every stream of traffic, we have a number here. Now this is a bit unfortunate that the numbers are so big. They were smaller, and we can see what's happening. So 15, 16, 17, 18 are all the links here. And 15 is the right turn. 16 is the straight movement. 17 is the left turn. And 18 is a turnaround. If you're not sure which is which, you can always disable the rendering of the junction itself. <kbd>Ctrl</kbd> + <kbd>J</kbd>. And simply do a right click on these internal edges. So there you see it. This is the thing with the 15 in the end. And this is the thing with the 16 in the end. And this is where the bikes want to go. So going back to this. 15 is here. 16. This is the one that the bikes have to use. Now if we look at what they had in the beginning, going this way was number one. 0. 1 going straight. So already you can see that the one in it's overall plan has two green phases. Whereas the 16 has only a single green face. So whenever the signal time was generated, there was some asymmetry in. And the reason the exact reason if you want to know is that here the bicycle lane is part of the road. And also the outgoing bicycle lane is part of the road. 

There is some asymmetry in all the edges that go in there. It's about mostly about the track, that breaks up the symmetry of this intersection. So anyway, generating signal plans for complex intermodal intersections is a bit of, well, it's difficult and so it will happen that the plan that sumo gives you has some artifacts in this case it has this asymmetry between going this way and that way, and so that's one of the reasons why the bikes going back to the train station collect more waitingTime, but there's something even more subtle going on here, so we have to watch the simulation for a bit and watch it slowly, see what's happening. Can you see this? There are some green lights here on the road but the bikes are not driving and as I mentioned 17 and 18 are the lights that affect the left turn and the turnaround which the bikes don't want to use, they want to go straight, but for straight they don't have the green light they have the red light, and now the traffic actuation says well we're detecting traffic here probably it wants to go left so let's keep open the green phase, and this is actually what the warning in the very beginning was about. It was oh I'm not sure if I can use the detector, I'm not really sure whether what it means if there's a bike on the detector. And then we set this option in the sumo config file that says well ignore this and if the detector is jammed after 30 seconds then just switch to another phase. So the good news is this left turn phase doesn't last for the maximum possible duration of in this case 50 seconds, after 30 seconds it detects that there's a problem it switches on but for these 30 seconds we have a green light with nobody driving. So this is a problem that you can have with an actuated traffic light that's a rather advanced thing here, but just bear in mind this can happen in your scenarios of that. So this is the mystery of why the two plots looked so different. Well I guess the moral here is microscopic simulations have lots of details and if you have lots of details you have lots of opportunities to make things wrong.

## Running a simulation with multiple seeds
All right but on a happier note let's do something fancy, something that we never discussed before in a tutorial: let's run the simulation not only once but multiple times, which you should always do of course, we've always been telling you to do this but we didn't really give you the tools to make this comfortable, you always had to do your own scripting to run your simulation multiple times. Now for those of you who still need some motivation for why would you even want to run the simulation multiple times, if you have your sumo config and you run it not once but twice, there will be essentially no difference, it will give you the exact same simulation and this is because there is a random seed so-called random seed, that's a value that initializes the random number generator and if you use the same values the same random numbers come out every time and the simulation will behave in the exact same way, but usually we want to have runs with different initial values with different random seeds and then see how the randomness affects the scenario. This is one of the reasons for running multiple times, and the second reason is maybe you have different variants of the same scenario maybe you have some parameter that you want to change and then you want to run your scenario with different versions of that parameter and we're going to do both things, we're going to have the simulation we just defined run multiple times with different seeds and then also we're going to switch off the sublane model, remember that's the thing that allowed the bikes to drive side by side, we're going to switch this off and also run this model, and it's not going to be slower because we'll have them run in parallel.

So how does that work? So let's go to the final folder of the tutorial and now there's a little point of difficulty here, I have to make sure that I start netedit in this folder because in the current version the tool requires the working directory to be set to the folder where all the config files are and this is one way to initialize the working directory. All right, so now I'm going to use the tool `runSeeds`. I select the configuration files that I want to run, so now by clicking this little hammer button I switch to the working directory, and I want sumo configuration files so I have to switch to "All files" here (the next version will have a smarter pre-select for the file folder) so I'll select those two config files, I select the number of seeds, let's not have 10 but rather 0, 1, 2, 3 and let's run this with a press, and that's it. So now this is running eight simulations in the background and presumably using all my cores, and now one thing you also see is if you change the randomness sometimes maybe the simulation will behave differently, actually this year uncovered an issue with the bicycle behavior at certain seeds there is a collision in the simulation which is of course something I will look at after the tutorial, but now I can close this and what do I have? The runSeeds tool generated two folders, one for every configuration file, and in each folder I have multiple versions of the output file and they are all prefixed with the random seed, as you recall I use random seeds zero to four so they are prefixed with the zero with the one with the two and with the three, which are the four runs. Well, that's fast isn't it? So an easy way to have all these different runs and now of course we need to do some analysis, so lets plot the timeLoss, we already took a look at the plotting tool, this time we are going to use some fancy attributes. Again, we want timeLoss in the Y-axis, but now on the X-axis we do a ranking, so basically every timeLoss data point, in each of these tripinfo output files will be a point in the plot, and we're going to sort them along the X-axis by their timeLoss value. Let's just see how that goes. And also we don't care about the IDs of the vehicles, rather, we want to group it by the file name, we want to compare the runs to each other. So this is why we have this special value of \@RANK here and add prefix things on magic attributes. All right. Now what's a good way to select all these files at once? You can do control-click and find them all. Or I can instead sort them by size. This way they will be close together. I can do a shift-click. And now the unfortunate thing here in the UI is we cannot currently easily collect files from multiple folders. The next version of the runSeeds tool actually has an option to put everything in one folder to make this more convenient. Right now I'm going to do some copy paste. So I'm just going to copy all the files from the first folder. Then I select all the files from the second folder. And I just paste in what I just copied. That's not very nice, but it won't stay that way. Now the rank, timeLoss, and no ID. And let's go. Ah, yes. I forgot this checkbox. Don't worry about it, the next version won't need the checkbox. Now that's it. Every file that we loaded gives us one line and we see that the scenarios changed quite a bit. We also see that there are two groups of lines. Now, I'll come back. You can already guess which group of lines corresponds to which configuration file, I guess. So, who wants to take a guess? All right, so the group with the low timeLoss, that's the one with the sublane model. And the other group with the high timeLoss, that's the group where we switched off the sublane model. Because then the capacity on the road's even lower and of course there's no timeLoss. But if we want to make sure we can just go back and switch on the legend. Now, see that the lines with the two that's from the second configuration file, these are the upper group. And the rank plots just sorts them to give you a better visual impression. What you can see is, that the lines are at different extent from the x-axis. What does that mean? Each data point is from one bike. We just put them all, sort them all along the X-axis. So the different lines mean that the different scenarios have different amounts of bicycle, which is to be expected because we defined our traffic in a very random manner, we used this Poisson flow, which randomized the time from one bike to the next. And so within the span of 1000 seconds, we're going to have different spacing and this can lead to different amounts of traffic in the scenario within the ranges, maybe not so high, but it adds some spread. Now, of course, this has quite an impact on the scenario because they interact, and if you had more, than likely they will experience even more timeLoss. So I think this is an awesome way to have a look at many runs at once. And this plotting tool gives you many options to get all kinds of plots out of the sumo files. You can find a lot more examples of what this tool can do. Barplots, histograms, just to name a few in the documentation. And also for every output file that sumo gives you, there is now in the documentation a plotting example to inspire you to take a look at these dry XML files in a new way. So that's what I wanted to show you today. And with this, I conclude my tutorial.

So use netedit, not only to edit your networks, but also to discover all these Python tools that sumo holds. I think right now it's 60 tools that you can get from that menu. And we didn't even link up all the tools we have. So there's still more to come. And of course, every tutorial needs to finish with the acknowledgement to use the osmWebWizard. So go ahead. And as always, before you ask, read the documentation. But if you don't find anything in the documentation, then drop us a line, talk to us on the mailing list and talk to us. We're always looking for project partners. That's it for my end. Thank you for your attention.

# Other conference tutorials

Take a look at our other conference tutorials, [here](index.md#sumo_user_conference_tutorials).