## TFSA-2021-093: Heap OOB write in TFLite

### CVE Number
CVE-2021-29603

### Impact
A specially crafted TFLite model could trigger an OOB write on heap in the
TFLite implementation of
[`ArgMin`/`ArgMax`](https://github.com/tensorflow/tensorflow/blob/102b211d892f3abc14f845a72047809b39cc65ab/tensorflow/lite/kernels/arg_min_max.cc#L52-L59):

```cc
TfLiteIntArray* output_dims = TfLiteIntArrayCreate(NumDimensions(input) - 1);
int j = 0;
for (int i = 0; i < NumDimensions(input); ++i) {
  if (i != axis_value) {
    output_dims->data[j] = SizeOfDimension(input, i);
    ++j;
  }
}
```

If `axis_value` is not a value between 0 and `NumDimensions(input)`, then the
condition in the `if` is never true, so code writes past the last valid element
of `output_dims->data`.

### Patches
We have patched the issue in GitHub commit
[c59c37e7b2d563967da813fa50fe20b21f4da683](https://github.com/tensorflow/tensorflow/commit/c59c37e7b2d563967da813fa50fe20b21f4da683).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
