package ONVIF::Device::Types::DeviceServiceCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Network_of :ATTR(:get<Network>);
my %Security_of :ATTR(:get<Security>);
my %System_of :ATTR(:get<System>);
my %Misc_of :ATTR(:get<Misc>);

__PACKAGE__->_factory(
    [ qw(        Network
        Security
        System
        Misc

    ) ],
    {
        'Network' => \%Network_of,
        'Security' => \%Security_of,
        'System' => \%System_of,
        'Misc' => \%Misc_of,
    },
    {
        'Network' => 'ONVIF::Device::Types::NetworkCapabilities',
        'Security' => 'ONVIF::Device::Types::SecurityCapabilities',
        'System' => 'ONVIF::Device::Types::SystemCapabilities',
        'Misc' => 'ONVIF::Device::Types::MiscCapabilities',
    },
    {

        'Network' => 'Network',
        'Security' => 'Security',
        'System' => 'System',
        'Misc' => 'Misc',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::DeviceServiceCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DeviceServiceCapabilities from the namespace http://www.onvif.org/ver10/device/wsdl.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Network


=item * Security


=item * System


=item * Misc




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::DeviceServiceCapabilities
   Network => ,
   Security => ,
   System => ,
   Misc => ,
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

