#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Το patch 1.0.1.0 δεν είναι εγκατεστημένο"},
    {TR_NO_PATCH_MESSAGE,
        "Η εγκατεστημένη έκδοση του Caesar 3 δεν περιλαμβάνει το patch 1.0.1.0"
        "Μπορείτε να κατεβάσετε το patch από εδώ:\n"
        URL_PATCHES "\n"
        "Συνεχίζετε με δική σας ευθύνη."},
    // Do not translate the following two strings since they cannot be shown in Greek:
    {TR_MISSING_FONTS_TITLE, "Missing fonts"},
    {TR_MISSING_FONTS_MESSAGE,
        "Your Caesar 3 installation requires extra font files. "
        "You can download them for your language from:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Ο επεξεργαστής δεν έχει εγκατασταθεί"},
    {TR_NO_EDITOR_MESSAGE,
        "Η εγκατάστασή σας στο Caesar 3 δεν περιέχει τα αρχεία του επεξεργαστή. "
        "Μπορείτε να τα κατεβάσετε από εδώ:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Μη έγκυρος γλωσσικός κατάλογος"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Ο κατάλογος που επιλέξατε δεν περιέχει έγκυρο πακέτο γλωσσών. "
        "Ελέγξτε το αρχείο καταγραφής για σφάλματα."},
    {TR_AUTO_CYCLE_TEMPLES, "Όλοι"},
    {TR_BUTTON_OK, "ΟΚ"},
    {TR_BUTTON_CANCEL, "Ακύρωση"},
    {TR_BUTTON_RESET_DEFAULTS, "Επαναφορά προεπιλογών"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Πλήκτρα συντομεύσεων"},
    {TR_CONFIG_ARE_YOU_SURE, "Επαναφορά προεπιλογών?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Θα χάσετε όλες τις προσαρμοσμένες ρυθμίσεις σας."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Θα χάσετε όλα τα προσαρμοσμένα πλήκτρα."},
    {TR_CONFIG_TITLE, "Επιλογές διαμόρφωσης Augustus"},
    {TR_CONFIG_HEADER_GENERAL, "Γενικές ρυθμίσεις"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Διεπαφή χρήστη"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Δυσκολία"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Διαχείριση πόλης"},
    {TR_CONFIG_LANGUAGE_LABEL, "Γλώσσα:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(προεπιλογή)"},
    {TR_CONFIG_GAME_SPEED, "Ταχύτητα παιχνιδιού:"},
    {TR_CONFIG_VIDEO, "Επιλογές βίντεο"},
    {TR_CONFIG_FULLSCREEN, "Πλήρης οθόνη"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Ανάλυση παραθύρων:"},
    {TR_CONFIG_DISPLAY_SCALE, "Κλίμακα απεικόνισης:"},
    {TR_CONFIG_CURSOR_SCALE, "Κλίμακα κέρσορα:"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Χρήση έγχρωμων δεικτών"},
    {TR_CONFIG_AUDIO, "Επιλογές ήχου"},
    {TR_CONFIG_VOLUME, "Ένταση"},
    {TR_CONFIG_ENABLE_AUDIO, "Ενεργοποίηση ήχου"},
    {TR_CONFIG_MUSIC, "Ενεργοποίηση μουσικής"},
    {TR_CONFIG_SPEECH, "Ενεργοποίηση ομιλίας"},
    {TR_CONFIG_EFFECTS, "Ενεργοποίηση ηχητικών εφέ"},
    {TR_CONFIG_CITY_SOUNDS, "Ενεργοποίηση ήχων πόλης"},
    {TR_CONFIG_VIDEO_SOUND, "Ενεργοποίηση ήχου βίντεο"},
    {TR_CONFIG_SCROLL_SPEED, "Ταχύτητα κύλισης:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Αναπαραγωγή εισαγωγικών βίντεο"},
    {TR_CONFIG_SIDEBAR_INFO, "Πρόσθετες πληροφορίες στον πίνακα ελέγχου"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Ενεργοποίηση ομαλής κύλισης"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Απενεργοποίηση κύλισης χάρτη στην άκρη του παραθύρου"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Απενεργοποίηση κύλισης με το δεξί κουμπί του ποντικιού"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Βελτίωση της οπτικής ανατροφοδότησης κατά την εκκαθάριση γης"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Δυνατότητα κατασκευής κάθε ναού διαδοχικά"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Εμφάνιση εύρους κατά την οικοδόμηση δεξαμενών, σιντριβανιών και πηγαδιών"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Εμφάνιση εύρους σιντριβανιών και φρεατίων κατά την οικοδόμηση σπιτιών"},
    {TR_CONFIG_SHOW_MARKET_RANGE, "Εμφάνιση εύρους κατά την οικοδόμηση αγορών"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Εμφάνιση συρόμενου μεγέθους κατασκευής"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Επισήμανση λεγεώνας στο πέρασμα του κέρσορα"},
    {TR_CONFIG_ROTATE_MANUALLY, "Περιστροφή της πύλης και της αψίδας θριάμβου με το πλήκτρο συντόμευσης"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Ενεργοποίηση πλευρικής στήλης στρατού"},
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Αντιστροφή συρσίματος χάρτη με το δεξί πλήκτρο του ποντικιού"},
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Εμφάνιση νέων μηνυμάτων ως ειδοποιήσεις αντί για αναδυόμενα παράθυρα"},
    {TR_CONFIG_UI_SHOW_GRID, "Εμφάνιση πλέγματος"},
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Εμφάνιση μερικού πλέγματος γύρω από τις κατασκευές"},
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Εμφάνιση των κουμπιών περιστροφής πάντα"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Επιδιόρθωση σφάλματος μετανάστευσης στο πολύ δύσκολο επίπεδο"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Επιδιόρθωση φαντασμάτων 100 ετών"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Διορθώστε την αλλαγή και το χρόνο επιβίωσης σε προσαρμοσμένες αυτοκρατορικές αποστολές"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Διόρθωση μη ολοκληρωμένων στηλών αξιολόγησης σε χαμηλούς στόχους"},
    {TR_CONFIG_GRANDFESTIVAL, "Οι μεγάλες γιορτές επιτρέπουν επιπλέον ευλογία από έναν θεό"},
    {TR_CONFIG_DIFFICULTY, "Δυσκολία:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Μέγιστος αριθμός μεγαλοπρεπών ναών ανά πόλη:"},
    {TR_CONFIG_INFINITE, "Άπειρη"},
    {TR_CONFIG_GODS_EFFECTS, "Ενεργοποιήστε τις κατάρες/ευλογίες των θεών"},
    {TR_CONFIG_JEALOUS_GODS, "Απενεργοποίηση της ζήλειας των θεών"},
    {TR_CONFIG_GLOBAL_LABOUR, "Ενεργοποίηση συνολικής δύναμης εργατικού δυναμικού"},
    {TR_CONFIG_SCHOOL_WALKERS, "Επέκταση του εύρους των περιπάτων των μαθητών"},
    {TR_CONFIG_RETIRE_AT_60, "Αλλαγή της ηλικίας συνταξιοδότησης των πολιτών από τα 50 στα 60 έτη"},
    {TR_CONFIG_FIXED_WORKERS, "Σταθερό εργατικό δυναμικό - 38% του πληθυσμού των πληβείων"},
    {TR_CONFIG_EXTRA_FORTS, "Επιτρέψτε την κατασκευή 4 επιπλέον οχυρών"},
    {TR_CONFIG_WOLVES_BLOCK, "Οικοδόμηση τετραγώνων γύρω από τους λύκους"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Αποκλεισμός ασύνδετων δρόμων σιταποθηκών"},
    {TR_CONFIG_MORE_STOCKPILE, "Οι κατοικίες αποθηκεύουν περισσότερα αγαθά από την αγορά"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Οι υπάλληλοι της αγοράς που αγοράζουν δεν διανέμουν αγαθά"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Άμεση καταστροφή κτιρίων"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Οι οδηγοί κάρρων από τις σιταποθήκες μπορούν να μετακινηθούν εκτός δρόμου"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Διπλασιασμός της χωρητικότητας των καροτσιών από τις σιταποθήκες που λαμβάνουν"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Επιτρέψτε στους εμπόρους να εξάγουν τρόφιμα από τις σιταποθήκες"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Οι φρουροί του πύργου δεν χρειάζονται οδική πρόσβαση από τους στρατώνες"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Τα αγροκτήματα και οι προβλήτες παραδίδουν μόνο σε κοντινές σιταποθήκες"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Δεν παραδίδονται τρόφιμα σε σιταποθήκες που λαμβάνουν"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Όλα τα σπίτια συγχωνεύονται"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Η ανοικτή εμπορική διαδρομή λογίζεται ως παροχή διαφορετικού τύπου οίνου"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Τα ορύγματα αργίλου και τα ορυχεία σιδήρου που καταρρέουν τυχαία απορροφούν κάποια χρήματα αντ' αυτού"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Δυνατότητα κατασκευής πολλαπλών στρατώνων" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Οι αποθήκες και οι σιταποθήκες δεν δέχονται τίποτα όταν κατασκευάζονται"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Οι κατοικίες δεν επεκτείνονται σε κήπους"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Οι περιπλανώμενοι περιπατητές δεν παραλείπουν γωνίες"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Εμφάνιση της μέγιστης επιτεύξιμης βαθμολογίας ευημερίας με τις τρέχουσες κατοικίες"},
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Οι πολίτες θα σκοτώνουν αυτόματα αβλαβή ζώα"},
    {TR_CONFIG_SHOW_ROAMING_PATH, "Προεπισκόπηση μονοπατιών που διανύουν περιπλανώμενοι περιπατητές"},
    {TR_CONFIG_DRAW_CLOUD_SHADOWS, "Σχεδιάστε σκιές σύννεφων"},
    {TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE, "Ζητήστε επιβεβαίωση όταν αντικαθιστάτε ένα αρχείο"},
	{TR_HOTKEY_TITLE, "Ρύθμιση πλήκτρων συντομεύσεων του Augustus"},
	{TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS, "Οι μη στρατιωτικές πύλες επιτρέπουν από προεπιλογή όλους τους περιπατητές"},
    {TR_HOTKEY_LABEL, "Πλήκτρα συντόμευσης"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Εναλλακτικά"},
    {TR_HOTKEY_HEADER_ARROWS, "Πλήκτρα βέλους"},
    {TR_HOTKEY_HEADER_GLOBAL, "Γενικά πλήκτρα συντόμευσης"},
    {TR_HOTKEY_HEADER_CITY, "Πλήκτρα συντομεύσεων πόλης"},
    {TR_HOTKEY_HEADER_ADVISORS, "Σύμβουλοι"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Επικαλύψεις"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Σελιδοδείκτες χάρτη πόλης"},
    {TR_HOTKEY_HEADER_EDITOR, "Επεξεργαστής"},
    {TR_HOTKEY_HEADER_BUILD, "Πλήκτρα συντόμευσης κατασκευών"},
    {TR_HOTKEY_ARROW_UP, "Πάνω"},
    {TR_HOTKEY_ARROW_DOWN, "Κάτω"},
    {TR_HOTKEY_ARROW_LEFT, "Αριστερά"},
    {TR_HOTKEY_ARROW_RIGHT, "Δεξιά"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Εναλλαγή πλήρους οθόνης"},
    {TR_HOTKEY_CENTER_WINDOW, "Παράθυρο στο κέντρο"},
    {TR_HOTKEY_RESIZE_TO_640, "Αλλαγή μεγέθους παραθύρου σε 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Αλλαγή μεγέθους παραθύρου σε 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Αλλαγή μεγέθους παραθύρου σε 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Αποθήκευση στιγμιότυπου οθόνης"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Αποθήκευση στιγμιoτύπου οθόνης ολόκληρης της πόλης"},
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Αποθήκευση στιγμιότυπου οθόνης μίνι χάρτη"},
    {TR_HOTKEY_BUILD_CLONE, "Κλωνοποίηση κτιρίου κάτω από τον κέρσορα"},
    {TR_HOTKEY_LOAD_FILE, "Φόρτωση αρχείου"},
    {TR_HOTKEY_SAVE_FILE, "Αποθήκευση αρχείου"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Αύξηση ταχύτητας παιχνιδιού"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Μείωση ταχύτητας παιχνιδιού"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Εναλλαγή παύσης"},
    {TR_HOTKEY_CYCLE_LEGION, "Περιοδεία στις λεγεώνες"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Περιστροφή χάρτη αριστερά"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Περιστροφή χάρτη δεξιά"},
	{TR_HOTKEY_ZOOM_IN, "ζουμ μέσα"},
    {TR_HOTKEY_ZOOM_OUT, "ζουμ έξω"},
    {TR_HOTKEY_RESET_ZOOM, "Επαναφορά ζουμ"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Σύμβουλος εργασίας"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Σύμβουλος στρατού"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Σύμβουλος Αυτοκράτορα"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Σύμβουλος αξιολογήσεων"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Σύμβουλος εμπορίου"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Σύμβουλος πληθυσμού"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Σύμβουλος υγείας"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Σύμβουλος εκπαίδευσης"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Σύμβουλος ψυχαγωγίας"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Σύμβουλος θρησκείας"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Σύμβουλος οικονομικών"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Επικεφαλής σύμβουλος"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Σύμβουλος στέγασης"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Εναλλαγή τρέχουσας επικάλυψης"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Σχετική επικάλυψη"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Επικάλυψη νερού"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Επικάλυψη πυρκαγιάς"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Επικάλυψη ζημιών"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Επικάλυψη εγκλήματος"},
    {TR_HOTKEY_ROTATE_BUILDING, "Επόμενη περιστροφή κτιρίου"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Προηγούμενη περιστροφή κτιρίου"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Επικάλυψη προβλημάτων"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Μετάβαση στο σελιδοδείκτη 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Μετάβαση στο σελιδοδείκτη 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Μετάβαση στο σελιδοδείκτη 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Μετάβαση στο σελιδοδείκτη 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Ορισμός σελιδοδείκτη 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Ορισμός σελιδοδείκτη 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Ορισμός σελιδοδείκτη 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Ορισμός σελιδοδείκτη 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Εναλλαγή πληροφοριών μάχης"},
    {TR_HOTKEY_EDIT_TITLE, "Πατήστε το νέο πλήκτρο συντόμευσης"},
    {TR_BUILDING_ROADBLOCK, "Οδόφραγμα"},
    {TR_BUILDING_ROADBLOCK_DESC, "Το οδόφραγμα σταματά τους πολίτες που περιφέρονται."},
    {TR_BUILDING_ARCHITECT_GUILD, "Συντεχνία αρχιτεκτόνων" },
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Οι αρχιτέκτονες εδώ εργάζονται ακούραστα για να κατασκευάσουν μνημεία για τη δόξα της Ρώμης." },
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Αποδώστε επίθετο στο ναό" },
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Μεγαλοπρεπής ναός της Δήμητρας" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Μεγαλοπρεπής ναός του Ποσειδώνα" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Μεγαλοπρεπής ναός του Ερμή" },
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Μεγαλοπρεπής ναός του Άρη" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Μεγαλοπρεπής ναός της Αφροδίτης" },
    {TR_BUILDING_PANTHEON, "Πάνθεον" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Μεγαλοπρεπής ναός της Δήμητρας" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Μεγαλοπρεπής ναός του Ποσειδώνα" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Μεγαλοπρεπής ναός του Ερμή" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Μεγαλοπρεπής ναός του Άρη" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Μεγαλοπρεπής ναός της Αφροδίτης" },
    {TR_BUILDING_PANTHEON_DESC, "Πάνθεον" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Η Δήμητρα εμπνέει τους μεταφορείς από τα αγροκτήματα της πόλης σας να κινούνται 50% ταχύτερα." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Ο Ποσειδώνας παρέχει επιπλέον +1 εμβέλεια για σιντριβάνια και πηγάδια και +2 για δεξαμενές. Το εργατικό δυναμικό των υπηρεσιών ύδρευσης μειώνεται επίσης κατά 50% και τα εμπορικά πλοία ταξιδεύουν 25% ταχύτερα. Η αύξηση των ασθενειών στα σπίτια παρεμποδίζεται σημαντικά." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Ο Ερμής ευλογεί τους χερσαίους και θαλάσσιους εμπόρους σας με επιπλέον 50% χωρητικότητα και εμπνέει τους χερσαίους εμπόρους να κινούνται 25% ταχύτερα." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Ο Άρης προτρέπει τους πολίτες σας να στρατολογηθούν, στέλνοντας νεοσύλλεκτους στα οχυρά της πόλης σας και επιτρέποντας την κατασκευή τεσσάρων επιπλέον οχυρών." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Η Αφροδίτη κάνει τους κήπους, τα αγάλματα και τους ναούς της πόλης σας να λάμπουν από ομορφιά, βελτιώνοντας την ελκυστικότητά τους. Τα σπίτια χωράνε επίσης περισσότερα αγαθά και υποβαθμίζονται πιο αργά." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Το Πάνθεον παρέχει στους πολίτες σας πρόσβαση στη λατρεία όλων των θεών. Εδώ πραγματοποιούνται επίσης ετήσιες γιορτές και οι εισφορές για θρησκευτικά και πολιτιστικά κτίρια μειώνονται κατά 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Οι ιερείς μειώνουν την κατανάλωση τροφής κατά 20%." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Οι ναοί παράγουν ηνιόχους για τον ιππόδρομο." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Οι ιερείς μειώνουν την κατανάλωση κεραμικών και επίπλων κατά 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Οι ναοί παράγουν τρόφιμα, σε ποσότητα που βασίζεται στον αριθμό των κατοικιών που καλύπτουν, και τα παραδίδουν στο σταθμό ανεφοδιασμού. Οι εισφορές των οχυρών μειώνονται κατά 25%." }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Ο μεγαλοπρεπής ναός παράγει οίνο σε ποσότητα ανάλογη με τον πληθυσμό της πόλης με πρόσβαση στο ναό της Αφροδίτης. Οι ναοί το συλλέγουν και το διανέμουν σε κατοικίες και ταβέρνες." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Οι ιερείς συλλέγουν και διανέμουν ταυτόχρονα λάδι και ένα είδος τροφής από τις αποθήκες της πόλης." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Οι ιερείς επεκτείνουν την χωρητικότητα στέγασης κατά 5%. Ο μεγαλοπρεπής ναός παρέχει νερό σαν μια γεμάτη δεξαμενή." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Οι ιερείς μειώνουν την κατανάλωση λαδιού και κρασιού κατά 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Οι ιερείς μειώνουν την κατανάλωση όλων των αγαθών κατά 10%." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Οι ιερείς παρέχουν ψυχαγωγία και καλλωπίζουν οι ίδιοι τα σπίτια, αυξάνοντας την ελκυστικότητα της γειτονιάς χωρίς πρόσθετη διακόσμηση." },
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Όλοι οι ναοί της πόλης στέλνουν ιερείς στο Πάνθεον, διαδίδοντας την πίστη και τις ευλογίες των θεών τους." },
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Τα σπίτια με πρόσβαση στο Πάνθεον μπορούν να εξελιχθούν ένα επιπλέον βήμα." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Ναός της Δήμητρας Fecunda (Γονιμότητα)" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Ναός της Δήμητρας Frugifera (Καρποφορία)" }, // Note to translators: This one changed from the previous version, please update.
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Ναός του Ποσειδώνα Equester (Ίππειος)" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Ναός του Ποσειδώνα Adiutor (Προστάτης)" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Ναός του Ερμή Fortunus (Καλότυχος)" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Ναός του Ερμή Mercator (Έμπορος)" }, // Note to translators: This one changed from the previous versions, please update.
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Ναός του Άρη Ultor(Εκδικητής)" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Ναός του Άρη Quirinus(Ειρηνοποιός)" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Ναός της Αφροδίτης Verticordia (Επιστροφία)" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Ναός της Αφροδίτης Genetrix (Πρόγονος)" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Πάνθεον Ara Maxima(Μεγάλος Βωμός)" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Πάνθεον Roma Aeterna(Αιώνια Ρώμη)" },
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Μεγαλοπρεπής Ναός" },
    {TR_BUILDING_WORK_CAMP, "Εγκατάσταση Εργατών" },
    {TR_BUILDING_WORK_CAMP_DESC, "Οι εργάτες συγκεντρώνονται εδώ για να μεταφέρουν υλικά στα εργοτάξια." },
	{TR_BUILDING_DEPOT, "Αποθήκη κάρρων"},
	{TR_BUILDING_CAT_DEPOT, "Αποθήκη γατών"},
    {TR_BUILDING_DEPOT_DESC, "Η αποθήκη κάρρων στέλνει κάρρα για τη μεταφορά εμπορευμάτων μεταξύ αποθηκών και σιταποθηκών με βάση την παραγγελία. Τα κάρρα πρέπει να επιστρέφουν στην αποθήκη μετά από κάθε παράδοση."},
    {TR_HEADER_HOUSING, "Στέγαση"},
    {TR_ADVISOR_HOUSING_ROOM, "Οι κατοικίες της πόλης έχουν διαθέσιμο χώρο για"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Δεν υπάρχει διαθέσιμος χώρος στις κατοικίες της πόλης."},
    {TR_ADVISOR_RESIDENCES_USING_POTTERY, "Κατοικίες που χρησιμοποιούν κεραμικά"},
    {TR_ADVISOR_RESIDENCES_USING_FURNITURE, "Κατοικίες που χρησιμοποιούν έπιπλα"},
    {TR_ADVISOR_RESIDENCES_USING_OIL, "Κατοικίες που χρησιμοποιούν λάδι"},
    {TR_ADVISOR_RESIDENCES_USING_WINE, "Κατοικίες που χρησιμοποιούν κρασί"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Σύνολο κατοικιών:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Διαθέσιμη χωρητικότητα:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Συνολική χωρητικότητα:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Πληθυσμός - Κατοικίες"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Γραφήματα"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Η ευημερία των κατοικιών είναι"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Το ποσοστό του πληθυσμού σας σε βίλες και ανάκτορα είναι"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Το ποσοστό του πληθυσμού σας σε σκηνές και καλύβες είναι"},
    {TR_ADVISOR_AVERAGE_TAX, "Το μέσο φορολογικό εισόδημα ανά κατοικία είναι"},
    {TR_ADVISOR_AVERAGE_AGE, "Η μέση ηλικία του πληθυσμού σας είναι"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Το ποσοστό του πληθυσμού σας που αποτελεί εργατικό δυναμικό είναι"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Γεννήσεις πέρυσι:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Θάνατοι πέρυσι:"},
    {TR_ADVISOR_TOTAL_POPULATION, "κάτοικοι συνολικά"},
    {TR_ADVISOR_IN_STORAGE, "αποθηκευμένο"},
    {TR_ADVISOR_FROM_GRANARIES, "από σιταποθήκες"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Αποστολή τροφίμων από σιταποθήκες"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Είστε σίγουροι;"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Συνεχίστε την αποθήκευση πόρων"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Η μέγιστη ευημερία για το τρέχον επίπεδο κατοικιών είναι"},
    {TR_ADVISOR_POPULATION_AGE, "Ηλικία"},
    {TR_ADVISOR_POPULATION_RESIDENTS, "κάτοικοι"},
    {TR_ADVISOR_POPULATION_DWELLERS, "ένοικοι"},
    {TR_REQUIRED_RESOURCES, "Πόροι που παραδόθηκαν στο τρέχων στάδιο:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Η κατασκευή μεγάλων ναών απαιτεί υλικά αποθηκευμένα σε μια αποθήκη, εργάτες από μια εγκατάσταση εργατών και αρχιτέκτονες από μια συντεχνία αρχιτεκτόνων."},
    {TR_CONSTRUCTION_PHASE, "Στάδιο κατασκευής:"},
    {TR_ADD_MODULE, "Αφιέρωση ναού;"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Απονεμήθηκε επίθετο."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Πρώτη η Δήμητρα δίδαξε την κοπιαστική αγελάδα να οργώνει την εγκυμονούσα Γη, και να σπέρνει τον σπόρο.\n Αυτή πρώτη για τον άνθρωπο παρείχε υγιεινή τροφή και με δίκαιους νόμους προμήθευσε τον αμαρτωλό κόσμο.\n-Οβιδίου Μεταμορφώσεων, Βιβλίο Ε’"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Τα κύματα υποχωρούν, ενώ ο Ποσειδώνας απλώνει το σκήπτρο του στη φουρτουνιασμένη θάλασσα,\n και εξομαλύνει το αυλακωμένο της πρόσωπο.\n Ήδη ο Τρίτων, στο κάλεσμά του, εμφανίζεται πάνω από τα κύματα.\nΈνα τυριανό ένδυμα φοράει.\nΚαι στο χέρι του κρατάει μια στραβή σάλπιγγα.\n-Ὀβιδίου Μεταμορφώσεων, Βιβλίο Α’"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Τρίποδες, μόσχους, πρόβατα, ίππους ξανθούς αν χάσεις,\nπάλιν μ' αντάλλαγμ' αποκτάς ή λάφυρα τα παίρνεις.\nΑλλ' η ψυχή μας λάφυρο δεν γίνεται, ούτε κτήμα,\nαφού περάσει μια φορά το φράγμα των οδόντων.\n-Oμήρου Ιλιάδα, Ραψωδία Θ’"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Για τον Άρη, επιδιόρθωσε τα σπασμένα τσεκούρια του και τον αμβλυμένο πόλεμο,\nκαι στείλε τον ξανά με φτιαγμένα όπλα,\nγια να ξυπνήσει τον νωχελικό πόλεμο\n με τους δυνατούς συναγερμούς των σαλπίγγων\n-Βιργίλιος, Η Αινειάδα, Βιβλίο Η’" },
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Μα τον φτερωτό Έρωτα και την Αφροδίτη,\nτην τρυφερή μητέρα του, πόσο μεγάλη ήταν η χαρά μου!\nΠόσο ξεκάθαρα με άγγιξε το πάθος!\nΠόσο έλιωσε όλη μου η καρδιά εκεί που ήμουν ξαπλωμένη!\n Oβιδίου Μεταμορφώσεων, Βιβλίο Θ’" },
    {TR_BUILDING_PANTHEON_QUOTE, "Οι πύλες του ουρανού ανοίγουν: Ο Δίας συγκαλεί όλους\nτους θεούς σε συμβούλιο στην κοινή αίθουσα.\nΣε ύψιστη θέση, παρατηρεί από μακριά\nΤα χωράφια, το στρατόπεδο, την τύχη του πολέμου,\nΚαι όλο τον υποδεέστερο κόσμο. Από τον πρώτο μέχρι τον τελευταίο, η άρχουσα σύγκλητος τοποθετείται σε βαθμίδες.\n-Βιργίλιος, Η Αινειάδα, Βιβλίο Ι" },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "Διάζωμα(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "Αίθριο(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "Αίθουσα(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "Περίφραξη(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "Αφιερώσεις(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Οι εργάτες κατασκευάζουν το βάθρο που θα ανυψώσει το ναό και θα παρέχει ένα στέρεο θεμέλιο για να αντέξει το πέρασμα του χρόνου." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Οι τεχνίτες κατασκευάζουν το αίθριο, το οποίο φέρει τον θυσιαστήριο βωμό του ναού." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Οι μηχανικοί κατασκευάζουν την αίθουσα, το εσωτερικό του ναού που στεγάζει τις ιερές εικόνες." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Ξεκίνησαν οι εργασίες για την περίφραξη του ναού, όπου οι πιστοί θα συγκεντρώνονται στο ύπαιθρο για δημόσιες τελετές." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Καθώς ο ναός έχει σχεδόν ολοκληρωθεί, οι ιερείς συγκεντρώνονται για να εκτελέσουν τις τελετές του αγιασμού." },
    {TR_BUILDING_MENU_TREES, "Δέντρα" },
    {TR_BUILDING_MENU_PATHS, "Μονοπάτια" },
    {TR_BUILDING_MENU_PARKS, "Πάρκα"},
    {TR_BUILDING_SMALL_POND, "Μικρή λίμνη"},
    {TR_BUILDING_LARGE_POND, "Μεγάλη λίμνη"},
    {TR_BUILDING_PINE_TREE, "Πεύκο"},
    {TR_BUILDING_FIR_TREE, "Έλατο" },
    {TR_BUILDING_OAK_TREE, "Δρυς" },
    {TR_BUILDING_ELM_TREE, "Φτελιά" },
    {TR_BUILDING_FIG_TREE, "Συκιά" },
    {TR_BUILDING_PLUM_TREE, "Δαμασκηνιά" },
    {TR_BUILDING_PALM_TREE, "Φοίνικας" },
    {TR_BUILDING_DATE_TREE, "Χουρμαδιά" },
    {TR_BUILDING_PINE_PATH, "Μονοπάτι πεύκων" },
    {TR_BUILDING_FIR_PATH, "Μονοπάτι ελάτων" },
    {TR_BUILDING_OAK_PATH, "Μονοπάτι δρυών" },
    {TR_BUILDING_ELM_PATH, "Μονοπάτι φτελιών" },
    {TR_BUILDING_FIG_PATH, "Μονοπάτι Συκιών" },
    {TR_BUILDING_PLUM_PATH, "Μονοπάτι Δαμασκηνιών" },
    {TR_BUILDING_PALM_PATH, "Μονοπάτι φοινίκων" },
    {TR_BUILDING_DATE_PATH, "Μονοπάτι Χουρμαδιών" },
    {TR_BUILDING_BLUE_PAVILION, "Υπόστεγο" },
    {TR_BUILDING_RED_PAVILION, "Κόκκινο υπόστεγο"},
    {TR_BUILDING_ORANGE_PAVILION, "Πορτοκαλί υπόστεγο"},
    {TR_BUILDING_YELLOW_PAVILION, "Κίτρινο υπόστεγο"},
    {TR_BUILDING_GREEN_PAVILION, "Πράσινο υπόστεγο" },
    {TR_BUILDING_SMALL_STATUE_ALT, "Άγαλμα θεάς" },
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Άγαλμα συγκλητικού"},
    {TR_BUILDING_OBELISK, "Οβελίσκος" },
    {TR_BUILDING_POND_DESC, "Οι λίμνες γεμίζουν από τις δεξαμενές της πόλης και παρέχουν νερό για τα φυτά και τα ζώα και μια δροσερή, χαλαρωτική όαση για τους ανθρώπους. Όλοι οι πολίτες θα ήθελαν να ζουν κοντά σε μια λίμνη." },
    {TR_BUILDING_WINDOW_POND, "Λίμνη"},
    {TR_BUILDING_OBELISK_DESC, "Ένα μνημείο κύρους, έργο ενός αρχαίου βασιλιά του Νείλου. Οι Αιγύπτιοι δεν το χρησιμοποιούσαν."},
    {TR_ADVISOR_FINANCE_LEVIES, "Κτιριακές εισφορές"},
    {TR_CONFIRM_DELETE_MONUMENT, "Κατεδάφιση αυτού του μνημείου"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Επιλέξτε επίθετο για να αποδώσετε"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Η απονομή ενός επιθέτου θα αφιερώσει μόνιμα το ναό σας σε μια πτυχή της θεότητάς του, προσδίδοντας στους ιερείς θεϊκή δύναμη." },
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/μήνα"},
    {TR_BUILDING_MESS_HALL, "Σταθμός εφοδιασμού"},
    {TR_BUILDING_MESS_HALL_DESC, "Ο σταθμός ανεφοδιασμού συλλέγει τρόφιμα από τις αποθήκες της πόλης για να ταΐσει τους στρατιώτες που σταθμεύουν στα φρούρια της πόλης. Ένας ανεπαρκώς εφοδιασμένος σταθμός ανεφοδιασμού θα επιβραδύνει τη στρατολόγηση και θα βλάψει το ηθικό."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Προμήθειες τροφίμων τελευταίου μήνα:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Οι στρατιώτες είναι: " },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Καλοθρεμμένοι" },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Tαϊσμένοι"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Πεινασμένοι"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Πολύ πεινασμένοι"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Λιμοκτονούντες"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Η ποικίλη διατροφή των στρατιωτών σας αυξάνει σημαντικά το ηθικό."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Η ποικίλη, θρεπτική διατροφή που απολαμβάνουν οι στρατιώτες σας αυξάνει σημαντικά το ηθικό."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Δεν έχετε στρατιώτες να τροφοδοτήσετε." },
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Αποθηκευμένα τρόφιμα για μήνες:" },
	{TR_BUILDING_MESS_HALL_NO_FOOD, "Αυτή η θέση εφοδιασμού έχει υπαλλήλους, αλλά προς το παρόν αναζητούν μια διαθέσιμη πηγή τροφίμων." },
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Οδηγίες σταθμού εφοδιασμού"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Οι ελλείψεις τροφίμων στο σταθμό ανεφοδιασμού σας επιβραδύνουν τη στρατολόγηση στρατιωτών."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Οι κρίσιμες ελλείψεις τροφίμων στο σταθμό ανεφοδιασμού σας παραλύουν τη στρατολόγηση στρατιωτών." },
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Η πρόσφατη έλλειψη τροφίμων μείωσε το ηθικό"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Η πρόσφατη έλλειψη τροφίμων μείωσε σημαντικά το ηθικό"},
    {TR_BUILDING_LEGION_STARVING, "Έλλειψη τροφίμων" },
    {TR_ADVISOR_TRADE_MAX, "Μέγιστο"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "μέγιστο"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Εισαγώγιμο"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Εξαγώγιμο"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Δεν υπάρχουν αγοραστές για αυτόν τον πόρο"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Δεν υπάρχουν πωλητές για αυτόν τον πόρο"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Δεν εισάγεται"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Δεν εξάγεται"},
	{TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE, "Δεν μπορεί να αποθηκευτεί"},
    {TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE, "Ο πόρος δεν μπορεί να αποθηκευτεί ή να διακινηθεί"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Ανοίξτε την εμπορική οδό για εισαγωγή"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Ανοίξτε την εμπορική οδό για εξαγωγές"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Οι στρατιώτες σας έχουν όλο το φαγητό που χρειάζονται."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Οι στρατιώτες σας χρειάζονται περισσότερο φαγητό." },
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Οι στρατιώτες σας λιμοκτονούν!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Αποθηκευμένα τρόφιμα μηνών στο σταθμό ανεφοδιασμού:" },
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Πεινασμένοι στρατιώτες" },
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Ο σταθμός ανεφοδιασμού σας έχει έλλειψη τροφίμων και το ηθικό των στρατευμάτων σας εξασθενεί. Βεβαιωθείτε ότι ο σταθμός ανεφοδιασμού σας έχει πρόσβαση σε μια καλά εφοδιασμένη σιταποθήκη."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Η πόλη σας έχει χάσει το σταθμό ανεφοδιασμού της και τα στρατεύματά σας λιμοκτονούν. Κατασκευάστε αμέσως ένα σταθμό ανεφοδιασμού."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Οδηγίες αγοράς"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Οδηγίες αποβάθρας"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Οδηγίες ναού"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Οδηγίες ταβέρνας"},
    {TR_WARNING_NO_MESS_HALL, "Πρέπει πρώτα να χτίσετε ένα σταθμό ανεφοδιασμού για να ταΐσετε τους στρατιώτες σας."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "Δεν μπορούν να χτιστούν άλλοι μεγαλοπρεπείς ναοί."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Ολοκληρώθηκε ο μεγαλοπρεπής ναός"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Ιερείς και πιστοί συρρέουν στο νέο μεγαλοπρεπή ναό για τις τελετές των εγκαινίων. Ο λαός σας στέκεται με δέος μπροστά στο μεγαλείο των έργων σας και η θεότητα που επιλέξατε σας περιβάλλει με εύνοια."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Μια ευλογία από τον Ερμή" },
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Ευχαριστημένος από την αφοσίωσή σας, ο Ερμής ευλόγησε τη βιομηχανία σας, αποκαλύπτοντας πρώτες ύλες για τους τεχνίτες σας."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Επιστάτης"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Μεταφορέας"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Αρχιτέκτονας"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Φροντιστής"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Υπηρέτης σταθμού"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Ο μεγαλοπρεπής ναός διορίζει ιερείς της Δήμητρας για να βοηθήσουν στη διανομή τροφίμων και ελαιολάδου στους πεινασμένους πολίτες σας."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Ο μεγαλοπρεπής ναός επιτρέπει στους ιερείς της Αφροδίτης να παρέχουν ιερό κρασί στους πολίτες σας." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Ο μεγαλοπρεπής ναός διορίζει ιερείς του Άρη για την προμήθεια τροφίμων στο σταθμό ανεφοδιασμού σας."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Ναός της Δήμητρας"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Ναός του Ποσειδώνα"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Ναός του Ερμή"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Ναός του Άρη"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Ναός της Αφροδίτης"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Ιερέας" },
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Πόλεις με ανοιχτό θαλάσσιο εμπόριο:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Δεν υπάρχουν ανοιχτοί θαλάσσιοι εμπορικοί δρόμοι." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Θα κάνω ό,τι μπορώ για να ηρεμήσω αυτούς τους βαρβάρους. Είμαι σίγουρος ότι θα σταματήσουν να επιτίθενται στην πόλη όταν τους μιλήσω.\"" },
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Ένα ετήσιο φεστιβάλ"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Οι πιστοί συρρέουν στους ναούς για τον εορτασμό των Δημητρίων (Cerealia), προς τιμήν της Δήμητρας. Οι αγρότες προσφέρουν θυσίες για πλούσιες σοδειές τα επόμενα χρόνια."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Σήμερα είναι η γιορτή των Ποσειδωνίων (Neptunalia), προς τιμήν του Ποσειδώνα. Οι πιστοί χτίζουν καλύβες από κλαδιά και φυλλώματα και διασκεδάζουν κάτω από την καυτή ζέστη του καλοκαιρινού ήλιου."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Οι έμποροι και οι έμποροι προσέρχονται μαζικά για να γιορτάσουν τα Έρμαια (Mercuralia). Ιερό νερό ραντίζεται στα πλοία και τις αποθήκες με την ελπίδα της θεϊκής προστασίας από τον θεό Ερμή."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Οι πολίτες συγκεντρώνονται έξω από την πόλη για τη γιορτή των Άρειων (Equirria), για να ζητήσουν την εύνοια του Άρη. Ο αέρας γεμίζει από τον βροντερό ήχο των οπλών και το τρίξιμο των αρμάτων, καθώς οι πιστοί τρέχουν προς τιμήν του θεού τους."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Οι πιστοί συγκεντρώνονται για τον εορτασμό των Αφροδισίων (Veneralia), μιας ημέρας αφιερωμένης στην Αφροδίτη. Οι πολίτες σας την παρακαλούν για καλή τύχη σε θέματα καρδιάς."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Διαγραφή αναγνωσμένων μηνυμάτων"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Απενεργοποιήστε αυτό το κτίριο"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Ενεργοποιήστε αυτό το κτίριο"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Επιτρέψτε στους πωλητές της αγοράς να αγοράσουν από εδώ"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Επιτρέψτε στα καραβάνια να εμπορεύονται εδώ"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Επιτρέψτε στα εμπορικά πλοία να εμπορεύονται εδώ"},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Διακοπή εφοδιασμού σε εργαστήρια ή σιταποθήκες"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, " Ενεργοποίηση αποθήκευσης σε αποθήκη"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Απενεργοποίηση αποθήκευσης αποθεμάτων"},
    {TR_BUILDING_LIGHTHOUSE, "Φάρος"},
    {TR_BUILDING_CARAVANSERAI, "Καραβανσεράι"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Τα καραβάνια των εμπόρων καταφεύγουν εδώ για να ξεκουραστούν και να ταΐσουν τα ζώα τους. Οι διακοπές του χερσαίου εμπορίου διαρκούν το μισό χρόνο."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Οδηγίες Καραβανσεράι"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Θεμέλια)"},
	{TR_BUILDING_CARAVANSERAI_PHASE_2, "(Κολώνες)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Οι μηχανικοί θέτουν τα θεμέλια ενός καταφυγίου για τους εμπόρους."},
    {TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT, "Οι μασόνοι κατασκευάζουν μια ορθογώνια κιονοστοιχία. Στο εσωτερικό θα υπάρχουν καταφύγια για τους εμπόρους και τα ζώα τους."},
	{TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "προμηθευτής Καραβανσεράι" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Συλλέκτης Καραβανσεράι" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Πολιτική χερσαίου εμπορίου" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Καμία πολιτική χερσαίου εμπορίου." },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Επιλέξτε μια πολιτική χερσαίου εμπορίου για την πόλη σας. Μπορείτε να αλλάξετε σε άλλη πολιτική ανά πάσα στιγμή." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Πολιτική του πωλητή: Οι χερσαίες εξαγωγές κερδίζουν 20% περισσότερο, αλλά οι χερσαίες εισαγωγές είναι 10% ακριβότερες." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Πολιτική του αγοραστή: Οι χερσαίες εισαγωγές είναι 20% φθηνότερες, αλλά οι χερσαίες εξαγωγές κερδίζουν 10% λιγότερο." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Πολιτική χερσαίων ποσοτήτων: Τα εμπορικά καραβάνια μεταφέρουν 4 επιπλέον εμπορεύματα, αλλά το Καραβανσεράι καταναλώνει 20% περισσότερη τροφή." },
	{TR_BUILDING_CARAVANSERAI_NO_FOOD, "Αυτό το καραβανσεράι έχει υπαλλήλους, αλλά προς το παρόν αναζητούν μια διαθέσιμη πηγή τροφής." },																																
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Θεμέλια)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(βάθρο)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Πύργος)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Κορώνα)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Οι μηχανικοί θέτουν ένα ισχυρό θεμέλιο για να αντέξει το βάρος ενός μεγάλου πέτρινου πύργου." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Οι μαστόροι κατασκευάζουν το βάθρο που θα υψώσει τη φλόγα του φάρου πολύ πάνω από τον ορίζοντα." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Ο φάρος ανεβαίνει ψηλότερα κάθε μέρα, καθώς οι μαστόροι τοποθετούν διαδοχικές στρώσεις του μεγάλου πύργου." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Οι μηχανικοί πραγματοποιούν τις τελευταίες πινελιές στον φάρο. Σύντομα θα λάμπει για μίλια, καθοδηγώντας τα πλοία στην πατρίδα τους." },
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Η κατασκευή του φάρου απαιτεί υλικά αποθηκευμένα σε μια αποθήκη, εργάτες από ένα στρατόπεδο εργασίας και αρχιτέκτονες από μια συντεχνία αρχιτεκτόνων." },
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Το φως στην κορυφή αυτού του μεγάλου πύργου οδηγεί τα πλοία από τα πέρατα του κόσμου με ασφάλεια στην πόλη σας. Τα αλιευτικά πλοία κινούνται τώρα 10% ταχύτερα και οι θαλάσσιες καταιγίδες διαρκούν το μισό χρόνο." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Πολιτική θαλάσσιου εμπορίου" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Καμία πολιτική θαλάσσιου εμπορίου." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Επιλέξτε μια πολιτική θαλάσσιου εμπορίου για την πόλη σας. Μπορείτε να αλλάξετε σε άλλη πολιτική ανά πάσα στιγμή." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Ναυτιλιακή πολιτική πωλητή: Οι θαλάσσιες εξαγωγές κερδίζουν 20% περισσότερο, αλλά οι θαλάσσιες εισαγωγές είναι 10% ακριβότερες." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Ναυτιλιακή πολιτική αγοραστή: Οι θαλάσσιες εισαγωγές είναι 20% φθηνότερες, αλλά οι θαλάσσιες εξαγωγές κερδίζουν 10% λιγότερο." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" }, // XXX "quantitatis"? Can anybody double check?
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Ναυτιλιακή πολιτική ποσοτήτων: Τα εμπορικά πλοία μεταφέρουν 4 επιπλέον εμπορεύματα, αλλά ο Φάρος καταναλώνει 20% περισσότερη ξυλεία." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Μνημεία"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Ο ολοκληρωμένος φάρος, ένας πανίσχυρος πέτρινος πύργος, δεσπόζει στον ορίζοντα. Είθε ο πύρινος φάρος του να οδηγεί τα πλοία με ασφάλεια στο σπίτι τους μέχρι το τέλος του κόσμου." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Το Πάνθεον ολοκληρώθηκε. Στέκεται ασυναγώνιστα ως μνημείο της φοβερής δύναμης των θεών και των ανθρώπων της Ρώμης." },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Ολοκλήρωση μνημείου" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Ευλογία από τον Ποσειδώνα"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Ανταμείβοντας την αφοσίωση της πόλης σας, ο Ποσειδώνας παρέχει ομαλή διέλευση στους εμπόρους για δώδεκα μήνες, κατά τη διάρκεια των οποίων οι εξαγωγές σας θα κερδίζουν επιπλέον 50%."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Ευλογία από την Αφροδίτη" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Η Αφροδίτη, ευχαριστημένη από τη μεγάλη ευλάβεια που της δείχνουν, χαρίζει νεανικότητα, υγεία και ευτυχία στο λαό σας, αυξάνοντας το πλήθος του ενεργού πληθυσμού σας. Η διάθεση στην πόλη σας ανεβαίνει από το χαμόγελο της Αφροδίτης." },
    {TR_BUILDING_MENU_STATUES, "Αγάλματα" },
    {TR_BUILDING_MENU_GOV_RES, "Μέγαρα κυβερνήτη" },
    {TR_OVERLAY_ROADS, "Δρόμοι" },
    {TR_NO_EXTRA_ASSETS_TITLE, "Δεν ήταν δυνατή η φόρτωση επιπλέον στοιχείων" },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Τα πρόσθετα στοιχεία του Augustus δεν μπόρεσαν να φορτωθούν.\n"
        "Αυτό μπορεί να οφείλεται σε ένα ελλείποντα ή παλιό κατάλογο 'assets'.\n"
        "Βεβαιωθείτε ότι έχετε τον πιο ενημερωμένο κατάλογο 'assets', τον οποίο μπορείτε να αποκτήσετε από το GitHub." },
    {TR_WARNING_WATER_NEEDED_FOR_BUILDING, "Ο φάρος πρέπει να τοποθετηθεί κοντά στο νερό"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Αυτό το σπίτι έχει πρόσβαση και στους πέντε θεούς από το Πάνθεον"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Το άφθονο φαγητό ενισχύει το ηθικό" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Κατάσταση τροφίμων"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Επιτρέψτε στον επιστάτη να πάρει τρόφιμα εδώ"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Δεν μπορείτε να προμηθευτείτε τα απαραίτητα υλικά"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Οι ολοκληρωμένοι μεγάλοι ναοί χορηγούν βαθμολογία πολιτισμού +6"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Απενεργοποίηση της αναπαραγωγής άπειρων λύκων"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Έξοδος στο κύριο μενού" },
    {TR_LABEL_PAUSE_MENU, "Παύση" },
    {TR_OVERLAY_LEVY, "Εισφορές" },
    {TR_TOOLTIP_OVERLAY_LEVY, " δηνάρια καταβάλλονται μηνιαίως σε εισφορές." },
    {TR_MAP_EDITOR_OPTIONS, "Ρυθμίσεις σεναρίων" },
    {TR_BUILDING_TAVERN, "Ταβέρνα" },
    {TR_BUILDING_GRAND_GARDEN, "Μέγας κήπος" },
    {TR_BUILDING_TAVERN_DESC_1, "Αυτή η ταβέρνα δεν έχει εργάτες και δεν μπορεί να λειτουργήσει." },
    {TR_BUILDING_TAVERN_DESC_2, "Αυτή η ταβέρνα δεν έχει κρασί και δεν μπορεί να λειτουργήσει." },
    {TR_BUILDING_TAVERN_DESC_3, "Αυτή η ταβέρνα προσφέρει διασκέδαση όσο το κρασί συνεχίζει να ρέει. Μια προσφορά κρέατος ή ψαριών θα αύξανε την ελκυστικότητά της." },
    {TR_BUILDING_TAVERN_DESC_4, "Το άφθονο κρασί και η μυρωδιά του ψημένου φαγητού προσελκύουν ένα ζωηρό πλήθος σε αυτή την ταβέρνα για τζόγο, μουσική και γλέντι." },
    {TR_FIGURE_TYPE_BARKEEP, "Μπάρμαν" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Προμηθευτής ταβέρνας" },
    {TR_OVERLAY_TAVERN, "Ταβέρνα" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Αυτό το σπίτι δεν έχει πρόσβαση σε ταβέρνα ή η ταβέρνα του έχει στερέψει από κρασί." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Δεν έχει περάσει κανένας μπάρμαν εδώ και καιρό. Αυτό το σπίτι θα χάσει σύντομα την πρόσβαση στην ταβέρνα του." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Από αυτό το σπίτι πέρασε ένας μπάρμαν από μια ταβέρνα με κρασί." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Από αυτό το σπίτι πέρασε ένας μπάρμαν από μια ταβέρνα με κρασί και κρέας ή ψάρια." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Από αυτό το σπίτι πέρασε πρόσφατα ένας μπάρμαν από μια ταβέρνα με κρασί." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Από αυτό το σπίτι πέρασε πρόσφατα ένας μπάρμαν από μια ταβέρνα με κρασί και κρέας ή ψάρια. Ας αρχίσει το γλέντι!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Οι κάτοικοι απεχθάνονται το όνομά σας."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Οι κάτοικοι είναι πολύ θυμωμένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Οι κάτοικοι είναι θυμωμένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Οι κάτοικοι είναι πολύ εκνευρισμένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Οι κάτοικοι είναι εκνευρισμένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Οι κάτοικοι είναι ενοχλημένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Οι κάτοικοι αδιαφορούν για σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Οι κάτοικοι είναι ευχαριστημένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Οι κάτοικοι είναι πολύ ευχαριστημένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Οι κάτοικοι είναι εξαιρετικά ευχαριστημένοι μαζί σας." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Οι κάτοικοι σας αγαπούν." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Οι κάτοικοι σας λατρεύουν σαν θεό." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Οι κάτοικοι είναι αναστατωμένοι από την υψηλή φορολογία." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Οι κάτοικοι είναι ενοχλημένοι για τους χαμηλούς μισθούς." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Οι κάτοικοι είναι ενοχλημένοι για την έλλειψη θέσεων εργασίας." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Οι κάτοικοι είναι απελπισμένοι για την κακή στέγασή τους." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Οι κάτοικοι θα εκτιμούσαν περισσότερη ψυχαγωγία." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Οι κάτοικοι θα εκτιμούσαν μια πιο ποικίλη διατροφή." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Οι κάτοικοι θα εκτιμούσαν μεγαλύτερη ελκυστικότητα." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Οι κάτοικοι έχουν αναπτερώσει το ηθικό τους από ένα πρόσφατο γεγονός." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Οι κάτοικοι αποθαρρύνονται λόγω ενός πρόσφατου γεγονότος." },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Αποδοτικότητα:" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "Η απόδοση είναι η αναλογία μεταξύ του ποσού που μπορεί να παράγει το κτίριο σε ένα έτος σε σχέση με αυτό που παρήγαγε το προηγούμενο έτος." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "Αυτό το κτίριο έχει χαμηλή απόδοση. Αυτό μπορεί να οφείλεται στην έλλειψη κοντινού προορισμού για τα τελικά προϊόντα." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "Αυτό το κτίριο έχει χαμηλή απόδοση. Αυτό θα μπορούσε να οφείλεται στην έλλειψη σταθερής προμήθειας πρώτων υλών ή στην έλλειψη κοντινού προορισμού για τα τελικά προϊόντα." },
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Μέσο μηνιαίο αλίευμα:" },
	{TR_BUILDING_WINDOW_INDUSTRY_NEEDED, " χρειάζεται)" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Ταβέρνα" },
	{TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL, "Ταβέρνες" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Αγώνες" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Χορηγήστε Μεγάλους Αγώνες στο Κολοσσαίο σας, με κόστος προσωπικά κεφάλαια και πόρους από την πόλη σας." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Διοργανώστε Αγώνες" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Οι προετοιμασίες για τους Μεγάλους Αγώνες βρίσκονται σε εξέλιξη." },
    {TR_SELECT_GAMES_HEADER, "Αγώνες" },
    {TR_SELECT_GAMES_TEXT, "Οι αγώνες θα διεξάγονται στο Κολοσσαίο και θα κοστίζουν προσωπικά κεφάλαια και πόρους από την πόλη σας." },
    {TR_BUILDING_ARENA, "Αρένα" },
    {TR_BUILDING_HORSE_STATUE, "Άγαλμα ιππέα" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Σιντριβάνι δελφινιού" },
    {TR_BUILDING_HEDGE_DARK, "Καταπράσινος φράχτης" },
    {TR_BUILDING_HEDGE_LIGHT, "Ηλιόλουστος φράχτης" },
    {TR_BUILDING_GARDEN_WALL, "Αυλακωτός τοίχος κήπου" },
    {TR_BUILDING_LEGION_STATUE, "Άγαλμα λεγεωνάριου" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Μαρμάρινη στήλη" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Υπόγειο)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Θεμέλια)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Αψίδα)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Εξώστης)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Οι εργάτες σκάβουν τις υπόγειες σήραγγες και τα μηχανήματα από τα οποία θα ξεπηδούν μεγαλειώδη θεάματα." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Τα τείχη του Κολοσσαίου παίρνουν μορφή καθώς τοποθετούνται σειρές καθισμάτων τόσο για τους απλούς πολίτες όσο και για τους αυτοκράτορες." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Χαριτωμένες αψίδες υψώνονται στον ουρανό, για να κρατήσουν το πανίσχυρο Κολοσσαίο ψηλά." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Καθώς το Κολοσσαίο φτάνει προς τον ουρανό, οι τοίχοι του είναι ντυμένοι με αστραφτερό μάρμαρο και αγάλματα." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Στίβος)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Θεμέλια)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Κερκίδες)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Πρόσοψη)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Αυτός ο τεράστιος χώρος ερευνάται και καθαρίζεται με επιμέλεια για ένα έργο πρωτοφανούς κλίμακας." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Γύρω από τον στίβο κατασκευάζονται διάδρομοι πρόσβασης και υποστηρικτικές κατασκευές." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Οι μασόνοι σμιλεύουν πέτρινα καθίσματα για δεκάδες χιλιάδες άτομα." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Περισσότερο από έναν απλό ιππόδρομο, οι τεχνίτες κατασκευάζουν ένα μνημείο αντάξιο των θεών και των ανθρώπων της Ρώμης." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Για την κατασκευή του μνημείου απαιτούνται υλικά αποθηκευμένα σε μια αποθήκη, εργάτες από ένα εργοτάξιο και αρχιτέκτονες από μια συντεχνία αρχιτεκτόνων." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Η κατασκευή σταμάτησε." },
	{TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Αρένα" },														   
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL, "Αρένες" },
    {TR_BUILDING_INFO_TOURISM, "(ταξιδιώτες)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Το Κολοσσαίο ολοκληρώθηκε! Ας ξεκινήσουν οι αγώνες!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Ο Ιππόδρομος ολοκληρώθηκε. Οι πολίτες σας περιμένουν με ανυπομονησία την εντολή σας για την έναρξη των αγώνων!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Εναρκτήριοι αγώνες" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Οι αγώνες ξεκινούν" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Οι εναρκτήριοι αγώνες για το Κολοσσαίο σας έχουν αρχίσει. Με την εντολή σας, αυτό το μνημείο θα καθαγιαστεί με το αίμα των γενναίων!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Η πόλη σας αδειάζει καθώς πλήθος κόσμου συρρέει στον Ιππόδρομο για τις εναρκτήριες αρματοδρομίες. Εκκωφαντικές ζητωκραυγές γεμίζουν τον αέρα καθώς οι πύλες ανοίγουν!" },
    {TR_WINDOW_GAMES_OPTION_1, "Διεξαγωγή ναυτικών αγώνων" },
    {TR_WINDOW_GAMES_OPTION_2, "Διεξαγωγή αγώνων ζώων" },
    {TR_WINDOW_GAMES_OPTION_3, "Διεξαγωγή Καλένδων του Ιανουαρίου" },
    {TR_WINDOW_GAMES_OPTION_4, "Διεξαγωγή Ολυμπιακών Αγώνων" },
    {TR_WINDOW_GAMES_OPTION_5, "Διεξαγωγή Ρωμαϊκών Αγώνων" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Το Κολοσσαίο θα πλημμυρίσει για να αναπαραστήσει μια μεγάλη ναυμαχία. Η ταχύτητα κίνησης των στρατευμάτων σας και η δύναμή τους σε μακρινές μάχες θα αυξηθούν για τον επόμενο χρόνο." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Το Κολοσσαίο θα φιλοξενεί φρικιαστικά κυνήγια ζώων και εκτελέσεις από άγρια θηρία, ενθουσιάζοντας τις πληβείες μάζες. Το έγκλημα, οι ταραχές και οι εξεγέρσεις θα κατασταλούν για τον επόμενο χρόνο. Οι θηριοδαμαστές θα βοηθήσουν στην υπεράσπιση της πόλης από την επόμενη εισβολή." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Το Κολοσσαίο θα φιλοξενήσει αγώνες προς τιμήν των θεών την πρώτη ημέρα του επόμενου έτους, ζητώντας τύχη και ευημερία. Οι εμπορικές ποσοστώσεις θα διπλασιαστούν το επόμενο έτος." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "Ο Ιππόδρομος θα φιλοξενήσει τους Ολυμπιακούς Αγώνες. Η πόλη σας θα φιλοξενήσει πλήθος επισκεπτών, και αν οι αθλητές σας τιμήσουν καλά την πόλη σας, θα κερδίσετε μια μόνιμη αύξηση του τουρισμού και της εύνοιας." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Το Κολοσσαίο θα φιλοξενήσει τους Ρωμαϊκούς Αγώνες, με τους ανθρώπους να ταξιδεύουν στην πόλη σας από όλη την αυτοκρατορία για να διαγωνιστούν. Ένα τόσο μεγάλο θέαμα θα κερδίσει σίγουρα την εύνοια τόσο του αυτοκράτορα όσο και του απλού λαού για το επόμενο έτος." },
    {TR_WINDOW_GAMES_COST, "Κόστος:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(προσωπικά κεφάλαια)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Ελλιπή προσωπικά κεφάλαια." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Δεν υπάρχουν αρκετοί αποθηκευμένοι πόροι." },
    {TR_WINDOW_GAMES_NO_VENUE, "Ο χώρος δεν έχει κατασκευαστεί ή δεν έχει εργαζόμενους." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Κατασκευή)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Κτίστες και μηχανικοί κατασκευάζουν αυτό το ιερό οικοδόμημα από αστραφτερό μάρμαρο." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Για την κατασκευή αυτού του ναού θα χρειαστούν υλικά αποθηκευμένα σε μια αποθήκη, εργάτες από ένα εργοτάξιο και αρχιτέκτονες από μια συντεχνία αρχιτεκτόνων." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Το νερό από τις δεξαμενές της πόλης σας γεμίζει σιγά σιγά το Κολοσσαίο. Οι ξυλουργοί αρχίζουν να συναρμολογούν αληθοφανείς μινιατούρες πολεμικών πλοίων, καθώς οι μονομάχοι εκπαιδεύονται στη μάχη στο νερό. Σύντομα θα ξεκινήσουν οι ναυτικοί αγώνες!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Το Κολοσσαίο έχει μετατραπεί σε τεχνητή λίμνη, καθώς οι μονομάχοι αναπαριστούν μεγάλες ρωμαϊκές νίκες στη θάλασσα. Αίμα και νερό αναμειγνύονται καθώς το πλήθος βροντοφωνάζει επιδοκιμαστικά. Οι Ναυμαχίες - οι Ναυτικοί Αγώνες - έχουν αρχίσει!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Αρχίζει μια μακρά διαδικασία καθαρισμού του Κολοσσαίου, το οποίο αποξηραίνεται και προετοιμάζεται για κανονική χρήση. Οι άνθρωποί σας θα μιλούν για αυτό το μεγάλο υδάτινο θέαμα για τα επόμενα χρόνια." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Παράξενο φορτίο αρχίζει να εμφανίζεται στην πόλη σας, καθώς έμποροι από τα πέρατα της γης παραδίδουν τρομακτικά θηρία στα κλουβιά κάτω από το Κολοσσαίο. Σύντομα ένα φρικιαστικό θέαμα θα ενθουσιάσει τους κατοίκους σας." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Καταδικασμένοι εγκληματίες και μονομάχοι που αναζητούν την απόλυτη δόξα αντιμετωπίζουν το θάνατο με τη μορφή δοντιών και νυχιών. Με ένα σάλπισμα από σάλπιγγες, οι Αγώνες Ζώων έχουν αρχίσει!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Τα τελευταία άγρια θηρία κείτονται σφαγμένα στην άμμο του Κολοσσαίου, το αίμα τους αναμειγνύεται με αυτό των καταδικασμένων. Οι Αγώνες Ζώων έφτασαν στο τέλος τους." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Θα υποδεχτούμε το νέο έτος με ένδοξους αγώνες προς τιμήν των θεών. Σε αντάλλαγμα, ζητάμε τύχη, ευημερία και ευλογίες σε θέματα εμπορίου." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Οι Αγώνες ξεκινούν με την ανατολή του ηλίου στις Καλένδες του Ιανούριου. Οι ιερείς κάνουν θυσίες ζώων καθώς οι μονομάχοι ζώνουν τα όπλα τους για να πεθάνουν αναζητώντας την εύνοια των θεών."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Οι ωρολογιακές αναφορές δείχνουν ότι οι θεοί ήταν ευχαριστημένοι από τους μεγάλους αγώνες μας, τις θυσίες και την ευλάβεια που τους επιδείξαμε. Μπορούμε να περιμένουμε μια πολύ κερδοφόρα χρονιά!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Όλα τα βλέμματα θα είναι στραμμένα στην πόλη σας, καθώς οι Ολυμπιακοί Αγώνες φέρνουν ταξιδιώτες, διαγωνιζόμενους και Ρωμαίους αξιωματούχους από όλο τον κόσμο. Θα χρειαστεί τουλάχιστον ένας ολόκληρος χρόνος για να δείτε να γίνεται κάθε δυνατή προετοιμασία."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Επιτέλους, έφτασε η μέρα. Η ιερή φλόγα ανάβει και οι δρόμοι της πόλης σας είναι έρημοι, καθώς οι πολίτες μαζεύονται στον μεγάλο ιππόδρομο. Ας αρχίσουν οι αγώνες!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Η ιερή φλόγα σβήνει, και οι ταξιδιώτες και οι πολίτες επιστρέφουν στα σπίτια τους με κουρασμένη αγαλλίαση. Η αιώνια δόξα είναι δική σας για την επιτυχή φιλοξενία αυτής της αρχαίας και ιερής γιορτής της θνητής δύναμης και τιμής." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Με την ανακοίνωση των Ρωμαϊκών Αγώνων, άνθρωποι από τα πιο απομακρυσμένα μέρη συρρέουν στην πόλη σας, πολλοί ελπίζοντας να κερδίσουν τους επερχόμενους διαγωνισμούς. Θα χρειαστεί τουλάχιστον ένας ολόκληρος χρόνος για να δείτε να γίνεται κάθε δυνατή προετοιμασία." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Αρχίζει η επίσημη πομπή και μαζί της οι Ρωμαϊκοί Αγώνες. Είθε ο ίδιος ο Δίας να επιλέξει τους πρωταθλητές των αγώνων δρόμου, των αγώνων πάλης και άλλων διαγωνισμών αντοχής και ευκινησίας. Το Κολοσσαίο γεμίζει ασφυκτικά από πολίτες που περιμένουν τους αγώνες και τα καθιερωμένα δώρα από σιτάρι και ελαιόλαδο. Ας αρχίσουν οι αγώνες!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Η τελευταία ημέρα των Ρωμαϊκών Αγώνων φτάνει στο τέλος της. Γεμάτοι ενθουσιασμό και με γεμάτες κοιλιές, κάθε πολίτης έχει γευτεί το μεγαλείο της ρωμαϊκής ζωής. Δόξα στους θεούς, δόξα στους νικητές και δόξα στον κυβερνήτη!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Οι Μεγάλοι Αγώνες"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Μήνες μέχρι να μπορούν να διεξαχθούν νέοι Αγώνες: " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Μήνες μέχρι τους Ναυτικούς Αγώνες:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Οι Ναυτικοί Αγώνες βρίσκονται σε εξέλιξη. Ο παφλασμός του νερού, το τρίξιμο των ξύλων και οι κραυγές μάχης των μονομάχων συμπληρώνουν τη βοή του πλήθους." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Μήνες μέχρι τους Αγώνες Ζώων:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Οι Αγώνες Ζώων βρίσκονται σε εξέλιξη. Ο όχλος ουρλιάζει βραχνά καθώς τα άγρια θηρία καταδιώκουν το ανθρώπινο θήραμά τους." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Μήνες μέχρι τους Αγώνες Καλένδων:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Οι Αγώνες των Καλένδων βρίσκονται σε εξέλιξη. Η μυρωδιά των θυσιών ζώων και του θυμιάματος ξεπερνά ακόμη και το καυστικό αίμα και τον ιδρώτα της αρένας." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Μήνες μέχρι τους Ολυμπιακούς Αγώνες:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Οι Ολυμπιακοί Αγώνες βρίσκονται σε εξέλιξη. Η ιερή φωτιά καίει μέρα και νύχτα καθώς οι αθλητές αγωνίζονται για την αθάνατη δόξα." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Μήνες μέχρι τους Ρωμαϊκούς Αγώνες:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Οι Ρωμαϊκοί Αγώνες βρίσκονται σε εξέλιξη. Κάθε συμμετέχων χύνει αίμα, ιδρώτα και δάκρυα για να αποδείξει ότι είναι ο καλύτερος Ρωμαίος." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Οι Μεγαλοπρεπείς αγώνες θα συνεχιστούν για άλλες" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Πρόσφατα πραγματοποιήθηκαν σπουδαίοι αγώνες." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Οι Μεγαλοπρεπείς Αγώνες είναι σε εξέλιξη! Η πόλη σας σφύζει από ταξιδιώτες και γλέντι." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Η αρένα είναι κλειστή. Τα πουλιά φτιάχνουν φωλιές στις άδειες θέσεις." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Αυτή η αρένα δεν φιλοξενεί ούτε λιοντάρια ούτε μονομάχους και παρέχει ελάχιστη ψυχαγωγία." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Αυτή η αρένα φιλοξενεί μονομάχους και κυνήγια ζώων, προς τέρψη των ντόπιων." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Οι τακτικές παραστάσεις μονομάχων διασκεδάζουν τον όχλο, αλλά τα λιοντάρια θα απογείωναν το θέαμα." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Τα πεινασμένα θηρία περιφέρονται στην αρένα αναζητώντας θήραμα, αλλά η έλλειψη εκπαιδευμένων μονομάχων κάνει τις παραστάσεις σύντομες." },
    {TR_OVERLAY_ARENA_COL, "Αρένα" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Αυτή η κατοικία δεν έχει πρόσβαση σε αρένα ή στο Κολοσσαίο." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Αυτή η κατοικία έχει πρόσβαση σε μια αρένα με μία παράσταση." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Αυτή η κατοικία έχει πρόσβαση σε μια αρένα με δύο παραστάσεις." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Αυτή η κατοικία έχει πρόσβαση στο Κολοσσαίο, με μία παράσταση." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Αυτή η κατοικία έχει πρόσβαση στο Κολοσσαίο, με δύο παραστάσεις." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Οι εργαζόμενοι απεργούν" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Καμία πρόσβαση σε νερό" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Περιμένοντας τον μεταφορέα" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Δεν υπάρχουν πόροι" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Κτίριο ναρκοθετημένο" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "Το κτίριο έχει πανούκλα"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Πάρα πολλά κτίρια αυτού του τύπου - οι ταξιδιώτες αποφεύγουν αυτό το μέρος." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Έσοδα από ταξιδιώτες φέτος:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Ο Εμπορικός σας Σύμβουλος διέταξε τη διακοπή της παραγωγής ψαριών."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Φόρος/τόκος"},
    {TR_WINDOW_ADVISOR_TOURISM, "Διάφορα"},
    {TR_WINDOW_FIGURE_TOURIST, "Αυτός ο ταξιδιώτης έχει ξοδέψει: "},
    {TR_FIGURE_TYPE_TOURIST,  "Ταξιδιώτης"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Μη συμβατή έκδοση αποθηκευμένου παιχνιδιού" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Το savegame που προσπαθείτε να φορτώσετε είναι για μια πιο πρόσφατη έκδοση του Augustus.\nΠαρακαλούμε ενημερώστε τον Augustus στην πιο πρόσφατη έκδοση." },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Αδυναμία αποθήκευσης του παιχνιδιού" },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "Δεν ήταν δυνατή η αποθήκευση του παιχνιδιού.\nΜπορεί να οφείλεται στο γεγονός ότι ο φάκελος όπου το Caesar 3 διατηρεί τα αποθηκευμένα παιχνίδια απαιτεί πρόσβαση διαχειριστή.\nΠαρακαλούμε είτε αλλάξτε το φάκελο του Caesar 3 σε ένα μέρος που δεν απαιτεί πρόσβαση διαχειριστή είτε εκτελέστε το Augustus ως διαχειριστής (δεν συνιστάται)." },
    {TR_BUILDING_COLONNADE, "Κολώνα" },
    {TR_BUILDING_LARARIUM, "Λαράριο" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Αυτό το μικρό ιερό είναι αφιερωμένο στους Λάρητες - τα προγονικά πνεύματα του ρωμαϊκού λαού. Εδώ μπορούν να γίνουν μικρές θυσίες και προσευχές."},
    {TR_BUILDING_WATCHTOWER, "Παρατηρητήριο"},
    {TR_BUILDING_WATCHTOWER_DESC, "Οι τοξότες στις επάλξεις αυτού του πύργου επαγρυπνούν για τους εισβολείς, ενώ οι φρουροί περιπολούν στους δρόμους από κάτω." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Αυτός ο πύργος χρειάζεται έναν φρουρό από τους στρατώνες για να μπορέσει να προστατεύσει την πόλη μας."},
    {TR_BUILDING_NYMPHAEUM, "Νυμφαίον"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Αυτός ο μεγάλος ναός είναι αφιερωμένος στις νύμφες του νερού - μικρές θεότητες των πηγών, των ποταμών και των θαλασσών. Υπόσχεται ομορφιά και αφθονία στη γύρω γη και θεϊκή εύνοια στην πόλη." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Μικρό Μαυσωλείο"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Αυτό το κτίριο είναι ο τόπος τελευταίας ανάπαυσης των περασμένων γενεών των περήφανων οικογενειών της πόλης σας και ο φθόνος πολλών από τους ζωντανούς." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Μεγάλο Μαυσωλείο"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Οι στιλβωμένοι μαρμάρινοι τοίχοι και τα αγάλματα αυτού του υπέροχου οικοδομήματος αντανακλούν τις μεγάλες πράξεις των πατρικίων που κέρδισαν το προνόμιο να αναπαύονται εδώ." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1, "Θόλος" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2, "Πρόσοψη" },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT, "Οι κτίστες τοποθετούν στρώσεις από ακριβώς λαξευμένες πέτρες για να σχηματίσουν τον κεντρικό θόλο αυτού του μαυσωλείου." },
    {TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT, "Ειδικευμένοι τεχνίτες προετοιμάζουν την πρόσοψη αυτού του μαυσωλείου, σμιλεύοντας αστραφτερά μαρμάρινα αγάλματα για να μνημονεύσουν εκείνους που θα αναπαυθούν εδώ." },
    {TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC, "Για την κατασκευή αυτού του μαυσωλείου θα χρειαστούν υλικά αποθηκευμένα σε μια αποθήκη, εργάτες από ένα στρατόπεδο εργασίας και αρχιτέκτονες από μια συντεχνία αρχιτεκτόνων." },
	{TR_FIGURE_TYPE_WATCHMAN, "Φύλακας" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Αυτός ο ναός θα συλλέγει τρόφιμα για το σταθμό ανεφοδιασμού σας, μόλις αυτός κατασκευαστεί." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Εναλλαγή πρόσβασης των νομαρχών και των μηχανικών" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Εναλλαγή πρόσβασης ιερέων" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Εναλλαγή πρόσβασης σε προμηθευτές της αγοράς" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Εναλλαγή πρόσβασης διασκεδαστών" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Εναλλαγή πρόσβασης εκπαιδευτικών" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Εναλλαγή πρόσβασης υγειονομικών" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Εναλλαγή πρόσβασης φοροεισπράκτορα" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Εναλλαγή της πρόσβασης των αιτούντων εργασία" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Εναλλαγή πρόσβασης ιεραποστόλων" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Εναλλαγή πρόσβασης φυλάκων" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Το πλήκτρο συντόμευσης χρησιμοποιήθηκε ήδη"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Αυτός ο συνδυασμός πλήκτρων έχει ήδη εκχωρηθεί στην ακόλουθη ενέργεια:"},
    {TR_BUILDING_GARDEN_PATH, "Μονοπάτι κήπου" },
    {TR_BUTTON_GO_TO_SITE, "Πηγαίνετε στον τόπο" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Διακοπή κατασκευής" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Συνέχιση κατασκευής" },
    {TR_RESOURCE_FISH, "Ψάρια" },
	{TR_RESOURCE_GOLD, "Χρυσός"},
    {TR_RESOURCE_STONE, "Πέτρα"},
    {TR_RESOURCE_SAND, "Άμμος"},
    {TR_RESOURCE_BRICKS, "Τούβλα"},
    {TR_RESOURCE_CONCRETE, "Σκυρόδεμα"},
    {TR_WARNING_VARIANT_TOGGLE, "Πατήστε το πλήκτρο περιστροφής για να γυρίσετε τις εκδοχές αυτού του κτιρίου."},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Το σχολείο αυτό είναι λειτουργικό. Η τοπική ανάπτυξη επέτρεψε στους πολίτες σας να επεκτείνουν το κτίριο, παρέχοντας χώρο για περισσότερα παιδιά."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Το θέατρο αυτό είναι λειτουργικό. Η τοπική ανάπτυξη επέτρεψε στους πολίτες σας να επεκτείνουν το κτίριο, παρέχοντας περισσότερες θέσεις." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Αυτή η βιβλιοθήκη είναι λειτουργική. Η τοπική ανάπτυξη επέτρεψε στους πολίτες σας να επεκτείνουν το κτίριο, παρέχοντας επιπλέον πάπυρους και γωνιές ανάγνωσης." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Αυτό το μνημειακό εργοτάξιο δεν έχει οδική πρόσβαση και δεν μπορεί να παραλάβει υλικά. Συνδέστε έναν δρόμο σε ένα από τα μεσαία πλακίδια."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Λόγω του πεσμένου κλίματος στην πόλη, οι πληβείοι αυτού του εργαστηρίου κήρυξαν αποστασία και αρνούνται να εργαστούν!" },
    {TR_CITY_WARNING_SECESSION, "Οι πληβείοι αρνούνται να εργαστούν!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Μια αποθήκη λεηλατήθηκε!" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Μια σιταποθήκη λεηλατήθηκε!" },
    {TR_CITY_WARNING_THEFT, "Κλάπηκαν κονδύλια από ένα φόρουμ ή την σύγκλητο!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Λεηλασίες στην πόλη!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Μια αποθήκη ή σιταποθήκη λεηλατήθηκε από εξαγριωμένους πολίτες και κλάπηκαν αγαθά! Το πεσμένο ηθικό καθιστά αυτά τα περιστατικά πιο πιθανά."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Επιδρομές" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Επιδρομή σε εξέλιξη" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Καμία επιδρομή" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Επίκειται επιδρομή" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Πλησιάζουν εχθροί" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Μακρινοί εχθροί" },
    {TR_SIDEBAR_EXTRA_GODS, "Θεοί" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Προβολή όλων" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Μικρή δύναμη"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Μέση δύναμη"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Μεγάλη δύναμη"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Αποστολή αιτήματος"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Αποθήκευση"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Σταματήστε την αποθήκευση"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Μετάβαση στα γραφήματα πληθυσμού" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Επισκεφθείτε τον Σύμβουλο Στέγασης" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Αυτό το μνημείο διαθέτει όλα τα υλικά που απαιτούνται για αυτή τη φάση. Οι εργάτες περιμένουν έναν εξειδικευμένο αρχιτέκτονα από μια συντεχνία αρχιτεκτόνων για να επιβλέψει την περαιτέρω κατασκευή." },
    {TR_RETURN_ALL_TO_FORT, "Επιστροφή όλων" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Πληροφορίες για αγώνες" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Αυτό το άγαλμα θα φαινόταν ακόμη πιο εντυπωσιακό με το σιντριβάνι του να λειτουργεί. Εξασφαλίστε του πρόσβαση στο νερό." },
    {TR_OPTION_MENU_APPLY, "Εφαρμογή" },
    {TR_OPTION_MENU_COST, "Αυτό θα κοστίσει" },
    {TR_FIGURE_TYPE_LOOTER, "Λεηλάτης" },
    {TR_FIGURE_TYPE_ROBBER, "Ληστής" },
    {TR_OVERLAY_SENTIMENT, "Αίσθημα" },
    {TR_OVERLAY_EFFICIENCY, "Αποδοτικότητα" },
	{TR_OVERLAY_STORAGES, "Αποθήκες" },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_0, "Κανείς δεν μπορεί να θυμηθεί την τελευταία φορά που αυτό το κτίριο παρήγαγε κάτι." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_1, "Αυτό το κτίριο δεν παράγει σχεδόν τίποτα." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_2, "Πολύ περισσότερα θα μπορούσαν να παραχθούν εδώ αν η αποδοτικότητά του ήταν υψηλότερη." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_3, "Οι εργασίες συχνά σταματούν σε αυτό το κτίριο και η αποδοτικότητά του είναι χαμηλή." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_4, "Αυτό το κτίριο είναι παραγωγικό και έχει ελάχιστο χρόνο διακοπής λειτουργίας." },
    {TR_TOOLTIP_OVERLAY_EFFICIENCY_5, "Αυτό το κτίριο παράγει στο μέγιστο βαθμό απόδοσης." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Κανείς" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Όλοι" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Επιλογή πολιτικής χερσαίου εμπορίου"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Ένα Καραβανσεράι απαιτείται για να ορίσει μια πολιτική χερσαίου εμπορίου"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Επιλογή πολιτικής θαλάσσιου εμπορίου"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Ένας Φάρος απαιτείται για τον καθορισμό μιας πολιτικής θαλάσσιου εμπορίου"},
    {TR_TOOLTIP_HOLD_GAME, "Διεξαγωγή των αγώνων"},
    {TR_TOOLTIP_NO_GAME, "Ακύρωση των αγώνων"},
    {TR_WARNING_NEARBY_WOLF, "Δεν μπορείτε να χτίσετε όταν βρίσκονται κοντά λύκοι" },
    {TR_MARKET_TRADING, "Εμπορεύεται"},
    {TR_MARKET_NOT_TRADING, "Δεν εμπορεύεται"},
    {TR_TAVERN_FETCHING, "Λαμβάνει"},
    {TR_TAVERN_NOT_FETCHING, "Δεν λαμβάνει"},
    {TR_TEMPLE_DISTRIBUTING, "Διανέμει"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Δεν διανέμει"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Οι άθλιες κατοικίες και οι παραγκουπόλεις εμποδίζουν τη μετανάστευση"},
    {TR_CITY_MESSAGE_SQUALOR, "Οι άθλιες κατοικίες και οι παραγκουπόλεις αποτελούν πρόβλημα"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Φύλακας φάρου" },
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Ο χώρος δεν έχει πρόσβαση σε δεξαμενή." },
    {TR_HOTKEY_COPY_SETTINGS, "Αντιγραφή ρυθμίσεων κτιρίου" },
    {TR_HOTKEY_PASTE_SETTINGS, "Επικόλληση ρυθμίσεων κτιρίου" },
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Ναρκοθέτηση/Ενεργοποίηση κτιρίου" },
    {TR_HOTKEY_SPECIAL_ORDERS, "Εμφάνιση ειδικών εντολών κτιρίου" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Λαράρια στην πόλη" },
    {TR_WINDOW_RACE_YOUR_BET, "Το στοίχημά σας"},
    {TR_WINDOW_RACE_BET_BUTTON, "Στοιχηματίστε σε ένα άλογο"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Αγώνας σε εξέλιξη..."},
    {TR_WINDOW_RACE_BET_TITLE, "Τοποθετήστε ένα στοίχημα σε ένα άλογο"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Ποσό"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Ποντάρετε ένα ποσό από τα προσωπικά σας κεφάλαια στην ομάδα αρμάτων της επιλογής σας και διπλασιάστε το ποντάρισμά σας αν το άλογό σας κερδίσει. Τα κέρδη σας μάλιστα θα τετραπλασιαστούν κατά τη διάρκεια των αγώνων του Κολοσσαίου!"},
    {TR_WARNING_BET_VICTORY, "Το άλογό σας κέρδισε την κούρσα στον ιππόδρομο της πόλης σας"},
    {TR_WARNING_BET_DEFEAT, "Το άλογό σας έχασε την κούρσα στον ιππόδρομο της πόλης σας"},
    {TR_PERSONAL_SAVINGS, "Αποταμιεύσεις :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Στοιχηματίστε στο μπλε άλογο"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Στοιχηματίστε στο κόκκινο άλογο"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Στοιχηματίστε στο λευκό άλογο"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Στοιχηματίστε στο πράσινο άλογο"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Χωρίς ένα πλήρες προσωπικό ιερέων και συνοδών, ο ναός αυτός δεν μπορεί να εκτελέσει όλες τις ιερές τελετές και εορτασμούς. Μέχρι να αλλάξει αυτό, δεν θα πρέπει να περιμένετε θεϊκή εύνοια. "},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Το Κολοσσαίο είναι υποστελεχωμένο. Χρειάζονται περισσότεροι εργάτες για να διασφαλιστεί ότι όλοι οι πολίτες σας θα απολαύσουν τους αγώνες."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Ο Ιππόδρομος είναι υποστελεχωμένος. Χρειάζονται περισσότεροι εργαζόμενοι για να παρέχουν θεαματική ψυχαγωγία σε όλους τους πολίτες σας."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Ο Φάρος είναι υποστελεχωμένος και δεν μπορεί να κρατήσει τη φωτιά σε λειτουργία. Τα πλοία δυσκολεύονται να βρουν το δρόμο προς τις αποβάθρες της πόλης σας."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Το Καραβανσεράι είναι υποστελεχωμένο και δεν μπορεί να υποστηρίξει όλα τα εισερχόμενα καραβάνια."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Στεγασμένος τοίχος κήπου"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Πύλη κήπου"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Αυτή η μικρή πύλη ελέγχει την κίνηση των ανθρώπων μέσα και έξω από τα πιο απομονωμένα σημεία της πόλης σας."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Ο μεταφορέας καροτσιού πηγαίνει να πάρει εμπορεύματα από μια άλλη αποθήκη."},
    {TR_BUILDING_PALISADE, "Ξύλινο Τείχος" },
    {TR_BUILDING_PALISADE_DESC, "Αυτή η χωμάτινη όχθη, που ολοκληρώνεται με ένα ψηλό τείχος από ακονισμένους ξύλινους πασσάλους, θα κρατήσει την πόλη σας ασφαλή από εισβολείς και εχθρικά ζώα."},
    {TR_OVERLAY_MOTHBALL, "Ναρκωμένο"},
    {TR_OVERLAY_ENEMY, "Εχθροί"},
    {TR_BUILDING_TAVERN_DESC_5, "Οι πολίτες λατρεύουν να επισκέπτονται αυτό το κατάστημα στον ελεύθερο χρόνο τους για να κοινωνικοποιηθούν με καλό φαγητό και κρασί." },
    {TR_OVERLAY_WAREHOUSES, "Αποθήκες" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Η μπλε ομάδα - οι ευνοούμενοι του Ποσειδώνα. Πρόκειται για τους πιο υποσχόμενους νέους αρματολούς της Ρώμης που θέλουν να αποδείξουν την αξία τους." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Η κόκκινη ομάδα - γνωστή ως η ομάδα του πιο επιτυχημένου αρματολού στην ιστορία της Ρώμης - πρώην κωπηλάτη και σωτήρα ενός Ρωμαίου ύπατου." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Η Λευκή ομάδα - ιδρύθηκε από πρώην μονομάχους. Έχουν τη μάχη στο αίμα τους και ακόμη και ως ελεύθεροι άνθρωποι ζουν για την πρόκληση." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Η Πράσινη ομάδα - απόγονοι των ιππέων της \"Σέλερης\" από την εποχή του Βασιλείου της Ρώμης. Εξακολουθούν να ισχυρίζονται ότι είναι οι καλύτεροι των καλύτερων." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Συνέχιση παράδοσης πόρων"},
    {TR_CONFIG_DIGIT_SEPARATOR, "Ξεχωριστά ψηφία"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Χωρίς εργάτες" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "Ο αμαξάς είναι καθ' οδόν για να πάρει τρόφιμα από μια άλλη σιταποθήκη."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "Ο αμαξάς επιστρέφει με μια παράδοση." },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Ετήσια αυτόματη αποθήκευση OFF"},
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Ετήσια αυτόματη αποθήκευση ON" },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "Η πανούκλα ήρθε εδώ με εμπορικό πλοίο. Αυτή η αποβάθρα βρίσκεται σε καραντίνα ενώ ένας γιατρός ή χειρουργός απολυμαίνει την περιοχή."},
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "Η πανούκλα μεταφέρθηκε εδώ από έναν μολυσμένο εργάτη. Αυτή η σιταποθήκη βρίσκεται σε καραντίνα ενώ ένας γιατρός ή χειρουργός απολυμαίνει την περιοχή."},
    {TR_BUILDING_GRANARY_NO_FOOD, "Δεν υπάρχουν αποθηκευμένα τρόφιμα σε αυτή τη σιταποθήκη."},
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "Η πανούκλα μεταφέρθηκε εδώ από έναν μολυσμένο εργάτη. Αυτή η αποθήκη βρίσκεται σε καραντίνα ενώ ένας γιατρός ή χειρουργός απολυμαίνει την περιοχή."},
    {TR_BUILDING_WAREHOUSE_NO_GOODS, "Δεν υπάρχουν αποθηκευμένα εμπορεύματα σε αυτή την αποθήκη."},
    {TR_BUILDING_HOUSE_DISEASE_DESC, "Η πανούκλα χτύπησε! Χωρίς επαρκή υγειονομική περίθαλψη, οι κάτοικοι που κατοικούν εδώ πέθαναν. Αυτό το σπίτι βρίσκεται σε καραντίνα, ενώ ένας γιατρός ή χειρουργός απολυμαίνει την περιοχή."},
    {TR_BUILDING_FUMIGATION_DESC, "Το κτίριο καθαρίζεται από ασθένειες. Η απολύμανση θα διαρκέσει λίγες ημέρες."},
    {TR_OVERLAY_SICKNESS, "Ασθένειες"},
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Οι ασθένειες είναι σπάνιο φαινόμενο στην πόλη. Το υψηλό επίπεδο υγειονομικής περίθαλψης που παρέχεται στη συντριπτική πλειονότητα των κατοίκων αποτρέπει αποτελεσματικά την εξάπλωση των επιδημιών εδώ."},
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Ορισμένες μολυσματικές ασθένειες εμφανίστηκαν σε περιοχές της πόλης με έλλειψη υγιεινής, αλλά η κατάσταση είναι υπό έλεγχο. Ένα αρκετά υψηλό επίπεδο υγειονομικής περίθαλψης θα μετριάσει τις επιπτώσεις των επιδημιών στην πόλη."},
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Οι μολυσματικές ασθένειες εξαπλώνονται σε περιοχές της πόλης με χαμηλό επίπεδο υγιεινής. Εάν η κατάσταση δεν διορθωθεί σύντομα, ορισμένα κτίρια ενδέχεται να τεθούν σε καραντίνα. Η μεγαλύτερη πρόσβαση στην υγειονομική περίθαλψη θα αποτρέψει αποτελεσματικά το ξέσπασμα επιδημιών."},
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "Η πανούκλα έχει έρθει σε κάποιες ανθυγιεινές περιοχές της πόλης! Οι πολίτες αρρωσταίνουν και τα κτίρια έχουν τεθεί σε καραντίνα ή έχουν καεί για να αποτραπεί η περαιτέρω εξάπλωση της ασθένειας. Διαθέσιμοι γιατροί και χειρουργοί έχουν επιστρατευτεί για την απολύμανση των προσβεβλημένων περιοχών. Πρέπει να ληφθούν μέτρα!"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "Καμία ασθένεια"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Πολύ λίγες ασθένειες"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Μερικές μολυσματικές ασθένειες"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Πολλές μολυσματικές ασθένειες που εξαπλώνονται"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "Η πανούκλα στοιχειώνει αυτή τη γη"},
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "Πανούκλα στην πόλη"},
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "Η πανούκλα έχει ξεσπάσει στην πόλη! Ένα κτίριο έχει τεθεί σε καραντίνα και έχουν ζητηθεί γιατροί ή χειρουργοί για να το απολυμάνουν."},
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Παράδοση του αιτήματος στη Ρώμη"},
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Οι ρυθμίσεις αντιγράφηκαν" },
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Δεν μπορείτε να αντιγράψετε από αυτό το κτίριο" },
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Οι ρυθμίσεις επικολλήθηκαν" },
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Δεν μπορεί να επικολληθεί" },
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "Το κτίριο είναι παροπλισμένο" },
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "Το κτίριο είναι τώρα ενεργό" },
	{TR_CITY_WARNING_GOLD_NEEDED, "Αυτό το κτίριο χρειάζεται χρυσό"},
    {TR_CITY_WARNING_BUILD_GOLD_MINE, "Κατασκευάστε ένα χρυσωρυχείο"},
    {TR_CITY_WARNING_SAND_NEEDED, "Αυτό το κτίριο χρειάζεται άμμο"},
    {TR_CITY_WARNING_BUILD_SAND_PIT, "Φτιάξτε ένα λάκκο με άμμο"},
    {TR_CITY_WARNING_STONE_NEEDED, "Αυτό το κτίριο χρειάζεται πέτρα"},
    {TR_CITY_WARNING_BUILD_STONE_QUARRY, "Κατασκευάστε ένα λατομείο πέτρας"},
    {TR_CITY_WARNING_SENATE_NEEDED, "Αυτό το κτίριο χρειάζεται μια λειτουργούσα σύγκλητο"},
    {TR_CITY_WARNING_BUILD_SENATE, "Κατασκευάστε μια σύγκλητο"},
    {TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY, "Επικάλυψη αποδοτικότητας"},
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Επικάλυψη αποθεμάτων τροφίμων"},
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Επικάλυψη ψυχαγωγίας" },
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Επικάλυψη εκπαίδευσης" },
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Επικάλυψη σχολείων" },
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Επικάλυψη βιβλιοθηκών" },
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Επικάλυψη ακαδημιών" },
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Επικάλυψη κουρείων" },
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Επικάλυψη λουτρών" },
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Επικάλυψη κλινικών" },
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Επικάλυψη νοσοκομείων" },
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Επικάλυψη ασθενειών" },
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Επικάλυψη φορολογικών εσόδων" },
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Επικάλυψη ελκυστικότητας" },
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Επικάλυψη συναισθήματος" },
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "Επικάλυψη παροπλισμένων" },
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Επικάλυψη θρησκείας" },
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Επικάλυψη δρόμων" },
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Επικάλυψη εισφορών" },
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Περιστροφή χάρτη προς Βορρά" },
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Αγρόκτημα σιταριού" },
    {TR_HOTKEY_SHOW_MESSAGES, "Εμφάνιση μηνυμάτων"},
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Εμφάνιση χάρτη αυτοκρατορίας"},
    {TR_TOGGLE_GRID, "Εναλλαγή πλέγματος"},
    {TR_WARNING_SCREENSHOT_SAVED, "Στιγμιότυπο αποθηκεύτηκε: "},
    {TR_OUT_OF_MONEY, "Χωρίς χρήματα"},
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "Οργή του αυτοκράτορα" },
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "Έχετε εκπέσει από τη χάρη του Καίσαρα και γι' αυτό διέταξε τη σύλληψή σας. Αν δεν αποκαταστήσετε την εύνοια του αυτοκράτορα, οι επίλεκτοι λεγεωνάριοι του θα εισβάλουν σύντομα στην πόλη σας!" },
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "Αυτή η ακαδημία είναι λειτουργική. Η τοπική ανάπτυξη επέτρεψε στους πολίτες σας να επεκτείνουν το κτίριο, παρέχοντας περισσότερες αίθουσες για ομιλίες και έρευνα."},
    {TR_BUILDING_PALISADE_GATE, "Πύλη ξύλινου τείχους"},
    {TR_BUILDING_PALISADE_GATE_DESC, "Αυτή η στενή ξύλινη πύλη ελέγχει τη μετακίνηση των ανθρώπων μέσα και έξω από την άμυνα της πόλης σας."},
    {TR_SAVE_DIALOG_INVALID_FILE, "Άκυρο αρχείο"},
	{TR_SAVE_DIALOG_INVALID_FILE_DESC, "Η αποθήκευση που προσπαθείτε να φορτώσετε είναι άκυρη.\n\nΗ αποθήκευση ενδέχεται να έχει καταστραφεί λόγω σφάλματος.\n\nΕάν είστε σίγουροι ότι πρόκειται για έγκυρη αποθήκευση, αναφέρετε το σφάλμα στο:\n\n\nhttps://github.com/Keriew/augustus/issues/new\n\n\nΠαρακαλούμε επισυνάψτε και την αποθήκευση."},
    {TR_SAVE_DIALOG_INCOMPATIBLE_VERSION, "Μη συμβατή έκδοση"},
	{TR_SAVE_DIALOG_NEW_FILE, "Νέο αρχείο"},
    {TR_SAVE_DIALOG_SELECT_FILE, "Επιλέξτε ένα αρχείο"},
    {TR_SAVE_DIALOG_FUNDS, "Κεφάλαια:"},
    {TR_SAVE_DIALOG_POPULATION, "Πληθυσμός:"},
    {TR_SAVE_DIALOG_DATE, "Ημερομηνία:"},
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Προσαρμοσμένο σενάριο"},
    {TR_SAVE_DIALOG_FIRST_MISSION, "Πρώτη αποστολή"},
    {TR_SAVE_DIALOG_MISSION, "Αποστολή"},
    {TR_SAVE_DIALOG_MILITARY, "Στρατιωτική"},
    {TR_SAVE_DIALOG_PEACEFUL, "Ειρηνική"},
	{TR_SAVE_DIALOG_FILTER, "Φίλτρο"},
    {TR_SAVE_DIALOG_SORTING_BY_NAME, "Ταξινόμηση κατά όνομα"},
    {TR_SAVE_DIALOG_SORTING_BY_DATE, "Ταξινόμηση κατά ημερομηνία"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE, "Αντικατάσταση αρχείου;"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DESC, "Το αρχείο υπάρχει ήδη. Αντικατάσταση?"},
    {TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN, "Μην ξαναρωτήσετε"},
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Οργή του Άρη" },
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Ο Άρης είναι εξοργισμένος! Δεν έχουμε πολλά να φοβηθούμε σε ένα τόσο ειρηνικό τόπο, αλλά να είστε σίγουροι ότι αυτή η ειρήνη δεν θα διαρκέσει για πάντα!" },
    {TR_TOOLTIP_MONUMENT_PHASE, " φάση. "},
    {TR_TOOLTIP_MONUMENT_PHASES, " φάσεις. "},
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Απαιτήσεις πόρων:\n"},
    {TR_BUILDING_GLADIATOR_STATUE, "Άγαλμα μονομάχου"},
    { TR_BUILDING_HIGHWAY, "Αυτοκινητόδρομος" },
    { TR_BUILDING_HIGHWAY_DESC, "Οι αυτοκινητόδρομοι επιτρέπουν στους πολίτες να φτάνουν ταχύτερα στον προορισμό τους." },
	{TR_BUILDING_GOLD_MINE, "Χρυσωρυχείο"},
    {TR_BUILDING_GOLD_MINE_DESC, "Εξορύξτε χρυσό για το εμπόριο ή για να τροφοδοτήσετε το νομισματοκοπείο της πόλης σας για να παράγετε δηνάρια."},
    {TR_BUILDING_GOLD_MINE_PRODUCTION, "Η παραγωγή είναι"},
    {TR_BUILDING_GOLD_MINE_COMPLETE, "ολοκληρωμένη."},
    {TR_BUILDING_GOLD_MINE_HALTED, "Ο Εμπορικός σας Σύμβουλος διέταξε να σταματήσει η εξόρυξη χρυσού."},
    {TR_BUILDING_GOLD_MINE_NO_EMPLOYEES, "Αυτό το ορυχείο δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES, "Αυτό το ορυχείο έχει όλους τους εργαζόμενους που χρειάζεται και εργάζεται με όλες του τις δυνάμεις για την παραγωγή χρυσού."},
    {TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES, "Αυτό το ορυχείο λειτουργεί κάτω από τη μέγιστη δυναμικότητα. Η εξόρυξη χρυσού θα μπορούσε να είναι ελαφρώς πιο αποτελεσματική με περισσότερους χρυσωρύχους."},
    {TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES, "Αυτό το ορυχείο είναι υποστελεχωμένο. Χρειάζεται περισσότερο χρόνο για να παράγει χρυσό από όσο θα έπρεπε."},
    {TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτό το ορυχείο. Ως αποτέλεσμα, η παραγωγή χρυσού είναι αργή."},
    {TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου χρυσωρύχοι εδώ, η παραγωγή έχει σχεδόν σταματήσει.Θα παραχθεί ελάχιστος χρυσός κατά το επόμενο έτος."},
    {TR_BUILDING_STONE_QUARRY, "Λατομείο πέτρας"},
    {TR_BUILDING_STONE_QUARRY_DESC, "Λατομείο πέτρας για την κατασκευή μνημείων."},
    {TR_BUILDING_STONE_QUARRY_PRODUCTION, "Η παραγωγή είναι"},
    {TR_BUILDING_STONE_QUARRY_COMPLETE, "ολοκληρωμένη."},
    {TR_BUILDING_STONE_QUARRY_HALTED, "Ο Εμπορικός σας Σύμβουλος διέταξε να σταματήσει η εξόρυξη πέτρας."},
    {TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES, "Αυτό το λατομείο δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES, "Αυτό το λατομείο έχει όλους τους εργαζόμενους που χρειάζεται και εργάζεται με όλες του τις δυνάμεις για την παραγωγή πέτρας." },
    {TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES, "Αυτό το λατομείο λειτουργεί κάτω από τη μέγιστη δυναμικότητα. Το λατομείο πέτρας θα μπορούσε να είναι ελαφρώς πιο αποδοτικό με περισσότερους εργάτες." },
    {TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES, "Αυτό το λατομείο είναι υποστελεχωμένο. Χρειάζεται περισσότερο χρόνο για να παράγει πέτρα από ό,τι θα έπρεπε." },
    {TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτό το λατομείο. Ως αποτέλεσμα, η παραγωγή πέτρας είναι αργή." },
    {TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου εργάτες λατομείου εδώ, η παραγωγή έχει σχεδόν σταματήσει. Θα παράγει λίγη πέτρα κατά το επόμενο έτος."},
    {TR_BUILDING_SAND_PIT, "Αμμόλακκος"},
    {TR_BUILDING_SAND_PIT_DESC, "Εξόρυξη άμμου για την κατασκευή μνημείων."},
    {TR_BUILDING_SAND_PIT_PRODUCTION, "Η παραγωγή είναι"},
    {TR_BUILDING_SAND_PIT_COMPLETE, "ολοκληρωμένη."},
    {TR_BUILDING_SAND_PIT_HALTED, "Ο Εμπορικός σας Σύμβουλος διέταξε να σταματήσει η εξόρυξη άμμου."},
    {TR_BUILDING_SAND_PIT_NO_EMPLOYEES, "Αυτός ο λάκκος δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_SAND_PIT_FULL_EMPLOYEES, "Αυτός ο λάκκος έχει όλους τους εργαζόμενους που χρειάζεται και εργάζεται με εντατικούς ρυθμούς για την εξόρυξη άμμου."},
    {TR_BUILDING_SAND_PIT_MANY_EMPLOYEES, "Αυτός ο λάκκος λειτουργεί κάτω από τη μέγιστη χωρητικότητα. Η εξόρυξη άμμου θα μπορούσε να είναι ελαφρώς πιο αποτελεσματική με περισσότερους εργάτες."},
    {TR_BUILDING_SAND_PIT_HALF_EMPLOYEES, "Αυτός ο λάκκος είναι υποστελεχωμένος. Η εξόρυξη της άμμου διαρκεί περισσότερο απ' ό,τι θα έπρεπε."},
    {TR_BUILDING_SAND_PIT_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτόν τον λάκκο. Ως αποτέλεσμα, η παραγωγή άμμου είναι αργή."},
    {TR_BUILDING_SAND_PIT_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου εργάτες στα ορυχεία, η παραγωγή έχει σχεδόν σταματήσει. Θα παράγει ελάχιστη άμμο κατά το επόμενο έτος."},
    {TR_BUILDING_BRICKWORKS, "Πλινθοκεραμοποιείο"},
    {TR_BUILDING_BRICKWORKS_DESC, "Εδώ, η άμμος και ο άργιλος μεταποιούνται σε πλίνθους για την κατασκευή μνημείων."},
    {TR_BUILDING_BRICKWORKS_PRODUCTION, "Η παραγωγή είναι"},
    {TR_BUILDING_BRICKWORKS_COMPLETE, "ολοκληρωμένη."},
    {TR_BUILDING_BRICKWORKS_HALTED, "Ο Εμπορικός σας Σύμβουλος διέταξε τη διακοπή της παραγωγής πλίνθων."},
    {TR_BUILDING_BRICKWORKS_NO_EMPLOYEES, "Αυτό το εργαστήριο δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES, "Αυτό το εργαστήριο έχει όλους τους εργαζόμενους που χρειάζεται και εργάζεται με εντατικούς ρυθμούς για την παραγωγή πλίνθων."},
    {TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES, "Αυτό το εργαστήριο λειτουργεί κάτω από τη μέγιστη χωρητικότητα. Η παραγωγή πλίνθων θα μπορούσε να είναι ελαφρώς πιο αποδοτική με περισσότερους εργάτες."},
    {TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES, "Αυτό το εργαστήριο είναι υποστελεχωμένο. Χρειάζεται περισσότερο χρόνο για να παράγει πλίνθους απ' ό,τι θα έπρεπε."},
    {TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτό το εργαστήριο. Η παραγωγή πλίνθων είναι αργή ως αποτέλεσμα."},
    {TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου εργαζόμενοι εδώ, η παραγωγή έχει σχεδόν σταματήσει. Θα παράγει ελάχιστους πλίνθους κατά το επόμενο έτος."},
    {TR_BUILDING_BRICKWORKS_NO_RESOURCES, "Αυτό το εργαστήριο χρειάζεται άργιλο και άμμο που του παραδίδονται από μια αποθήκη ή από ένα λάκκο με άμμο και άργιλο, για να παράγει πλίνθους."},
    {TR_BUILDING_BRICKWORKS_STORED_SAND, "Αποθηκευμένη άμμος,"},
    {TR_BUILDING_BRICKWORKS_STORED_CLAY, "Αποθηκευμένος άργιλος,"},
    {TR_BUILDING_CONCRETE_MAKER, "Παρασκευαστής σκυροδέματος"},
    {TR_BUILDING_CONCRETE_MAKER_DESC, "Εδώ, η άμμος αναμιγνύεται σε σκυρόδεμα για την κατασκευή μνημείων."},
    {TR_BUILDING_CONCRETE_MAKER_PRODUCTION, "Η παραγωγή είναι"},
    {TR_BUILDING_CONCRETE_MAKER_COMPLETE, "ολοκληρωμένη."},
    {TR_BUILDING_CONCRETE_MAKER_HALTED, "Ο Εμπορικός σας Σύμβουλος διέταξε τη διακοπή της παραγωγής σκυροδέματος."},
    {TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES, "Αυτό το εργαστήριο δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES, "Αυτό το εργαστήριο έχει όλους τους εργαζόμενους που χρειάζεται και εργάζεται με εντατικούς ρυθμούς για την παραγωγή σκυροδέματος."},
    {TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES, "Αυτό το εργαστήριο λειτουργεί κάτω από τη μέγιστη χωρητικότητα. Η παραγωγή σκυροδέματος θα μπορούσε να είναι ελαφρώς πιο αποτελεσματική με περισσότερους εργαζόμενους."},
    {TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES, "Αυτό το εργαστήριο είναι υποστελεχωμένο. Παίρνει περισσότερο χρόνο για να παράγει σκυρόδεμα από ό,τι θα έπρεπε."},
    {TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτό το εργαστήριο. Ως αποτέλεσμα, η παραγωγή σκυροδέματος είναι αργή."},
    {TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου εργαζόμενοι εδώ, η παραγωγή έχει σχεδόν σταματήσει. Θα παράγει ελάχιστο σκυρόδεμα κατά το επόμενο έτος."},
    {TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES, "Αυτό το εργαστήριο χρειάζεται πρόσβαση σε νερό από δεξαμενή, αναβρυτήριο ή πηγάδι, καθώς και άμμο που παραδίδεται σε αυτό, από αποθήκη ή αμμόλακκο, για την ανάμιξη σκυροδέματος."},
    {TR_BUILDING_CONCRETE_MAKER_STORED_SAND, "Αποθηκευμένη άμμος,"},
    {TR_BUILDING_CONCRETE_MAKER_NO_TARGETS, "Δεν υπάρχουν κτίρια που απαιτούν σκυρόδεμα. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS, "Αυτό το εργαστήριο έχει πρόσβαση μόνο σε πηγάδι ή αναβρυτήριο. Η απόδοση θα μπορούσε να βελτιωθεί εάν υπήρχε άμεση πρόσβαση σε δεξαμενή."},
    {TR_BUILDING_CITY_MINT, "Νομισματοκοπείο πόλης"},
    {TR_BUILDING_CITY_MINT_PHASE_1, "(Θεμέλια)"},
    {TR_BUILDING_CITY_MINT_PHASE_1_TEXT, "Οι μηχανικοί θέτουν τα θεμέλια του κτιρίου."},
    {TR_BUILDING_CITY_MINT_DESC, "Εδώ, ο χρυσός κόβεται σε νομίσματα, τα οποία γεμίζουν το θησαυροφυλάκιο της πόλης σας."},
    {TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE, "Εδώ, το νόμισμα λιώνει σε χρυσό, ο οποίος μπορεί να χρησιμοποιηθεί για την κατασκευή μνημείων."},
    {TR_BUILDING_CITY_MINT_DESC_NO_PALACE, "Χτίστε το παλάτι σας για να συλλέγετε επίσης προσωπικά κεφάλαια από το νομισματοκοπείο της πόλης."},
    {TR_BUILDING_CITY_MINT_DESC_PALACE, "Εφόσον είστε ιδιοκτήτης ενός παλατιού, επιπλέον νομίσματα προστίθενται στα προσωπικά σας κεφάλαια."},
    {TR_BUILDING_CITY_MINT_NO_EMPLOYEES, "Το νομισματοκοπείο της πόλης δεν έχει υπαλλήλους. Η παραγωγή έχει σταματήσει."},
    {TR_BUILDING_CITY_MINT_FULL_EMPLOYEES, "Το νομισματοκοπείο της πόλης έχει όλους τους υπαλλήλους που χρειάζεται. Δουλεύει με όλες τις δυνάμεις του για να κόψει νομίσματα ή να τα λιώσει για χρυσό."},
    {TR_BUILDING_CITY_MINT_MANY_EMPLOYEES, "Το νομισματοκοπείο της πόλης λειτουργεί κάτω από τη μέγιστη δυνατή χωρητικότητα. Η κοπή νομισμάτων ή η παραγωγή χρυσού θα είναι ελαφρώς πιο αργή ως αποτέλεσμα."},
    {TR_BUILDING_CITY_MINT_HALF_EMPLOYEES, "Το νομισματοκοπείο της πόλης είναι υποστελεχωμένο και η κοπή νομισμάτων ή η τήξη χρυσού διαρκεί περισσότερο απ' ό,τι θα έπρεπε."},
    {TR_BUILDING_CITY_MINT_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται εδώ. Ως εκ τούτου, η κοπή νομισμάτων ή η παραγωγή χρυσού είναι αργή."},
    {TR_BUILDING_CITY_MINT_FEW_EMPLOYEES, "Με ελάχιστους εργαζόμενους στο εργαστήριο αυτό, το εργαστήριο βρίσκεται σε ουσιαστικό αδιέξοδο. Το επόμενο έτος δεν θα παράγει σχεδόν τίποτα."},
    {TR_BUILDING_CITY_MINT_NO_GOLD, "Αυτό το εργαστήριο χρειάζεται χρυσό που παραδίδεται σε αυτό, από μια αποθήκη ή ένα ορυχείο χρυσού, για την κοπή νομισμάτων."},
    {TR_BUILDING_CITY_MINT_STORED_GOLD, "Αποθηκευμένος χρυσός,"},
    {TR_BUILDING_CITY_MINT_NO_SENATE, "Αυτό το κτίριο απαιτεί μια ενεργή σύγκλητο για να λειτουργήσει. Χωρίς ένα τέτοιο κτίριο, κανένα νόμισμα δεν μπορεί να κοπεί."},
    {TR_BUILDING_CITY_MINT_CONVERT, "Μετατρέψτε:"},
    {TR_BUILDING_CITY_MINT_GOLD_TO_DN, "Ένα φορτίο χρυσού σε 500 δηνάρια"},
    {TR_BUILDING_CITY_MINT_DN_TO_GOLD, "600 δηνάρια για ένα φορτίο χρυσού"},
    {TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION, "Αλλαγή της παραγωγής νομισματοκοπείου της πόλης;"},
    {TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST, "Η τρέχουσα πρόοδος παραγωγής θα χαθεί."},
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "Δεν υπάρχει ενεργό Κολοσσαίο στην πόλη"},
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "Η πόλη εξυπηρετείται από το Κολοσσαίο"},
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "Δεν υπάρχει ενεργός ιππόδρομος στην πόλη"},
    {TR_ADVISOR_ACTIVE_HIPPODROME, "Η πόλη εξυπηρετείται από τον ιππόδρομο"},
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Σταθμοί αποστολών"},
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "Οι εχθροί υποχωρούν"},
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Χμμ! Η ασήμαντη πόλη σας δεν έχει τίποτα άλλο που να αξίζει να καταστραφεί. Φεύγουμε προς το παρόν, αλλά προσέξτε, μπορούμε πάντα να επιστρέψουμε!"},
    {TR_ZOOM, "Ζουμ:"},
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Προεπισκόπηση ενεργητικού"},
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Ομάδα:"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "( καμία ομάδα )"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Έδαφος:"},
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Αναπαραγωγή κινήσεων"},
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Ανανέωση"},
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Κλείσιμο"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Ενεργητικό:"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "Τίποτα" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Κεντρικά"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Βόρεια"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Έρημος"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "Κανένα ενεργητικό"},
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( ανώνυμο ενεργητικό )"},
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( πλαίσιο κινήσεων )"},
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Εμφάνιση πλαισίου κινήσεων"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Ανανέωση ενεργητικού" },
    {TR_CHEAT_ADDED_MONEY, "Προστέθηκαν χρήματα"},
    {TR_CHEAT_STARTED_INVASION, "Ξεκίνησε εισβολή"},
    {TR_CHEAT_YEAR_ADVANCED, "Έτος προωθήθηκε"},
    {TR_CHEAT_CASTED_BLESSING, "Χρησιμοποιήθηκε ευλογία"},
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Ενεργοποιήθηκε η εμφάνιση συμβουλών"},
    {TR_CHEAT_KILLED_ALL_WALKERS, "Σκοτώθηκαν όλοι οι περιπατητές"},
    {TR_CHEAT_FINISHED_MONUMENTS, "Τα μνημεία ολοκληρώθηκαν"},
    {TR_CHEAT_UPDATED_MONUMENTS, "Τα μνημεία αναβαθμίσθηκαν"},
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "Όλα τα κτίρια ξεκλειδώθηκαν"},
    {TR_CHEAT_INCITED_RIOT, "Προκλήθηκε εξέγερση"},
    {TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING, "Πόλη Απροσπέλαστη" },
    {TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING, "Ο δρόμος προς τη Ρώμη είναι φραγμένος. Αν δεν αποκαταστήσουμε αμέσως την πρόσβαση στην αυτοκρατορική εθνική οδό, οι μηχανικοί της Ρώμης θα αναγκαστούν να αναλάβουν δράση." },
    {TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE, "Τιμή εμπορικής διαδρομής" },
    {TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE, "Η τιμή για το άνοιγμα μιας εμπορικής διαδρομής έχει αλλάξει." },
    {TR_EDITOR_CHOOSE_CUSTOM_EMPIRE, "Επιλέξτε προσαρμοσμένη αυτοκρατορία"},															 
    {TR_EDITOR_CUSTOM_EMPIRE_TITLE, "Φόρτωση μιας αυτοκρατορίας"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE, "Αδυναμία φόρτωσης προσαρμοσμένης αυτοκρατορίας"},
    {TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE, "Ελέγξτε το αρχείο augustus-log.txt στον κατάλογο Augustus για λεπτομέρειες."},
    {TR_EDITOR_SHORT_ROUTE_TEXT, "rt"},
    {TR_EDITOR_TOGGLE_INVASIONS, "Εναλλαγή εισβολών"},
    {TR_EDITOR_REFRESH_EMPIRE, "Ανανέωση (F5)"},
    {TR_EDITOR_CITY_PREVIEW, "Προεπισκόπηση εικόνας πόλης: "},
    {TR_EDITOR_CURRENT_COORDS, "Τρέχουσες συντεταγμένες: "},
    {TR_EDITOR_SELECTED_COORDS, "Επιλεγμένες συντεταγμένες: "},
    {TR_EDITOR_MAX_WAGES, "Μέχρι"},
    {TR_EDITOR_MIN_WAGES, "Από"},
	{TR_EDITOR_FAVOUR_DISFAVOR, "Η εύνοια χάνεται εάν απαιτείται επέκταση"},
    {TR_EDITOR_FAVOUR_IGNORED, "Η εύνοια χάνεται αν το αίτημα αγνοηθεί εντελώς"},
    {TR_EDITOR_FAVOUR_EXTENSION_MONTHS, "Επιτρεπόμενοι μήνες παράτασης"},
    {TR_EDITOR_SCENARIO_EVENTS_TITLE, "Συμβάντα σεναρίου" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT, "Εισαγωγή" },
    {TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL, "Εισαγωγή συμβάντων σεναρίου" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT, "Εξαγωγή" },
    {TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL, "Εξαγωγή συμβάντων σεναρίου" },
    {TR_EDITOR_SCENARIO_EVENTS_CLEAR, "Εκκαθάριση όλων των συμβάντων" },
    {TR_EDITOR_SCENARIO_EVENTS_COUNT, "συμβάντα σεναρίου" },
    {TR_EDITOR_SCENARIO_EVENTS_CONDITIONS, "συνθήκες" },
    {TR_EDITOR_SCENARIO_EVENTS_ACTIONS, "ενέργειες" },
    {TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE, "Αδυναμία φόρτωσης συμβάντων σεναρίου"},
    {TR_EDITOR_CHECK_LOG_MESSAGE, "Ελέγξτε το αρχείο augustus-log.txt στον κατάλογο Augustus για λεπτομέρειες."},
    {TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE, "Αδυναμία αποθήκευσης συμβάντων σεναρίου"},
    {TR_EDITOR_IMPORT_LINE, "Γραμμή: "},
    {TR_EDITOR_SCENARIO_EVENT_ID, "ID: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS, "Ελάχιστοι μήνες πριν από την επανάληψη: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS, "Μέγιστοι μήνες πριν από την επανάληψη: "},
    {TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS, "Μέγιστος αριθμός επαναλήψεων: "},
    {TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER, "Άπειρο"},
    {TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT, "Δεν επαναλαμβάνεται."},
    {TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED, "Απροσδιόριστο"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED, "Απενεργοποιημένο"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE, "Ενεργό"},
    {TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED, "Διακόπηκε"},
    {TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT, "Αριθμός εκτελέσεων: "},
    {TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE, "Μήνες μέχρι να ενεργοποιηθεί: "},
    {TR_EDITOR_SCENARIO_CONDITION, "Κατάσταση"},
    {TR_EDITOR_SCENARIO_ACTION, "Ενέργεια"},
    {TR_EDITOR_SCENARIO_EVENTS_ADD, "Προσθήκη νέου συμβάντος"},
    {TR_EDITOR_SCENARIO_CONDITION_ADD, "Προσθήκη νέας συνθήκης"},
    {TR_EDITOR_SCENARIO_ACTION_ADD, "Προσθήκη νέας ενέργειας"},
    {TR_EDITOR_DELETE, "Διαγραφή"},
    {TR_EDITOR_DELETED, "Διαγράφηκε"},
    {TR_EDITOR_SCENARIO_EVENT_DELETED, "Διαγραμμένο συμβάν"},
    {TR_EDITOR_CUSTOM_MESSAGES_TITLE, "Προσαρμοσμένα μηνύματα" },
    {TR_EDITOR_CUSTOM_MESSAGES_COUNT, "Σύνολο μηνυμάτων" },
    {TR_EDITOR_CUSTOM_MESSAGES_CLEAR, "Εκκαθάριση μηνυμάτων" },
    {TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL, "Εισαγωγή προσαρμοσμένων μηνυμάτων" },
    {TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL, "Εξαγωγή προσαρμοσμένων μηνυμάτων" },
    {TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE, "Αδυναμία φόρτωσης προσαρμοσμένων μηνυμάτων"},
    {TR_EDITOR_SCENARIO_SELECT_INTRO, "Επιλέξτε εισαγωγή σεναρίου"},
    {TR_EDITOR_SCENARIO_DESELECT_INTRO, "Αποεπιλογή εισαγωγής σεναρίου"},
    {TR_EDITOR_CUSTOM_VARIABLES_TITLE, "Προσαρμοσμένες μεταβλητές" },
    {TR_EDITOR_CUSTOM_VARIABLES_COUNT, "Μέγιστες δυνατές μεταβλητές" },
    {TR_EDITOR_GRID_OFFSET, "αντιστάθμιση" },
	{TR_PARAMETER_TYPE_CHECK, "Έλεγχος συγκρίσεων"},		  
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN, "Ελάχιστο"},
    {TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX, "Μέγιστο"},
    {TR_PARAMETER_TYPE_DIFFICULTY, "Δυσκολία"},
    {TR_PARAMETER_TYPE_BOOLEAN, "Σωστό ή Λάθος"},
    {TR_PARAMETER_TYPE_NUMBER, "Αριθμός"},
    {TR_PARAMETER_TYPE_RESOURCE, "Πόρος"},
    {TR_PARAMETER_TYPE_POP_CLASS, "Κατηγορία πληθυσμού"},
    {TR_PARAMETER_TYPE_BUILDING_COUNTING, "Τύπος κτιρίου για καταμέτρηση"},
    {TR_PARAMETER_TYPE_ALLOWED_BUILDING, "Επιτρεπόμενος τύπος κτιρίου"},
    {TR_PARAMETER_TYPE_ROUTE, "Εμπορική διαδρομή-στόχος"},
    {TR_PARAMETER_TYPE_STANDARD_MESSAGE, "Κανονικό μήνυμα"},
    {TR_PARAMETER_TYPE_FUTURE_CITY, "Στόχος μελλοντικής εμπορικής πόλης"},
    {TR_PARAMETER_USE_PERCENTAGE, "Χρήση ποσοστού?"},
    {TR_PARAMETER_IN_CITY_ONLY, "Να μετράτε μόνο τους στρατιώτες στην πόλη;"},
    {TR_PARAMETER_CHECK_FOR_ONGOING, "Ελέγξτε ότι είναι σε εξέλιξη;"},
    {TR_PARAMETER_SHOW_MESSAGE, "Εμφάνιση μηνύματος;"},
    {TR_PARAMETER_SET_TO_VALUE, "Ρύθμιση στην τιμή;"},
    {TR_PARAMETER_ADD_AS_BUYING, "Προσθήκη ως αγορά;"},
	{TR_PARAMETER_PRODUCED, "Παράγεται;"},		 
    {TR_PARAMETER_ALLOWED, "Επιτρέπεται;"},
    {TR_PARAMETER_SET_BUY_PRICE, "Ορισμός τιμής αγοράς;"},
    {TR_PARAMETER_CHECK_FOR_OPEN, "Ελέγξτε αν η διαδρομή είναι ανοιχτή;"},
    {TR_PARAMETER_RESPECT_SETTINGS, "Να σέβεστε τις ρυθμίσεις αποθήκευσης;"},
    {TR_PARAMETER_TYPE_CUSTOM_MESSAGE, "Προσαρμοσμένο μήνυμα"},
    {TR_PARAMETER_TYPE_CUSTOM_VARIABLE, "Προσαρμοσμένη μεταβλητή"},
    {TR_PARAMETER_TYPE_RATING_TYPE, "Τύπος αξιολόγησης"},
    {TR_PARAMETER_TYPE_STORAGE_TYPE, "Τύπος αποθήκευσης"},
	{TR_PARAMETER_APPLY_COST, "Εφαρμογή του ανοικτού κόστους;"},
    {TR_PARAMETER_DESTROY_ALL, "Καταστροφή όλων των τύπων;"},
    {TR_PARAMETER_GRID_OFFSET, "Αντιστάθμιση πλέγματος"},
    {TR_PARAMETER_RADIUS, "Ακτίνα"},
    {TR_PARAMETER_TYPE_INVASION_SIZE, "Μέγεθος"},
    {TR_PARAMETER_TYPE_INVASION_TYPE, "Τύπος επίθεσης"},
    {TR_PARAMETER_TYPE_INVASION_POINT, "Σημείο εισβολής"},
    {TR_PARAMETER_TYPE_TARGET_TYPE, "Τύπος στόχου"},
    {TR_PARAMETER_TYPE_ENEMY_TYPE, "Τύπος εχθρού"},													  										 
    {TR_CONDITION_TYPE_TIME_PASSED, "Χρόνος που πέρασε"},
    {TR_CONDITION_TYPE_DIFFICULTY, "Δυσκολία"},
    {TR_CONDITION_TYPE_MONEY, "Χρήματα της πόλης"},
    {TR_CONDITION_TYPE_SAVINGS, "Προσωπικές αποταμιεύσεις"},
    {TR_CONDITION_TYPE_STATS_FAVOR, "Εύνοια"},
    {TR_CONDITION_TYPE_STATS_PROSPERITY, "Ευημερία"},
    {TR_CONDITION_TYPE_STATS_CULTURE, "Πολιτισμός"},
    {TR_CONDITION_TYPE_STATS_PEACE, "Ειρήνη"},
    {TR_CONDITION_TYPE_TRADE_SELL_PRICE, "Εμπορική τιμή πώλησης"},
    {TR_CONDITION_TYPE_POPS_UNEMPLOYMENT, "Ανεργία"},
    {TR_CONDITION_TYPE_ROME_WAGES, "Μισθοί που καταβάλλονται από τη Ρώμη"},
    {TR_CONDITION_TYPE_CITY_POPULATION, "Πληθυσμός πόλης"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE, "Ενεργή καταμέτρηση τύπου κτιρίων"},
    {TR_CONDITION_TYPE_STATS_CITY_HEALTH, "Υγεία πόλης"},
    {TR_CONDITION_TYPE_COUNT_OWN_TROOPS, "Καταμέτρηση των στρατευμάτων"},
    {TR_CONDITION_TYPE_REQUEST_IS_ONGOING, "Το αίτημα βρίσκεται σε εξέλιξη"},
    {TR_CONDITION_TYPE_TAX_RATE, "Φορολογικός συντελεστής"},
    {TR_CONDITION_TYPE_BUILDING_COUNT_ANY, "Καταμέτρηση τύπου κτιρίων"},
    {TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK, "Προσαρμοσμένη τιμή μεταβλητής"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_OPEN, "Η εμπορική οδός είναι ανοικτή"},
    {TR_CONDITION_TYPE_TRADE_ROUTE_PRICE, "Τιμή ανοίγματος εμπορικής διαδρομής"},
    {TR_CONDITION_TYPE_RESOURCE_STORED_COUNT, "Μέτρηση αποθηκευμένων πόρων"},
    {TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE, "Διαθέσιμος αποθηκευτικός χώρος πόρων"},
	{TR_CONDITION_TYPE_BUILDING_COUNT_AREA, "Κτίρια στην περιοχή"},											 
    {TR_ACTION_TYPE_ADJUST_FAVOR, "Ρύθμιση εύνοιας"},
    {TR_ACTION_TYPE_ADJUST_MONEY, "Ρύθμιση χρημάτων"},
    {TR_ACTION_TYPE_ADJUST_SAVINGS, "Ρύθμιση αποταμιεύσεων"},
    {TR_ACTION_TYPE_TRADE_ADJUST_PRICE, "Ρύθμιση εμπορικής τιμής"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_LAND, "Έναρξη προβλήματος εμπορίου γης"},
    {TR_ACTION_TYPE_TRADE_PROBLEM_SEA, "Έναρξη προβλήματος θαλάσσιου εμπορίου"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT, "Ρύθμιση ποσού εμπορικής διαδρομής"},
    {TR_ACTION_TYPE_ADJUST_ROME_WAGES, "Ρύθμιση μισθών Ρώμης"},
    {TR_ACTION_TYPE_GLADIATOR_REVOLT, "Έναρξη εξέγερσης μονομάχων"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED, "Μεταβολή διαθέσιμων πόρων"},
    {TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS, "Επιτρέψτε ή απαγορεύστε κτίρια"},
    {TR_ACTION_TYPE_SEND_STANDARD_MESSAGE, "Αποστολή τυπικού μηνύματος"},
    {TR_ACTION_TYPE_ADJUST_CITY_HEALTH, "Ρύθμιση υγείας της πόλης"},
    {TR_ACTION_TYPE_TRADE_SET_PRICE, "Ορισμός εμπορικής τιμής"},
    {TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY, "Μετατροπή μελλοντικής εμπορικής πόλης αυτοκρατορίας"},
    {TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START, "Άμεση έναρξη αιτήματος"},
    {TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE, "Εμφάνιση προσαρμοσμένου μηνύματος"},
    {TR_ACTION_TYPE_TAX_RATE_SET, "Ορισμός φορολογικού συντελεστή"},
    {TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE, "Αλλαγή τιμής προσαρμοσμένης μεταβλητής"},
    {TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE, "Αλλαγή κόστους ανοίγματος εμπορικής διαδρομής"},
    {TR_ACTION_TYPE_A_MESSAGE, "Ένα μήνυμα"},
    {TR_ACTION_TYPE_CHANGE_CITY_RATING, "Αλλαγή βαθμολογίας πόλης"},
    {TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES, "Αλλαγή αποθέματος πόρων"},
	{TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN, "Άνοιγμα διαδρομής"},
    {TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE, "Εμπορική διαδρομή προσθήκη νέου πόρου"},
    {TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY, "Ορισμός τιμής αγοράς εμπορίου μόνο"},
    {TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY, "Ορισμός τιμής πώλησης εμπορίου μόνο"},
    {TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE, "Συντριβή κτιρίου"},
    {TR_ACTION_TYPE_INVASION_IMMEDIATE, "Έναρξη εισβολής αμέσως"},															  
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL, "Ίσο"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS, "Λιγότερο ή ίσο"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE, "Μεγαλύτερο ή ίσο"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL, "Δεν είναι ίσο"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN, "Λιγότερο από"},
    {TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN, "Μεγαλύτερο από"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY, "Πολύ εύκολο"},
    {TR_PARAMETER_VALUE_DIFFICULTY_EASY, "Εύκολο"},
    {TR_PARAMETER_VALUE_DIFFICULTY_NORMAL, "Κανονικό"},
    {TR_PARAMETER_VALUE_DIFFICULTY_HARD, "Δύσκολο"},
    {TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD, "Πολύ δύσκολο"},
    {TR_PARAMETER_VALUE_BOOLEAN_FALSE, "Λάθος"},
    {TR_PARAMETER_VALUE_BOOLEAN_TRUE, "Σωστό"},
    {TR_PARAMETER_VALUE_POP_CLASS_ALL, "Όλα"},
    {TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN, "Πατρίκιοι"},
    {TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN, "Πληβείοι"},
    {TR_PARAMETER_VALUE_POP_CLASS_SLUMS, "Φτωχολογιά"},
    {TR_PARAMETER_VALUE_BUILDING_NONE, "Κανένα"},
	{TR_PARAMETER_VALUE_BUILDING_ANY, "Οποιοδήποτε"},		 
    {TR_PARAMETER_VALUE_BUILDING_MENU_FARMS, "Όλα τα αγροκτήματα"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS, "Όλες οι πρώτες ύλες"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS, "Όλα τα εργαστήρια"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_STATUES, "Όλα τα αγάλματα"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES, "Όλες οι κατοικίες του κυβερνήτη"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES, "Όλοι οι μεγαλοπρεπείς ναοί"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_TREES, "Όλα τα διακοσμητικά δέντρα"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PATHS, "Όλα τα διακοσμητικά μονοπάτια"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_PARKS, "Όλα τα διακοσμητικά πάρκα"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES, "Όλοι οι μικροί ναοί"},
    {TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES, "Όλοι οι μεγάλοι ναοί"},
    {TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS, "Καλλιέργειες ιθαγενών"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES, "Μικρός ναός Δήμητρας"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE, "Μικρός ναός Ποσειδώνα"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY, "Μικρός ναός Ερμή"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS, "Μικρός ναός Άρη"},
    {TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS, "Μικρός ναός Αφροδίτης"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES, "Μεγάλος ναός Δήμητρας"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE, "Μεγάλος ναός Ποσειδώνα"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, "Μεγάλος ναός Ερμή"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS, "Μεγάλος ναός Άρη"},
    {TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS, "Μεγάλος ναός Αφροδίτης"},
    {TR_PARAMETER_VALUE_DYNAMIC_RESOLVE, "..."},
    {TR_PARAMETER_VALUE_NONE, "Τίποτα"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT, "Χρεωμένη πόλη"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN, "Η πόλη ξαναχρεώνεται"},
    {TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT, "Η πόλη εξακολουθεί να είναι χρεωμένη"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH, "Οργή του Καίσαρα"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE, "Ο στρατός του Καίσαρα συνεχίζει"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT, "Υποχώρηση του στρατού του Καίσαρα"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE, "Μακρινή μάχη"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING, "Πλησιάζουν εχθροί"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR, "Εχθροί προ των πυλών"},
    {TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL, "Μικρό φεστιβάλ"},
    {TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL, "Μεγάλο φεστιβάλ"},
    {TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL, "Μεγαλειώδες φεστιβάλ"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY, "Δυσαρεστημένοι Θεοί"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT, "Εξέγερση μονομάχων"},
    {TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED, "Τέλος εξέγερσης μονομάχων"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE, "Ο αυτοκράτορας άλλαξε"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS, "Αμμοθύελλες χερσαίου εμπορίου"},
    {TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES, "Κατολισθήσεις χερσαίου εμπορίου"},
    {TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED, "Διακοπή θαλάσσιου εμπορίου"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES, "Η Ρώμη αυξάνει τους μισθούς"},
    {TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES, "Η Ρώμη μειώνει τους μισθούς"},
    {TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER, "Μολυσμένο νερό"},
    {TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED, "Η αυτοκρατορία επεκτάθηκε"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES, "Η οργή της Δήμητρας"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE, "Η Οργή του Ποσειδώνα (χωρίς θαλάσσιο εμπόριο)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY, "Η οργή του Ερμή"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY, "Η οργή του Άρη (χωρίς στρατό)"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS, "Η οργή της Αφροδίτης"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE, "Η οργή του Ποσειδώνα"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS, "Η οργή του Άρη"},
    {TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET, "Η Δήμητρα είναι εκνευρισμένη"},
    {TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET, "Ο Ποσειδώνας είναι εκνευρισμένος"},
    {TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET, "Ο Ερμής είναι εκνευρισμένος"},
    {TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET, "Ο Άρης είναι εκνευρισμένος"},
    {TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET, "Η Αφροδίτη είναι εκνευρισμένη"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES, "Ευλογία από τη Δήμητρα"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE, "Ευλογία από τον Ποσειδώνα"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY, "Ευλογία από τον Ερμή"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS, "Ευλογία από τον Άρη"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS, "Ευλογία από την Αφροδίτη"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE, "Εναλλακτική ευλογία από τον Ερμή"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE, "Εναλλακτική ευλογία από τον Ποσειδώνα"},
    {TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE, "Εναλλακτική ευλογία από την Αφροδίτη"},
    {TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES, "Η οργή του Άρη (χωρίς ιθαγενείς)"},
    {TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL, "Οργισμένοι Θεοί"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS, "Μακρινή μάχη χαμένη (χωρίς στρατεύματα)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE, "Μακρινή μάχη χαμένη (πολύ αργά)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK, "Μακρινή μάχη χαμένη (πολύ αδύναμος)"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON, "Μακρινή μάχη κερδισμένη"},
    {TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN, "Μακρινή μάχη πόλης που ανακαταλήφθηκε"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS, "Ασθένεια"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE, "Νόσος"},
    {TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE, "Πανούκλα"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1, "Ο σεβασμός του Καίσαρα 1"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2, "Ο σεβασμός του Καίσαρα 2"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3, "Ο σεβασμός του Καίσαρα 3"},
    {TR_PARAMETER_VALUE_MESSAGE_EMIGRATION, "Αποδημία"},
    {TR_PARAMETER_VALUE_MESSAGE_FIRED, "Απόλυση"},
    {TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING, "Οι στρατιώτες λιμοκτονούν"},
    {TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER, "Ο θυμός του Καίσαρα"},
    {TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING, "Οι εχθροί φεύγουν"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND, "Ήχος"},
    {TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO, "Βίντεο"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PEACE, "Ειρήνη"},
    {TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY, "Ευημερία"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_ALL, "Όλα"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES, "Σιταποθήκες"},
    {TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES, "Αποθήκες"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY, "Εχθρικός στρατός"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR, "Καίσαρας"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES, "Ιθαγενείς"},
    {TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES, "ιθαγενείς του Άρη"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN, "Τροφική αλυσίδα"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES, "Κατάστημα χρυσού"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS, "Καλύτερα κτίρια"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS, "Στρατεύματα"},
    {TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM, "Τυχαία"},
    {TR_PARAMETER_VALUE_ENEMY_UNDEFINED, "Καθορισμένος χάρτης"},
    {TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN, "Βάρβαροι!"},
    {TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN, "Νουμιδιανοί"},
    {TR_PARAMETER_VALUE_ENEMY_2_GAUL, "Γαλάτες"},
    {TR_PARAMETER_VALUE_ENEMY_3_CELT, "Κέλτες"},
    {TR_PARAMETER_VALUE_ENEMY_4_GOTH, "Γότθοι"},
    {TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM, "Πέργαμος"},
    {TR_PARAMETER_VALUE_ENEMY_6_SELEUCID, "Σελευκίδες"},
    {TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN, "Ετρούσκοι"},
    {TR_PARAMETER_VALUE_ENEMY_8_GREEK, "Έλληνες"},
    {TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN, "Αιγύπτιοι"},
    {TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN, "Καρθαγήνιοι"},
    {TR_PARAMETER_VALUE_ENEMY_11_CAESAR, "Καίσαρας"},
	{TR_PARAMETER_DISPLAY_SET_TO, "ορίστε σε"},							
    {TR_PARAMETER_DISPLAY_ADD_TO, "προσθέστε"},
    {TR_PARAMETER_DISPLAY_BETWEEN, "μεταξύ"},
    {TR_PARAMETER_DISPLAY_IN_CITY, "στην πόλη"},
    {TR_PARAMETER_DISPLAY_ANYWHERE, "οπουδήποτε"},
    {TR_PARAMETER_DISPLAY_PERCENTAGE, "ποσοστό"},
    {TR_PARAMETER_DISPLAY_FLAT_NUMBER, "σταθερός αριθμός"},
    {TR_PARAMETER_DISPLAY_ONGOING, "συνεχίζεται"},
    {TR_PARAMETER_DISPLAY_NOT_ONGOING, "δεν συνεχίζεται"},
    {TR_PARAMETER_DISPLAY_ROUTE_OPEN, "η διαδρομή είναι ανοιχτή"},
    {TR_PARAMETER_DISPLAY_ROUTE_CLOSED, "η διαδρομή είναι κλειστή"},
    {TR_PARAMETER_DISPLAY_ALLOWED, "επιτρέπεται"},
    {TR_PARAMETER_DISPLAY_DISALLOWED, "απαγορεύεται"},
    {TR_PARAMETER_DISPLAY_SHOW_MESSAGE, "προβολή μηνύματος"},
    {TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE, "Δεν εμφανίζεται μήνυμα"},
    {TR_PARAMETER_DISPLAY_BUY_PRICE, "τιμή αγοράς"},
    {TR_PARAMETER_DISPLAY_SELL_PRICE, "τιμή πώλησης"},
    {TR_PARAMETER_DISPLAY_MONTHS, "μήνες"},
	{TR_PARAMETER_DISPLAY_DAYS, "μέρες"},						
    {TR_PARAMETER_DISPLAY_RESPECT_SETTINGS, "τήρηση ρυθμίσεων"},
    {TR_PARAMETER_DISPLAY_IGNORE_SETTINGS, "αγνόηση ρυθμίσεων"},
	{TR_PARAMETER_DISPLAY_APPLY_COST, "Εφαρμογή κόστους"},
    {TR_PARAMETER_DISPLAY_NO_COST, "χωρίς κόστος"},
    {TR_PARAMETER_DISPLAY_ADD_AS_BUYING, "Προσθήκη ως αγορά"},
    {TR_PARAMETER_DISPLAY_ADD_AS_SELLING, "Προσθήκη ως πώληση"},
    {TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES, "καταστροφή όλων των τύπων"},														  
    {TR_ORDER_CONDITION_NEVER, "Ποτέ" },
    {TR_ORDER_CONDITION_ALWAYS, "Πάντα" },
    {TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN, "Η προέλευση έχει περισσότερα από" },
    {TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN, "Ο προορισμός έχει λιγότερο από" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE, "Επιλέξτε μια προέλευση"},
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION, "Επιλέξτε έναν προορισμό"},
    {TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE, "Μόνο ένα κτίριο διαθέσιμο"},
    {TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE, "Δεν υπάρχει διαθέσιμη προέλευση"},
    {TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE, "Δεν υπάρχει διαθέσιμος προορισμός"},
    {TR_BUILDING_INFO_DEPOT_DELIVER, "Παραδώστε" },
    {TR_BUILDING_INFO_DEPOT_CONDITION, "Όταν" },
    {TR_BUILDING_INFO_DEPOT_SOURCE, "Προέλευση" },
    {TR_BUILDING_INFO_DEPOT_DESTINATION, "Προορισμός" },
    {TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE, "Επιλογή αποθηκευτικού χώρου προέλευσης" },
    {TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE, "Επιλογή αποθηκευτικού χώρου προορισμού" },
    {TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE, "Επιλέξτε πόρο" },
    {TR_TOOLTIP_BUTTON_CENTER_CAMERA, "Κεντράρετε την κάμερα στο κτίριο"},
    {TR_FIGURE_INFO_DEPOT_RECALL, "Ανάκληση" },
    {TR_FIGURE_INFO_DEPOT_RETURNING, "Επιστροφή" },
    {TR_FIGURE_INFO_DEPOT_DELIVER, "Παράδοση" },
    {TR_FIGURE_INFO_DEPOT_FROM, "Από " },
    {TR_FIGURE_INFO_DEPOT_TO, " σε " },
    {TR_BUILDING_DEPOT_NO_EMPLOYEES, "Το συγκεκριμένο αμαξοστάσιο δεν έχει υπαλλήλους. Οι γάτες κοιμούνται στα άδεια καροτσάκια." },
    {TR_BUILDING_DEPOT_FEW_EMPLOYEES, "Καθώς δεν υπάρχουν σχεδόν καθόλου εργαζόμενοι εδώ, κανείς δεν μπορεί να θυμηθεί πότε αυτό το αμαξοστάσιο έστειλε τον τελευταίο προωθητή καροτσιών." },
    {TR_BUILDING_DEPOT_SOME_EMPLOYEES, "Πολύ λίγοι άνθρωποι εργάζονται σε αυτό το αμαξοστάσιο. Χρειάζεται αρκετός χρόνος για να μεταφερθούν τα εμπορεύματα." },
    {TR_BUILDING_DEPOT_HALF_EMPLOYEES, "Αυτό το αμαξοστάσιο είναι υποστελεχωμένο. Ως αποτέλεσμα, τα εμπορεύματα μεταφέρονται αργά." },
    {TR_BUILDING_DEPOT_MANY_EMPLOYEES, "Το εν λόγω αμαξοστάσιο λειτουργεί κάτω από τη μέγιστη χωρητικότητα. Τα εμπορεύματα θα μπορούσαν να μεταφερθούν ελαφρώς ταχύτερα με περισσότερους εργάτες." },
    {TR_BUILDING_INFO_MOTHBALL_WARNING, "Αυτό το κτίριο είναι παροπλισμένο." },
    {TR_BUILDING_INFO_CARTLOAD, "φορτίο." },
    {TR_BUILDING_INFO_CARTLOADS, "φορτία." },
    {TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE, "Επικάλυψη Ιθαγενών"},
    {TR_BUILDING_PANELLED_GARDEN_WALL, "Τείχος κήπου με επένδυση"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE, "Πύλη τοίχου κήπου"},
    {TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC, "Αυτή η μικρή πύλη ελέγχει την κίνηση των ανθρώπων μέσα και έξω από τα πιο απομονωμένα σημεία της πόλης σας." },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE, "Πύλη τοίχου κήπου με επένδυση" },
    {TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC, "Αυτή η μικρή πύλη ελέγχει την κίνηση των ανθρώπων μέσα και έξω από τα πιο απομονωμένα σημεία της πόλης σας." },
    {TR_HOTKEY_BUILD_HIGHWAY, "Αυτοκινητόδρομος"},										  
	{TR_BUILDING_SHRINE_DESC, "Οι βωμοί εκτιμώνται όχι μόνο από τους γείτονές τους αλλά και από τους αντίστοιχους θεούς τους."},
    {TR_BUILDING_SHRINE_CERES, "Βωμός Δήμητρας"},
    {TR_BUILDING_SHRINE_MARS, "Βωμός Άρη"},
    {TR_BUILDING_SHRINE_MERCURY, "Βωμός Ερμή"},
    {TR_BUILDING_SHRINE_NEPTUNE, "Βωμός Ποσειδώνα"},
    {TR_BUILDING_SHRINE_VENUS, "Βωμός Αφροδίτης"},
    {TR_BUILDING_MENU_SHRINES, "Βωμός" },
    {TR_BUILDING_INFO_TOTAL_FOOD, "Σύνολο τροφίμων:" },
    {TR_BUILDING_FORMAL_GARDENS, "Επίσημοι κήποι" },
    {TR_BUILDING_OVERGROWN_GARDENS, "Κατάφυτοι κήποι" },			
    {TR_WINDOW_ADVISOR_RELIGION_ALTARS_HEADER, "βωμός" }

};

void translation_greek(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
