// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

pub struct HuffmanDecodeEntry {
    pub val: u16,
    pub prefix_len: u8,
}

pub struct HuffmanDecodeTable<'a> {
    entry: &'a [HuffmanDecodeEntry],
    next_table: &'a [&'a HuffmanDecodeTable<'a>],
    index_of_first_next_table: u16,
}

impl<'a> HuffmanDecodeTable<'a> {
    pub fn index_has_a_next_table(&self, inx: u8) -> bool {
        u16::from(inx) >= self.index_of_first_next_table
    }

    pub fn entry(&self, inx: u8) -> &'a HuffmanDecodeEntry {
        assert!(u16::from(inx) < self.index_of_first_next_table);
        &self.entry[inx as usize]
    }

    pub fn next_table(&self, inx: u8) -> &'a HuffmanDecodeTable {
        assert!(u16::from(inx) >= self.index_of_first_next_table);
        self.next_table[(inx as usize) - (self.index_of_first_next_table as usize)]
    }
}

pub const HUFFMAN_DECODE_ROOT: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_ROOT,
    next_table: HUFFMAN_DECODE_NEXT_TABLE_ROOT,
    index_of_first_next_table: 254,
};

const HUFFMAN_DECODE_NEXT_TABLE_ROOT: &[&HuffmanDecodeTable] =
    &[HUFFMAN_DECODE_254, HUFFMAN_DECODE_255];

macro_rules! huffman_decode_entries {
        [$($v:expr => $p:expr),+ $(,)?] => {
            &[
                $(HuffmanDecodeEntry { val: $v, prefix_len: $p }),+
            ]
        };
    }

const HUFFMAN_DECODE_ENTRIES_ROOT: &[HuffmanDecodeEntry] = huffman_decode_entries![
    48 => 5,
    48 => 5,
    48 => 5,
    48 => 5,
    48 => 5,
    48 => 5,
    48 => 5,
    48 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    49 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    50 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    97 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    99 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    101 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    105 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    111 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    115 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    116 => 5,
    32 => 6,
    32 => 6,
    32 => 6,
    32 => 6,
    37 => 6,
    37 => 6,
    37 => 6,
    37 => 6,
    45 => 6,
    45 => 6,
    45 => 6,
    45 => 6,
    46 => 6,
    46 => 6,
    46 => 6,
    46 => 6,
    47 => 6,
    47 => 6,
    47 => 6,
    47 => 6,
    51 => 6,
    51 => 6,
    51 => 6,
    51 => 6,
    52 => 6,
    52 => 6,
    52 => 6,
    52 => 6,
    53 => 6,
    53 => 6,
    53 => 6,
    53 => 6,
    54 => 6,
    54 => 6,
    54 => 6,
    54 => 6,
    55 => 6,
    55 => 6,
    55 => 6,
    55 => 6,
    56 => 6,
    56 => 6,
    56 => 6,
    56 => 6,
    57 => 6,
    57 => 6,
    57 => 6,
    57 => 6,
    61 => 6,
    61 => 6,
    61 => 6,
    61 => 6,
    65 => 6,
    65 => 6,
    65 => 6,
    65 => 6,
    95 => 6,
    95 => 6,
    95 => 6,
    95 => 6,
    98 => 6,
    98 => 6,
    98 => 6,
    98 => 6,
    100 => 6,
    100 => 6,
    100 => 6,
    100 => 6,
    102 => 6,
    102 => 6,
    102 => 6,
    102 => 6,
    103 => 6,
    103 => 6,
    103 => 6,
    103 => 6,
    104 => 6,
    104 => 6,
    104 => 6,
    104 => 6,
    108 => 6,
    108 => 6,
    108 => 6,
    108 => 6,
    109 => 6,
    109 => 6,
    109 => 6,
    109 => 6,
    110 => 6,
    110 => 6,
    110 => 6,
    110 => 6,
    112 => 6,
    112 => 6,
    112 => 6,
    112 => 6,
    114 => 6,
    114 => 6,
    114 => 6,
    114 => 6,
    117 => 6,
    117 => 6,
    117 => 6,
    117 => 6,
    58 => 7,
    58 => 7,
    66 => 7,
    66 => 7,
    67 => 7,
    67 => 7,
    68 => 7,
    68 => 7,
    69 => 7,
    69 => 7,
    70 => 7,
    70 => 7,
    71 => 7,
    71 => 7,
    72 => 7,
    72 => 7,
    73 => 7,
    73 => 7,
    74 => 7,
    74 => 7,
    75 => 7,
    75 => 7,
    76 => 7,
    76 => 7,
    77 => 7,
    77 => 7,
    78 => 7,
    78 => 7,
    79 => 7,
    79 => 7,
    80 => 7,
    80 => 7,
    81 => 7,
    81 => 7,
    82 => 7,
    82 => 7,
    83 => 7,
    83 => 7,
    84 => 7,
    84 => 7,
    85 => 7,
    85 => 7,
    86 => 7,
    86 => 7,
    87 => 7,
    87 => 7,
    89 => 7,
    89 => 7,
    106 => 7,
    106 => 7,
    107 => 7,
    107 => 7,
    113 => 7,
    113 => 7,
    118 => 7,
    118 => 7,
    119 => 7,
    119 => 7,
    120 => 7,
    120 => 7,
    121 => 7,
    121 => 7,
    122 => 7,
    122 => 7,
    38 => 8,
    42 => 8,
    44 => 8,
    59 => 8,
    88 => 8,
    90 => 8,
];

const HUFFMAN_DECODE_255: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255,
    next_table: HUFFMAN_DECODE_NEXT_TABLE_255,
    index_of_first_next_table: 254,
};

const HUFFMAN_DECODE_NEXT_TABLE_255: &[&HuffmanDecodeTable] =
    &[HUFFMAN_DECODE_255_254, HUFFMAN_DECODE_255_255];

const HUFFMAN_DECODE_ENTRIES_255: &[HuffmanDecodeEntry] = huffman_decode_entries![
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    63 => 2,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    39 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    43 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    124 => 3,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    35 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    62 => 4,
    0 => 5,
    0 => 5,
    0 => 5,
    0 => 5,
    0 => 5,
    0 => 5,
    0 => 5,
    0 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    36 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    64 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    91 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    93 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    126 => 5,
    94 => 6,
    94 => 6,
    94 => 6,
    94 => 6,
    125 => 6,
    125 => 6,
    125 => 6,
    125 => 6,
    60 => 7,
    60 => 7,
    96 => 7,
    96 => 7,
    123 => 7,
    123 => 7,
];

const HUFFMAN_DECODE_255_255: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255,
    next_table: HUFFMAN_DECODE_NEXT_TABLE_255_255,
    index_of_first_next_table: 246,
};

const HUFFMAN_DECODE_NEXT_TABLE_255_255: &[&HuffmanDecodeTable] = &[
    &HUFFMAN_DECODE_255_255_246,
    &HUFFMAN_DECODE_255_255_247,
    &HUFFMAN_DECODE_255_255_248,
    &HUFFMAN_DECODE_255_255_249,
    &HUFFMAN_DECODE_255_255_250,
    &HUFFMAN_DECODE_255_255_251,
    &HUFFMAN_DECODE_255_255_252,
    &HUFFMAN_DECODE_255_255_253,
    &HUFFMAN_DECODE_255_255_254,
    &HUFFMAN_DECODE_255_255_255,
];

const HUFFMAN_DECODE_ENTRIES_255_255: &[HuffmanDecodeEntry] = huffman_decode_entries![
    176 => 5,
    176 => 5,
    176 => 5,
    176 => 5,
    176 => 5,
    176 => 5,
    176 => 5,
    176 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    177 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    179 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    209 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    216 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    217 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    227 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    229 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    230 => 5,
    129 => 6,
    129 => 6,
    129 => 6,
    129 => 6,
    132 => 6,
    132 => 6,
    132 => 6,
    132 => 6,
    133 => 6,
    133 => 6,
    133 => 6,
    133 => 6,
    134 => 6,
    134 => 6,
    134 => 6,
    134 => 6,
    136 => 6,
    136 => 6,
    136 => 6,
    136 => 6,
    146 => 6,
    146 => 6,
    146 => 6,
    146 => 6,
    154 => 6,
    154 => 6,
    154 => 6,
    154 => 6,
    156 => 6,
    156 => 6,
    156 => 6,
    156 => 6,
    160 => 6,
    160 => 6,
    160 => 6,
    160 => 6,
    163 => 6,
    163 => 6,
    163 => 6,
    163 => 6,
    164 => 6,
    164 => 6,
    164 => 6,
    164 => 6,
    169 => 6,
    169 => 6,
    169 => 6,
    169 => 6,
    170 => 6,
    170 => 6,
    170 => 6,
    170 => 6,
    173 => 6,
    173 => 6,
    173 => 6,
    173 => 6,
    178 => 6,
    178 => 6,
    178 => 6,
    178 => 6,
    181 => 6,
    181 => 6,
    181 => 6,
    181 => 6,
    185 => 6,
    185 => 6,
    185 => 6,
    185 => 6,
    186 => 6,
    186 => 6,
    186 => 6,
    186 => 6,
    187 => 6,
    187 => 6,
    187 => 6,
    187 => 6,
    189 => 6,
    189 => 6,
    189 => 6,
    189 => 6,
    190 => 6,
    190 => 6,
    190 => 6,
    190 => 6,
    196 => 6,
    196 => 6,
    196 => 6,
    196 => 6,
    198 => 6,
    198 => 6,
    198 => 6,
    198 => 6,
    228 => 6,
    228 => 6,
    228 => 6,
    228 => 6,
    232 => 6,
    232 => 6,
    232 => 6,
    232 => 6,
    233 => 6,
    233 => 6,
    233 => 6,
    233 => 6,
    1 => 7,
    1 => 7,
    135 => 7,
    135 => 7,
    137 => 7,
    137 => 7,
    138 => 7,
    138 => 7,
    139 => 7,
    139 => 7,
    140 => 7,
    140 => 7,
    141 => 7,
    141 => 7,
    143 => 7,
    143 => 7,
    147 => 7,
    147 => 7,
    149 => 7,
    149 => 7,
    150 => 7,
    150 => 7,
    151 => 7,
    151 => 7,
    152 => 7,
    152 => 7,
    155 => 7,
    155 => 7,
    157 => 7,
    157 => 7,
    158 => 7,
    158 => 7,
    165 => 7,
    165 => 7,
    166 => 7,
    166 => 7,
    168 => 7,
    168 => 7,
    174 => 7,
    174 => 7,
    175 => 7,
    175 => 7,
    180 => 7,
    180 => 7,
    182 => 7,
    182 => 7,
    183 => 7,
    183 => 7,
    188 => 7,
    188 => 7,
    191 => 7,
    191 => 7,
    197 => 7,
    197 => 7,
    231 => 7,
    231 => 7,
    239 => 7,
    239 => 7,
    9 => 8,
    142 => 8,
    144 => 8,
    145 => 8,
    148 => 8,
    159 => 8,
    171 => 8,
    206 => 8,
    215 => 8,
    225 => 8,
    236 => 8,
    237 => 8,
];

const HUFFMAN_DECODE_255_255_255: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_255,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_255: &[HuffmanDecodeEntry] = huffman_decode_entries![
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    19 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    20 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    21 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    23 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    24 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    25 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    26 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    27 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    28 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    29 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    30 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    31 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    127 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    220 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    249 => 4,
    10 => 6,
    10 => 6,
    10 => 6,
    10 => 6,
    13 => 6,
    13 => 6,
    13 => 6,
    13 => 6,
    22 => 6,
    22 => 6,
    22 => 6,
    22 => 6,
    256 => 6,
    256 => 6,
    256 => 6,
    256 => 6,
];

const HUFFMAN_DECODE_255_255_254: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_254,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_254: &[HuffmanDecodeEntry] = huffman_decode_entries![
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    254 => 3,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    2 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    3 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    4 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    5 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    6 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    7 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    8 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    11 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    12 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    14 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    15 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    16 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    17 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
    18 => 4,
];

const HUFFMAN_DECODE_255_255_253: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_253,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_253: &[HuffmanDecodeEntry] = huffman_decode_entries![
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    245 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    246 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    247 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    248 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    250 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    251 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    252 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
    253 => 3,
];

const HUFFMAN_DECODE_255_255_252: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_252,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_252: &[HuffmanDecodeEntry] = huffman_decode_entries![
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    211 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    212 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    214 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    221 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    222 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    223 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    241 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
    244 => 3,
];

const HUFFMAN_DECODE_255_255_251: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_251,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_251: &[HuffmanDecodeEntry] = huffman_decode_entries![
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    242 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    243 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    255 => 2,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    203 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
    204 => 3,
];

const HUFFMAN_DECODE_255_255_250: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_250,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_250: &[HuffmanDecodeEntry] = huffman_decode_entries![
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    218 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    219 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    238 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
    240 => 2,
];

const HUFFMAN_DECODE_255_255_249: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_249,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_249: &[HuffmanDecodeEntry] = huffman_decode_entries![
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    202 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    205 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    210 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
    213 => 2,
];

const HUFFMAN_DECODE_255_255_248: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_248,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_248: &[HuffmanDecodeEntry] = huffman_decode_entries![
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    192 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    193 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    200 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
    201 => 2,
];

const HUFFMAN_DECODE_255_255_247: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_247,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_247: &[HuffmanDecodeEntry] = huffman_decode_entries![
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    234 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
    235 => 1,
];

const HUFFMAN_DECODE_255_255_246: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_255_246,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_255_246: &[HuffmanDecodeEntry] = huffman_decode_entries![
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    199 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
    207 => 1,
];

const HUFFMAN_DECODE_255_254: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_255_254,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_255_254: &[HuffmanDecodeEntry] = huffman_decode_entries![
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    92 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    195 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    208 => 3,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    128 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    130 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    131 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    162 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    184 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    194 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    224 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    226 => 4,
    153 => 5,
    153 => 5,
    153 => 5,
    153 => 5,
    153 => 5,
    153 => 5,
    153 => 5,
    153 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    161 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    167 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
    172 => 5,
];

const HUFFMAN_DECODE_254: &HuffmanDecodeTable = &HuffmanDecodeTable {
    entry: HUFFMAN_DECODE_ENTRIES_254,
    next_table: &[],
    index_of_first_next_table: 256,
};

const HUFFMAN_DECODE_ENTRIES_254: &[HuffmanDecodeEntry] = huffman_decode_entries![
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    33 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    34 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    40 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
    41 => 2,
];
